<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Admin_product_distribution extends CI_Controller {
	function __construct()
	{
		parent::__construct();
		$this->load->helper(array('form', 'url','all_function'));
		$this->load->helper('security');
		$this->load->library('form_validation');
		$this->load->model('login_database');
		$this->load->model('Admin_product_mdl');
		//$this->load->database($db);
		if(!isset($this->session->userdata['mlm_admin_logged_in']))
		{
			redirect('mlm_cp');
		}
	}
	public function index()
	{
		$data['page_title']   = "Product Distribution List";
		$data['report_data']  = $this->Admin_product_mdl->get_reentry_member_data($id=''); 

		$data['main_content'] = "admin/product_destribution_listing";
		$this->load->view('admin/includes/template',$data);
	}

	public function generate_receipt()
	{
		$reentry_id = $this->uri->segment(3); 
		$data['page_title']   = "Generate Receipt";
		$data['member_data']  = $this->Admin_product_mdl->get_reentry_member_data($reentry_id); 

		if (isset($_POST['report-submit']))
		{
			$this->form_validation->set_rules('product_name', 'Product Name', 'required');
			$this->form_validation->set_rules('dist_date', 'Distribution Date', 'required');
			$this->form_validation->set_rules('remark', 'Remark', 'required'); 

			 if ($this->form_validation->run() == TRUE)		 
			 {	 
				 $productData = array('product_reentry_id' 		=>$this->input->post('re_entry_id'),
				 					 'product_member_id' 		=>$this->input->post('member_id'),
				 					 'product_name'				=>$this->input->post('product_name'),
				 					 'product_distribution_date'=>$this->input->post('dist_date'),
				 					 'product_remark'			=>$this->input->post('remark'),
				 					 'product_description'		=>$this->input->post('desc'),
				 					 'product_added_date'		=>date('Y-m-d')
				 					);
				$res = $this->Admin_product_mdl->insert_data('product_distribution',$productData); 
				if ($res)
				{
					$this->session->set_flashdata('success','Product report generated successfully.');
					redirect('admin-product-distribution');  
				}

			} 

		}

		$data['main_content'] = "admin/product_distribution_receipt";
		$this->load->view('admin/includes/template',$data);
	}
	
	public function view_receipt()
	{
		$reentry_id = $this->uri->segment(3); 
		$data['page_title']   = "View Receipt";
		$data['member_data']  = $this->Admin_product_mdl->get_receipt_data($reentry_id); 
		$data['main_content'] = "admin/view_distribution_receipt";
		$this->load->view('admin/includes/template',$data);
	}   

}