<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Admin_report extends CI_Controller {
	function __construct()
	{
		parent::__construct();
		$this->load->helper(array('form', 'url','all_function'));
		$this->load->helper('security');
		$this->load->library('form_validation');
		$this->load->model('login_database');
		$this->load->model('Admin_report_mdl');
		date_default_timezone_set('Asia/Kolkata'); 
		//$this->load->database($db);
	if(!isset($this->session->userdata['mlm_admin_logged_in']))
		{
			redirect('mlm_master');
		}
		if($this->session->userdata('tree_star')!=NULL)
		{ 
			$ar = array('username'=>'','member_name'=>'','user_id'=>'');
			$this->session->set_userdata('tree_star',$ar);
			$this->session->set_userdata('myNet','');   
		}
	}
	public function index()
	{
		$data['page_title'] = "Weekly payout";
		$data['main_content'] = "admin/15_days_payout_report";

		if (isset($_POST['search']) && !empty($_POST['search_dates']))
		{
		   $sea_dates =  explode(',', $this->input->post('search_dates'));
		   $data['filterDate']    = $this->input->post('search_dates'); 
		   $data['payout_data'] = $this->Admin_report_mdl->get_days_payout_filter_data($sea_dates); 
		}
		else
		{
			$data['payout_data'] = $this->Admin_report_mdl->get_days_payout_data();    
		}

		$this->load->view('admin/includes/template',$data);
	}
	
	
	public function award_rewards()
	{
		$data['page_title'] = "Award And Rewards";
		$data['main_content'] = "admin/award_rewards";
		
		$award_type='Trip';
		
		if (isset($_POST['search'])) 
		{
			$award_type = $this->input->post('type'); 
		}
		$data['selType']=$award_type;
		$data['rewards'] = $this->Admin_report_mdl->get_award_rewards_members($award_type);

		$this->load->view('admin/includes/template',$data);
	}
	
	public function deduction_income()
	{
		$data['page_title'] = "Deduction income";
		$data['main_content'] = "admin/deduction_income";
		$data['deduction_data']=$this->db->get('deductionincome')->result();

		$this->load->view('admin/includes/template',$data);
	}
		public function print_report()
	{
		$data['page_title'] = "Weekly Payout Paid Details";
		$data['main_content'] = "admin/print_report.php";

		if (isset($_POST['search']) && !empty($_POST['search_dates']))
		{
		   $sea_dates =  explode(',', $this->input->post('search_dates'));
		   $data['filterDate']    = $this->input->post('search_dates'); 
		   $data['payout_data'] = $this->Admin_report_mdl->get_days_payout_filter_data($sea_dates); 
		}
		else
		{
			$data['payout_data'] = $this->Admin_report_mdl->get_paid_payout_details();    
		}

		$this->load->view('admin/includes/template',$data);
	}

	public function getPayoutDates($filterDate)
	{
		$data = $this->Admin_report_mdl->get_payout_dates();   

		$i=1;
		foreach ($data as $value) 
		{			 
				$res = array('from_date' => $value->from_date,'to_date'=>$value->to_date ); 
				$dates = implode(',', $res);

			if ($dates==$filterDate && !empty($filterDate)) 
			{
				echo '<option value="'.$dates.'" selected>'.date('d M y',strtotime($value->from_date)).' To '.date('d M y',strtotime($value->to_date)).'</option>';
			}
			else
			{
				echo '<option value="'.$dates.'">'.date('d M y',strtotime($value->from_date)).' To '.date('d M y',strtotime($value->to_date)).'</option>';  
			}	 
		}
	}
	 
	public function paynow()
	{
		$data['page_title'] = "Paynow";
		$data['main_content'] = "admin/pay_now";
 		$id = $this->uri->segment(3);
		
		if (isset($_POST['paynow-submit']))
		{
			$paynowData = array('status' =>'Paid' ,
								'transaction_id'=>$this->input->post('transaction_id'),
								'remark'=>$this->input->post('remark'), 
								'paid_date'=>date('Y-m-d') );  

			$res = $this->Admin_report_mdl->payout_paynow($paynowData,$id); 
			$this->session->set_flashdata('success','Paynow success..');
			redirect('admin_report/payout');	  
		}

		$data['payout_data'] = $this->Admin_report_mdl->get_binary_payout($sea_dates,$status='',$id);  

		$this->load->view('admin/includes/template',$data);
	} 
	
	public function paynow_autodeduction_income()
	{
		$data['page_title'] = "Paynow";
		$data['main_content'] = "admin/pay_now_deduction_income";
 		$id = $this->uri->segment(3);
		
		if (isset($_POST['paynow-submit']))
		{
			$paynowData = array('status' =>'Complete' ,
								'transaction_id'=>$this->input->post('transaction_id'),
								'remark'=>$this->input->post('remark'), 
								'paid_date'=>date('Y-m-d') );  

			$res = $this->Admin_report_mdl->payout_paynow_ded_income($paynowData,$id); 
			$this->session->set_flashdata('success','Paynow success..');
			redirect('admin/deduction-income');	  
		}

		$data['payout_data'] = $this->Admin_report_mdl->get_paynow_deduction_income($id);  

		$this->load->view('admin/includes/template',$data);
	} 
	
	public function bulk_approve()
	{
		$id=$_POST['ids'];		
		$new_arr = array_map('trim', explode(',', $id));		
		$debug = true;		
		foreach($new_arr as $id)
		{
			$info=	$this->Admin_report_mdl->approve_bulk_confirm($id);
		}
	}

	public function payout()
	{
		$data['page_title'] = "Binary Payout";
		$data['main_content'] = "admin/binary_payout_report";

		if (isset($_POST['search']))
		{
		   	$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');        
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date'); 

		   $data['payout_data'] = $this->Admin_report_mdl->get_binary_payout($from_date,$to_date='',$id=''); 
		}
		else
		{
			$data['from_date'] ='';
			$data['to_date']   ='';
			$data['payout_data'] = $this->Admin_report_mdl->get_binary_payout($from_date='',$to_date='',$id='');    
		}
		 
		$this->load->view('admin/includes/template',$data);
	}
	
	public function payout_paynow()
	{ 
 		$id = $this->uri->segment(3);
		
		if ($id!='')
		{
			$paynowData = array('payment_status' =>'Paid');  
 			
			$this->db->where('payment_id',$id);
			$this->db->set('payment_status','Paid');
			$if = $this->db->update('binary_payment');
			if ($if) {
				$this->session->set_flashdata('success','Paynow success..'); 
			}else{
				$this->session->set_flashdata('fail','Paynow fail..'); 
			}
			redirect('admin_report/payout');	  
		} 
	}  

	public function withdrawal_request()
	{
		$data['page_title'] = "Withdrawal Request";
		$data['main_content'] = "admin/withdrawal_request_members";

// 		if (isset($_POST['search']))
// 		{
// 		   	$from_date =''; $to_date   ='';
//  			$from_date =  $this->input->post('from_date');   
//  			$to_date   =  $this->input->post('to_date');        
//  			$paymentDate   =  $this->input->post('paymentDate');        
 			
//  			$data['from_date'] = $this->input->post('from_date');
//  			$data['to_date']   = $this->input->post('to_date'); 
//  			$data['paymentDate']   = $this->input->post('paymentDate'); 

// 		   $data['request_data'] = $this->Admin_report_mdl->withdrawal_request_members($from_date,$to_date,$paymentDate); 
// 		}
// 		else
// 		{
			$data['from_date'] ='';
			$data['to_date']   ='';
			$data['paymentDate']   ='';
			$data['request_data'] = $this->Admin_report_mdl->withdrawal_request_members_list();  
// 			print_r($data['request_data']);die;
// 		}
		 
		$this->load->view('admin/includes/template',$data);
	}

	public function withdrawal_request_paynow()
	{
		if($this->input->post('submit'))
		{ 	
// 			$this->form_validation->set_rules('ptype', 'Payment type', 'required');  
// 			$this->form_validation->set_rules('nameslip', 'Nameslip', 'required'); 
// 			$this->form_validation->set_rules('payment_date', 'PaymentDate', 'required'); 
// 			if (empty($_FILES['img']['name']))
// 			{
// 				$this->form_validation->set_rules('img', 'Payment image', 'required');
// 			}
// 			if ($this->form_validation->run() == TRUE)
// 			{
				$folder = "assets/paymentimages/";
				$extention = strrchr($_FILES['img']['name'], ".");
				$size = $_FILES['img']['size']/1024;
				$ex = strtoupper($extention);
				$err1 = 0;$err2 = 0;
				// if ($ex==".PNG" || $ex==".JPG" || $ex==".JPEG" || $ex==".GIF") 
				// {
					$txn_id=rand();
					$new_name = $txn_id;
					$img = $new_name.$extention;
					$uploaddir = $folder . $img;
					move_uploaded_file($_FILES['img']['tmp_name'], $uploaddir);

					$request_id = $this->input->post('request_id');

					$mempara = array('withdrawal_payment_type'=> $this->input->post('ptype'),
									'withdrawal_name_slip'=> $this->input->post('nameslip'), 
									'withdrawal_image'=> $img,
									'withdrawal_status'=> 'paid',
									'withdrawal_paid_date'=> $this->input->post("payment_date")
									);
					$this->db->where('roi_withdrawal_request_id',$request_id);
					$this->db->update('roi_withdrawal_request',$mempara);

					$this->session->set_flashdata('success','Paynow success..'); 
					redirect('epin/withdrawal_list');
				// }
				// else
				// {
				//      $this->session->set_flashdata('error', 'IMAGE TYPE NOT ALLOWD !');
				// 	    redirect('admin_report/withdrawal_request');
				// }
// 			}
		}
	}
	
	public function binary_income_paynow($id)
	{
        $binary_details = get_binary_details($id);
        // print_r($binary_details);die;
        $member_id          = $binary_details ->binary_member_id;
        $totalbalence       = $binary_details ->binary_amount;
        $request_amount     = $binary_details ->binary_amount;
        $admin_charges      = $binary_details ->admin_charges;
        $tds_charges        = $binary_details ->tds_charges;
        $repurchase_charges = $binary_details ->repurshase_charges;
        $net_payout         = $binary_details ->net_amount;
        
        $this->db->where('member_id', $member_id);
        $banks = $this->db->get('banks')->row();
        // print_r($banks);die;
        
        	$req = array('withdrawal_request_type'	=> 'Binary',
					'member_id'					=> $member_id,
					'withdrawal_total_amount'	=> $totalbalence,
					'withdrawal_request_amount' => $request_amount,
					'withdrawal_admin_charges'	=> $admin_charges,
					'withdrawal_tds_charges'	=> $tds_charges, 
					'withdrawal_repurchase_charges'	=> $repurchase_charges, 
					'withdrawal_net_amount'		=> $net_payout,
					'withdrawal_request_date'	=> date('Y-m-d H:i:s'),	
					'withdrawal_paid_date'	=> date('Y-m-d H:i:s'),	
					'withdrawal_status'			=> 'paid',
					'account_name'	=> $banks->member_account_name, 
					'account_no'	=> $banks->member_account_no, 
					'bank_name'		=> $banks->member_bank_name,
					'ifsc_code'	=> $banks->member_ifsc_code,	
					'branch_name'			=> $banks->member_branch_name
				);
		$insert = $this->db->insert('roi_withdrawal_request',$req);
		if($insert)
		{
		    $mempara = array(
							'payment_status'=> 'paid',
							'payment_date'=> date('Y-m-d H:i:s')
							);
			$this->db->where('binary_id',$binary_details->binary_id);
			$this->db->update('binary_income',$mempara);
		}
		$this->session->set_flashdata('success','Payment successful'); 
		redirect('epin/binary_list');
	}
	public function award_insert()
	{
		if($this->input->post('submit'))
		{ 	

				$folder = "assets/paymentimages/";
				$extention = strrchr($_FILES['img']['name'], ".");
				$size = $_FILES['img']['size']/1024;
				$ex = strtoupper($extention);
				$err1 = 0;$err2 = 0;
			
					$txn_id=rand();
					$new_name = $txn_id;
					$img = $new_name.$extention;
					$uploaddir = $folder . $img;
					move_uploaded_file($_FILES['img']['tmp_name'], $uploaddir);

					$request_id = $this->input->post('request_id');
					

					$mempara = array('award_member_id'=> $this->input->post('request_id'),
								'award_title'=> $this->input->post('title'), 
									'award_description'=> $this->input->post('description'),
									'award_date'=> $this->input->post("award_date"),
									'award_remark'=> $this->input->post("remark"),
									'award_image'=> $img,
									);
					
					$this->db->insert('isp_award',$mempara);

					$this->session->set_flashdata('success','Award Added success..'); 
					redirect('admin/awards');
		
		}
	}
	public function withdrawal_request_paynow_update()
		{
			if($this->input->post('submit'))
			{ 	
				// $this->form_validation->set_rules('ptype', 'Payment type', 'required');  
				// $this->form_validation->set_rules('nameslip', 'Nameslip', 'required'); 
				// $this->form_validation->set_rules('payment_date', 'PaymentDate', 'required'); 
				if (empty($_FILES['img']['name']))
				{
					//$this->form_validation->set_rules('img', 'Payment image', 'required');
					$img=$this->input->post("old_img");
				}
				else
				{
					$folder = "assets/paymentimages/";
					$extention = strrchr($_FILES['img']['name'], ".");
					$size = $_FILES['img']['size']/1024;
					$ex = strtoupper($extention);
					$err1 = 0;$err2 = 0;
					if ($ex==".PNG" || $ex==".JPG" || $ex==".JPEG" || $ex==".GIF") 
					{
						$txn_id=rand();
						$new_name = $txn_id;
						$img = $new_name.$extention;
						$uploaddir = $folder . $img;
						move_uploaded_file($_FILES['img']['tmp_name'], $uploaddir);
					}
					else
					{
					    $this->session->set_flashdata('error', 'IMAGE TYPE NOT ALLOWD !');
						redirect('admin_report/withdrawal_request');
					}

				}
				// if ($this->form_validation->run() == TRUE)
				// {
						$request_id = $this->input->post('request_id');

						$mempara = array('withdrawal_payment_type'=> $this->input->post('ptype'),
										'withdrawal_name_slip'=> $this->input->post('nameslip'), 
										'withdrawal_image'=> $img,
										'withdrawal_status'=> 'paid',
										'withdrawal_paid_date'=> $this->input->post("payment_date")
										);
						$this->db->where('roi_withdrawal_request_id',$request_id);
						$this->db->update('roi_withdrawal_request',$mempara);

						$this->session->set_flashdata('success','Paynow Update success..'); 
						redirect('epin/withdrawal_list');
						
				// }
			}
		}

	public function roi_wallet_list()
	{
		$data['page_title'] = "ROI LIST";
		$data['main_content'] = "admin/view_roi_list";

		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');       
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date');
 			  
 			$data['roi_list'] = $this->Admin_report_mdl->get_roilist_members($from_date,$to_date);  
 		} 
 		else
 		{
			$data['roi_list'] = $this->Admin_report_mdl->get_roilist_members($from_date='',$to_date='');
		}
		$this->load->view('admin/includes/template',$data);
	}

	public function roi_level_list()
	{
		if (isset($_POST['search'])) 
 		{ 
 			$level = $this->input->post('sr_level');
 			$data['sr_level'] = $this->input->post('sr_level'); 
 			$data['roi_list'] = $this->Admin_report_mdl->get_level_income($level); //get income
 		} 
 		else
 		{
 			$data['sr_level'] = '';
			$data['roi_list'] = $this->Admin_report_mdl->get_level_income($level=0); //get income
		}
		$data['page_title'] = "ROI LEVEL LIST";
		$data['main_content']      = "admin/view_roi_level_list"; 
		$this->load->view('admin/includes/template',$data); 
	}

	public function roi_paid()
	{
		$roi = (object) $this->input->post('roi_members');
		if ($roi) 
		{  
		  foreach ($roi as $roi_id) 
		  {
		  	$roiData = null;
		  	$roiData = $this->db->get_where('roi_wallet',array('roi_wallet_id' =>$roi_id))->row();

		   	$member=getSponsorDetails($roiData->member_id);

		  	 $mempara = array('withdrawal_payment_type'	=>'Daily ROI',
							'member_id'					=>$roiData->member_id,  
							'withdrawal_name_slip'		=>$member->member_name,  
							'withdrawal_request_amount'	=>$roiData->amount,  
							'withdrawal_net_amount'		=>$roiData->amount,  
							'withdrawal_status'			=> 'Paid',
							'withdrawal_request_date'	=> date('Y-m-d'),
							'withdrawal_paid_date'		=> date('Y-m-d')
							);

			$this->db->insert('roi_withdrawal_request',$mempara);

			$this->db->where('roi_wallet_id',$roi_id);
			$this->db->set('payment_status','Paid');
			$this->db->update('roi_wallet'); 			
		  }

		  $this->session->set_flashdata('success','Paynow success..'); 
		  redirect('admin_report/roi_wallet_list');
		} 
		else
		{
			$this->session->set_flashdata('fail','Please select members.');
			redirect('admin_report/roi_wallet_list');
		}
	}

	public function award_rewards_paid()
	{
		$member_id = $this->input->post('member_id');
		$description = $this->input->post('description');
		$type = $this->input->post('type');
		$date = $this->input->post('date'); 

		if ($member_id && $description ) 
		{
		  $award = array('award_member_id' 	=>$member_id,
		  				 'award_description'=>$description,
		  				 'award_type'=>$type,
		  				 'award_date'		=>$date, 
		  				  );
		  $this->db->insert('award_rewards',$award);

		  $this->session->set_flashdata('success','Rewards paid success..'); 
		  redirect('admin_report/award_rewards');
		}
	}
	public function exportCSV()
	{
	    
		//csv file name
		$filename = 'binarylist_'.date('Ymd').'.csv';

		header("Content-Description: File Transfer");
		header("Content-Disposition: attachment; filename=$filename");
		header("Content-Type: application/csv; "); 

		// get data
		$usersData = $this->Admin_report_mdl->export_binary();
		
//  		print_r($usersData);die;
	// file creation
		$file = fopen('php://output', 'w');
		$header = array("Sr. No.","Member Name","Binary Amount","Admin Charges","TDS Charges","Repurchase Charge","Net Amount","Date","Status");
		fputcsv($file, $header);
		foreach ($usersData as $key=>$line){
		  //  print_r($line);die;
		// fputcsv($file,$line);
		fputcsv($file, (array) $line);


		}

		fclose($file);
		exit;
	}

}