<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Home extends CI_Controller {

	function __construct()
	{
	    parent::__construct();
	    $this->data = new stdClass();
	    $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->load->library('email');
        $this->load->helper('all_function_helper');
        $this->load->model('Home_model');
	    date_default_timezone_set("Asia/Kolkata");
	}
  
 	public function dashboard()
	{		
	  
	    $response['status']     = 'fail';
        $response['message']    = '';
        $response['data']       = [];

        $this->form_validation->set_rules('member_email', 'Member Email', 'required|trim');
		
        if ($this->form_validation->run() == TRUE)
        {
            $member_email = $this->input->post('member_email');
            $data['member_details']=$user_details=$this->db->get_where('isp_members',array('member_email_id'=>$member_email))->row();
    
            
                $response['status']     = 'success';
                $response['message']    = 'Dashboard';
                $response['data']       = $data;
        }
        else{
            $response['status']     = 'fail';
            $response['message']    = validation_errors();
        }
        echo json_encode($response);
	}
// 	public function dashboard()
// 	{		
	  
// 	    $response['status']     = 'fail';
//         $response['message']    = '';
//         $response['data']       = [];

//         $this->form_validation->set_rules('member_email', 'Member Email or Login ID', 'required|trim');
		
//         if ($this->form_validation->run() == TRUE)
//         {
//             $member_email = $this->input->post('member_email');
         
          
//             if($member_email !=""){
//              $this->db->select('*');
//             $this->db->from('isp_members');
//             $this->db->where('member_email_id',$member_email);
//             $this->db->or_where('member_login_id',$member_email);
//             $query                      = $this->db->get();
//             $result                     = $query->result();
//         $data['result'] = $result;
//           $data['news'] = $this->db->get_where('isp_dailynews',array('status'=>'active'))->row();
      
            
//                 $response['status']     = 'success';
//                 $response['message']    = 'Dashboard';
//                 $response['data']       = $data;
//         }
//         }
//         else{
//             $response['status']     = 'fail';
//             $response['message']    = validation_errors();
//         }
//         echo json_encode($response);
// 	}
    public function profile()
	{		
	    $response['status']     = 'fail';
        $response['message']    = '';
        $response['data']       = [];
        
        $this->form_validation->set_rules('member_id', 'Member Id', 'required|trim');
        if ($this->form_validation->run() == TRUE)
        {
            $member_id = $this->input->post('member_id');
            $result=$this->db->get_where('isp_members',array('member_id'=>$member_id))->row();
         
    	    
    	    if ($result !="")
            {
                $sponser =  $result->member_sponsored;
                $sponser1=   getSponsor($sponser);
            
                $data = array( 
						'username'    	=> $result->member_login_id,
						'member_id'   	=> $result->member_id,
						'member_name' 	=> $result->member_name,
						'member_mobile' => $result->member_mobile,
						'joining_date' 	=> $result->member_added_date,
						'member_email' 	=> $result->member_email_id,
						'joining_date' 	=> $result->member_added_date,
						'member_sponsored'  => $sponser1,
						'member_pincode' 	=> $result->member_pin_code,
						'member_pan'  => $result->member_pan_card,
						'member_profile'  => $result->member_profile,
						'gender'  => $result->member_gender,
						'kyc_status'  => $result->kyc_status
						); 
					$response['status']     = 'success';
                    $response['message']    = 'profile data';
                    $response['data']       = $data; 
				
            }
            else
            {
                $response['status']     = 'fail';
                $response['message']    = 'No data found';
                $response['data']       = [];
            }
        }
        else{
            $response['status']     = 'fail';
            $response['message']    = validation_errors();
        }
        echo json_encode($response);
	}
	public function edit_profile()
    {
        $response['status']     = 'fail';
        $response['message']    = '';
        $response['data']       = [];
       
        $member_id      = $this->input->post('member_id'); 
       
        $member_detail   = $this->db->order_by('member_id','DESC')->get_where(' isp_members',array('member_id'=>$member_id))->row();
     
        if($member_detail !='')
        {
           
            $member_name  = $this->input->post('member_name');
            // $member_email_id  = $this->input->post('member_email_id');
            $member_mobile  = $this->input->post('member_mobile');
            $member_pin_code  = $this->input->post('member_pin_code');
            $member_profile  = $this->input->post('member_profile');
            
             if($this->input->post('member_name')!="")
            {
                $member_name  = $this->input->post('member_name');
            }
            else
            {
                $member_name=$member_detail->member_name;
            }
            // if($this->input->post('member_email_id')!="")
            // {
            //     $member_email_id  = $this->input->post('member_email_id');
            // }
            // else
            // {
            //     $member_email_id=$member_detail->member_email_id;
            // }
           
            if($this->input->post('member_mobile')!="")
            {
                $member_mobile = $this->input->post('member_mobile');
            }
            else
            {
                $member_mobile=$member_detail->member_mobile;
            }
            if($this->input->post('member_pin_code')!="")
            {
                $member_pin_code = $this->input->post('member_pin_code');
            }
            else
            {
                $member_pin_code=$member_detail->member_pin_code;
            }
            
            
            $ar = array('member_name' =>$member_name,
                        // 'member_email_id'=>$member_email_id,
						'member_mobile'=>$member_mobile,
						'member_pin_code'=>$member_pin_code,
			        	'member_profile'=>$member_profile,
						'member_flag'=>'1',
						);
            
			$this->db->where('member_id',$member_id);
			$this->db->update('isp_members',$ar);
			
            $response['status']="success";
            $response['data'] = "";
            $response['message'] = "Data Updated Successfully"; 
        }      
        else
        {
            $response['status']="fail";
            $response['data'] = "";
            $response['message'] = "Data Not Updated"; 
        }
        echo json_encode($response);
    }	

	public function upload_profile_img()
    { 
        $response=array();
        $this->form_validation->set_rules('image', 'Image', 'trim|required');
        if($this->form_validation->run() == TRUE) 
        {
            $img = $this->input->post('image');
            $member_id =$this->input->post('member_id');
            if ($img!='') 
            {
                    $decodedImage = base64_decode("$img");
                    $image_name = time().rand(999,99999);
                    file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
                    $image = $image_name.'.jpeg';
                   $image_full_path=base_url().'assets/profile/'.$image;
            }
                 $sql1="Update isp_members set   member_profile='".$image."' 
                  where member_id='".$member_id."' ";
                 $last_id = $this->db->query($sql1);
              
            

            $response['status']="success";
            $response['data'] = array("name"=>$image,"path"=>$image_full_path);
            $response['message'] = "Image name";
        }
        else
        {
            $response['status']="fail";
            $response['data'] = "";
            $response['message'] =validation_errors();
        }
        echo json_encode($response);
    }
    	public function upload_kyc_img()
    { 
        $response=array();
        $this->form_validation->set_rules('image', 'Image', 'trim|required');
        if($this->form_validation->run() == TRUE) 
        {
            $img = $this->input->post('image');
            
            if ($img!='') 
            {
                    $decodedImage = base64_decode("$img");
                    $image_name = time().rand(999,99999);
                    file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
                    $image = $image_name.'.jpeg';
                   $image_full_path=base_url().'assets/profile/'.$image;
            }
              
              
            

            $response['status']="success";
            $response['data'] = array("name"=>$image,"path"=>$image_full_path);
            $response['message'] = "Image name";
        }
        else
        {
            $response['status']="fail";
            $response['data'] = "";
            $response['message'] =validation_errors();
        }
        echo json_encode($response);
    }
    public function change_password()
	{		
	    
	    $response['status']     = 'fail';
        $response['message']    = '';
        $response['data']       = [];
        

        $this->form_validation->set_rules('member_id', 'Member Id', 'required|trim');
        $this->form_validation->set_rules('new_password', 'new password', 'required'); 
		
        if ($this->form_validation->run() == TRUE)
        {
            $member_id = $this->input->post('member_id');
            $pass = $this->input->post('new_password');
            $password = array('member_password' => base64_encode($this->input->post('new_password')) );
          
             $currentTimestamp = date("Y-m-d H:i:s");
             //$originalPassword = $password;
     
                  $options = ['cost' => 10]; 
             
                  $d = password_hash($pass, PASSWORD_BCRYPT);
    
			$update=$this->Home_model->update_pass($member_id,$password,$d);

			
            $response['status']     = 'success';
            $response['message']    = ' Password Updated successfully';
            $response['data']       = []; 
           
        }
        else{
            $response['status']     = 'fail';
            $response['message']    = validation_errors();
        }
        echo json_encode($response);
	}
    public function my_orders()
	{		
	    
	    $response['status']     = 'fail';
        $response['message']    = '';
        $response['data']       = [];
        

        $this->form_validation->set_rules('member_id', 'Member Id', 'required|trim');
		
        if ($this->form_validation->run() == TRUE)
        {
            $member_id = $this->input->post('member_id');
            $orders=$this->db->get_where('isp_order',array('member_id'=>$member_id))->result();
           
            $pack = array();
           if($orders!="")
           {
               if($orders != $pack)
               {
					$response['status']     = 'success';
                    $response['message']    = 'My Order';
                    $response['data']       = $orders; 
               }
               else
               {
                    $response['status']     = 'fail';
                    $response['message']    = 'No Records Found';
                    $response['data']       = [];
               }
           }
           else
           {
               $response['status']     = 'fail';
                $response['message']    = 'No Records Found';
                $response['data']       = [];
           }
        }
        else{
            $response['status']     = 'fail';
            $response['message']    = validation_errors();
        }
        echo json_encode($response);
	}
     public function support_list()
	{		
	    
	    $response['status']     = 'fail';
        $response['message']    = '';
        $response['data']       = [];

        $this->form_validation->set_rules('member_id', 'Member Id', 'required|trim');
		
        if ($this->form_validation->run() == TRUE)
        {
            $member_id = $this->input->post('member_id');
           
            $result= $this->db->order_by('ticket_id','DESC')->get_where('isp_ticket_support',array('ticket_member_id'=>$member_id))->result();
    	  
           if($result!="")
           {
					$response['status']     = 'success';
                    $response['message']    = 'Support List';
                    $response['data']       = $result; 
           }
           else
           {
               $response['status']     = 'fail';
                $response['message']    = 'No Records Found';
                $response['data']       = [];
           }
        }
        else{
            $response['status']     = 'fail';
            $response['message']    = validation_errors();
        }
        echo json_encode($response);
	}
	 public function support()
	{		
	    
	    $response['status']     = 'fail';
        $response['message']    = '';
        $response['data']       = [];

        $this->form_validation->set_rules('member_id', 'Member Id', 'required|trim');
        $this->form_validation->set_rules('subject', 'subject', 'required');  
		$this->form_validation->set_rules('description', 'description', 'required');  
		$this->form_validation->set_rules('ticket_image', 'Ticket Images', 'required');
		
        if ($this->form_validation->run() == TRUE)
        {
            $member_id = $this->input->post('member_id');

			$ar = array('ticket_subject' =>escapeStr($this->input->post('subject')),
							'ticket_description'=>escapeStr($this->input->post('description')),
							'ticket_member_id'=>$member_id,
				// 			'ticket_image'=>$fileName,
				        	'ticket_image'=>$this->input->post('ticket_image'),
							'ticket_status'=>'Pending',
							'ticket_date'=>date('Y-m-d H:i:s')
							);
			
		

              $config['allowed_types']='gif|jpg|jpeg|png';
            $config['upload_path'] = base_url().'assets/front/ticket_img/';
            $config['overwrite']  = FALSE;
            $config['encrypt_name']  = TRUE;
            $config['remove_spaces']  = TRUE;
            $this->load->library('upload');
            $this->upload->initialize($config);
            
            if(!empty($_FILES['ticket_img']))
            {
                if($this->upload->do_upload('ticket_img')){
                   $member_photo_one = $this->upload->data();
                   $ar['ticket_image'] = $member_photo_one['file_name'];
                }
                else{
                    $error = array('error' => $this->upload->display_errors());
                    $response['status']     = 'fail';
                    $response['message']    = $error['error'];
                }
            }
            $insert=$this->db->insert('isp_ticket_support',$ar);
    	  
           if($insert)
           {
				$response['status']     = 'success';
                $response['message']    = 'Ticket submitted successfully';
                $response['data']       = []; 
           }
           else
           {
               $response['status']     = 'fail';
                $response['message']    = 'Error occured while submitting Ticket. ';
                $response['data']       = [];
           }
        }
        else{
            $response['status']     = 'fail';
            $response['message']    = validation_errors();
        }
        echo json_encode($response);
	}
	public function upload_img()
    { 
        $response=array();
        $this->form_validation->set_rules('image', 'Image', 'trim|required');
        if($this->form_validation->run() == TRUE) 
        {
            $image = $this->input->post('image');
            if ($image!='') 
                {
                        $decodedImage = base64_decode("$image");
                        $image_name = time().rand(999,99999);
                        file_put_contents(FCPATH.'assets/front/ticket_img/'.$image_name.'.jpeg', $decodedImage);
                        $image = $image_name.'.jpeg';
                        $image_full_path=base_url().'assets/front/ticket_img/'.$image;
                }

            $response['status']="success";
            $response['data'] = array("name"=>$image,"path"=>$image_full_path);
            $response['message'] = "Image name";
        }
        else
        {
            $response['status']="fail";
            $response['data'] = "";
            $response['message'] =validation_errors();
        }
        echo json_encode($response);
    }	
    public function complete_kyc()
    {
        $response = array();
        $this->form_validation->set_rules('member_id', 'Member Id', 'required|trim');
        $this->form_validation->set_rules('member_first_name', 'Member First Name', 'required|trim');
        $this->form_validation->set_rules('member_middle_name', 'Member Middle Name', 'required|trim');
        $this->form_validation->set_rules('member_last_name', 'Member Last Name', 'required|trim');
        $this->form_validation->set_rules('member_dob', 'Member Date of Birth', 'required|trim');
        if ($this->form_validation->run() == TRUE)
        {
        $memberId      = $this->input->post('member_id'); 
      
      $data['profile_data'] = $this->Home_model->get_member_profile($memberId);
       
      $kyc_status =   $data['profile_data'][0]->kyc_status;

        if($kyc_status== "Under_process")
		{
			$response['status']="fail";
            $response['data'] = "";
            $response['message'] = "Wait for Admin Approval"; 
		}
		else
		{
		  	$email_id = $data['profile_data'][0]->member_email_id;
		  	$user_details = $data['user_details'] = $this->db->get_where('isp_members',array('member_id'=>$memberId))->row();
	
		    if($data['user_details'] != "") 
    	    {
    	        $selfie             = $this->input->post('selfie');
    	        if($selfie == ""){ $selfie= $user_details->member_profile; }
    	        $doc_details=$this->db->get_where('isp_profile_doc_details',array('member_id'=>$memberId))->row();
                if($doc_details != "")
                {
		            $member_first_name	= $this->input->post('member_first_name'); 
					$member_middle_name = $this->input->post('member_middle_name'); 
					$member_last_name 	= $this->input->post('member_last_name');
					$member_dob 		= $this->input->post('member_dob');
					$member_address 	= $this->input->post('address');
					$aadhar_id 			= $this->input->post('aadhaar_detail');
					$pan_no		        = $this->input->post('member_pan_detail');
					$pan_front          = $this->input->post('pan_front');
					$pan_back           = $this->input->post('pan_back');
					$passport_id 		= $this->input->post('member_passport_detail');
					$driving_lic_id 	= $this->input->post('member_driving_license_detail');
					$id_proof 			= $this->input->post('member_address_doc_details');
					$address_varify 	= $this->input->post('member_address_doc_detail');
					$passport_front     = $this->input->post('passport_front');
					$passport_back      = $this->input->post('passport_back');
					$adhar_front        = $this->input->post('adhar_front');
					$adhar_back         = $this->input->post('adhar_back');
					$driving_front      = $this->input->post('driving_front');
					$driving_back       = $this->input->post('driving_back');
					$pan_front = $pan_back =$passport_front = $passport_back = $adhar_front = $adhar_back = $driving_front = $driving_back = '';
					if($member_first_name == ""){ $member_first_name= $doc_details->first_name; }
					if($member_middle_name == ""){ $member_middle_name= $doc_details->middle_name; }
					if($member_last_name == ""){ $member_last_name= $doc_details->last_name; }
					if($member_dob == ""){ $member_dob= $doc_details->birthdate; }
					if($member_address == ""){ $member_address= $doc_details->address; }
					if($aadhar_id == ""){ $aadhar_id= $doc_details->aadhar_id; }
					if($pan_no == ""){ $pan_no= $doc_details->pan_card_no; }
					if($passport_id == ""){ $passport_id= $doc_details->passport_id; }
					if($driving_lic_id == ""){ $driving_lic_id= $doc_details->driving_lic_id; }
				 	//if($userphoto == ""){ $userphoto= $doc_details->member_profile; }
					if($address_varify == ""){ $address_varify= $doc_details->address_verify_option; }
					if($passport_front == ""){ $passport_front= $doc_details->passport_doc; }
					if($passport_back == ""){ $passport_back= $doc_details->passport_back_doc; }
					if($adhar_front == ""){ $adhar_front= $doc_details->adhar_card_doc; }
					if($adhar_back == ""){ $adhar_back= $doc_details->adhar_card_back; }
					if($driving_front == ""){ $driving_front= $doc_details->driving_lic_doc; }
					if($driving_back == ""){ $driving_back= $doc_details->driving_lic_back_doc; }
					if($pan_front == ""){ $pan_front= $doc_details->pan_card_front; }
					if($pan_back == ""){ $pan_back= $doc_details->pan_card_back; }
					if($adhar_front !="" AND $adhar_back !="" )
					{
					    $address_varify ="adhaar_card";
					}
					elseif($passport_front != "" AND $passport_back !=""){
					    $address_varify ="passport";
					}
					else{
					    $address_varify ="driving_licence";
					}
					$arr = array(
							'first_name'=>$member_first_name,
							'middle_name'=>$member_middle_name,
							'last_name'=>$member_last_name,
				        	'birthdate'=>$member_dob,
							'aadhar_id'=>$aadhar_id,
							'adhar_card_doc'	=>$adhar_front,
							'adhar_card_back'	=>$adhar_back,
							'pan_card_no'			=>$pan_no,
							'pan_card_front'		=>$pan_front,
							'pan_card_back'		    =>$pan_back,
							'passport_id'=>   $passport_id,
							'passport_doc'			=>$passport_front,
							'passport_back_doc'		=>$passport_back,
							'driving_lic_id'=>$driving_lic_id,
							'driving_lic_doc'		=>$driving_front,
							'driving_lic_back_doc'	=>$driving_back,
							'address_verify_option'=>$address_varify,
							'address'=>$member_address,
							'member_photo'=>$selfie
							);
						    
							$this->db->where('member_id',$memberId);
							$update = $this->db->update('isp_profile_doc_details',$arr);
							if($update){
								
							$data=array(
								// 'member_profile'=>$userphoto,
								'member_profile'=>$selfie,
								'kyc_status'=>"Under_process",
								'member_address'	=>$member_address,
									'member_pan_card'	=>$pan_no
								);
								$this->db->where('member_id',$memberId);
								//$this->db->update('isp_members',$u_data);
									$this->db->update('isp_members',$data);
							}
							
						}
				else
				{ 
				    
				    $member_first_name	= $this->input->post('member_first_name'); 
					$member_middle_name = $this->input->post('member_middle_name'); 
					$member_last_name 	= $this->input->post('member_last_name');
					$member_dob 		= $this->input->post('member_dob');
					$member_address 	= $this->input->post('address');
					$aadhar_id 			= $this->input->post('aadhaar_detail');
					$passport_id 		= $this->input->post('member_passport_detail');
					$driving_lic_id 	= $this->input->post('member_driving_license_detail');
					$id_proof 			= $this->input->post('member_address_doc_details');
					$address_varify 	= $this->input->post('member_address_doc_detail');
					$passport_front     = $this->input->post('passport_front');
					$passport_back      = $this->input->post('passport_back');
					$adhar_front        = $this->input->post('adhar_front');
					$adhar_back         = $this->input->post('adhar_back');
					$driving_front      = $this->input->post('driving_front');
					$driving_back       = $this->input->post('driving_back');
					$selfie             = $this->input->post('selfie');
					$pan_no		        = $this->input->post('member_pan_detail');
					$pan_front          = $this->input->post('pan_front');
					$pan_back           = $this->input->post('pan_back');
				    	if($adhar_front !="" AND $adhar_back !="" )
					{
					    $address_varify ="adhaar_card";
					}
					elseif($passport_front != "" AND $passport_back !=""){
					    $address_varify ="passport";
					}
					else{
					    $address_varify ="driving_licence";
					}
				    $arr = array('member_id' =>$memberId,
					'first_name'=>$member_first_name,
					'middle_name'=>$member_middle_name,
					'last_name'=>$member_last_name,
		        	'birthdate'=>$member_dob,
					'aadhar_id'=>$aadhar_id,
					'adhar_card_doc'		=>$adhar_front,
					'adhar_card_back'		=>$adhar_back,
					'pan_card_no'			=>$pan_no,
					'pan_card_front'		=>$pan_front,
					'pan_card_back'		    =>$pan_back,
					'passport_id'=>   $passport_id,
					'passport_doc'			=>$passport_front,
					'passport_back_doc'		=>$passport_back,
					'driving_lic_id'=>$driving_lic_id,
					'driving_lic_doc'		=>$driving_front,
					'driving_lic_back_doc'	=>$driving_back,
					'address_verify_option'=>$address_varify,
					'address'=>$member_address,
					'member_photo'=>$selfie
					);
					
					$this->Home_model->insert_data('isp_profile_doc_details',$arr); 
				    $data=array(
								'member_profile'=>$selfie,
								'kyc_status'=>"Under_process",
								'member_address'	=>$member_address,
								'member_pan_card'	=>$pan_no
								);
					$this->db->where('member_id',$memberId);
					$this->db->update('isp_members',$data);
				}
				$message=' Dear User, Your KYC Documents uploaded successfully. Wait for KYC verification, Currently your KYC verification under process. ';
				$subject = 'KYC document uploaded successfully.';
				$to =$email_id;
				send_email($to,$subject,$message);
				
				$response['status']="success";
                $response['data'] = "";
                $response['message'] = "KYC Document uploaded successfully"; 
			}
			
		}
		
        }
    else
            {
              $response['status']     = 'fail';
            $response['message']    = validation_errors();
            }
            	echo json_encode($response);
    }
// public function complete_kyc()//diksha
//     {
//         $response = array();
//         $this->form_validation->set_rules('member_id', 'Member Id', 'required|trim');
//         $this->form_validation->set_rules('member_first_name', 'Member First Name', 'required|trim');
//         $this->form_validation->set_rules('member_middle_name', 'Member Middle Name', 'required|trim');
//         $this->form_validation->set_rules('member_last_name', 'Member Last Name', 'required|trim');
//         $this->form_validation->set_rules('member_dob', 'Member Date of Birth', 'required|trim');
//         if ($this->form_validation->run() == TRUE)
//         {
//         $memberId      = $this->input->post('member_id'); 
      
//       $data['profile_data'] = $this->Home_model->get_member_profile($memberId);
       
//       $kyc_status =   $data['profile_data'][0]->kyc_status;

//         if($kyc_status== "Under_process")
// 		{
// 			$response['status']="fail";
//             $response['data'] = "";
//             $response['message'] = "Wait for Admin Approval"; 
// 		}
// 		else
// 		{
// 		    	$pan_front = $pan_back =$passport_front = $passport_back = $adhar_front = $adhar_back = $driving_front = $driving_back = '';
// 		  	$email_id = $data['profile_data'][0]->member_email_id;
// 		  	$user_details = $data['user_details'] = $this->db->get_where('isp_members',array('member_id'=>$memberId))->row();
	
// 		    if($data['user_details'] != "") 
//     	    {
//     	        $self             = $this->input->post('selfie');
// 						if ($self!='') 
//             {
//                     $decodedImage = base64_decode("$self");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                   $selfie = $image_name.'.jpeg';
                
//                   $image_full_path=base_url().'assets/profile/'.$selfie;
//             }
//     	        if($self == ""){ $selfie= $user_details->member_profile; }
//     	        $doc_details=$this->db->get_where('isp_profile_doc_details',array('member_id'=>$memberId))->row();
//                 if($doc_details != "")
//                 {
// 		            $member_first_name	= $this->input->post('member_first_name'); 
// 					$member_middle_name = $this->input->post('member_middle_name'); 
// 					$member_last_name 	= $this->input->post('member_last_name');
// 					$member_dob 		= $this->input->post('member_dob');
					
// 					$member_address 	= $this->input->post('address');
// 					$aadhar_id 			= $this->input->post('aadhaar_detail');
// 					$pan_no		        = $this->input->post('member_pan_detail');
// 					$panfront          = $this->input->post('pan_front');
// 					 if ($panfront!='') 
//             {
//                     $decodedImage = base64_decode("$panfront");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                     $pan_front = $image_name.'.jpeg';
                    
//                   $image_full_path=base_url().'assets/profile/'.$pan_front;
//             }
// 					$panback           = $this->input->post('pan_back');
// 					 if ($panback!='') 
//             {
//                     $decodedImage = base64_decode("$panback");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                     $pan_back = $image_name.'.jpeg';
                    
//                   $image_full_path=base_url().'assets/profile/'.$pan_back;
//             }
// 					$passport_id 		= $this->input->post('member_passport_detail');
// 					$driving_lic_id 	= $this->input->post('member_driving_license_detail');
// 					$id_proof 			= $this->input->post('member_address_doc_details');
// 					$address_varify 	= $this->input->post('member_address_doc_detail');
// 					$passfront     = $this->input->post('passport_front');
// 					  if ($passfront!='') 
//             {
//                     $decodedImage = base64_decode("$passfront");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                     $passport_front = $image_name.'.jpeg';
                    
//                   $image_full_path=base_url().'assets/profile/'.$passport_front;
//             }
// 					$passback      = $this->input->post('passport_back');
// 						if ($passback!='') 
//             {
//                     $decodedImage = base64_decode("$passback");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                     $passport_back = $image_name.'.jpeg';
                
//                   $image_full_path=base_url().'assets/profile/'.$passport_back;
//             }
// 					$adharfront        = $this->input->post('adhar_front');
// 					if ($adharfront!='') 
//             {
//                     $decodedImage = base64_decode("$adharfront");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                     $adhar_front = $image_name.'.jpeg';
                
//                   $image_full_path=base_url().'assets/profile/'.$adhar_front;
//             }
// 					$adharback         = $this->input->post('adhar_back');
// 						if ($adharback!='') 
//             {
//                     $decodedImage = base64_decode("$adharback");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                   $adhar_back = $image_name.'.jpeg';
                
//                   $image_full_path=base_url().'assets/profile/'.$adhar_back;
//             }
// 					$drivingfront      = $this->input->post('driving_front');
// 						if ($drivingfront!='') 
//             {
//                     $decodedImage = base64_decode("$drivingfront");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                   $driving_front = $image_name.'.jpeg';
                
//                   $image_full_path=base_url().'assets/profile/'.$driving_front;
//             }
//             $drivingback      = $this->input->post('driving_back');
// 				if ($drivingback!='') 
//             {
//                     $decodedImage = base64_decode("$drivingback");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                   $driving_back = $image_name.'.jpeg';
                
//                   $image_full_path=base_url().'assets/profile/'.$driving_back;
//             }
				
// 					if($member_first_name == ""){ $member_first_name= $doc_details->first_name; }
// 					if($member_middle_name == ""){ $member_middle_name= $doc_details->middle_name; }
// 					if($member_last_name == ""){ $member_last_name= $doc_details->last_name; }
// 					if($member_dob == ""){ $member_dob= $doc_details->birthdate; }
// 					if($member_address == ""){ $member_address= $doc_details->address; }
// 					if($aadhar_id == ""){ $aadhar_id= $doc_details->aadhar_id; }
// 					if($pan_no == ""){ $pan_no= $doc_details->pan_card_no; }
// 					if($passport_id == ""){ $passport_id= $doc_details->passport_id; }
// 					if($driving_lic_id == ""){ $driving_lic_id= $doc_details->driving_lic_id; }
// 				 	//if($userphoto == ""){ $userphoto= $doc_details->member_profile; }
// 					if($address_varify == ""){ $address_varify= $doc_details->address_verify_option; }
// 					if($passport_front == ""){ $passport_front= $doc_details->passport_doc; }
// 					if($passport_back == ""){ $passport_back= $doc_details->passport_back_doc; }
// 					if($adhar_front == ""){ $adhar_front= $doc_details->adhar_card_doc; }
// 					if($adhar_back == ""){ $adhar_back= $doc_details->adhar_card_back; }
// 					if($driving_front == ""){ $driving_front= $doc_details->driving_lic_doc; }
// 					if($driving_back == ""){ $driving_back= $doc_details->driving_lic_back_doc; }
// 					if($pan_front == ""){ $pan_front= $doc_details->pan_card_front; }
// 					if($pan_back == ""){ $pan_back= $doc_details->pan_card_back; }
// 					$arr = array(
// 							'first_name'=>$member_first_name,
// 							'middle_name'=>$member_middle_name,
// 							'last_name'=>$member_last_name,
// 				        	'birthdate'=>$member_dob,
// 							'aadhar_id'=>$aadhar_id,
// 							'adhar_card_doc'	=>$adhar_front,
// 							'adhar_card_back'	=>$adhar_back,
// 							'pan_card_no'			=>$pan_no,
// 							'pan_card_front'		=>$pan_front,
// 							'pan_card_back'		    =>$pan_back,
// 							'passport_id'=>   $passport_id,
// 							'passport_doc'			=>$passport_front,
// 							'passport_back_doc'		=>$passport_back,
// 							'driving_lic_id'=>$driving_lic_id,
// 							'driving_lic_doc'		=>$driving_front,
// 							'driving_lic_back_doc'	=>$driving_back,
// 							'address_verify_option'=>$address_varify,
// 							'address'=>$member_address
// 							);
						    
// 							$this->db->where('member_id',$memberId);
// 							$update = $this->db->update('isp_profile_doc_details',$arr);
// 							if($update){
								
// 							$data=array(
// 								// 'member_profile'=>$userphoto,
// 								'member_profile'=>$selfie,
// 								'kyc_status'=>"Under_process",
// 								'member_address'	=>$member_address,
// 									'member_pan_card'	=>$pan_no
// 								);
// 								$this->db->where('member_id',$memberId);
// 								//$this->db->update('isp_members',$u_data);
// 									$this->db->update('isp_members',$data);
// 							}
							
// 						}
// 				else
// 				{ 
				    
// 				    $member_first_name	= $this->input->post('member_first_name'); 
// 					$member_middle_name = $this->input->post('member_middle_name'); 
// 					$member_last_name 	= $this->input->post('member_last_name');
// 					$member_dob 		= $this->input->post('member_dob');
				
// 					$member_address 	= $this->input->post('address');
// 					$aadhar_id 			= $this->input->post('aadhaar_detail');
// 					$passport_id 		= $this->input->post('member_passport_detail');
// 					$driving_lic_id 	= $this->input->post('member_driving_license_detail');
// 					$id_proof 			= $this->input->post('member_address_doc_details');
// 					$address_varify 	= $this->input->post('member_address_doc_detail');
// 					$passfront     = $this->input->post('passport_front');
// 					 if ($passfront!='') 
//             {
//                     $decodedImage = base64_decode("$passfront");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                     $passport_front = $image_name.'.jpeg';
                
//                   $image_full_path=base_url().'assets/profile/'.$passport_front;
//             }
// 					$passback      = $this->input->post('passport_back');
// 					if ($passback!='') 
//             {
//                     $decodedImage = base64_decode("$passback");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                     $passport_back = $image_name.'.jpeg';
                
//                   $image_full_path=base_url().'assets/profile/'.$passport_back;
//             }
				
// 				$adharfront        = $this->input->post('adhar_front');
// 					if ($adharfront!='') 
//             {
//                     $decodedImage = base64_decode("$adharfront");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                     $adhar_front = $image_name.'.jpeg';
                
//                   $image_full_path=base_url().'assets/profile/'.$adhar_front;
//             }
// 					$adharback         = $this->input->post('adhar_back');
// 						if ($adharback!='') 
//             {
//                     $decodedImage = base64_decode("$adharback");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                   $adhar_back = $image_name.'.jpeg';
                
//                   $image_full_path=base_url().'assets/profile/'.$adhar_back;
//             }
// 					$drivingfront      = $this->input->post('driving_front');
// 						if ($drivingfront!='') 
//             {
//                     $decodedImage = base64_decode("$drivingfront");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                   $driving_front = $image_name.'.jpeg';
                
//                   $image_full_path=base_url().'assets/profile/'.$driving_front;
//             }
// 					$drivingback       = $this->input->post('driving_back');
// 					if ($drivingback!='') 
//             {
//                     $decodedImage = base64_decode("$drivingback");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                   $driving_back = $image_name.'.jpeg';
                
//                   $image_full_path=base_url().'assets/profile/'.$driving_back;
//             }
// 					$self             = $this->input->post('selfie');
// 						if ($self!='') 
//             {
//                     $decodedImage = base64_decode("$self");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                   $selfie = $image_name.'.jpeg';
                
//                   $image_full_path=base_url().'assets/profile/'.$selfie;
//             }
// 					$pan_no		        = $this->input->post('member_pan_detail');
// 					$panfront          = $this->input->post('pan_front');
// 					 if ($panfront!='') 
//             {
//                     $decodedImage = base64_decode("$panfront");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                     $pan_front = $image_name.'.jpeg';
                    
//                   $image_full_path=base_url().'assets/profile/'.$pan_front;
//             }
// 					$panback           = $this->input->post('pan_back');
// 					 if ($panback!='') 
//             {
//                     $decodedImage = base64_decode("$panback");
//                     $image_name = time().rand(999,99999);
//                     file_put_contents(FCPATH.'assets/profile/'.$image_name.'.jpeg', $decodedImage);
//                     $pan_back = $image_name.'.jpeg';
                    
//                   $image_full_path=base_url().'assets/profile/'.$pan_back;
//             }
				    
// 				    $arr = array('member_id' =>$memberId,
// 					'first_name'=>$member_first_name,
// 					'middle_name'=>$member_middle_name,
// 					'last_name'=>$member_last_name,
// 		        	'birthdate'=>$member_dob,
// 					'aadhar_id'=>$aadhar_id,
// 					'adhar_card_doc'		=>$adhar_front,
// 					'adhar_card_back'		=>$adhar_back,
// 					'pan_card_no'			=>$pan_no,
// 					'pan_card_front'		=>$pan_front,
// 					'pan_card_back'		    =>$pan_back,
// 					'passport_id'=>   $passport_id,
// 					'passport_doc'			=>$passport_front,
// 					'passport_back_doc'		=>$passport_back,
// 					'driving_lic_id'=>$driving_lic_id,
// 					'driving_lic_doc'		=>$driving_front,
// 					'driving_lic_back_doc'	=>$driving_back,
// 					'address_verify_option'=>$address_varify,
// 					'address'=>$member_address
// 					);
				
// 					$this->Home_model->insert_data('isp_profile_doc_details',$arr); 
// 				    $data=array(
// 								'member_profile'=>$selfie,
// 								'kyc_status'=>"Under_process",
// 								'member_address'	=>$member_address,
// 								'member_pan_card'	=>$pan_no
// 								);
// 					$this->db->where('member_id',$memberId);
// 					$this->db->update('isp_members',$data);
// 				}
// 				$message=' Dear User, Your KYC Documents uploaded successfully. Wait for KYC verification, Currently your KYC verification under process. ';
// 				$subject = 'KYC document uploaded successfully.';
// 				$to =$email_id;
// 				send_email($to,$subject,$message);
				
// 				$response['status']="success";
//                 $response['data'] = "";
//                 $response['message'] = "KYC Document uploaded successfully"; 
// 			}
			
// 		}
		
//         }
//     else
//             {
//               $response['status']     = 'fail';
//             $response['message']    = validation_errors();
//             }
//             	echo json_encode($response);
//     }
    public function kyc_details()
	{		
	    
	    $response['status']     = 'fail';
        $response['message']    = '';
        $response['data']       = [];
        

		 $this->form_validation->set_rules('member_id', 'Member Id', 'required|trim');
        if ($this->form_validation->run() == TRUE)
        {
            $member_id = $this->input->post('member_id');
            $result=$this->db->get_where('isp_members',array('member_id'=>$member_id))->row();
    	  
    	    if ($result !="")
            {
                $img = '';$pid = ''; $did = '';$aid='';$member_first_name='';$fname=""; $mname=""; $lname=""; $dob="";$pan_no="";
                $details=	getMember_doc_Details($member_id);
                
                if($details !='')
                {
                	if($details->first_name){ $fname=$details->first_name; }
                	if($details->middle_name){ $mname=$details->middle_name; }
                    if($details->last_name){ $lname=$details->last_name; }
                	if($details->birthdate){ $dob=$details->birthdate; }
                    $pan_imgf = '';  $pan_imgb = ''; 							
                    if($details->pan_card_front)
                    { 
                        $pan_imgf = base_url().'assets/profile/'.$details->pan_card_front;
                        $pan_imgb = base_url().'assets/profile/'.$details->pan_card_back;
                        $pan_no= $details->pan_card_no;
                    } 
              
                    $img2 = '';  $img2b = ''; 							
                    if($details->driving_lic_doc)
                    { 
                        $img2 = base_url().'assets/profile/'.$details->driving_lic_doc;
                        $img2b = base_url().'assets/profile/'.$details->driving_lic_back_doc;
                        $did= $details->driving_lic_id;
                    } 

                    $img3 = '';$img3b = '';
					if($details->passport_doc)
					{ 
                        $img3 = base_url().'assets/profile/'.$details->passport_doc;
                        $img3b = base_url().'assets/profile/'.$details->passport_back_doc;
                        $pid= $details->passport_id;
                    }
                    $adhar_front = '';$adhar_back = '';
					if($details->adhar_card_doc)
					{ 
                        $adhar_front = base_url().'assets/profile/'.$details->adhar_card_doc;
                        $adhar_back = base_url().'assets/profile/'.$details->adhar_card_back;
                        $aid= $details->aadhar_id;
                    }
                    $img4 = '';
                    $add='';
					if($details->verify_address_doc)
					{ 
                        $img4 = base_url().'assets/profile/'.$details->verify_address_doc;
                        $add = $details->address;
                    } 
                    $profile_photo="";
                    if($details->member_photo)
                    { 
                        $profile_photo = base_url().'assets/profile/'.$details->member_photo;
                     
                    } 
                }
                else
                {
                    $fname=""; $mname=""; $lname=""; $dob=""; $img2 = ''; $img2b = ''; $img = '';$pid = ''; $did = ''; $img4 = '';
                $add=''; $img3 = '';$img3b = '';  $adhar_front = '';$adhar_back = '';$aid='';$profile_photo='';$pan_no="";$pan_imgf="";$pan_imgb="";
                }
                
                $data = array( 
						'first_name'    	=> $fname,
						'middle_name'   	=> $mname,
						'last_name' 	=> $lname,
						'dob' 	=> $dob,
						'driving_lic_front' 	=> $img2,
						'driving_lic_back' 	=> $img2b,
						'passport_id' 	=> $pid,
						'driving_lic_id'  => $did,
						'verify_address_doc'=> $img4,
						'address'   	=> $add,
						'passport_doc_front' 	=> $img3,
						'passport_doc_back' 	=> $img3b,
						'adhar_front' 	=> $adhar_front,
						'adhar_back' 	=> $adhar_back,
						'aadhar_id' 	=> $aid,
						'pan_front' 	=> $pan_imgf,
						'pan_back' 	=> $pan_imgb,
						'pan_card_no' 	=> $pan_no,
						'profile_photo' 	=> $profile_photo,
						'member_mobile' 	=> $result->member_mobile,
						'member_email_id' 	=> $result->member_email_id
						); 
					$response['status']     = 'success';
                    $response['message']    = 'KYC Details';
                    $response['data']       = $data; 
				
            }
            else
            {
                $response['status']     = 'fail';
                $response['message']    = 'No data found';
                $response['data']       = [];
            }
        }
        else{
            $response['status']     = 'fail';
            $response['message']    = validation_errors();
        }
        echo json_encode($response);
	}
	public function add_bank_details()
	{		
	   
	    $response['status']     = 'fail';
        $response['message']    = '';
        $response['data']       = [];

        $this->form_validation->set_rules('account_holder_name', 'Account Holder Name', 'required|trim');
        $this->form_validation->set_rules('account_no', 'Account Number', 'required|trim');
        $this->form_validation->set_rules('bank_name', 'Bank Name', 'required|trim');
        $this->form_validation->set_rules('ifsc_code', 'IFSC Code', 'required|trim');
        $this->form_validation->set_rules('branch_name', 'Branch Name', 'required|trim');
		
        if ($this->form_validation->run() == TRUE)
        {
            $member_id = $this->input->post('member_id');
            $account_holder_name = $this->input->post('account_holder_name');
            $account_no = $this->input->post('account_no');
            $bank_name = $this->input->post('bank_name');
            $ifsc_code = $this->input->post('ifsc_code');
            $branch_name = $this->input->post('branch_name');
              
          $data =array(
                              "member_id"=>$member_id,
                             "member_account_name"=>$account_holder_name,
                            "member_account_no"=>$account_no,
                            "member_bank_name"=>$bank_name,
                            "member_ifsc_code"=>$ifsc_code,
                            "member_branch_name"=>$branch_name
                           
                            
                          
                           );
          
            $this->db->insert('isp_banks', $data);
            $insert_id = $this->db->insert_id();
          
            
                $response['status']     = 'success';
                $response['message']    = 'Dashboard';
                $response['data']       = $data;
        }
        else{
            $response['status']     = 'fail';
            $response['message']    = validation_errors();
        }
        echo json_encode($response);
	}
		public function fetch_bank_details()
    { 
        $response['status']             = 'fail';
        $response['message']            = '';
        $response['data']               = '';
        $result                         = '';
        $data="";
        $member_id = $this->input->post('member_id') ;
      
        
        if(!empty($member_id)){
 
            $this->db->select('*');
            $this->db->from('isp_banks');
           
            $this->db->where('member_id',$member_id);
            $query                      = $this->db->get();
            $result                     = $query->result();
             $data = $query->result();
             
          
             
             if(!empty($result)){
                 $i=0;
                foreach($result as $row){
                  $response['data']     = $result;
                     $i++;
                }
                $response['status']     = 'success';
              
            }
            else{
                $response['message']    = 'No Data Found';
            }
       
        echo json_encode($response);
    }
    }
	public function edit_bank_details()
	{		
	   
	    $response['status']     = 'fail';
        $response['message']    = '';
        $response['data']       = [];

      
           $member_id     = $this->input->post('member_id'); 
        
          $details   = $this->db->get_where('isp_banks',array('member_id'=>$member_id))->row();
       
     if($details !='')
 {
           
            $account_holder_name = $this->input->post('account_holder_name');
           
            $account_no = $this->input->post('account_no');
            $bank_name = $this->input->post('bank_name');
            $ifsc_code = $this->input->post('ifsc_code');
            $branch_name = $this->input->post('branch_name');
               
         $sql1="Update isp_banks set   member_account_name='".$account_holder_name."' ,
                member_account_no='".$account_no."',
          
               member_bank_name='".$bank_name."',
                member_ifsc_code='".$ifsc_code."',
                member_branch_name='".$branch_name."'
                
           
                      where member_id='".$member_id."' ";
                      
                
                $last_id = $this->db->query($sql1);
       
                if($last_id !="")
                { 
                    
                    $response['status']="success";
                    $response['data'] = "";
                    $response['message'] = "Data Updated Successfully"; 
                }
              
 }
  else{
            $response['status']     = 'fail';
            $response['message']    = validation_errors();
        }
        
        echo json_encode($response);
	}
	
	
		public function view_profile()
    { 
        $response['status']             = 'fail';
        $response['message']            = '';
        $response['data']               = '';
        $result                         = '';
        $data="";
        $member_id = $this->input->post('member_id') ;
      
        
        if(!empty($member_id)){
 
            $this->db->select('member_profile');
            $this->db->from('isp_members');
           
            $this->db->where('member_id',$member_id);
            $query                      = $this->db->get();
            $result                     = $query->result();
             $data = $query->result();
             
          
             
             if(!empty($result)){
                 $i=0;
                foreach($result as $row){
                  $response['data']     = $result;
                     $i++;
                }
                $response['status']     = 'success';
              
            }
            else{
                $response['message']    = 'No Data Found';
            }
       
        echo json_encode($response);
    }
    }
    
    	public function income()
    { 
        $response['status']             = 'fail';
        $response['message']            = '';
        $response['data']               = '';
        $result                         = '';
        $data="";
        $member_id = $this->input->post('member_id') ;
      
        
        if(!empty($member_id)){
 
            $this->db->select('*');
            $this->db->from('isp_income_bank_details');
           
            $this->db->where('member_id',$member_id);
            $query                      = $this->db->get();
            $result                     = $query->result();
        
             $data = $query->result();
             
          
             
             if(!empty($result)){
                 $i=0;
                foreach($result as $row){
                  $response['data']     = $result;
                     $i++;
                }
                $response['status']     = 'success';
              
            }
            else{
                $response['message']    = 'No Data Found';
            }
       
        echo json_encode($response);
    }
    }
    	public function income_details()
    { 
        $response['status']             = 'fail';
        $response['message']            = '';
        $response['data']               = '';
        $result                         = '';
        $data="";
        $day = $this->input->post('day');
        $month = $this->input->post('month');
        $year = $this->input->post('year');
        $member_id = $this->input->post('member_id');     
        $monthNumber = date_parse(date('Y') . '-' . $month)['month'];
       
            if (strlen($monthNumber) == 1) 
            {
                $monthNumber = "0" . $monthNumber;
            }
          
			if($day!='All')
			{
		        $date = $year."-".$monthNumber."-".$day;
		    
        
        //   $date1 = $year."-".$month."-".$day;
        //   echo $date1;die;
        // $this->db->select('*');
        // $this->db->from('isp_level_income'); 
        // $this->db->where('income_date =',$date); 
        // $this->db->where('income_member_id =',$member_id);
        // $this->db->order_by('income_id','desc');
        // $q = $this->db->get();
        
        $this->db->select('isp_level_income.*,isp_members.member_name,isp_members.member_login_id');
        $this->db->from('isp_level_income'); 
        $this->db->join('isp_members', 'isp_members.member_id = isp_level_income.income_member_by');
        $this->db->where('income_date', $date); 
        $this->db->where('income_member_id', $member_id);
        $this->db->order_by('income_id', 'desc');
        $q = $this->db->get();
        $result = $q->result();
      
        if(!empty($result)){
                 $i=0;
                foreach($result as $row){
                  $response['data']     = $result;
                     $i++;
                }
                $response['status']     = 'success';
              
            }
            else{
                $response['message']    = 'No Data Found';
            }
       
        echo json_encode($response);
    }
    }
  	public function get_member_name()
    { 
        $response['status']             = 'fail';
        $response['message']            = '';
        $response['data']               = '';
        $result                         = '';
        $data="";
   
        $member_id = $this->input->post('member_id');     
       
        $sql = 'select * from isp_members where member_id="'.$member_id.'"'; 
        $query = $this->db->query($sql);
        $row = $query->row();
        $member_name=$row->member_name;
             
          
             
             if(!empty($row)){
                
                  $response['data']     = $member_name;
               
                $response['status']     = 'success';
              
            }
            else{
                $response['message']    = 'No Data Found';
            }
       
        echo json_encode($response);
    
    }
} //class closed