<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Binary_roi_wallet extends CI_Controller { 
	function __construct()
	{
		parent::__construct();
		$this->load->helper(array('form', 'url','all_function'));
		$this->load->helper('security');
		$this->load->library('form_validation');
		$this->load->library('session');  
		date_default_timezone_set('Asia/Kolkata'); 
		$this->load->model('Member_product_mdl');  	
	}
 
	 public function index()
	 { 	  	
	 	$data['main_content']      = "front/binary_roi_wallet";
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$memberId=$user_data['user_id'];  
	 	//binary ROI level start 
	 	$levels = $this->config->item('binary_roi_levels');
	 	$sr = 0;
	 	$level_count =0;
	 	$required = array('2','4','8','16','32');

	 	for ($i=1; $i <= count($levels); $i++) 
	 	{ 	
	 		$isExist = ''; 
	 		$memberlevel = $i;
	 		$percentage = $levels[$i];
	 		$level_count = $this->Member_product_mdl->count_levels_members($memberId,$memberlevel); 
	 		   
	 		if ($level_count=='') { 
	 			$level_count = 0;
 			}
 			$in = array('binary_member_id' =>$memberId,
 						'binary_leve'=>$memberlevel,
 						'binary_ROI_percentage'=>$percentage,
 						'binary_required_count'=>$required[$sr],
 						'binary_actual_count'=>$level_count
 						); 

	 		$isExist = $this->db->get_where('binary_wallet',array('binary_member_id' =>$memberId,'binary_leve'=>$memberlevel))->row();

	 		if ($isExist=='') 
	 		{	 			
	 			$this->db->insert('binary_wallet',$in);
	 		}
	 		else
	 		{
	 			$this->db->where('binary_id',$isExist->binary_id);
	 			$this->db->update('binary_wallet',$in);
	 		}

	 		$sr++;
	 	}	 
	 	//binary ROI level end 
	 	  
	 	$data['all_level']=$this->db->order_by('binary_leve','ASC')->get_where('binary_wallet',array('binary_member_id'=>$memberId))->result();	

	 	if ($data['all_level']!='') 
	 	{
	 		foreach ($data['all_level'] as $key) 
	 		{
	 		  $percentage = $key->binary_ROI_percentage;  
	 		  $binary_level = $key->binary_leve;  
	 		  $this->Member_product_mdl->check_binary_level($memberId,$binary_level,$percentage);
	 		}  
	 	}    

	 	$data['all_level_data']=$this->db->order_by('binary_leve','ASC')->get_where('binary_wallet',array('binary_member_id'=>$memberId))->result();	  
	 	$this->load->view('front/includes/template',$data);

	 } 
  	
  	public function withdrawal_request()
  	{
  	  	$data['main_content']      = "front/report_payment";
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];	
  	  	$this->load->view('front/includes/template',$data);
  	}
  
} //class closed..