<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Donation extends CI_Controller {
	function __construct()
	{
		parent::__construct();
		$this->load->helper(array('form', 'url','all_function'));
		$this->load->helper('security');
		$this->load->library('form_validation'); 
		$this->load->model('Admin_donation_mdl'); 
		if(!isset($this->session->userdata['mlm_admin_logged_in']))
		{
			redirect('admin/index');
		}
		if($this->session->userdata('tree_star')!=NULL)
		{ 
			$ar = array('username'=>'','member_name'=>'','user_id'=>'');
			$this->session->set_userdata('tree_star',$ar);
			$this->session->set_userdata('myNet','');   
		}
	}

	public function awaiting_members()
	{
		$data['page_title'] = "Awaiting Confirmation Members";
		$data['main_content'] = "admin/awaiting_donation_members";

		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');  
 			$donation_type   =  $this->input->post('donation_type');      
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date');
 			$data['donation_type']   = $this->input->post('donation_type');

 			$data['members_data'] = $this->Admin_donation_mdl->ser_awa_donation_members_data($from_date,$to_date,$donation_type);   
 		} 
 		else
 		{
 		  $data['stage_le']=''; 
 		  $data['donation_type']='';		
 		  $data['members_data'] = $this->Admin_donation_mdl->get_awa_donation_members_data($from_date='',$to_date='',$donation_type='');		 
 		} 
 		 
		$this->load->view('admin/includes/template',$data);
	} 

	public function payment_members()
	{
		$data['page_title'] = "Payment Confirmation Members";
		$data['main_content'] = "admin/donation_members";

		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');       
 			$donation_type   =  $this->input->post('donation_type');       
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date');
 			$data['donation_type']   = $this->input->post('donation_type');
 			 
 			$data['members_data'] = $this->Admin_donation_mdl->get_search_donation_members(array('donate_status'=>'paid','donate_blocked_member'=>0),$from_date,$to_date,$donation_type);   
 		} 
 		else
 		{
 		  $data['stage_le']=''; 
 		  $data['donation_type']='';	
 		  $data['members_data'] = $this->Admin_donation_mdl->get_donation_members_data(array('donate_status'=>'paid','donate_blocked_member'=>0));		 
 		} 

		$this->load->view('admin/includes/template',$data);
	} 

	public function rejected_members()
	{
		$data['page_title'] = "Rejected Members";
		$data['main_content'] = "admin/donation_members";

		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');       
 			$donation_type   =  $this->input->post('donation_type');

 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date');
 			$data['donation_type']   = $this->input->post('donation_type');

 			$data['members_data'] = $this->Admin_donation_mdl->get_search_donation_members(array('donate_status'=>'cancel'),$from_date,$to_date,$donation_type);   
 		} 
 		else
 		{
 		  $data['stage_le']=''; 	
 		  $data['donation_type']='';
 		  $data['members_data'] = $this->Admin_donation_mdl->get_donation_members_data(array('donate_status'=>'cancel'));		 
 		} 

		$this->load->view('admin/includes/template',$data);
	} 

	public function accept_donation()
	{
		$donateId = $this->uri->segment(3);  
		$donateBy = $this->uri->segment(4);  

		$this->db->where('donate_id',$donateId);
		$up = $this->db->update('donations',array('donate_status'=>'paid'));

		if($up)
		{
			$data = $this->Admin_donation_mdl->get_donatedBy_data($donateBy);
			
			$get_details=$this->db->get_where('donations',array('donate_id'=>$donateId))->row();
			$pay_by=$get_details->donate_by;
			$pay_to=$get_details->donate_to;
			$check_status=$this->db->get_where('donations',array('donate_by'=>$pay_by,'donate_status'=>'paid'))->result();
			
			
		  if($check_status)
			{
				$total=count($check_status);							
				if($total>=2)
				{
					$params2=array(
					'member_status'=>'Approve',
					'is_paid'=>'Yes'	
					);
			
					$this->db->where('member_id',$pay_by);
					$this->db->update('members',$params2);
				}
			}
		}

		$this->session->set_flashdata('success','Donation accept successfully');

		redirect('donation/awaiting_members');
	}

	public function reject_donation()
	{
		$donateId = $this->uri->segment(3);   
		$donateBy = $this->uri->segment(4); 

		$this->db->where('donate_id',$donateId);
		$up = $this->db->update('donations',array('donate_status'=>'cancel'));
 		
 		if($up)
		{ 
			$user_details=$this->db->get_where('members',array('member_id'=>$donateBy))->row();

			$upline_id=$user_details->member_upline_id;		
		
			$upline_details=$this->db->get_where('members',array('member_id'=>$upline_id))->row();

		   if($upline_details->member_downline1==$user_details->member_id)
			{					
				$var= 1;					
			}
			if($upline_details->member_downline2==$user_details->member_id)
			{
				$var= 2;					
			}
			if($upline_details->member_downline3==$user_details->member_id)
			{
				$var=3;					
			}
			if($upline_details->member_downline4==$user_details->member_id)
			{
				$var=4;					
			}
						 
			$this->db->where('member_id',$upline_id);
			$this->db->update('members',array("member_downline$var"=>null)); 

		    $this->db->where('member_id',$donateBy);
	        $this->db->update('members',array('member_status'=>'Deleted'));  
		} 

		$this->session->set_flashdata('success','Donation rejected successfully');

		redirect('donation/awaiting_members');
	}

	public function blocked_payment_members()
	{
		$data['page_title'] = "Blocked Payment";
		$data['main_content'] = "admin/blocked_donation_members";

		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');       
 			$donation_type   =  $this->input->post('donation_type');       
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date');
 			$data['donation_type']   = $this->input->post('donation_type');
 			 
 			$data['members_data'] = $this->Admin_donation_mdl->get_search_donation_members(array('donate_status'=>'paid','donate_blocked_member!='=>0),$from_date,$to_date,$donation_type);   
 		} 
 		else
 		{
 		  $data['stage_le']=''; 
 		  $data['donation_type']='';	
 		  $data['members_data'] = $this->Admin_donation_mdl->get_donation_members_data(array('donate_status'=>'paid','donate_blocked_member!='=>0));		 
 		} 

		$this->load->view('admin/includes/template',$data);
	}

	public function ticket_support()
	{
		$data['page_title'] = "Support Ticket";
		$data['main_content'] = "admin/ticket_support";

		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');        
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date'); 

 			$data['members_data'] = $this->Admin_donation_mdl->get_tickets_data($from_date,$to_date);   
 		} 
 		else
 		{
 		  $data['from_date']=''; 
 		  $data['to_date']='';		
 		  $data['members_data'] = $this->Admin_donation_mdl->get_tickets_data($from_date='',$to_date='');		 
 		} 

		$this->load->view('admin/includes/template',$data);
	} 

	public function ticket_reply()
	{
		$reply = $this->input->post('ticket_reply');
		$id = $this->input->post('ticket_id');

		if ($id!='' && $reply!='') 
		{
			$ar = array('ticket_reply' =>$reply,'ticket_status'=>'Replied');
			$this->db->where('ticket_id',$id);
			$this->db->update('ticket_support',$ar);

			$this->session->set_flashdata('success', 'Ticket reply send successful.');
			redirect('donation/ticket_support');
		}
	}


	public function donation_given()
	{
		$data['page_title'] = "Donation Given Members";
		$data['main_content'] = "admin/donation_given_members";

		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');  
 			$donation_type   =  $this->input->post('donation_type');      
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date');
 			$data['donation_type']   = $this->input->post('donation_type');

 			$data['members_data'] = $this->Admin_donation_mdl->donation_given_members_data($from_date,$to_date);   
 		} 
 		else
 		{
 		  $data['stage_le']=''; 
 		  $data['donation_type']='';		
 		  $data['members_data'] = $this->Admin_donation_mdl->donation_given_members_data($from_date='',$to_date='');		 
 		} 

		$this->load->view('admin/includes/template',$data);
	} 


	public function donation_receiver()
	{
		$data['page_title'] = "Donation Receiver Members";
		$data['main_content'] = "admin/donation_receiver_members";

		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');  
 			$donation_type   =  $this->input->post('donation_type');      
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date');
 			$data['donation_type']   = $this->input->post('donation_type');

 			$data['members_data'] = $this->Admin_donation_mdl->donation_receiver_members_data($from_date,$to_date);   
 		} 
 		else
 		{
 		  $data['stage_le']=''; 
 		  $data['donation_type']='';		
 		  $data['members_data'] = $this->Admin_donation_mdl->donation_receiver_members_data($from_date='',$to_date='');		 
 		} 

		$this->load->view('admin/includes/template',$data);
	} 

	public function sponsor_income()
	{
		$data['page_title'] = "Referral Income";
		$data['main_content'] = "admin/sponsor_income";

		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');        
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date'); 

 			$data['income'] = $this->Admin_donation_mdl->get_sponsor_income($from_date,$to_date);   
 		} 
 		else
 		{ 		
 		 	$data['income'] = $this->Admin_donation_mdl->get_sponsor_income($from_date='',$to_date='');		 
 		} 

		$this->load->view('admin/includes/template',$data);
	} 

	public function binary_income()
	{
		$data['page_title'] = "Matching Income";
		$data['main_content'] = "admin/binary_income";

		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');        
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date'); 

 			$data['income'] = $this->Admin_donation_mdl->get_binary_income($from_date,$to_date);   
 		} 
 		else
 		{ 		
 		 	$data['income'] = $this->Admin_donation_mdl->get_binary_income($from_date='',$to_date='');		 
 		} 

		$this->load->view('admin/includes/template',$data);
	} 

	public function level_income()
	{
		$data['page_title'] = "Level Income";
		$data['main_content'] = "admin/level_income";

		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');        
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date'); 

 			$data['income'] = $this->Admin_donation_mdl->get_level_income($from_date,$to_date);   
 		} 
 		else
 		{ 		
 		 	$data['income'] = $this->Admin_donation_mdl->get_level_income($from_date='',$to_date='');		 
 		} 

		$this->load->view('admin/includes/template',$data);
	} 

	public function jackpot_income()
	{
		$data['page_title'] = "Jackpot Income";
		$data['main_content'] = "admin/jackpot_income";

		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');        
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date'); 

 			$data['income'] = $this->Admin_donation_mdl->get_jackpot_income($from_date,$to_date);   
 		} 
 		else
 		{ 		
 		 	$data['income'] = $this->Admin_donation_mdl->get_jackpot_income($from_date='',$to_date='');		 
 		} 

		$this->load->view('admin/includes/template',$data);
	} 

	public function topup_income()
	{
		$data['page_title'] = "Toup Income";
		$data['main_content'] = "admin/level_income";

		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');        
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date'); 

 			$data['income'] = $this->Admin_donation_mdl->get_topup_income($from_date,$to_date);   
 		} 
 		else
 		{ 		
 		 	$data['income'] = $this->Admin_donation_mdl->get_topup_income($from_date='',$to_date='');		 
 		} 

		$this->load->view('admin/includes/template',$data);
	} 

	public function rank_qualification()
	{
		$data['page_title'] = "Rank Qualification";
		$data['main_content'] = "admin/rank_qualification";

		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');        
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date'); 

 			$data['rewards'] = $this->Admin_donation_mdl->get_rank_qualification($from_date,$to_date);   
 		} 
 		else
 		{ 		
 		 	$data['rewards'] = $this->Admin_donation_mdl->get_rank_qualification($from_date='',$to_date='');		 
 		} 

		$this->load->view('admin/includes/template',$data);
	} 


	public function award_rewards_paid()
	{
		$income_id = $this->input->post('income_id');

		$row = $this->db->get_where('isp_rank_income',array('income_id'=>$income_id,'income_status'=>'Unused'))->row();
 
		if($row)
		{
			$income_id = $row->income_id;
			$member_id = $row->income_member_id;

			$description = $this->input->post('description');
			$type = $this->input->post('type');
			$date = $this->input->post('date');  
			
			$award = array( 
		  				 'income_award_description' =>$description,
		  				 'income_award_type'		=>$type,
		  				 'income_award_date'		=>$date, 
		  				 'income_status'			=>'Used', 
		  				  );

			  $this->db->where('income_id',$income_id);
			  $this->db->update('rank_income',$award);

			  $this->session->set_flashdata('success','Rewards paid success..');  
		 
		}
		
		redirect('donation/rank_qualification'); 
		
	}

} //class closed