<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Epin extends CI_Controller {
	function __construct()
	{
		parent::__construct();
		$this->load->helper(array('form', 'url','all_function'));
		$this->load->helper('security');
		$this->load->library('form_validation');
		$this->load->model('login_database');
		$this->load->model('Epin_model');
		$this->load->model('Member_network_mdl');
		$this->load->model('Home_model');
		$this->load->model('Payments_model'); 
		//$this->load->database($db);
		date_default_timezone_set("Asia/Calcutta");


		if($this->session->userdata('tree_star')!=NULL)
		{ 
			$ar = array('username'=>'','member_name'=>'','user_id'=>'');
			$this->session->set_userdata('tree_star',$ar);
			$this->session->set_userdata('myNet','');   
		}
	}
	public function index()
	{
		
	}
	public function generate_epin_by_admin()
 	{
 	  
 		$data['page_title']   = "Generate E-PIN";
 		$data['main_content'] = "admin/generate_epin";
		if($this->input->post('submit')=='submit')
		{
		  
			$this->form_validation->set_rules('epin_qty','Quantity','required');
            $this->form_validation->set_rules('member_login_id','Login Id','required');
            $this->form_validation->set_rules('epin_type','Epin Type','required');
			if($this->form_validation->run()==TRUE)
			{ 
				$qty 				= $this->input->post('epin_qty');
				$request_member_id  = $this->input->post('request_member_id');
				$epin_type  = $this->input->post('epin_type');
			


				if($qty!='' && $request_member_id!='')
				{ 						
					for($i=0;$i<$qty;$i++)
					{
						$digit= rand(pow(10, 7-1), pow(10, 7)-1);
    				    $alphabet = range('A', 'Z'); // Array containing all capital letters
                        $randomLetter = $alphabet[array_rand($alphabet)]; // Randomly select an alphabet
                        
						$epin= 'SK'.$randomLetter.$digit; 
						$insertData = array(
							'epin_member_id'  =>$request_member_id,	 
							'epin'  =>$epin,
						    'epin_type'  	  =>$epin_type,
							'epin_added_date'   =>date('Y-m-d H:i:s'),  
							'epin_status'  	  =>'Unused'
							
							 ); 
						$result=$this->db->insert('epin',$insertData); 
                        $result = $i;
					}
					
					$this->session->set_flashdata('success','Epin Generated successfully...');
					redirect('epin/generate-epin');
				}
				else
				{
					$this->session->set_flashdata('fail','Something went wrong...');
					redirect('epin/generate-epin');
				}
			}
		}
		$this->load->view('admin/includes/template',$data); 
 	}
	 public function epin_request()
	{
		$data['page_title'] = "Epin Request";
		$data['epin_request']=$this->Epin_model->get_epin_request($filters='');
		if($this->input->post('submit')=='submit')
		{
			$this->form_validation->set_rules('request_quantity','Quantity','required');
			if($this->form_validation->run()==TRUE)
			{
			$id = $this->input->post('request_id');
			$qty = $this->input->post('request_quantity');
			$data=array('request_quantity'=>$qty); 
			$update = $this->Epin_model->update($data,'request_id='.$id,'epin_request');
			$details = $this->Epin_model->select_single_row('epin_request',array('request_id'=>$id));
			$member_id = $details->request_member_id; 
			for($i=0;$i<$qty;$i++)
			{
				$digit = date('H').date('i').date('s'); 
				$Last_char = $this->generateRandomString(); 
				$epin="IS".$digit.$Last_char;
				$_POST['epin_member_id']=$member_id;
				$_POST['epin']=$epin;
				$_POST['epin_added_by']="";
				$_POST['epin_added_date']=date('Y-m-d H:i:s');
				$_POST['epin_status']='Unused';
				$insert = $this->Epin_model->insertData('epin');
				$result = $i;
			}
			$data=array('request_status'=>'Approve'); 
			$update = $this->Epin_model->update($data,'request_id='.$id,'epin_request');
			$this->session->set_flashdata('success','Epin Generate  successfully...'); 
			redirect('epin/epin_request');
			}
		} 

		if (isset($_POST['search']))
		{
			$filters = $this->input->post('search_filters'); 
			$data['filters']  = $filters;
			$data['epin_request']=$this->Epin_model->get_epin_request($filters);
		}

		$data['main_content'] = "admin/view_epin_request";
		$this->load->view('admin/includes/template',$data);
	}
	public function transfer_list()
	{
		$data['page_title']   = "Epin Transfer list";
 		$data['main_content'] = "admin/epin_transfer_list";
 		$data['trans_history']	  = $this->Epin_model->get_transfer_list();
		$this->load->view('admin/includes/template',$data);
	}
	public function epin_requested()
	{
		$data['page_title']   = "Requested Epin list";
 		$data['main_content'] = "admin/requested_epin";
 		$data['requested']	  = $this->Epin_model->get_requested();
 
		$this->load->view('admin/includes/template',$data);
	}
		public function update_request_status()
	{
	    echo "F";die;
		$data['page_title']   = "Requested Epin list";
 		$data['main_content'] = "admin/requested_epin";
 		$data['requested']	  = $this->Epin_model->get_requested();
 
		$this->load->view('admin/includes/template',$data);
	}
	public function cancel_request()
	{
		$id = $this->uri->segment(3);
		$data = $this->Epin_model->cancel_request($id);
		if($data>0)
		{
			$this->session->set_flashdata('success',
				'Epin Request canceled successfully...');
		}
		else
		{
			$this->session->set_flashdata('fail',
				'Epin Request Not canceled');	
		}
		redirect('epin/epin_request');
	}
	public function get_qty()
	{
		$id=$this->input->post('id');
		//$data = $this->Epin_model->get_quantity($id);
		//echo "<input type='hidden' name='request_id' value='".$data->request_id."'><input type='text' id='request_quantity' name='request_quantity' value='".$data->request_quantity."' class='form-control'>";
	
	
	
	}
	function generateRandomString($length = 6) 
	{
	    $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
	    $charactersLength = strlen($characters);
	    $randomString = '';
	    for ($i = 0; $i < $length; $i++) {
	        $randomString .= $characters[rand(0, $charactersLength - 1)];
	    }
	    return $randomString;
	}

 	public function view_epin()
 	{
 		$data['page_title']   = "View Used Epin List";
 		$data['main_content'] = "admin/view_epin_list";

 		if (isset($_POST['search']))
 		{
 		    $from_date = $this->input->post('from_date');
 		    $to_date   = $this->input->post('to_date');  
 		    
 		    $data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date');

 		    $data['epin_data']	  = $this->Epin_model->get_search_epin_data($from_date,$to_date); 
 		}
 		else
 		{
 			$data['epin_data']	  = $this->Epin_model->get_epin_data();
 		}
 
		$this->load->view('admin/includes/template',$data);
 		
 	}
 	public function view_unused_epin()
 	{
 		$data['page_title']   = "View Unused Epin List";
 		$data['main_content'] = "admin/view_unused_epin_list";
 		$data['epin_data']	  = $this->Epin_model->get_unused_epin_data();
		$this->load->view('admin/includes/template',$data);
 	}	
 
 	public function view_members()
 	{
 		$data['page_title']   = "View Active Members List";
 		$data['main_content'] = "admin/view_member_list";  
 		$data['stage_le']=''; 	
 		$data['members_data'] = $this->Epin_model->get_view_members_data();
 	    $this->load->view('admin/includes/template',$data); 
 	}
 	public function view_member_orders()
 	{
 		$data['page_title']   = "View Member Orders";
 		$data['main_content'] = "admin/view_member_orders";  
 		$id = $this->uri->segment(3);

 		$data['members_data'] = $this->Epin_model->get_view_members_orders($id);
 	    $this->load->view('admin/includes/template',$data); 
 	}
    public function view_kyc_members()
 	{
 		$data['page_title']   = "View KYC Members List";
 		$data['main_content'] = "admin/view_kyc_member_list";  
       // $data['members_data'] = $this->Epin_model->get_kyc_members_data();
        $data['members_data'] = $this->Epin_model->view_kyc_members();
        $this->load->view('admin/includes/template',$data); 
 	}
 	public function daily_staking_income()
 	{
 		$data['page_title']   = "View Daily Income List";
 		$data['main_content'] = "admin/view_daily_income";  
	    $data['income'] = $this->Epin_model->get_daily_income_data();
        	

		$this->load->view('admin/includes/template',$data); 
 	}
 		public function daimond_income()
 	{
 		$data['page_title']   = "View Daimond Income List";
 		$data['main_content'] = "admin/view_daimond_income";  
	    $data['income'] = $this->Epin_model->get_daimond_income_data();
        	

		$this->load->view('admin/includes/template',$data); 
 	}
 	public function income_list()
 	{
 		$data['page_title']   = "View  Income List";
 		$data['main_content'] = "admin/referral_income";  
        
       
        if($this->input->post("btn_submit"))
		{ 
		  
			$day_selected=$this->input->post("day_selected");
			$month_selected=$this->input->post("month_selected");
			$year_selected=$this->input->post("year_selected");
			$monthNumber = date_parse(date('Y') . '-' . $month_selected)['month'];
            if (strlen($monthNumber) == 1) 
            {
                $monthNumber = "0" . $monthNumber;
            }
          
			if($day_selected!='All')
			{
		        $date = $year_selected."-".$monthNumber."-".$day_selected;
		      //  if($day_selected =='01')
		      //  {
		      //      $lastMonth = new DateTime('last month');
		      //      $fromDate = $lastMonth->format('Y-m-21');
	       //         $todate = date('Y-m-d', strtotime('last day of last month'));
            	    
                    
		      //  }
		      //  else if($day_selected=='11')
		      //  {
		      //      $fromDate = date('Y-m-01');
        //             $todate = date('Y-m-10');
		      //  }
		      //  elseif($day_selected=='21')
		      //  {
		      //      $fromDate = date('Y-m-11');
        //             $todate = date('Y-m-20');
		      //  }
		      //  echo "from date : ". $fromDate." to date : ".$todate;die;
				$data['income'] = $this->Epin_model->get_referral_income_datewisedata2($date);
				// echo $this->db->last_query();die;
				// print_r($data['income']);die;
				$data['day_selected']=$day_selected;
				$data['month_selected']=$month_selected;
				$data['year_selected']=$year_selected;
			}
			else
			{
				// $data['income'] = $this->Epin_model->get_referral_income_data();
					$data['income'] = array();
				$data['day_selected']='All';
    			$data['month_selected']='All';
    			$data['year_selected']='All';
			}
			
		}

		else
		{
		  //  $data['income'] = $this->Epin_model->get_referral_income_data();
		    	$data['income'] = array();
			$data['day_selected']='All';
			$data['month_selected']='All';
			$data['year_selected']='All';
		}	
		
		if($this->input->post("csv_submit"))
		{ 
		 
			$day_selected=$this->input->post("day_selected");
			$month_selected=$this->input->post("month_selected");
			$year_selected=$this->input->post("year_selected");
			$monthNumber = date_parse(date('Y') . '-' . $month_selected)['month'];
            if (strlen($monthNumber) == 1) 
            {
                $monthNumber = "0" . $monthNumber;
            }
          
		    $date = $year_selected."-".$monthNumber."-".$day_selected;
			if($date!="")
			{
		        //csv file name
		        $filename = 'referral_income_'.$date.'.csv';

        		header("Content-Description: File Transfer");
        		header("Content-Disposition: attachment; filename=$filename");
        		header("Content-Type: application/csv; "); 

		        $usersData = $this->Epin_model->get_referral_income_datewisedata1($date);
                // print_r($usersData);die;
	            // file creation
		        $file = fopen('php://output', 'w');
		        $header = array("Sr. No.","Income Level","Income Member Name / Username","Income Member By / Username","Order ID","Income","Package","Percentage","Date");
		        fputcsv($file, $header);
		        $i=1;
		        foreach ($usersData as $key=>$line)
		        {
		          //  print_r($line);die;
		          // echo $line->income_amount;die;
		          
		            $line = array(
    									'income_id'      	  =>$i,	 
    									'income_level'  	  =>$line->income_level,
    									'income_member_id'	  =>getSponsor($line->income_member_id)." / ".getMemberLoginID($line->income_member_id),
    									'income_member_by'    =>getSponsor($line->income_member_by)." / ".getMemberLoginID($line->income_member_by),
    									'order_id'  	      =>$line->order_id, 
    									'income_amount' 	  =>$line->income_amount, 							
    									'package_amount' 	  =>$line->package_amount, 
    									'income_percentage'   =>$line->income_percentage,	  
    									'income_date'         =>$line->income_date
    									 ); 
		           $i++;
		          fputcsv($file, (array) $line);
                }
                fclose($file);
		        exit;
	       }
		}
        $data['months'] = $this->config->item('months');
        $this->load->view('admin/includes/template',$data); 
 	}
 	public function bank_details()
 	{
 		$data['page_title']   = "View Bank Details";
 		$data['main_content'] = "admin/bank_details";  
        
        if($this->input->post("btn_submit"))
		{ 
		  
			$day_selected=$this->input->post("day_selected");
			$month_selected=$this->input->post("month_selected");
			$year_selected=$this->input->post("year_selected");
			$monthNumber = date_parse(date('Y') . '-' . $month_selected)['month'];
            if (strlen($monthNumber) == 1) 
            {
                $monthNumber = "0" . $monthNumber;
            }
          
			if($day_selected!='All')
			{
		        $date = $year_selected."-".$monthNumber."-".$day_selected;

				$data['income'] = $this->Epin_model->get_referral_income_bank_datewisedata($date);
				 //echo $this->db->last_query();die;
				$data['day_selected']=$day_selected;
				$data['month_selected']=$month_selected;
				$data['year_selected']=$year_selected;
			}
			else
			{
				// $data['income'] = $this->Epin_model->get_referral_income_bank_data();
				$data['income'] =array();
				$data['day_selected']='All';
    			$data['month_selected']='All';
    			$data['year_selected']='All';
			}
			
		}

		else
		{
		  //  $data['income'] = $this->Epin_model->get_referral_income_bank_data();
		    $data['income'] =array();
			$data['day_selected']='All';
			$data['month_selected']='All';
			$data['year_selected']='All';
		}	
		
		
		if($this->input->post("csv_submit"))
		{ 
		 
			$day_selected=$this->input->post("day_selected");
			$month_selected=$this->input->post("month_selected");
			$year_selected=$this->input->post("year_selected");
			$monthNumber = date_parse(date('Y') . '-' . $month_selected)['month'];
            if (strlen($monthNumber) == 1) 
            {
                $monthNumber = "0" . $monthNumber;
            }
          
		    $date = $year_selected."-".$monthNumber."-".$day_selected;
			if($date!="")
			{
		        //csv file name
		        $filename = 'referral_income_bank_details_'.$date.'.csv';

        		header("Content-Description: File Transfer");
        		header("Content-Disposition: attachment; filename=$filename");
        		header("Content-Type: application/csv; "); 

		        $usersData = $this->Epin_model->get_referral_income_bank_datewisedata($date);
                // print_r($usersData);die;
	            // file creation
		        $file = fopen('php://output', 'w');
		        $header = array("Sr. No.","Income Member Name / Username","Account Holder Name","Account No","Bank Name","IFSC Code","Total Amount","Date");
		        fputcsv($file, $header);
		          $i=1;
		        foreach ($usersData as $key=>$line)
		        {
		          // print_r($line);
		          // echo $line->income_member_id;die;
		          $bank= get_bank_detailsByid($line->income_member_id);
		    
		      if($bank==null || empty($bank))
		      {
		          $member_account_name="Not Available";
		          $member_account_no="Not Available";
		          $member_bank_name="Not Available";
		          $member_ifsc_code="Not Available";
		      }
		      else
		      {
		          $member_account_name=$bank->member_account_name;
		          $member_account_no=$bank->member_account_no;
		          $member_bank_name=$bank->member_bank_name;
		          $member_ifsc_code=$bank->member_ifsc_code;
		      }
		    
		            $line = array(
    									'income_id'      	  =>$i,	
    									'income_member_id'	  =>getSponsor($line->income_member_id)." / ".getMemberLoginID($line->income_member_id),
    									'acc_holder_name'     =>$member_account_name,
    									'acc_no'                =>$member_account_no,
    									'bank_name'           =>$member_bank_name,
    									'ifsc_code'           =>$member_ifsc_code,
    								
    									'total_income' 	  =>$line->total_income, 		  
    									'income_date'         =>$line->income_date
    									 ); 
		           $i++;
		          fputcsv($file, (array) $line);
                }
                fclose($file);
		        exit;
	       }
		}
        // echo $this->db->last_query();die;
        
        $data['months'] = $this->config->item('months');
        $this->load->view('admin/includes/template',$data); 
 	}
 
 	public function withdrawal_list()
 	{
 	  
 		$data['page_title']   = "View Withdrawal List";
 		$data['main_content'] = "admin/view_withdrawal_list";  
        $data['withdrawal'] = $this->Epin_model->get_withdrawal_data();
        $this->load->view('admin/includes/template',$data); 
 	}
 	public function global_pool()
 	{
 		$data['page_title']   = "View Global Pool List";
 		$data['main_content'] = "admin/view_global_income";  
	    $data['income'] = $this->Epin_model->get_global_income_data();
        	

		$this->load->view('admin/includes/template',$data); 
 	}
 			public function leadership_bonus()
 	{
 		$data['page_title']   = "View Leadership Bonus List";
 		$data['main_content'] = "admin/view_leadership_bonus";  
	    $data['income'] = $this->Epin_model->get_leadership_bonus_data();
        	

		$this->load->view('admin/includes/template',$data); 
 	}
 	public function referral_income()
 	{
 		$data['page_title']   = "View Referral Income List";
 		$data['main_content'] = "admin/my_team";  
	    if($this->input->post("btn_submit"))
		{ 
		  
			$level_no=$this->input->post("level_no");
			if($level_no!='All')
			{
		
				$data['income'] = $this->Epin_model->get_referral_income_with_level_data($level_no);
				// print_r($data['income']);die;
				$data['level']=$level_no;
			}
			else
			{
				$data['income'] = $this->Epin_model->get_referral_income_data();
					$data['level']='All';
			}
			
		}

		else
		{
		    $data['income'] = $this->Epin_model->get_referral_income_data();
			$data['level']='All';
		}	

		$this->load->view('admin/includes/template',$data); 
 	}
 	public function reinvestment()
 	{
 		$data['page_title']   = "View Reinvestment List";
 		$data['main_content'] = "admin/view_reinvestment_list";  
	    $data['income'] = $this->Epin_model->get_reinvestment_data();
        	

		$this->load->view('admin/includes/template',$data); 
 	}
	public function epin_request_confirm()
 	{
 		$data['page_title']   = "Epin Request Generate";
 		$data['main_content'] = "admin/epin_request_generate";
 		$reqeust_details = $this->db->get_where('isp_epin_request',array('request_id'=>$this->uri->segment(3)))->row();
		$data['request_details']=$reqeust_details;

		if($this->input->post('submit')=='submit')
		{
			$this->form_validation->set_rules('request_quantity','Quantity','required');
			if($this->form_validation->run()==TRUE)
			{	
				$id = $this->input->post('request_id');
				
				$request_package = $this->input->post('request_package');
				$package_data 		= getPackages($request_package);
				$package_prefix	    = $package_data[0]->package_prefix;

				$qty = $this->input->post('request_quantity');
				 
				$data=array('request_quantity'=>$qty); 
				$update = $this->Epin_model->update($data,'request_id='.$id,'epin_request');
				$details = $this->Epin_model->select_single_row('epin_request',array('request_id'=>$id));
				$member_id = $details->request_member_id; 
				
				for($i=0;$i<$qty;$i++)
				{
					$digit = date('i').date('s'); 
					$Last_char = $this->generateRandomString(); 
					$epin=$package_prefix.$digit.$Last_char;
					
					$_POST['epin_member_id']=$member_id;
					$_POST['epin']=$epin;
					$_POST['epin_package_id'] = $request_package;
					$_POST['epin_added_by']="";
					$_POST['epin_added_date']=date('Y-m-d H:i:s');
					$_POST['epin_status']='Unused';
					$insert = $this->Epin_model->insertData('epin');
					$result = $i;
				}
				$data=array('request_status'=>'Approve'); 
				$update = $this->Epin_model->update($data,'request_id='.$id,'epin_request');
				$this->session->set_flashdata('success','Epin Generate  successfully...');
				redirect('epin/epin_request');
			}
		}
		$this->load->view('admin/includes/template',$data); 
 	}
 	
 	 
 		public function pending_payments()
 	{
 		$data['page_title']   = "View Pending Payment Members List";
 	
        $data['members_data'] = $this->Epin_model->get_memberpackage_data();
        // print_r($data['members_data']);
        	$data['main_content'] = "admin/pending_payment_member_list";  
 		$this->load->view('admin/includes/template',$data); 
 	}
 		public function accept_payment($id)
 	{
 	    
 		$this->db->where('member_packageid',$id); 
 		$this->db->set('payment_status','is_paid');
 	
 		$this->db->update('member_packages'); 

 		$this->session->set_flashdata('success','Payment is complete'); 

 		redirect('epin/pending_payments');
 	}
 	public function pending_member_payment_detail()
 	{
 		$data['page_title']   = "View Members Details";
 		$data['main_content'] = "admin/pending_member_payment_detail";
 		$member_packageid           = $this->uri->segment(3); 
 		$data['members_details'] = $this->Epin_model->get_package_data($member_packageid);
		$this->load->view('admin/includes/template',$data); 
 	}
 	public function verify_login_id()
 	{
 		$id = $this->input->post('id');
 		$epin_qty = $this->input->post('epin_qty');
 		
 		$details = $this->Epin_model->get_members_login_id($id);
 		if($details)
 		{
			echo "<div class='form-group'>
            <label class='' for='name'>Name</label>
            ".$details[0]->member_name."
        	</div>
        	
        	<div class='form-group'>
        		<input type='hidden' class='input-group' id='request_member_id' value=".$details[0]->member_id." name='request_member_id'>
	            <label class='' for='name'>Mobile</label>
	            ".$details[0]->member_mobile."
        	</div>
        	<div class='modal-footer text-left'>
                <button type='submit' id='submit' name='submit' value='submit' class='btn btn-success waves-effect waves-light m-r-10'>Submit</button>
                <button type='button' class='btn btn-default' data-dismiss='modal'>Close</button>
            </div>";
 		}
 		else
 		{
 			echo "Invalid Member Login Id";
 		}
 	}
 	public function verify_sponsor_id()
 	{
 		$id = $this->input->post('id');
 		
 		$details = $this->Epin_model->get_members_login_id($id);
 		if($details)
 		{
			echo $details[0]->member_name;
 		}
 		else
 		{
 			echo "Invalid Member Login Id";
 		}
 	}
 
	public function get_package_details($package_id)
 	{
 	  
 		$amount = $this->input->post('amount');
 		 
 	$package_details = getPackages($package_id);
 	$percentage = $package_details[0]->package_ROI_percentage;
    $monthly    = (($amount*$percentage)/100)/30;
 	$daily_income =	number_format((float)$monthly, 2, '.', '');
 		 if($daily_income)
 		{
 		    echo " $daily_income";
 		}
 		
 	}
 	public function view_member_detail()
 	{
 		$data['page_title']   = "View Members Details";
 		$data['main_content'] = "admin/view_member_detail";
 		$member_id            = $this->uri->segment(3);
 	    $data['pdf_path']=	$_SERVER['SERVER_NAME']."/data/pay_receipt/";
 	   
	    $data['payment_details']=$this->db->order_by('mp_id','DESC')->get_where('isp_member_payment',array('m_id'=>$member_id))->row();	
	    $data['order_data'] = $this->Epin_model->get_view_members_orders($member_id);
	    
	    if($this->input->post("btn_submit1"))
		{
			$level_no=$this->input->post("level_no");
			if($level_no!='All')
			{
				$data['ref_income']=$this->db->order_by('income_id','DESC')->get_where('isp_level_income',array('income_member_id'=>$member_id,'income_level'=>$level_no))->result();	
				$data['level']=$level_no;
			}
			else
			{
				$data['ref_income']=$this->db->order_by('income_id','DESC')->get_where('isp_level_income',array('income_member_id'=>$member_id))->result();	
					$data['level']='All';
			}
			
		}
        else
		{
			$data['ref_income']=$this->db->order_by('income_id','DESC')->get_where('isp_level_income',array('income_member_id'=>$member_id))->result();	
			$data['level']='All';
		}	
 		
 		$data['members_details'] = $this->Epin_model->get_members($member_id);
		$this->load->view('admin/includes/template',$data); 
 	}
    public function verify_kyc_members()
 	{
 		$data['page_title']   = "View Members Details";
 		$data['main_content'] = "admin/verify_kyc_members";
 		$member_id            = $this->uri->segment(3);
        $data['network_data'] = $this->Epin_model->get_member_network_data($member_id);  		
      // $data['package'] = $this->Epin_model->get_member_package_data($member_id); 
 			
 		$data['members_details'] = $this->Epin_model->get_members($member_id);
		$this->load->view('admin/includes/template',$data); 
 	}
    	public function member_invest_more($id)
 	{
 	    $data['page_title']   = "Invest More";
 		$data['main_content'] = "admin/package_invest_more";
 		$member_id            = $this->uri->segment(3);
 		$package_id            = $this->uri->segment(4);
        $data['network_data'] = $this->Epin_model->get_member_network_data($member_id); 
 		$data['package'] = $this->Epin_model->get_member_package_data($member_id); 
 			
 		$data['members_details'] = $this->Epin_model->get_members($member_id);
		$this->load->view('admin/includes/template',$data); 
 	}
 	 public function send_payment_receipt($id)
 	{
 		$member_id            = $this->uri->segment(3);
       	$data['members_details'] = $this->Epin_model->get_members($member_id);
		$members_data = $this->Epin_model->get_member_regi($member_id); 
        $customer_name = $members_data[0]->member_name;
        $email = $members_data[0]->member_email_id;
        $amount =$members_data[0]->package;
        $package_type =$members_data[0]->package_type;
        $c_id = $members_data[0]->member_id;
        
        $payment_details=$this->db->order_by('mp_id','DESC')->get_where('isp_member_payment',array('m_id'=>$member_id))->row();
        $pdf_path = $payment_details->pdf_path;
        // print_r($payment_details);die;
  
        $mesg = " Dear $customer_name Congratulations, Your membership is activated your payment of Rs.$amount is received successfully and your receipt no. is $c_id. You can download your receipt from the link. ".$pdf_path." Regards, MaxxGain Bazzar, MAGACN"; 
        $subject="Payment receipt from Maxxgain";
        send_email($email,$subject,$mesg);
        
        $this->session->set_flashdata('success','Email Send successfully...'); 
        redirect('epin/view_members');
 	}
    public function send_email_reg($id)
 	{
 		$member_id            = $this->uri->segment(3);
       	$data['members_details'] = $this->Epin_model->get_members($member_id);
		$name=getSponsorName($member_id);
		
        $to=getMemberemail($member_id);
        $subject="Login Credentials from Maxxgain Bazzar";
        $login_id=getMemberLoginID($member_id);   
        $password=getMemberpassword($member_id);   
        $message='Hello '.$name.',>';
        $message.=" Here's your Login Credentials.";
        $message.=' Your login information : ';
        $message.=' Login :'.$login_id.'.';
        $message.=' Password :'.$password.'.';
        $message.=' You can login here :'.$this->config->item('website_name').'.';
        $message.=' Contact us immediately if you did not authorize this registration.';
        $message.=' Thank you.';
  
        send_email($to,$subject,$message);
        $this->session->set_flashdata('success','Email Send successfully...'); 
        redirect('epin/register_members');
 	}
    public function send_email_kyc($id)
 	{
 		$member_id            = $this->uri->segment(3);
       	$data['members_details'] = $this->Epin_model->get_members($member_id);
       	// print_r($data['members_details']);die;
			$name=getSponsorName($member_id);
		
            $to=getMemberemail($member_id);
            $subject="Login Credentials from Maxxgain Bazzar";
             $login_id=getMemberLoginID($member_id);   
             $password=getMemberpassword($member_id);   
                $message='Hello '.$name.','.'<br><br>';
                $message.="Here's your Login Credentials.".'<br><br>';
                $message.='Your login information : '.'<br><br>';
                $message.='Login :'.$login_id.'<br><br>';
                $message.='Password :'.$password.'<br><br>';
                $message.='You can login here :'.$this->config->item('website_name').'<br><br>';
                $message.='Contact us immediately if you did not authorize this registration.'.'<br><br>';
                $message.='Thank you.'.'<br><br>';
  
                  send_email($to,$subject,$message);
                  	$this->session->set_flashdata('success','Email Send successfully...'); 
                  redirect('epin/view_kyc_members');
 	}
 	 public function send_email_pending_members($id)
 	{
 		$member_id            = $this->uri->segment(3);
       	$data['members_details'] = $this->Epin_model->get_members($member_id);
       	// print_r($data['members_details']);die;
			$name=getSponsorName($member_id);
		
            $to=getMemberemail($member_id);
            $subject="Login Credentials from Maxxgain Bazzar";
             $login_id=getMemberLoginID($member_id);   
             $password=getMemberpassword($member_id);   
                $message='Hello '.$name.','.'<br><br>';
                $message.="Here's your Login Credentials.".'<br><br>';
                $message.='Your login information : '.'<br><br>';
                $message.='Login :'.$login_id.'<br><br>';
                $message.='Password :'.$password.'<br><br>';
                $message.='You can login here :'.$this->config->item('website_name').'<br><br>';
                $message.='Contact us immediately if you did not authorize this registration.'.'<br><br>';
                $message.='Thank you.'.'<br><br>';
  
                  send_email($to,$subject,$message);
                  	$this->session->set_flashdata('success','Email Send successfully...'); 
                  redirect('epin/pending_members');
 	}
 		 public function send_email_view_members($id)
 	{
 		$member_id            = $this->uri->segment(3);
       	$data['members_details'] = $this->Epin_model->get_members($member_id);
       	// print_r($data['members_details']);die;
			$name=getSponsorName($member_id);
		
            $to=getMemberemail($member_id);
            $subject="Login Credentials from Maxxgain Bazzar";
             $login_id=getMemberLoginID($member_id);   
             $password=getMemberpassword($member_id);   
                $message='Hello '.$name.','.'<br><br>';
                $message.="Here's your Login Credentials.".'<br><br>';
                $message.='Your login information : '.'<br><br>';
                $message.='Login :'.$login_id.'<br><br>';
                $message.='Password :'.$password.'<br><br>';
                $message.='You can login here :'.$this->config->item('website_name').'<br><br>';
                $message.='Contact us immediately if you did not authorize this registration.'.'<br><br>';
                $message.='Thank you.'.'<br><br>';
  
                  send_email($to,$subject,$message);
                  	$this->session->set_flashdata('success','Email Send successfully...'); 
                  redirect('epin/view_members');
 	}
 		 public function send_email_all_members($id)
 	{
 		$member_id            = $this->uri->segment(3);
       	$data['members_details'] = $this->Epin_model->get_members($member_id);
       	// print_r($data['members_details']);die;
			$name=getSponsorName($member_id);
		
            $to=getMemberemail($member_id);
            $subject="Login Credentials from Maxxgain Bazzar";
             $login_id=getMemberLoginID($member_id);   
             $password=getMemberpassword($member_id);   
                $message='Hello '.$name.','.'<br><br>';
                $message.="Here's your Login Credentials.".'<br><br>';
                $message.='Your login information : '.'<br><br>';
                $message.='Login :'.$login_id.'<br><br>';
                $message.='Password :'.$password.'<br><br>';
                $message.='You can login here :'.$this->config->item('website_name').'<br><br>';
                $message.='Contact us immediately if you did not authorize this registration.'.'<br><br>';
                $message.='Thank you.'.'<br><br>';
  
                  send_email($to,$subject,$message);
                  	$this->session->set_flashdata('success','Email Send successfully...'); 
                  redirect('epin/all_members_list');
 	}
 	public function members_det($id)
 	{
 		return $this->Epin_model->get_members($id);
 	}

 	public function edit_member_detail()
 	{
 		$data['page_title']   = "Edit Members Details";
 		$data['main_content'] = "admin/edit_member_detail";
 		$member_id            = $this->uri->segment(3);
 		$data['members_details'] = $this->Epin_model->get_members($member_id);

 		if (isset($_POST['update-profile']))
 		{
 			$this->form_validation->set_rules('name','Name','required');
 			$this->form_validation->set_rules('password','Password','required'); 

 			if ($this->form_validation->run() == TRUE)
            {
				$updateData = array( 
 			 					 'member_name' => $this->input->post('name'),
 			 					 'member_dob' => $this->input->post('dob'),
 			 					 'member_password' => base64_encode($this->input->post('password')),
 			 					 'member_email_id' => $this->input->post('email'),
 			 					 'member_mobile' => $this->input->post('mobile'),
 			 					 'member_address' => $this->input->post('postal_address'),
 			 					 'member_state' => $this->input->post('state'),
 			 					 'member_city' => $this->input->post('city'),
 			 					 'member_pin_code' => $this->input->post('pin_code'),
 			 					 /*'member_nom_name' => $this->input->post('nom_name'),
 			 					 'member_nom_relation' => $this->input->post('nom_relation'),
 			 					 'member_nom_address' => $this->input->post('nom_address'),
 			 					 'member_nom_city' => $this->input->post('nom_city'),
 			 					 'member_nom_mobile' => $this->input->post('nom_mobile'),*/
 			 					 'member_pan_card' => $this->input->post('pan_card_no'),
 			 					 'member_aadhar_no' => $this->input->post('aadhar_no'),
 			 					 'member_bank_name' => $this->input->post('bank_name'),
 			 					 'member_account_no' => $this->input->post('account_no'),
 			 					 'member_ifsc_code' => $this->input->post('ifsc_code'),
 			 					 'member_branch_name' => $this->input->post('branch_name')
 			 						 );  
 

				$update = $this->Epin_model->update($updateData,'member_id='.$member_id,'members'); 
				$this->session->set_flashdata('success','Profile update successfully...');
				//redirect('epin/view_members');  
				redirect('epin/edit_member_detail/'.$member_id);  
			}
 		}
		$this->load->view('admin/includes/template',$data); 
 	}

 	public function block_member()
 	{
 		$member_id         = $this->uri->segment(3);
 		$status            = $this->uri->segment(4);
 		$result  = array('member_status' =>$status);

 		$update = $this->Epin_model->update($result,'member_id='.$member_id,'members'); 
 		
 		if ($status=='Pending') {
 			$this->session->set_flashdata('success','Member Bloked successfully...');	 
 		}else{
 			$this->session->set_flashdata('success','Member Unblock successfully...');
 		}
 		
		redirect('epin/view_members');  
 	}		


 	public function view_pending_members()
 	{
 		$data['page_title']   = "View Pending Members List";
 		$data['main_content'] = "admin/view_member_list";  

 		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');       
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date'); 			 
 			 
 			$data['members_data'] = $this->Epin_model->get_search_members_data(array('member_status'=>'Approve','member_type'=>'member','is_paid'=>'No'),$from_date,$to_date);   
 		}
 		else
 		{
			$data['stage_le']=''; 	
			$data['members_data'] = $this->Epin_model->get_members_data(array('member_status'=>'Approve','member_type'=>'member','is_paid'=>'No'));		
		
 		}
		$this->load->view('admin/includes/template',$data); 
 	}

 	public function view_deleted_members()
 	{
 		$data['page_title']   = "View Deleted Members List";
 		$data['main_content'] = "admin/view_deleted_member_list";  

 		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');       
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date');
 			 
 			$data['members_data'] = $this->Epin_model->get_search_members_data(array('member_status'=>'Deleted','member_type'=>'member'),$from_date,$to_date);   
 		} 
 		else
 		{
			$data['stage_le']=''; 	
			$data['members_data'] = $this->Epin_model->get_members_data(array('member_status'=>'Deleted','member_type'=>'member'));		 
 		}
		$this->load->view('admin/includes/template',$data); 
 	}
 	public function view_blocked_members()
 	{
 		$data['page_title']   = "View Blocked Members List";
 		$data['main_content'] = "admin/view_blocked_member_list";  

 		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');       
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date'); 
 			   
 			$data['members_data'] = $this->Epin_model->get_search_members_data(array('member_status'=>'Blocked','member_type'=>'member'),$from_date,$to_date);   
 		} 
 		else
 		{
			$data['stage_le']=''; 	
			$data['members_data'] = $this->Epin_model->get_members_data(array('member_status'=>'Blocked','member_type'=>'member'));		 
 		}
		$this->load->view('admin/includes/template',$data); 
 	}

 	public function view_admin_members()
 	{
 		$data['page_title']   = "View Admin Members List";
 		$data['main_content'] = "admin/view_member_list";  
	
 		 $data['members_data'] = $this->Epin_model->get_members_data(array('member_status'=>'Approve','member_type'=>'Admin_member'));		
 		$this->load->view('admin/includes/template',$data); 
 	}
    
    public function unblock_member()
 	{
		$member_id = $this->uri->segment(3);
		$memdata ='';
		$donation='';
 	  
		$memdata = $this->db->get_where('members',array('member_id' =>$member_id,'member_status'=>'Blocked'))->row();
		$donation = $this->db->order_by('donate_id','DESC')->get_where('donations',array('donate_by' =>$member_id,'donate_plan'=>'level'))->row();

		if ($memdata!='' && $donation!='')
		{
			$this->db->where('member_id',$member_id);
			$this->db->update('members',array('member_status' =>'Approve')); 
 	   	    
			$this->db->where('donate_id',$donation->donate_id); 
			$this->db->where('donate_by',$member_id); 
			$this->db->update('donations',array('donate_ctime'=>date('Y-m-d H:i:s')));

			$this->session->set_flashdata('success','Member Unblock successfully...'); 
			redirect('epin/view_blocked_members'); 

		}elseif ($memdata!='' && $donation=='') {
			$this->db->where('member_id',$member_id);
			$this->db->update('members',array('member_status' =>'Pending','member_added_date'=>date('Y-m-d H:i:s')));
			$this->session->set_flashdata('success','Member Unblock successfully...'); 
			redirect('epin/view_blocked_members');
		}else{ } 
 	}

 	public function pending_members()
 	{
 		$data['page_title']   = "View Pending Members List";
 		$data['main_content'] = "admin/pending_member_list";  

 		
 			//$data['members_data'] ='';
// 			$data['members_data'] = $this->db->get_where('isp_members',array('member_status' =>'Pending','kyc_status'=>'Pen','is_paid'=>'No','member_is_verify'=>'Yes'))->result();
 
         $this->db->select('*');
        $this->db->from('isp_members'); 
        $where = '(member_status="Pending" or kyc_status = "Pending")';
        $this->db->where($where);
        $this->db->order_by('member_id','desc');
        $q = $this->db->get();
        $data['members_data'] = $q->result();
 	
 		
 		
 	
		$this->load->view('admin/includes/template',$data); 
 	}

 	public function pending_member_detail()
 	{
 		$data['page_title']   = "View Members Details";
 		$data['main_content'] = "admin/view_pending_member_detail";
 		$member_id            = $this->uri->segment(3); 
 		   
 		$data['members_details'] = $this->Epin_model->get_members($member_id);
 		 
 		$sponsorid = $data['members_details'][0]->member_sponsored;
 		$data['admin_data'] = $this->db->get_where('isp_members',array('member_type'=>'admin_member'))->row(); 
 		$data['sponsor_data'] = $this->db->get_where('isp_members',array('member_id'=>$sponsorid))->row(); 
 	 	 
		$this->load->view('admin/includes/template',$data); 
 	}	
 	public function all_members_list()
 	{
 		$data['page_title']   = "View All Members List";
 		$data['main_content'] = "admin/all_member_list";  

 		if (isset($_POST['search'])) 
 		{
 			$package_id ='';  
 			$package_id =  $this->input->post('package_id');  
 			$data['packageID'] = $this->input->post('package_id'); 		 
 			 
 			$data['members_data'] = $this->db->get_where('members',array('member_status' =>'Approve','member_package_id'=>$package_id,'member_is_verify'=>'Yes'))->result();  
 		}
 		else{
 			//$data['members_data'] ='';
			$data['members_data'] = $this->db->get_where('members',array('member_status' =>'Approve','member_is_verify'=>'Yes'))->result();  
 			$data['packageID'] ='';
 		} 
 		
 		$data['packages_data'] = $this->db->get_where('pckages',array('package_status' =>'Active'))->result();
		$this->load->view('admin/includes/template',$data); 
 	}
	
	public function select_payment_type()
 	{
 		$data['page_title']   = "View Members Details";
 		$data['main_content'] = "admin/select_payment_pending_member";
 		$member_id            = $this->uri->segment(3);  		
 		$data['members_details'] = $this->Epin_model->get_members($member_id);
// 		 dd($data['members_details']);
		if($this->input->method() == 'post'){

			$package_amount = $this->input->post('amount');
			$package_id = $this->input->post('package_id');
			$packages = getPackages($package_id);
			$transaction_created = false;
			// dd();
			if (!empty($packages) && !empty($package_id)) 
			{
				$p_id               = $package_id;
				$p_amount           = $package_amount;
				$p_ROI_percentage   = $packages[0]->package_ROI_percentage;
				$p_ROI_days         = $packages[0]->package_ROI_to;
				$p_name         	= $packages[0]->package_name;
				$p_duration         = $packages[0]->package_duration;
				$package_type_id    = $packages[0]->package_type_id;


				$txn_id = 'DTOFFLINE_'. time();
				$req = array(
					'amount' 		=> $p_amount, //10.00,
					'currency1' 	=> 'CASH',
					'currency2' 	=> 'CASH',
					'buyer_email' 	=> $data['members_details'][0]->member_id, //'test_buy_coin@yopmail.com',
					'item_name' 	=> $p_name, //'Test Item/Order Description',
					'txn_id' 		=> $txn_id,
					'ipn_url' 		=> '',
				);
				
				$payment_id = $this->Payments_model->insertData($req);	
				if($payment_id){
					$resData = array(
						'amount' 			=> $p_amount, //10.00,
						'txn_id'  			=> $txn_id, 
						'address'  			=> '0', 
						'confirms_needed'  	=> '0', 
						'timeout'  			=> '0', 
						'checkout_url'  	=> '0', 
						'status_url'  		=> '0', 
					);
					$this->Payments_model->updateData($resData, $payment_id);	
				}
				$member_id 	= $data['members_details'][0]->member_id;
				$days		= 365 * $p_duration;
				$start_date	= date("Y-m-d");
				$end_date	= Date('Y-m-d', strtotime('+'.$days.' days'));
				$ROI_daily_per			= $p_ROI_percentage/30;
				$ROI_daily_percentage 	=  round($ROI_daily_per,2);

				$arr=array(
					'member_id'       		=> $member_id,
					'package_id'       		=> $package_id,
					'package_ROI_percentage'=> $p_ROI_percentage,
					'ROI_daily_percentage'	=> $ROI_daily_percentage,
					'package_name'       	=> $p_name,
					'package_duration'      => $p_duration,
					'package_amount'       	=> $p_amount,
					'package_type_id'       => $package_type_id,
					'start_date'       		=> $start_date,
					'end_date'       		=> $end_date,
					'txn_id'				=> $txn_id,	
					// 'txn_id'				=> $txn_id,			
				);
				$this->Home_model->insert_data('member_packages',$arr); 
								
				
				$webhookURL = base_url()."webhook/CoinPaymentWebHook?txn_id=$txn_id&received_amount=$p_amount";
				$ch = curl_init();
				$headers = array(
				'Accept: application/json',
				'Content-Type: application/json',

				);
				curl_setopt($ch, CURLOPT_URL, $webhookURL);
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				curl_setopt($ch, CURLOPT_HEADER, 0);
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET"); 
				//$body = '{}';
				//curl_setopt($ch, CURLOPT_POSTFIELDS,$body);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_TIMEOUT, 60);
				$output = curl_exec($ch);
				print("<pre>");
				print_r($output);
				if($output)
				{

                    $name=$data['members_details'][0]->member_name;
                    $to=$data['members_details'][0]->member_email_id;
                    $package=getPackageName($package_id);
                    $pack_type=getPackageNameByid($package_type_id);
                    $subject="Deposit Received";
                 
                    $message='Dear '.$name.',<br><br>';
                    $message.='           We have received your deposit. The details of your deposit is included below:<br><br>';
                  
                    $message.='Deposited Amount :'.$p_amount.'<br><br>';
                    $message.='Currency Type : CASH'.'<br><br>';
                    $message.='Plan :'.$package.' ('.$pack_type.')<br><br>';
                    $message.='Reference :'.$txn_id.'<br><br>';
                    $message.='With Best Regards,<br><br>';
                    $message.=$this->config->item('title').'<br><br>';
                    $message.='www.daimondtrade.net';
                    send_email($to,$subject,$message);
                }
				$this->session->set_flashdata('success', 'Member Payment received.');
					echo '<script language="javascript">' .
                        //  'setTimeout(function(){ window.location.href = "/epin/all_members_list"; }, 3000);' .
                        'setTimeout(function(){ window.location.href = "'.base_url().'epin/all_members_list"; }, 3000);' .
                         '</script>';
                die();
				// print_r($output);die;
			
				// redirect('epin/all_members_list');

			}
			
		}
		
 		 
 		$sponsorid = $data['members_details'][0]->member_sponsored;
 		$data['admin_data'] = $this->db->get_where('members',array('member_type'=>'admin_member'))->row(); 
 		$data['sponsor_data'] = $this->db->get_where('members',array('member_id'=>$sponsorid))->row(); 
 	 	 
		$this->load->view('admin/includes/template',$data); 
 	}	

 	public function donor_members()
 	{
 		$data['page_title']   = "Donor Members List";
 		$data['main_content'] = "admin/donor_member_list";  

 		if (isset($_POST['search']))
 		{
 			$package_id ='';  
 			$package_id =  $this->input->post('package_id');
 			$data['packageID'] = $this->input->post('package_id');
 			$data['members_data'] = $this->Epin_model->get_donor_members($package_id);
 		}
 		else{
 			$data['members_data'] = $this->Epin_model->get_donor_members($package_id=''); 
 			$data['packageID'] ='';
 		}
 		$data['packages_data'] = $this->db->get_where('pckages',array('package_status' =>'Active'))->result();
		$this->load->view('admin/includes/template',$data); 
 	}

 	public function assign_donation($id)
 	{
 		$data['page_title']   = "Assign Donation";
 		$data['main_content'] = "admin/assign_donation";  
 		//$data['to_member']   = $this->Epin_model->get_donation_to_members();
 		$data['package'] = $this->Epin_model->get_member_package_data($id);  
 		$data['assigned_member'] = $this->Epin_model->get_members($id);
 		$paid_per = $data['assigned_member'][0]->member_sponsor_percentage+$data['assigned_member'][0]->member_admin_percentage;
        $memberPercentage = 100-$paid_per;

        $memberPackageAmt= getMemberPackageAmt($id);
        $finalMemberAmt=($memberPackageAmt) * $memberPercentage/100;
        $data['package_amount'] = $finalMemberAmt; 
        $data['tot_package_amount'] = $memberPackageAmt; 

 		$data['don_receiver'] = $this->Epin_model->get_donation_receiver_members();

 		$this->load->view('admin/includes/template',$data); 
 	}

 	public function assign_donation_submit($member_id)
 	{
 		$assign_to_members ='';
 		$admin_checked_amount =0;
 		$assign_to_admin ='';
 		$p_amount=0;

 		$assign_to_admin = $this->input->post('assign_to_admin');
 		$admin_checked_amount = $this->input->post('admin_checked_amount');
 		 
 		if ($admin_checked_amount!=0 && $assign_to_admin!='') 
 		{
 			$p_amount+=$admin_checked_amount;
 			$params1=array(
				'donate_to'=>$assign_to_admin,
				'donate_by'=>$member_id,					
				'donate_plan'=>'member',
				'donate_status'=>'assign',
				'donate_amount'=> $admin_checked_amount, 
				'donate_assign_date'=> date('Y-m-d H:i:s') 
			);
			 
			$in = $this->db->insert('donations',$params1);  
 		} 
 		$amt_ar ='';
 		$assign_to_members = $this->input->post('assign_to_member');
 		$assign_amount = $this->input->post('members_checked_amount');
 		//$amt_ar = array_values(array_filter($assign_amount)); 

 		if ($assign_to_members!='' && $member_id!='') 
 		{  $j=1;
			for ($i=0; $i < count($assign_to_members); $i++) 
			{ 				 
				$isExist = $this->db->get_where('roi_withdrawal_request',array('roi_withdrawal_request_id' =>$assign_to_members[$i]))->row();

				if ($isExist!='') 
				{ 	
					//get reciever ID
					$recieverData = getMemberDetails($isExist->member_id);
					//donar ID
					$donarData = getMemberDetails($member_id);
					
					$reciever_message="Please collect Rs ".$isExist->withdrawal_request_amount." from ".$donarData->member_login_id." - ".$donarData->member_mobile;
					
					$donar_message="Please Pay Rs ".$isExist->withdrawal_request_amount." to ".$recieverData->member_login_id." - ".$recieverData->member_mobile;
					
					$this->Member_network_mdl->send_sms($recieverData->member_mobile,$reciever_message);
					$this->Member_network_mdl->send_sms($donarData->member_mobile,$donar_message);
					
					$params=array(
						'donate_to'=>$isExist->member_id,
						'donate_by'=>$member_id,					
						'donate_plan'=>'member',
						'donate_status'=>'assign',
						'donate_amount'=>$isExist->withdrawal_request_amount, 
						'donate_request_id'=>$isExist->roi_withdrawal_request_id, 
						'donate_assign_date'=> date('Y-m-d H:i:s') 
					); 
					$p_amount+=$isExist->withdrawal_request_amount; 
					$in = $this->db->insert('donations',$params); 

					$this->db->set('withdrawal_status','assign');
					$this->db->where('roi_withdrawal_request_id',$isExist->roi_withdrawal_request_id);
					$this->db->update('isp_roi_withdrawal_request');
				} 
				$j++;
			} 
 		}

 		 
 		if($in){
 			$memData = $this->db->get_where('members',array('member_id' =>$member_id))->row();
 			$new_amt = $memData->member_member_amount-$p_amount; 
 			
 			$this->db->set('member_member_amount',$new_amt);
 			$this->db->where('member_id',$member_id);
 			$this->db->update('members');

 			$this->session->set_flashdata('success', 'Donation assigned Successful.');
			unset($_POST);
			redirect('epin/donor_members');
		}
 		else{
 			$this->session->set_flashdata('fail', 'fail select members.');
 			redirect('epin/assign_donation/'.$member_id);
 		}
 	}

 	/*public function assign_donation_submit($member_id)
 	{
 		$assign_to_members ='';

 		$assign_to_members = $this->input->post('assign_to_member');
 		$assign_amount = $this->input->post('assign_amount');

 		if ($assign_to_members!='' && $member_id!='') 
 		{  
			for ($i=0; $i < count($assign_to_members); $i++) 
			{ 
				$isExist = $this->Epin_model->checkAlreadyAssigned($assign_to_members[$i]);

				if ($isExist==0) 
				{ 
					$params=array(
						'donate_to'=>$assign_to_members[$i],
						'donate_by'=>$member_id,					
						'donate_plan'=>'member',
						'donate_status'=>'assign',
						'donate_amount'=> $assign_amount, 
						'donate_assign_date'=> date('Y-m-d H:i:s') 
					);
					$this->db->insert('donations',$params); 
				}

				$this->session->set_flashdata('success', 'Donation assigned Successful.');
				unset($_POST);
				redirect('epin/donor_members');
			} 
 		}
 		else
 		{
 			$this->session->set_flashdata('fail', 'fail select members.');
 			redirect('epin/assign_donation/'.$member_id);
 		}
 	}*/

 	public function donation_receiver_members()
	{
		$data['page_title'] = "Donation Receiver Members";
		$data['main_content'] = "admin/donation_receiver_members_list";

		if (isset($_POST['search'])) 
 		{
 			$package_id ='';  
 			$package_id =  $this->input->post('package_id');  
 			$data['packageID'] = $this->input->post('package_id'); 		 
 			 
 			$data['members_data'] = $this->Epin_model->get_receivers_members($package_id);  
 		} 
 		else{
 			$data['members_data'] = $this->Epin_model->get_receivers_members($package_id=''); 
 			$data['packageID'] ='';
 		} 
 		
 		$data['packages_data'] = $this->db->get_where('pckages',array('package_status' =>'Active'))->result(); 

		$this->load->view('admin/includes/template',$data);
	}
	public function donar_reciever_list()
	{
		$data['page_title'] = "Donar & Reciever";
		
 		$data['reciever'] = $this->Epin_model->get_receiversData();
		$data['donar'] = $this->Epin_model->get_donarData();
		$data['totalReciever'] = $this->Epin_model->get_total_receivers_amount();
		$data['totalDonar'] = $this->Epin_model->get_total_donar_amount();
 		
 		$data['packages_data'] = $this->db->get_where('pckages',array('package_status' =>'Active'))->result(); 

		$data['main_content'] = "admin/donar_reciever";
		$this->load->view('admin/includes/template',$data);
	}

	public function reentry_donor_members()
 	{
 		$data['page_title']   = "Reentry Donor Members List";
 		$data['main_content'] = "admin/reentry_donor_member_list";  

 		if (isset($_POST['search']))
 		{
 			$package_id ='';  
 			$package_id =  $this->input->post('package_id');
 			$data['packageID'] = $this->input->post('package_id');
 			$data['members_data'] = $this->Epin_model->get_eentry_donor_members();
 		}
 		else{
 			$data['members_data'] = $this->Epin_model->get_eentry_donor_members(); 
 			$data['packageID'] ='';
 		}
 		 
		$this->load->view('admin/includes/template',$data); 
 	}

 	public function assign_reentry_donation($id)
 	{
 		$data['page_title']   = "Assign Donation";
 		$data['main_content'] = "admin/assign_reentry_donation";   
 		$data['package'] = $this->Epin_model->get_reentry_member_package_data($id);  
 		$data['assigned_member'] = $this->Epin_model->get_members($id);
 		$paid_per = $data['assigned_member'][0]->member_sponsor_percentage+$data['assigned_member'][0]->member_admin_percentage;
        $memberPercentage = 100-$paid_per;

        $memberPackageAmt= getReentryMemberPackageData($id);
        $finalMemberAmt=($memberPackageAmt->package_amount) * $memberPercentage/100;
        $data['package_amount'] = $finalMemberAmt; 
        $data['tot_package_amount'] = $memberPackageAmt->package_amount; 

 		$data['don_receiver'] = $this->Epin_model->get_donation_receiver_members();

 		$data['reentry_member'] = $this->db->get_where('reentry_members',array('member_id' =>$id,'member_status'=>'Approve'))->row();

 		$this->load->view('admin/includes/template',$data); 
 	}

 	public function assign_reentry_donation_submit($member_id)
 	{
 		$assign_to_members ='';
 		$admin_checked_amount =0;
 		$assign_to_admin ='';
 		$p_amount=0;

 		$assign_to_admin = $this->input->post('assign_to_admin');
 		$admin_checked_amount = $this->input->post('admin_checked_amount');
 		 
 		if ($admin_checked_amount!=0 && $assign_to_admin!='') 
 		{
 			$p_amount+=$admin_checked_amount;
 			$params1=array(
				'donate_to'=>$assign_to_admin,
				'donate_by'=>$member_id,					
				'donate_plan'=>'member',
				'donate_status'=>'assign',
				'donate_type'=>'Reentry',
				'donate_amount'=> $admin_checked_amount, 
				'donate_assign_date'=> date('Y-m-d H:i:s') 
			);
			 
			$in = $this->db->insert('donations',$params1);  
 		} 
 		$amt_ar ='';
 		$assign_to_members = $this->input->post('assign_to_member');
 		$assign_amount = $this->input->post('members_checked_amount');
 		//$amt_ar = array_values(array_filter($assign_amount)); 

 		if ($assign_to_members!='' && $member_id!='') 
 		{  $j=1;
			for ($i=0; $i < count($assign_to_members); $i++) 
			{ 				 
				$isExist = $this->db->get_where('roi_withdrawal_request',array('roi_withdrawal_request_id' =>$assign_to_members[$i]))->row();

				if ($isExist!='') 
				{ 	
					//get reciever ID
					$recieverData = getMemberDetails($isExist->member_id);
					//donar ID
					$donarData = getMemberDetails($member_id);
					
					$reciever_message="Please collect Rs ".$isExist->withdrawal_request_amount." from ".$donarData->member_login_id." - ".$donarData->member_mobile;
					
					$donar_message="Please Pay Rs ".$isExist->withdrawal_request_amount." to ".$recieverData->member_login_id." - ".$recieverData->member_mobile;
					
					$this->Member_network_mdl->send_sms($recieverData->member_mobile,$reciever_message);
					$this->Member_network_mdl->send_sms($donarData->member_mobile,$donar_message);
					
					$params=array(
						'donate_to'=>$isExist->member_id,
						'donate_by'=>$member_id,					
						'donate_plan'=>'member',
						'donate_status'=>'assign',
						'donate_type'=>'Reentry',
						'donate_amount'=>$isExist->withdrawal_request_amount, 
						'donate_request_id'=>$isExist->roi_withdrawal_request_id, 
						'donate_assign_date'=> date('Y-m-d H:i:s') 
					); 
					$p_amount+=$isExist->withdrawal_request_amount; 
					$in = $this->db->insert('donations',$params); 

					$this->db->set('withdrawal_status','assign');
					$this->db->where('roi_withdrawal_request_id',$isExist->roi_withdrawal_request_id);
					$this->db->update('isp_roi_withdrawal_request');
				} 
				$j++;
			} 
 		}
 		unset($_POST);
 		 
 		if($in){
 			$memData = $this->db->get_where('reentry_members',array('member_id' =>$member_id))->row();
 			$new_amt = $memData->member_member_amount-$p_amount; 
 			
 			$this->db->set('member_member_amount',$new_amt);
 			$this->db->where('member_id',$member_id);
 			$this->db->update('reentry_members');

 			$this->session->set_flashdata('success', 'Donation assigned Successful.');
			unset($_POST);
			redirect('epin/reentry_donor_members');
		}
 		else{
 			$this->session->set_flashdata('fail', 'fail select members.');
 			redirect('epin/assign_donation/'.$member_id);
 		}
 	}

 	public function view_pins()
 	{
 		$data['page_title']   = "View  Epin List";
 		$data['main_content'] = "admin/view_pins_list";
 		$data['epin_data']	  = $this->Epin_model->getused_epins();
		$this->load->view('admin/includes/template',$data);
 	}
 	
 	

 	public function epin_send()
	{
		$epin_id     = $this->input->post('epin_id');
		$epin_mobile = $this->input->post('epin_mobile');
		if ($epin_id!='' && $epin_mobile!='') 
		{
			$epin = $this->db->get_where('epin',array('epin_id' =>$epin_id))->row()->epin;
			  
			$msg =''.$this->config->item('title').' EPIN is : '.$epin;
			$this->Home_model->send_sms($epin_mobile,$msg);

			$this->session->set_flashdata('success', 'Epin send successfully..');
			redirect('epin/view_pins'); 
		}
	}

	public function epin_send_member()
	{
		$epin_id     = $this->input->post('epin_id');
		$epin_member = $this->input->post('member_login_id');
		$epin_member_id='';
		if ($epin_id!='' && $epin_member!='') 
		{
			$epin_member_id = getMemberID($epin_member);  
			if($epin_member_id!='')
			{				 
				$epin = $this->db->get_where('epin',array('epin_id' =>$epin_id))->row()->epin_id;
			   
				$this->db->where('member_id',$epin_member_id);
				$this->db->set('member_epin_id',$epin);
				$this->db->update('members');

				$this->session->set_flashdata('success', 'Epin send successfully..');
			}
			else
			{
				$this->session->set_flashdata('error', 'Invalid member login id.');	
			}
			redirect('epin/view_pins'); 
		}
	}

	public function view_topup_members()
 	{
 		$data['page_title']   = "View Topup Members List";
 		$data['main_content'] = "admin/view_topup_member_list";   

 		$from_date =''; $to_date   =''; $level='';
 		$data['sr_level']='';
 		if (isset($_POST['search'])) 
 		{ 			
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date'); 
 			$sel_pk   = $this->input->post('package');     
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date');  
 			$data['sel_pk']   = $this->input->post('package'); 
 			   
 			$data['members_data'] = $this->Epin_model->get_topup_membes($from_date,$to_date,$level,$sel_pk);    			
 		} 
 		else
 		{ 	
			$data['members_data'] = $this->Epin_model->get_topup_membes($from_date='',$to_date='',$level='',$sel_pk='');		 
 		} 

		$this->load->view('admin/includes/template',$data); 
 	}
	
 	public function epin_transfer()
 	{
 		$data['page_title']   = "Transfer E-PIN";
 		$data['main_content'] = "admin/transfer_epin"; 
		
		$admin = $this->db->get_where('members',array('member_type' =>'admin_member'))->row()->member_id;

		if($this->input->post('submit')=='submit')
		{
			$this->form_validation->set_rules('epin_qty','Quantity','required');
			$this->form_validation->set_rules('member_login_id','member id','required');
			$this->form_validation->set_rules('epin_package','package','required');
			if($this->form_validation->run()==TRUE)
			{   
				$member_login_id = $this->input->post('member_login_id');
				$member_id = getMemberID($member_login_id);

				$epin_package       = $this->input->post('epin_package');
				$package_data 		= getPackages($epin_package);
				$package_prefix	    = $package_data[0]->package_prefix; 
 				 
				$qty = $this->input->post('epin_qty'); 
				$tran=[];  
				for($i=0;$i<$qty;$i++)
				{
					$digit = date('H').date('i').date('s'); 
					$Last_char = $this->generateRandomString(); 
					$epin=$package_prefix.$digit.$Last_char;
					$tran['epin_member_id']=$member_id;
					$tran['epin_package_id'] = $epin_package;
					$tran['epin']=$epin; 
					$tran['epin_added_date']=date('Y-m-d H:i:s');
					$tran['epin_status']='Unused';
					$insert = $this->db->insert('epin',$tran);
					$insertId = $this->db->insert_id();
					$result = $i;

					$trans_history = array('transfer_from'=>$admin ,
										   'transfer_to'  =>$member_id,
										   'epin_id'	  =>$insertId,
										   'transfer_date'=>date('Y-m-d H:i:s')
										   );
					$this->db->insert('epin_history',$trans_history);
				}
				 
				$this->session->set_flashdata('success','Epin Transfer successfully...');
			
				redirect('epin/transfer_list');
			}
			else
			{  
				$this->session->set_flashdata('fail',validation_errors());
			}
		}  
		
		$this->load->view('admin/includes/template',$data); 
 	}

 	public function active_pending_member()
 	{
 		if(isset($_POST['active-submit']))
		{ 
			$this->form_validation->set_rules('epin', 'epin', 'required');   
			$this->form_validation->set_rules('member_id', 'member', 'required');   
			
			if ($this->form_validation->run() == TRUE)
			{	
				$memEpin ='';				  
				$memberId = $this->input->post('member_id');
				$check_epin=$this->db->get_where('isp_epin',array('epin'=>$this->input->post('epin'),'epin_type'=>'Registration','epin_status'=>'Unused'))->row();
				if($check_epin)
				{ 
						$epin_id = $check_epin->epin_id;
						$package_id = $check_epin->epin_package_id;

						$epin_params=array('epin_status'=>'Used','epin_used_date'=>date('Y-m-d'));
						$this->db->where('epin_id',$epin_id);
						$this->db->update('epin',$epin_params);  
							
						$upData = array( 	
										'member_epin_id'   	 	=>$epin_id,  
										'member_package_id'   	=>$package_id, 
										'member_current_package'=>$package_id, 
										'member_status'   	 	=>'Approve', 
						 				'member_active_date'	=>date('Y-m-d')
										);  
						$this->db->where('member_id',$memberId);
						$is_update=$this->db->update('members',$upData);  

						$re = $this->db->get_where('members',array('member_id' =>$memberId))->row();
						$mobileNo = $re->member_mobile; 
						$name = $re->member_name;

						$msg='Dear '.ucwords($name).' your account is activate. '.$this->config->item('title').'.';
						$this->Home_model->send_sms($mobileNo,$msg);
						
						if ($re->member_email_id!='') 
						{
							$to = $re->member_email_id; 
							$from = 'info@newskillholidays.com'; 
							$subject = 'Tour Packages for -'.$this->config->item('title');
							$message = 'Your registration Successfully for '.$this->config->item('title');
							//email send  
						   $this->load->library('email');
				           $this->email->set_newline("\r\n");
				           $this->email->from($from);
				           $this->email->to($to);
				           $this->email->subject($subject);
				           $this->email->message($message);
				           $this->email->attach($_SERVER["DOCUMENT_ROOT"].'/assets/front/pdf/mlm-plan-nsh.pdf');
				           $this->email->send();
				       }

						if ($is_update) 
						{ 	 
					 		$this->Home_model->add_roi_wallet($memberId,$package_id);  
						} 

					$this->session->set_flashdata('success','Member Active successfully...');	
					redirect('epin/view_pins');	
				}
				else
				{ 
					$this->session->set_flashdata('fail', 'Invalid Epin'); 
					redirect('epin/view_pins');
				} 
			}	
		} 
 	}
    public function activate_account()
	{

	    $data['page_title']   = "Activate Account";
 		$data['main_content'] = "admin/activate_account"; 
		
	
		
		$this->load->view('admin/includes/template',$data);
	}
	 public function activate_account1()
	{

	   
		
		if($this->input->post('submit')=='submit')
		{
		    $member_id = $this->input->post('member_id');
    		$epin = $this->input->post('epin');
	        $check_epin=$this->db->get_where('isp_epin',array('epin'=>$this->input->post('epin'),'epin_status'=>'Unused'))->row();
	        
	        $member_epin = $check_epin->epin_id;
			$member_epin_type = $check_epin->epin_type;
			
			$this->db->where('epin_id',$member_epin); 
	 		$this->db->set('epin_status','Used'); 
	 		$this->db->update('epin'); 
		
		    $this->db->where('member_id',$member_id); 
	 		$this->db->set('member_epin_id',$member_epin); 
	 		$this->db->update('members'); 
		    
		    echo 1;
		}
		
		
	}
 	public function activate_member()
 	{ 
 		
 		$login_id = $this->input->post('member_log_id');
 		//$package  = $this->input->post('epin_package');

		if ($login_id!='')
		{ 
			$roi_days = $this->config->item('config_daily_roi_days');

			$todayDate = date('Y-m-d');
			$toDate = date('Y-m-d', strtotime($todayDate. ' + '.$roi_days.' days'));

			$type = 'BYEPIN';
			 
			$memberData = getMemberData($login_id);

			/*$epinData = $this->Epin_model->get_packageEpin($package,$login_id);
 
			if ($epinData) 
			{
				$epin = $epinData->epin;
				$sponsorMember = $memberData->member_sponsored;
				$member_id = $memberData->member_id;

				$package_id = $epinData->package_id;
				$amount = $epinData->package_amount;

				$this->db->where('member_id',$member_id);
		 		$this->db->set('is_paid','Yes');  
		 		$this->db->set('member_status','Approve');  
		 		$this->db->set('member_package_id',$package_id); 
		 		$this->db->set('member_current_package',$package_id); 
		 		$this->db->set('member_active_date',$todayDate);
		 		$this->db->set('member_expired_date',$toDate);
		 		$this->db->set('member_epin_id',$epinData->epin_id);
		 		$this->db->update('members');

				$epin_params=array('epin_status'=>'Used','epin_used_date'=>date('Y-m-d'));
				$this->db->where('epin_id',$epinData->epin_id);
				$this->db->update('epin',$epin_params);

				$this->Home_model->add_sponsor_income($sponsorMember,$member_id,$amount);

			   unset($_POST);	 
			   $this->session->set_flashdata('success','Account active successfully'); 
			}
			else
			{
				$this->session->set_flashdata('fail','Invalid E-pin'); 
			} */

			$member_id = $memberData->member_id;

			$this->db->where('member_id',$member_id);
	 		$this->db->set('is_paid','Yes');  
	 		$this->db->set('member_status','Approve'); 
	 		$this->db->set('member_active_date',$todayDate);
	 		$this->db->update('members'); 
	 		 
		   unset($_POST);	 
		   $this->session->set_flashdata('success','Account active successfully'); 
		}
		else
		{
			$this->session->set_flashdata('fail','member id and package required'); 
		}
		redirect('epin/pending_members');
 	}

 	public function notSponsored_members()
 	{
 		$data['page_title']   = "View Not Sponsored Members List";
 		$data['main_content'] = "admin/view_notSponsored_members_list";   
 
 		$data['members_data'] = $this->Epin_model->get_members_data(array('member_status'=>'Approve','member_type'=>'member'));

		$this->load->view('admin/includes/template',$data); 
 	}

 	public function verify_doc($id)
 	{
 		$this->db->where('member_id',$id); 
 		$this->db->set('member_is_verify','Yes'); 
 			$this->db->set('rejection_remark','KYC Done'); 
 		//$this->db->set('member_status','Approve'); 
 	    $this->db->set('kyc_status','Approve'); 
 $update=		$this->db->update('isp_members'); 
 if($update){
        $data['profile_data'] = $this->Home_model->get_member_profile($id);
 
 		$message=' Dear User, Your KYC Documents Verified successfully. Plaese Login into your account and buy your packages. ';
				$subject = 'KYC document verified successfully.';
				$to = $data['profile_data'][0]->member_email_id;
			//	send_email($to,$subject,$message);
}
//  		$this->session->set_flashdata('success','verify success'); 

 		redirect('epin/view_kyc_members');
 	}
 		public function reject_doc($id)
 	{
 	
 	   	if($this->input->post('remark_submit')=='submit')
    	{
    	    $this->db->where('member_id',$id); 
      		$this->db->set('rejection_remark',$this->input->post('remark')); 
      		$this->db->set('member_is_verify','No'); 
      		$this->db->set('member_status','Pending'); 
     		$this->db->set('kyc_status','Rejected'); 
     $update=	    $this->db->update('isp_members'); 
     	    if($update){
        $data['profile_data'] = $this->Home_model->get_member_profile($id);
 
 		$message=' Dear User, Sorry to inform you, your kyc documents rejected by admin due to some document issues. Please upload the documents again. ';
				$subject = 'KYC document rejected by admin.';
				$to = $data['profile_data'][0]->member_email_id;
			//	send_email($to,$subject,$message);
}
     		$this->session->set_flashdata('success','KYC document rejected'); 
    	}

 		redirect('epin/view_kyc_members');
 	}
 		public function reject_register_mem($id)
 	{
 	
 	   	if($this->input->post('remark_submit')=='submit')
    	{
    	    $this->db->where('member_id',$id); 
      		// $this->db->set('rejection_remark',$this->input->post('remark')); 
      		// $this->db->set('member_is_verify','No'); 
      		// $this->db->set('member_status','Pending'); 
     		$this->db->set('member_status','Rejected'); 
     $update=	    $this->db->update('isp_members'); 
//      	    if($update){
//         $data['profile_data'] = $this->Home_model->get_member_profile($id);
 
//  		$message=' Dear User, Sorry to inform you, your kyc documents rejected by admin due to some document issues. Please upload the documents again. ';
// 				$subject = 'KYC document rejected by admin.';
// 				$to = $data['profile_data'][0]->member_email_id;
// 			//	send_email($to,$subject,$message);
// }
     		$this->session->set_flashdata('success','KYC document rejected'); 
    	}

 		redirect('epin/view_kyc_members');
 	}
 	public function verify_document($id)
 	{
 		$this->db->where('member_id',$id); 
 		$this->db->set('member_is_verify','Yes'); 
 		$this->db->update('members'); 

 		$this->session->set_flashdata('success','verify success'); 

 		redirect('epin/view_member_list');
 	}

	public function register_members()
 	{
 		$data['page_title']   = "View Register Members List";
 		$data['main_content'] = "admin/view_register_member_list";  
        $data['members_data'] = $this->Epin_model->get_view_regmembers_data();
        $this->load->view('admin/includes/template',$data); 
 	}
 	
 	public function view_registered_members()
 	{
 		$data['page_title']   = "View Members Details";
 		$data['main_content'] = "admin/register_member_view";
 		$member_id            = $this->uri->segment(3);
        $data['network_data'] = $this->Epin_model->get_member_network_data($member_id); 
 	//	$data['package'] = $this->Epin_model->get_member_package_data($member_id); 
 			
 		$data['members_details'] = $this->Epin_model->get_members($member_id);
		$this->load->view('admin/includes/template',$data); 
 	}
 
 	public function no_epin_members()
 	{
 		$data['page_title']   = "View No Epin Members List";
 		$data['main_content'] = "admin/view_no_epin_member_list";  
        $data['members_data'] = $this->Epin_model->get_no_epin_regmembers_data();
        $this->load->view('admin/includes/template',$data); 
 	}
 
 	
 	
 	
 public function edit_members_old()
 	{
 		$data['page_title']   = "Edit Register Members";
 		$data['main_content'] = "admin/edit-register-members";
 		$data['members_data']="";
 		$data['username']="";
        if (isset($_GET['search'])) 
 		{
 		    $type =  $this->input->get('username_type');     
 		  $data['username']= $username =  $this->input->get('username');       
 			if($type=='email')
 			{
 			    $data['members_data'] = $this->Epin_model->get_member_data_email($username);   
 			}
 			else if($type=='member_name')
 			{
 			    $data['members_data'] = $this->Epin_model->get_member_data_name($username);  
 			}
 				else if($type=='login_id')
 			{
 			    $data['members_data'] = $this->Epin_model->get_member_data_login_id($username);  
 			}
 			//  print_r($data['members_data']);
 		} 
//  		if (isset($_POST['update-profile']))
//  		{
//  			$this->form_validation->set_rules('name','Name','required');
//  			$this->form_validation->set_rules('password','Password','required'); 

//  			if ($this->form_validation->run() == TRUE)
//             {
// 				$updateData = array( 
//  			 					 'member_name' => $this->input->post('name'),
//  			 					 'member_dob' => $this->input->post('dob'),
//  			 					 'member_password' => base64_encode($this->input->post('password')),
//  			 					 'member_email_id' => $this->input->post('email'),
//  			 					 'member_mobile' => $this->input->post('mobile'),
//  			 					 'member_address' => $this->input->post('postal_address'),
//  			 					 'member_state' => $this->input->post('state'),   
//  			 					 'member_city' => $this->input->post('city'),
//  			 					 'member_pin_code' => $this->input->post('pin_code'),
 			 					
//  			 					 'member_pan_card' => $this->input->post('pan_card_no'),
//  			 					 'member_aadhar_no' => $this->input->post('aadhar_no'),
//  			 					 'member_bank_name' => $this->input->post('bank_name'),
//  			 					 'member_account_no' => $this->input->post('account_no'),
//  			 					 'member_ifsc_code' => $this->input->post('ifsc_code'),
//  			 					 'member_branch_name' => $this->input->post('branch_name')
//  			 						 );  
 

// 				$update = $this->Epin_model->update($updateData,'member_id='.$member_id,'members'); 
// 				$this->session->set_flashdata('success','Profile update successfully...');
// 				//redirect('epin/view_members');  
// 				redirect('epin/edit_register_members/'.$member_id);  
// 			}
//  		}
		$this->load->view('admin/includes/template',$data); 
 	}


public function edit_members()
 	{
 		$data['page_title']   = "Edit Register Members";
 		$data['main_content'] = "admin/edit-register-members";
 		$data['members_data']="";
 		$data['username']="";
        if (isset($_POST['search'])) 
 		{
 		  $type =  $this->input->post('username_type');     
 		  $data['username']= $username =  $this->input->post('username');       
 			if($type=='email')
 			{
 			    $data['members_data'] = $this->Epin_model->get_member_data_email($username);   
 			}
 			else if($type=='member_name')
 			{
 			    $data['members_data'] = $this->Epin_model->get_member_data_name($username);  
 			}
 				else if($type=='login_id')
 			{
 			    $data['members_data'] = $this->Epin_model->get_member_data_login_id($username);  
 			}
 
 		
 		} 

 	
 		if ($this->input->post('update-profile')=='update') 
 		{
 		
 		    $member_id = $this->input->post('member_id');
 			$login_id = getMemberLoginID($member_id);
 			$members_data = $this->Epin_model->get_member_data_login_id($login_id);  
 			$name = $members_data->member_name;
 	     
					$member_mobile 		= $this->input->post('mobile_no');
					$member_email	= $this->input->post('email');
					$member_Name 		= $this->input->post('member_Name');
					$member_gender	= $this->input->post('gender');
					$member_country		= $this->input->post('country');
					$member_password	= $this->input->post('password');
					$member_wallet_password	= $this->input->post('wallet_password');
					
				    $member_first_name	= $this->input->post('member_first_name'); 
					$member_middle_name = $this->input->post('member_middle_name'); 
					$member_last_name 	= $this->input->post('member_last_name');
					$member_dob 		= $this->input->post('member_dob');
					$member_address 	= $this->input->post('address');
					$aadhar_id 			= $this->input->post('aadhaar_detail');
					$passport_id 		= $this->input->post('member_passport_detail');
					$driving_lic_id 	= $this->input->post('member_driving_license_detail');
					$id_proof 			= $this->input->post('member_address_doc_details');
					$address_varify 	= $this->input->post('member_address_doc_details');
					
					$is_error		= true;
					$passport_front = $passport_back = $adhar_front = $adhar_back = $driving_front = $driving_back = '';$userphoto = '';
				// 	 echo $is_error;echo "<pre>";
					if($id_proof == 'passport')
					{
					  
						if($_FILES['passport_front']['size'] > 0 && $_FILES['passport_back']['size'] > 0 && !empty($passport_id))
						{
						     
							$config['upload_path'] 		= './assets/profile/';
							$config['allowed_types'] 	= 'jpg|jpeg|png';
							$config['file_name'] 		= $_FILES['passport_front']['name'];
							$this->load->library('upload',$config);
							$this->upload->initialize($config);							
							if($this->upload->do_upload('passport_front'))
							{
								$uploadData = $this->upload->data();
								$passport_front= $uploadData['file_name'];
							}
								
							$config['file_name'] = $_FILES['passport_back']['name'];
							$this->load->library('upload',$config);
							$this->upload->initialize($config);
							if($this->upload->do_upload('passport_back'))
							{
								$uploadData = $this->upload->data();
								$passport_back= $uploadData['file_name'];
							}
						
							$is_error		= false;
						
						}
					}else if($id_proof == 'adhaar_card'){
						if($_FILES['adhar_front']['size'] > 0 && $_FILES['adhar_back']['size'] > 0 && !empty($aadhar_id)){
							$config['upload_path'] 		= './assets/profile/';
							$config['allowed_types'] 	= 'jpg|jpeg|png';
							$config['file_name'] 		= $_FILES['adhar_front']['name'];
							
							$this->load->library('upload',$config);
							$this->upload->initialize($config);							
							if($this->upload->do_upload('adhar_front'))
							{
								$uploadData = $this->upload->data();
								$adhar_front= $uploadData['file_name'];
							}	
							$config['file_name'] = $_FILES['adhar_back']['name'];
							$this->load->library('upload',$config);
							$this->upload->initialize($config);
								
							if($this->upload->do_upload('adhar_back'))
							{
								$uploadData = $this->upload->data();
								$adhar_back= $uploadData['file_name'];
							}
							$is_error		= false;
						}						
					}else if($id_proof == 'driving_licence'){
						if($_FILES['driving_front']['size'] > 0 && $_FILES['driving_back']['size'] > 0 && !empty($driving_lic_id)){
							$config['upload_path'] 		= './assets/profile/';
							$config['allowed_types'] 	= 'jpg|jpeg|png';
							$config['file_name'] 		= $_FILES['driving_front']['name'];
							$this->load->library('upload',$config);
							$this->upload->initialize($config);							
							if($this->upload->do_upload('driving_front'))
							{
								$uploadData = $this->upload->data();
								$driving_front= $uploadData['file_name'];
							}	
							$config['file_name'] = $_FILES['driving_back']['name'];
							$this->load->library('upload',$config);
							$this->upload->initialize($config);
								
							if($this->upload->do_upload('driving_back'))
							{
								$uploadData = $this->upload->data();
								$driving_back= $uploadData['file_name'];
							}
							$is_error		= false;							
						}
					}
				// 	 if(!empty($_FILES['selfie']['name']))
				// 	{
				// 			$config['upload_path'] 		= './assets/profile/';
				// 			$config['allowed_types'] 	= 'jpg|jpeg|png';
				// 			$config['file_name'] 		= $_FILES['selfie']['name'];
				// 			$this->load->library('upload',$config);
				// 			$this->upload->initialize($config);
							
				// 			if($this->upload->do_upload('selfie'))
				// 			{
				// 				$uploadData = $this->upload->data();
				// 				$userphoto= $uploadData['file_name'];
				// 			}
				// 			else
				// 			{
				// 				$userphoto = '';
				// 			}
				// 	}
				// 	if($userphoto == '')
				// 	{
				// 	    $userphoto=$members_data->member_photo;
				// 	}
				// 	if($adhar_front == '')
				// 	{
				// 	    $userphoto=$members_data->adhar_card_doc;
				// 	}
				//     if($adhar_back == '')
				// 	{
				// 	    $userphoto=$members_data->adhar_card_back;
				// 	}
				// 	if($passport_front == '')
				// 	{
				// 	    $userphoto=$members_data->passport_doc;
				// 	}
				//     if($passport_back == '')
				// 	{
				// 	    $userphoto=$members_data->passport_back_doc;
				// 	}
				// 	if($driving_front == '')
				// 	{
				// 	    $userphoto=$members_data->driving_lic_doc;
				// 	}
				//     if($driving_back == '')
				// 	{
				// 	    $userphoto=$members_data->driving_lic_back_doc;
				// 	}
				 if (!empty($_FILES['selfie']['name'])) {
    $config['upload_path'] = './assets/profile/';
    $config['allowed_types'] = 'jpg|jpeg|png|pdf';

    $config['file_name'] = $_FILES['selfie']['name'];
    $this->load->library('upload', $config);
    $this->upload->initialize($config);

    if ($this->upload->do_upload('selfie')) {
        $uploadData = $this->upload->data();
        $userphoto = $uploadData['file_name'];
    } else {
        $userphoto = '';
    }
}

	if (empty($_FILES['selfie']['name']) && empty($userphoto)) {
   
    $userphoto = $members_data->member_photo;
}
					if($userphoto == '' && $adhar_front == '')
					{
					    $userphoto=$members_data->adhar_card_doc;
					}
				    if($userphoto == '' && $adhar_back == '')
					{
					    $userphoto=$members_data->adhar_card_back;
					}
					if($userphoto == '' && $passport_front == '')
					{
					    $userphoto=$members_data->passport_doc;
					}
				    if($userphoto == '' &&  $passport_back == '')
					{
					    $userphoto=$members_data->passport_back_doc;
					}
					if($userphoto == '' && $driving_front == '')
					{
					    $userphoto=$members_data->driving_lic_doc;
					}
				    if($userphoto == '' && $driving_back == '')
					{
					    $userphoto=$members_data->driving_lic_back_doc;
					}
					    $arr=array(
							'member_id'       		=>$member_id,
							'first_name'			=>$member_first_name,
							'middle_name'			=>$member_middle_name,
							'last_name'				=>$member_last_name,
							'birthdate'				=>$member_dob,
							'aadhar_id'				=>$aadhar_id,
							'adhar_card_doc'		=>$adhar_front,
							'adhar_card_back'		=>$adhar_back,
							'passport_id'			=>$passport_id,
							'passport_doc'			=>$passport_front,
							'passport_back_doc'		=>$passport_back,
							'driving_lic_id	'		=>$driving_lic_id,
							'driving_lic_doc'		=>$driving_front,
							'driving_lic_back_doc'	=>$driving_back,
							'address_verify_option'	=>$address_varify,
							'address'				=>$member_address,
							'member_photo'			=>$userphoto,
					
						);
						
						$this->db->where('member_id',$member_id);
							$update = $this->db->update('isp_profile_doc_details',$arr);
						
							if($update){
								
								$u_data=array(
								    	'member_name'=>$member_first_name." ".$member_last_name,
									'member_profile'=>$userphoto,
									'member_dob'	=>$member_dob,
									'member_email_id'	=>$member_email,
									'member_mobile'	=>$member_mobile,
									'member_password'	=>base64_encode($member_password),
								// 	'wallet_password'=>base64_encode($member_wallet_password),
								// 	'member_country'	=>$member_country,
									'member_gender'	=>$member_gender,
								);
								$this->db->where('member_id',$member_id);
								$this->db->update('isp_members',$u_data);
				// 			echo	$this->db->last_query();die;
							}
					
					   // }
 
                $str= $name." Details Updated successfully...";
			
				$this->session->set_flashdata('success',$str);
				redirect('epin/edit_members');  
		  
			
 		}
		$this->load->view('admin/includes/template',$data); 
 	} 	
 	public function reject_epin($id)
 	{
 		$this->db->where('epin_id',$id); 
 		$this->db->set('request_status','Rejected'); 
        $update=$this->db->update('request_epin'); 
       
 		$this->session->set_flashdata('success','Epin Rejected Successfully...'); 

 		redirect('epin/epin_requested');
 	}	
 	public function add_order($id)
 	{
 	
 	    $centerid= $this->uri->segment(3);
 	    $members_data = $this->Epin_model->get_member_regi($centerid); 
        $customer_name = $members_data[0]->member_name;
        $email = $members_data[0]->member_email_id;
        $amount =$members_data[0]->package;
        $package_type =$members_data[0]->package_type;
        $c_id = $members_data[0]->member_id;
        $data['payment_mode']=$this->input->post('mode_of_payment');
        $data['package_start_date']=$this->input->post('package_start_date');
        $customer_ID = $members_data[0]->member_login_id;
        if (!empty($_POST)) 
        {
            $value = $_POST['amount_payment'];
		    $parts = explode('_', $value);
            $package = $parts[0];
            $duration = $parts[1];
            $type = $parts[2];
            
            $durationParts = explode('*', $duration);
            $durationValue = trim($durationParts[0]);
            $durationUnit = trim($durationParts[1]);
           
           if(!empty($_FILES['receipt']['name']))
            {
                $config['upload_path'] = './assets/photo/';
                $config['allowed_types'] = 'jpg|jpeg|png|pdf';
                $config['file_name'] = $_FILES['receipt']['name'];
                
                //Load upload library and initialize configuration
                $this->load->library('upload',$config);
                $this->upload->initialize($config);
                
                if($this->upload->do_upload('receipt'))
                {
                    $uploadData = $this->upload->data();
                    $receipt= $uploadData['file_name'];
                }
                else
                {
                    $receipt = '';
                }
            }
            else
            {
                $receipt = '';
            }
           
            $userData = array(
                        'm_id' => $centerid,
                        'select_amount'=>$package,
                        'amount' => $durationValue,
                        'receipt' => $receipt,
                        'mode_of_payment' => $this->input->post('mode_of_payment'),
                        'transaction_id' => $this->input->post('transaction_id'),
                        'remark' => $this->input->post('remark1'),
                        'pay_date' =>  $this->input->post('package_start_date'),
                        'package_start_date'=>  $this->input->post('package_start_date')
                        
                      );
                      $this->db->insert('isp_member_payment',$userData); 
                      $payment_insert_id = $this->db->insert_id();
                      
			 	  $type  ='Member';
		
        				$id  = $centerid;
        				$title ='Your Payment is  Successfully';
        				$body  ='Dear   '.$customer_name.', Your Payment of '.$package.' is  Successfully';
        				
        				$date = date('Y-m-d H:i:s');
    					$notifyData = array(
    					        'notification_type'     => $type,
    					        'ven_cust_id'           => $id,
    					        'notification_subject'  => $title,
    					        'notification_message'  => $body,
    					        'created_at'            => $date,
    					    );
    					    
    					$last_id = $this->Home_model->insertDataapi('bs_notifications',$notifyData);
    					if($last_id)
    					{
    				   send_Notify($type,$id,$title,$body);
        			    
    					}  
            }
            if (!empty($c_id)) 
            {
                $this->db->where('member_id', $c_id); 
                $this->db->set('member_status', 'Approve');
                $this->db->update('isp_members');
               
                $date = $this->input->post('package_start_date');            //order date start from payment date selected
                
                // $date= date('Y-m-d');                //order date start from current date
              
                $days = 31;
                $status = "upcoming";

                for($i=1;$i<=36;$i++)
                {
                    if($i == 1)
                    {
                        $order_date= date('Y-m-d', strtotime($date. ' +'.$days.' days'));
                    }
                    else
                    {
                        $days = ($days+31);
                        $order_date= date('Y-m-d', strtotime($date. ' +'.$days.' days'));
                        $o_date = date("Y-m-d",strtotime("+ ".$days." days"));
                    }  
                    $last_row = $this->db->order_by('o_id',"desc")->limit(1)->get('isp_order')->row(); 
                    if($last_row== '' || $last_row=='null')
                    {
                        $next_id  = 1;
                    }
                    else
                    {
                        $next_id  = $last_row->o_id + 1;
                    }
                        
                    $order_id  = "M".str_pad($next_id, 5, '5000', STR_PAD_LEFT);
                    $insert_amt = $members_data[0]->amount;
                    $order_data = array(
                            'order_id' =>$order_id ,
                            'amount' => $insert_amt,
                            'v_id' =>"-" ,
                            'member_id' => $c_id,
                            'order_no' => $i,
                            'o_date' => $order_date,
                            'package' => $amount,
                            'package_type' => $package_type,
                            'status' => $status,
                        );
                    $insertUserData = $this->Epin_model->insert3($order_data);
                  
                   
                    
                }
                if($insertUserData)
                {
                    $centerid = $this->uri->segment(3);
                    $members_data = $this->Epin_model->get_member_regi($centerid);
                
                    foreach ($members_data as $member) 
                    {
                        $member_id = $member->member_id;
                        $this->Epin_model->set_payment_status($member_id, 'Approve');
                        ///pdf
                        $details=$this->db->get_where('isp_members',array('member_id'=>$centerid))->row();
                        $data['customer']   = $details;
                        //print_r($data);die;
           
                        $filename ="pay_receipt_".$customer_ID;
                        $filename1=$filename.'.pdf';
                
                        $this->load->library('pdf');
                        $html = $this->load->view('pdf', $data, true);
                
                        $this->pdf->createPDF($html, $filename, false);
                        $attched_file= $_SERVER["DOCUMENT_ROOT"]."/data/pay_receipt/".$filename.'.pdf'; 
                
                      
                      $attched_file1= base_url()."data/pay_receipt/".$filename.'.pdf';
                        $pdf=$filename.'.pdf';
             	        $data1=array(
             	            'pdf'=>$pdf,
             	            'pdf_path'=>$attched_file1
             	            
             	            );
             	
			            $update = $this->Epin_model->update($data1,'mp_id='.$payment_insert_id,'isp_member_payment');
			    	    $data_1=array(
             	                'member_active_date'=>$this->input->post('package_start_date')
             	                );
			            $update = $this->Epin_model->update($data_1,'member_id='.$member_id,'isp_members');
			    
                        $html = "Dear ,<br>";         
                        $html .= "<br>Customer Name : <b>".$customer_name."</b> ";
                        $html .= "<br>Amount : <b>".$amount."</b> ";
                        $html .= "<br>Receipt No : <b>".$c_id."</b>";
                             
                        $mesg = " Dear $customer_name Congratulations, Your membership is activated your payment of Rs.$amount is received successfully and your receipt no. is $c_id. You can download your receipt from the link. ".$attched_file1." Regards, MaxxGain Bazzar, MAGACN"; 
                                
                        $subject="Welcome in maxxgainbazzar";
                       send_email($email,$subject,$mesg);
                      
                                 redirect('epin/register_members');
                           
                        }
 
                }
            }
        $this->session->set_flashdata('success','verify success'); 
        redirect('epin/register_members');
 	}	
 	public function order()
	{    
 
    	$data['page_title']   = "Upcoming Order List";
    	$data['main_content']  = "admin/order";
    	$data['orders'] = $this->db->order_by('o_id', 'desc')->get_where('isp_order')->result();
    	
        $data['orders'] = $this->db->get_where('isp_order', array('status' => 'upcoming'))->result();
       // $data['orders']=$this->db->get_where('isp_order')->result();
 	  $this->load->view('admin/includes/template',$data); 
	}
	public function all_login_member()
	{    
 
        $members=$this->db->get_where('isp_members')->result();
        foreach($members as $mem)
        {
            $login_id = 'MAX'.mt_rand(10000000, 99999999);
  
             	$this->db->where('member_id',$mem->member_id); 
			 		$this->db->set('member_login_id',$login_id); 
			 			$this->db->set('member_referel_link',$login_id); 
			 		$this->db->update('isp_members');
			 	echo "<pre>";	echo $this->db->last_query();
        }
 
	}
	public function update_upline_member()
	{    
        $members=$this->db->get_where('isp_members')->result();
        foreach($members as $mem)
        {
            $arr=array(
					'level_member_id'       		=> $mem->member_id,
					'level_1'       		=> 1,
					);
			$this->Home_model->insert_data('isp_roi_upline_level',$arr); 
			echo "<pre>";	echo $this->db->last_query();
        }
 
	}
	public function pending()
	{    
 
        $data['page_title']   = "Pending Order List";
        $data['main_content']  = "admin/pending";
        $data['orders'] = $this->db->get_where('isp_order', array('status' => 'pending'))->result();
 	    $this->load->view('admin/includes/template',$data); 
	}

public function confirm_orders()
{
    $data['page_title'] = "Confirm Order List";
    $data['main_content'] = "admin/confirm_list";

    if ($this->input->post("btn_submit")) {
        $date = $this->input->post('date');

        
        $data['selected_date'] = $date;

        $data['orders'] = $this->db->order_by('o_id', 'desc')->get_where('isp_order', array('status' => 'confirmed', 'confirm_date' => $date))->result();

       
    } else {
        $data['selected_date'] = ''; 
        $data['orders'] = $this->db->order_by('o_id', 'desc')->get_where('isp_order', array('status' => 'confirmed'))->result();
    }

    $this->load->view('admin/includes/template', $data);
}
	public function approve_confirm()
	{  
        $confirm_date  = $_POST['confirm_date'];
        if($confirm_date=="")
        {
            $confirm_date=date('Y-m-d');
        }
         $member_name = $_POST['name'];
        $remark  = $_POST['remark'];
         $bill_no  = $_POST['bill_no'];
        $o_id  = $_POST['o_id'];
        $member_id  = $_POST['member_id'];
        $order_no = $data['order_no'] = $_POST['order_no'];
        $data['confirm_date']  = $_POST['confirm_date'];
        $date =$o_id; 
        $d=date("my");
        $order_id  = "MO".$d.str_pad($date, 4, '0', STR_PAD_LEFT);
	    if(!empty($_FILES['receipt']['name']))
        {
        
            $config['upload_path'] = './assets/uploads/';
            $config['allowed_types'] = 'jpg|jpeg|png|pdf';
            $config['file_name'] = $_FILES['receipt']['name'];
           
            //Load upload library and initialize configuration
            $this->load->library('upload',$config);
            $this->upload->initialize($config);
            
            if($this->upload->do_upload('receipt'))
            {
                $uploadData = $this->upload->data();
                $receipt= $uploadData['file_name'];
            }
            else
            {
                $receipt = '';
            }
        }
        else
        {
            $receipt = '';
        }  
        // if($receipt !="")
        // {
             $v_id=18;
             
   	        $this->db->where('o_id',$o_id); 
			$this->db->set('status','confirmed');
			$this->db->set('remark',$remark);
			$this->db->set('v_id',$v_id);
			$this->db->set('bill_no',$bill_no);
			$this->db->set('order_id',$order_id);
			$this->db->set('receipt',$receipt);
			$this->db->set('confirm_date',$confirm_date);
		    $a=	$this->db->update('isp_order');
		  //  echo $this->db->last_query();die;
		   
		    $bill_no  = $this->input->post('bill_no');
		    if($bill_no=='' || empty($bill_no)){
		        $bill_no="0000";
		    }

            
             $this->db->where('c_id',$member_id);
            $this->db->where('order_no',$order_no); 
			$this->db->set('status','confirmed');
			$this->db->set('remark',$remark);
			$this->db->set('v_id',$v_id);
			$this->db->set('bill_no',$bill_no);
			$this->db->set('order_id',$order_id);
			$this->db->set('receipt',$receipt);
			$this->db->set('confirm_date',$confirm_date);
		    $aa =	$this->db->update('mg_customer_order');
		  
		  	$type  ='Member';
		
        				$id    = $member_id;
        				$title ='Your order '.$order_no.' is  confirmed';
        				$body  ='Dear   '.$member_name.', Your order '.$order_no.' is  confirmed';
        				
        				$date = date('Y-m-d H:i:s');
    					$notifyData = array(
    					        'notification_type'     => $type,
    					        'ven_cust_id'           => $id,
    					        'notification_subject'  => $title,
    					        'notification_message'  => $body,
    					        'created_at'            => $date,
    					    );
    					    
    					$last_id = $this->Home_model->insertDataapi('bs_notifications',$notifyData);
    					if($last_id)
    					{
    				
        				     send_Notify($type,$id,$title,$body);
        				    
    					}
		  
	        $id = $this->uri->segment(3);
            $details=$this->db->get_where('isp_members',array('member_id'=>$id))->row();
    
            $data['customer']   = $details;
            $customer_ID = $details->member_login_id;
            

            if (strlen($order_no) == 1) 
            {
                $order_no = "0" . $order_no;
            }
            $filename ="pay_receipt_".$customer_ID.$order_no;
            $filename1=$filename.'.pdf';
            $this->load->library('pdf');
            $html = $this->load->view('receipt', $data, true);
         
            $this->pdf->createPDF($html, $filename, false);
            $attched_file= $_SERVER["DOCUMENT_ROOT"]."/business/data/pay_receipt/".$filename.'.pdf';
           
            $attched_file1= $_SERVER['SERVER_NAME']."/business/data/pay_receipt/".$filename.'.pdf';
            $pdf=$filename.'.pdf';
                
            $data1=array('pdf'=>$pdf,'pdf_path'=>$attched_file1); 
            $update = $this->Epin_model->update($data1,'o_id='.$o_id,'isp_order');
        
	    redirect('epin/pending');
 		$this->load->view('admin/includes/template',$data); 
	}
 	public function my_team()
	{
	    $data['page_title']   = "My Team";
	    $data['member_id']=	$member_id = $this->uri->segment(3);
		if($this->input->post("btn_submit"))
		{
			$level_no=$this->input->post("level_no");
			
			$details=$this->Member_network_mdl->get_level_member_list($member_id,$level_no);
		    $data['network_list']= $details;
		    $data['level']=$level_no;
			$names = getSponsor($member_id); 
		}
		else
		{
			$data['level']=1;
			$details=$this->Member_network_mdl->get_level_member_list($member_id,1);
		    $data['network_list']= $details;
		}

  	    $data['con_levels']= $this->config->item('config_levels');
	    $data['type_levels']= $this->config->item('level_type');

		$data['upline'] = getUplineId($member_id);
		
		$data['main_content']      = "admin/my_team"; 
		$this->load->view('admin/includes/template',$data);
	}
		public function ticket_support()
	{
		$data['page_title'] = "Support Ticket";
		$data['main_content'] = "admin/ticket_support";

		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');        
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date'); 

 			$data['members_data'] = $this->Epin_model->get_tickets_data($from_date,$to_date);   
 		} 
 		else
 		{
 		  $data['from_date']=''; 
 		  $data['to_date']='';		
 		  $data['members_data'] = $this->Epin_model->get_tickets_data($from_date='',$to_date='');		 
 		} 

		$this->load->view('admin/includes/template',$data);
	} 

	public function ticket_reply()
	{
		$reply = $this->input->post('ticket_reply');
		$id = $this->input->post('ticket_id');

		if ($id!='' && $reply!='') 
		{
			$ar = array('ticket_reply' =>$reply,'ticket_status'=>'Replied');
			$this->db->where('ticket_id',$id);
			$this->db->update('ticket_support',$ar);

			$this->session->set_flashdata('success', 'Ticket reply send successful.');
			redirect('donation/ticket_support');
		}
	}
	public function update_table()
	{
	    $this->db->select('*');
        $this->db->from('mytable'); 
        $q = $this->db->get();
        $demo_product = $q->result();
        foreach($demo_product as $product)
        {
            $ar = array(
                'slug' =>strtolower(str_replace(" ", "-",$product->name)),
                'sku' =>strtolower(str_replace(" ", "-",$product->name)),
                'meta_title' =>$product->name,
                'meta_description' =>$product->name,
                'current_stock'=>'1000',
               'thumbnail_img'=>'https://maxxgainbazzar.com/store/public/uploads/all/'.$product->photos,
                'photos'=>'https://maxxgainbazzar.com/store/public/uploads/all/'.$product->photos
               );
			$this->db->where('name',$product->name);
			$this->db->update('mytable',$ar);
			echo $this->db->last_query();echo "<pre>";
        }
	}

	public function update_cat()
	{
        $this->db->select('*');
        $this->db->from('mytable'); 
        $q = $this->db->get();
        $demo_product = $q->result();
        foreach($demo_product as $product)
        {
            $cat_details = $this->db->get_where('category',array('category_name'=>$product->Sub_Category))->row();
            // print_r($cat_details);die;
            //  $this->db->set('category_id', $cat_details->cat_id);
            // $this->db->where('mytable.Brand = brand.category_name');
            // $this->db->update('mytable');
            
            $this->db->where('product_Id =',$product->product_Id );
	 	    $this->db->update('mytable',array('category_id'=>$cat_details->cat_id));
	 	    echo $this->db->last_query();echo"<pre>";
        }
       
	}
		public function update_brandproduct()
	{
        $this->db->select('*');
        $this->db->from('mytable'); 
        $q = $this->db->get();
        $demo_product = $q->result();
        foreach($demo_product as $product)
        {
            $cat_details = $this->db->get_where('brand',array('brand_name'=>$product->Brand))->row();
            // print_r($cat_details);die;
            // $this->db->set('category_id', $cat_details->cat_id);
            // $this->db->where('mytable.Brand = brand.category_name');
            // $this->db->update('mytable');
            
            $this->db->where('product_Id =',$product->product_Id);
	 	    $this->db->update('mytable',array('brand_id'=>$cat_details->b_id));
	 	    echo $this->db->last_query();echo"<pre>";
        }
       
	}
		public function income_bank_details()
	{  

        $member_id  = $_POST['member_id'];
        $bank_id  = $_POST['bank_id'];
        //$receipt  = $_POST['receipt'];
       if(!empty($_FILES['receipt']['name']))
        {
        
            $config['upload_path'] = './assets/uploads/';
            $config['allowed_types'] = 'jpg|jpeg|png|pdf';
            $config['file_name'] = $_FILES['receipt']['name'];
            
            //Load upload library and initialize configuration
            $this->load->library('upload',$config);
            $this->upload->initialize($config);
            
            if($this->upload->do_upload('receipt'))
            {
                $uploadData = $this->upload->data();
                $receipt= $uploadData['file_name'];
            }
            else
            {
                $receipt = '';
            }
        }
        else
        {
            $receipt = '';
        } 
       $account= $this->input->post('account'); 
       $member_name= $this->input->post('name');
        $bank= $this->input->post('bank_name');
        $income_date  = $_POST['date'];
        $amount  = $_POST['amount'];
        $remark  = $_POST['remark'];
        $paid_date  = $_POST['paid_date'];
    if($member_name == ""){
        $member_name = "-";
    }  
     if($account == ""){
        $account = "-";
    }
    if($bank == ""){
        $bank = "-";
    }
	        $this->form_validation->set_rules('amount','Amount','required');
            
			if($this->form_validation->run()==TRUE)
			{ 
			   
			        
			    
			  $insertData = array(
							'account_holder_name'  =>$member_name,
							'member_id'  =>$member_id,
							'bank_id'  =>$bank_id,
							'account_number'  =>$account,
						    'bank_name'  	  =>$bank,
						    'receipt'   =>$receipt,
							'income_date'   =>$income_date,  
							'amount'  	  =>$amount,
							'remark'  	  =>$remark,
							'paid_date'  	  =>$paid_date
							
							 ); 
			   
			  
						$result=$this->db->insert('isp_income_bank_details',$insertData); 
        //               if($result){
        //                   $data = $_POST;
        //                   $details=$this->db->get_where('isp_members',array('member_id'=>$member_id))->row();
                     
        //                 $min = 1;
        //                 $max = 500; 
        //                     $randomNumberInRange = rand($min, $max);


        //                   $customer_ID = $details->member_login_id;
        //                   $filename ="pay_receipt_".$customer_ID.$randomNumberInRange;
                      
        //     $filename1=$filename.'.pdf';
        //     $this->load->library('pdf');
        //     $html = $this->load->view('bank_receipt', $data, true);
        //  print_r($html);die;
        //     $this->pdf->createPDF($html, $filename, false);
        //     $attched_file= $_SERVER["DOCUMENT_ROOT"]."/data/pay_receipt/".$filename.'.pdf';
        //     $attched_file1= $_SERVER['SERVER_NAME']."/data/pay_receipt/".$filename.'.pdf';
        //     $pdf=$filename.'.pdf';
                
        //     $data1=array('pdf'=>$pdf,'pdf_path'=>$attched_file1); 
        //               }
					
					
					$this->session->set_flashdata('success','Data Added successfully...');
					redirect('epin/bank_details');
			
			}

             


        
 	    redirect('epin/bank_details');
 		$this->load->view('admin/includes/template',$data); 
	}
		public function income_bk_details()
 	{
 		$data['page_title']   = "View Income Details";
 		$data['main_content'] = "admin/income_details";  
 		$id = $this->uri->segment(3);
        $data['members'] = $this->Epin_model->get_level_income($id);
 
        $this->load->view('admin/includes/template',$data); 
 	}
} //class closed..