<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Exportdb extends CI_Controller {

	function __construct(){
		parent::__construct();
		
		date_default_timezone_set('Asia/Kolkata'); 
		$this->load->database();
		$this->load->helper('all_function');
		$this->load->library('email');
	}


// function exportDatabase() //old
// {
//     $this->load->dbutil();
//     $backup = $this->dbutil->backup();
//     $this->load->helper('file');
//     $this->load->helper('download');
//     $filename = 'database_backup_' . date('Y-m-d_H-i-s') . '.sql';
//     $fp = fopen('Database_backup'.'/'. $filename ,'w+');
//     $result = fwrite($fp, $backup);
//     if (($result = fwrite($fp, $backup))) 
//     {
//         echo "Backup file created '--$filename' ($result)";  
//     }
//     fclose($fp);
// }

   //Export_Database 
	function exportDatabase()
    {
        $mysqlUserName      =   $this->db->username;
		$mysqlPassword      =   $this->db->password;
		$mysqlHostName      =   $this->db->hostname;
		$DbName             =   $this->db->database;
        $tables             =   false; 
        $backup_name        =   false; 
        $mysqli = new mysqli($mysqlHostName,$mysqlUserName,$mysqlPassword,$DbName); 
        $mysqli->select_db($DbName); 
        $mysqli->query("SET NAMES 'utf8'");
        $queryTables    =   $mysqli->query('SHOW TABLES'); 

        while($row = $queryTables->fetch_row()) 
        { 
            $target_tables[] = $row[0]; 
        }   
        if($tables !== false) 
        { 
            $target_tables = array_intersect( $target_tables, $tables); 
        }
        foreach($target_tables as $table)
        {
            $result         = $mysqli->query('SELECT * FROM '.$table);  
            $fields_amount  = $result->field_count;  
            $rows_num       = $mysqli->affected_rows;     
            $res            = $mysqli->query('SHOW CREATE TABLE '.$table); 
            $TableMLine     = $res->fetch_row();
            $content        = (!isset($content) ?  '' : $content) . "\n\n".$TableMLine[1].";\n\n";

            for ($i = 0, $st_counter = 0; $i < $fields_amount;   $i++, $st_counter=0) 
            {
                while($row = $result->fetch_row())  
                { //when started (and every after 100 command cycle):
                    if ($st_counter%100 == 0 || $st_counter == 0 )  
                    {
                            $content .= "\nINSERT INTO ".$table." VALUES";
                    }
                    $content .= "\n(";
                    for($j=0; $j<$fields_amount; $j++)  
                    { 
                        $row[$j] = str_replace("\n","\\n", addslashes($row[$j]) ); 
                        if (isset($row[$j]))
                        {
                            $content .= '"'.$row[$j].'"' ; 
                        }
                        else 
                        {
                            $content .= '""';
                        }     
                        if ($j<($fields_amount-1))
                        {
                            $content.= ',';
                        }
                    }
                    $content .=")";
                    //every after 100 command cycle [or at last line] ....p.s. but should be inserted 1 cycle eariler
                    if ( (($st_counter+1)%100==0 && $st_counter!=0) || $st_counter+1==$rows_num) 
                    {
                        $content .= ";";
                    }
                    else 
                    {
                        $content .= ",";
                    }
                    $st_counter=$st_counter+1;
                }
            } $content .="\n\n\n";
        }
        $name = "Maxxgain";
        $backup_name = $name ."_".date("Y-m-d-H-i-s").".sql";
         
        $fp = fopen('Database_backup'.'/'. $backup_name ,'w+');
        $result = fwrite($fp, $content);
        if (($result = fwrite($fp, $content))) {
            echo "Backup file created '--$backup_name' ($result)";  
        }
        fclose($fp);
		
		
		
        return $backup_name;
    }
		public function backup_db(){
		
		$this->load->helper('url');	
		$this->load->helper('file');	
		$this->load->helper('download');	
		$this->load->library('zip');	
		$this->load->dbutil();		
		$db_format=array('format'=>'zip','filename'=>'my_db_backup.sql');	
		$backup=& $this->dbutil->backup($db_format);
		$dbname='backup-on-'.date('Y-m-d').'.zip';		
		$save=base_url().'assets/db/'.$dbname;	
		write_file($save,$backup);		
		force_download($dbname,$backup);
		}
	

} //class close

