<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Member_epin extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->helper(array('form', 'url','all_function'));
		$this->load->helper('security');
		$this->load->library('form_validation');
		$this->load->library('session');  
		date_default_timezone_set('Asia/Kolkata'); 
		$this->load->model('Member_epin_mdl'); 
		$this->load->model('Home_model'); 
			if(!$this->session->userdata('mlm_user_logged_in'))
			{
				redirect('home');
			}
	}
	public function epin_request()
	{   
		$data['main_content']      = "front/epin_request"; 

		$member_data = $this->session->userdata('mlm_user_logged_in');
		$member_id   = $member_data['user_id'];
		$todayDate   = $this->Member_epin_mdl->today_date($member_id);		
		$data['my_epin_list']=$this->Member_epin_mdl->get_myepin_list($member_id);
		
		$this->form_validation->set_rules('epin_quantity', 'quantity', 'required');
		$this->form_validation->set_rules('ptype', 'Payment type', 'required');  
		$this->form_validation->set_rules('request_package', 'Package', 'required');  

		if (empty($_FILES['img']['name']))
		{
			$this->form_validation->set_rules('img', 'Payment image', 'required');
		}

		if ($this->form_validation->run() == TRUE)
		{ 
			$folder = "assets/paymentimages/";
			$extention = strrchr($_FILES['img']['name'], ".");
			$size = $_FILES['img']['size']/1024;
			$ex = strtoupper($extention);
			$img='';

			if ($ex==".PNG" || $ex==".JPG" || $ex==".JPEG" || $ex==".GIF") 
			{
				$txn_id=rand();
				$new_name = $txn_id;
				$img = $new_name.$extention;
				$uploaddir = $folder . $img;
				move_uploaded_file($_FILES['img']['tmp_name'], $uploaddir); 

				$insertData = array('request_member_id'    =>$member_id,
									'request_quantity'     =>$this->input->post('epin_quantity'),
									'request_date'         =>$todayDate,
									'request_package'      =>$this->input->post('request_package'),
									'request_ptype'		   => $this->input->post('ptype'), 
									'request_image'		   => $img,
									'request_status'       =>'Pending' 
								); 
				
			   $data = $this->Member_epin_mdl->insert_data('epin_request',$insertData);	

			   $this->session->set_flashdata('messege','E-pin request send successfully'); 
				redirect('member-epin/epin-request'); 
			} 
			else
			{
				$this->session->set_flashdata('messege','E-pin request fail'); 
			} 

		}	

		 $this->load->view('front/includes/template',$data);   

	} 


	public function epin_unseused()
	{
		$member_data = $this->session->userdata('mlm_user_logged_in');
		$member_id   = $member_data['user_id'];
		$data['main_content']      = "front/epin_unseused_list";
		$data['epin_data'] = $this->Member_epin_mdl->get_unused_epin($status='Unused',$member_id); 
		$this->load->view('front/includes/template',$data);
	}

	public function epin_used()
	{
		$member_data = $this->session->userdata('mlm_user_logged_in');
		$member_id   = $member_data['user_id'];
		$data['main_content']      = "front/epin_used_list"; 
 
		
		$data['used_list'] = $this->Member_epin_mdl->get_used_epin($status='Used',$member_id);
	//	print_r($data['used_list']);die();
		
		$this->load->view('front/includes/template',$data);
	}

	public function epin_transfer_list()
	{
		$member_data = $this->session->userdata('mlm_user_logged_in');
		$member_id   = $member_data['user_id'];

		//$data['transaction_pin_transfer'] = $this->Member_epin_mdl->get_transfer_epins($member_id);
		$data['trans_history'] = $this->Member_epin_mdl->get_trans_history($member_id);
		 

		$data['main_content']      = "front/epin_transfer_list"; 
		$this->load->view('front/includes/template',$data);
	}

	public function epin_recieve()
	{
		$member_data = $this->session->userdata('mlm_user_logged_in');
		$member_id   = $member_data['user_id'];
		$data['main_content']      = "front/epin_recieve_list";
		//$data['recieve_epins'] = $this->Member_epin_mdl->get_recieve_epins($member_id);
		$data['receive_history'] = $this->Member_epin_mdl->get_receive_history($member_id);
		 
		$this->load->view('front/includes/template',$data);
	}

	public function epin_send()
	{
		$epin_id     = $this->input->post('epin_id');
		$epin_mobile = $this->input->post('epin_mobile');
		if ($epin_id!='' && $epin_mobile!='') 
		{
			$epin = $this->db->get_where('epin',array('epin_id' =>$epin_id))->row()->epin;
			  
			$msg =''.$this->config->item('config_title').' epin is : '.$epin;
			$this->Home_model->send_sms($epin_mobile,$msg);

			$this->session->set_flashdata('success', 'Epin send successfully..');
			redirect('member-network/epin_unseused'); 
		}
	}

	public function epin_send_member()
	{
		$epin_id     = $this->input->post('epin_id');
		$epin_member = $this->input->post('member_login_id');
		$epin_member_id='';
		if ($epin_id!='' && $epin_member!='') 
		{
			$epin_member_id = getMemberID($epin_member);  
			if($epin_member_id!='')
			{				 
				$epin = $this->db->get_where('epin',array('epin_id' =>$epin_id))->row()->epin_id;
			   
				$this->db->where('member_id',$epin_member_id);
				$this->db->set('member_epin_id',$epin);
				$this->db->update('members');

				$this->session->set_flashdata('success', 'Epin send successfully..');
			}
			else
			{
				$this->session->set_flashdata('error', 'Invalid member login id.');	
			}
			redirect('member-network/epin_unseused'); 
		}
	}

	public function epin_transfer()
	{
		if(!$this->session->userdata('mlm_user_logged_in'))
		{
			redirect('home');
		}
		if(isset($_POST['submit']))
		{
			$epin_qty = escapeStr($this->input->post('epin_qty'));
			$epin_package = escapeStr($this->input->post('epin_package'));
			$member_login_id = escapeStr($this->input->post('member_login_id'));
			 
			//get current user id
			$memberData =$this->session->userdata('mlm_user_logged_in'); 
			$memberId   = $memberData['user_id'];
			//verify member login id
			 
			$details = $this->Home_model->get_members_login_id($member_login_id); 

			if($details)
			{
				if($memberId != $details[0]->member_id) //check current user and login id
				{
					$member_id = getMemberID($member_login_id);
					if($epin_qty!='' && $member_login_id!='')
					{   
						$epin_cnt = $this->Home_model->total_epin($memberId,$epin_package);
						if($epin_cnt >= $epin_qty)
						{
							$epins_to_transfer = $this->Home_model->get_epin_to_transfer($memberId,$epin_qty,$epin_package);
 	
							foreach ($epins_to_transfer as $pins) 
							{
								$arr = array('epin_member_id'=>$member_id, 
											'ein_transfer_date'=>date('Y-m-d H:i:s')
											);

									$this->db->where('epin_member_id',$memberId);
									$this->db->where('epin_status','Unused');
									$this->db->where('epin_id',$pins->epin_id);
									$this->db->update('epin',$arr); 
									
								$save_in_history=	array('transfer_from'=>$memberId,
												'transfer_to'=>$member_id,
												'epin_id'=>$pins->epin_id,   
												'transfer_date'=>date('Y-m-d H:i:s'));
								$in = $this->db->insert('epin_history',$save_in_history);
									
							}
							if($in){ 
								$this->session->set_flashdata('success', 'EPIN Transfered Successfully');
							}else{
								$this->session->set_flashdata('fail', 'This package EPIN not available');
							}
							redirect('member-epin/epin-transfer');
						}
						else
						{
							$this->session->set_flashdata('fail', 'Insufficient EPIN');
							redirect('member-epin/epin-transfer');
						}
					}
					else
					{
						//$data['err_msg'] = "All Fields Required";
						$this->session->set_flashdata('fail', 'All Fields are mandatory');
						redirect('member-epin/epin-transfer');
					}	
				}
				else
				{
					$this->session->set_flashdata('fail', 'You Can not Transfer EPINs to Self');
					redirect('member-epin/epin-transfer');
				}
			}
			else
			{
				$this->session->set_flashdata('fail', 'Invalid Member Login Id');
				redirect('member-epin/epin-transfer');
			}
			  
		}

		$data['main_content']      = "front/epin_transfer";  
		$this->load->view('front/includes/template',$data);
	} 

	public function verify_login_id()
 	{
 		$id = $this->input->post('id');
 		$epin_qty = $this->input->post('epin_qty'); 
 		$epin_package = $this->input->post('epin_package'); 
 	 
		$details = $this->Home_model->get_members_login_id($id); 

		if($details)
 		{ 		 
 			$memberData =$this->session->userdata('mlm_user_logged_in'); 
			$memberId   = $memberData['user_id']; 

			if($memberId != $details[0]->member_id)
			{
				$epin_cnt = $this->Home_model->total_epin($memberId,$epin_package);

				//echo $epin_cnt->total_epin; die;
				if($epin_cnt->total_epin >= $epin_qty)
				{
					echo "<div class='col-md-6'>
							<div class='control-group'>
								<label class='control-label' for='Address'>Name : ".$details[0]->member_name."</label>
							</div>
						</div>
						<div class='clearfix'> </div>
			        	<div class='col-md-6'>
							<button type='submit' name='submit' class='btn btn-primary'>Transfer EPIN</button>
						</div>";
		        }
		        else
		        {
		        	echo "<i style='color:red'>You have no E-PIN</i>";
		        }
		    }
		    else
		    {
		    	echo "You Can not Transfer EPIN's to Self";
		    }
 		}
 		else
 		{
 			echo "Invalid Member Login Id";
 		} 
 		 
 	}
 	
 public function epin_genrate()
	{   
		$data['main_content']      = "front/epin_genrate"; 

		$member_data = $this->session->userdata('mlm_user_logged_in');
		$member_id   = $member_data['user_id'];

		/*ROI income*/
		$totalRoi_generated = $this->Home_model->get_total_generated_roi();
		$totalROI_paid 		= $this->Home_model->get_total_withdrawal_roi(); 
		/*level income*/
		$totalLevel_income = $this->Home_model->get_total_generated_binary();
		$totalLevel_paid   = $this->Home_model->get_total_withdrawal_binary();
		/*EPIN Amount*/ 
		$totalEpin_amount  = $this->Home_model->get_total_totalEpin_amount();
		/*Transfered Amount*/ 
		$totaltransfered_amt  = $this->Home_model->get_total_transfered_amount();

		$totRoi = 0; $totRoiPiad = 0; 
		$totLevel = 0; $totLevelPaid = 0; 
		$total_income = 0; $total_paid= 0; $total_balence = 0;

		if ($totalRoi_generated) 
		{
			$totRoi = $totalRoi_generated->total_roi; 
		}
		if ($totalROI_paid) 
		{
			$totRoiPiad = $totalROI_paid->totalWithdraw; 
		}
		if ($totalLevel_income) 
		{
			$totLevel = $totalLevel_income->total_binary; 
		}
		if ($totalLevel_paid) 
		{
			$totLevelPaid = $totalLevel_paid->totalWithdrawBinary; 
		} 

		$total_income  = $totRoi+$totLevel; 
		$total_pending = getTotalPendingWithdrawal($member_id);
		$total_paid    = $totRoiPiad+$totLevelPaid+$totalEpin_amount+$total_pending+$totaltransfered_amt; 
		$total_balence = $total_income-$total_paid;
 
		$data['total_income'] 	 = $total_income;
		$data['total_paid'] 	 = $total_paid;
		$data['total_balence'] 	 = $total_balence;
 	
		$data['my_epin_list']=$this->Member_epin_mdl->get_myepin_list($member_id);
	
		if($this->input->post('submit')=='submit')
		{	
			$this->form_validation->set_rules('epin_quantity', 'Quantity', 'required');
			$this->form_validation->set_rules('available_balance', 'Available Balance', 'required');  
			$this->form_validation->set_rules('request_package', 'Package', 'required');  
			$this->form_validation->set_rules('total_epin_amount', 'Epin Amount', 'required');  
	 
			if ($this->form_validation->run() == TRUE)
			{   	 
				  $gst_charge = $this->input->post('gst_amount'); 
				  $total_epin_amount = $this->input->post('total_epin_amount'); 

					$req = array('withdrawal_request_type'=>'EPIN',
								 'member_id'=>$member_id,
								 'withdrawal_request_amount'=>$total_income,
								 'withdrawal_admin_charges'=>0,
								 'withdrawal_tds_charges'=>0,
								 'withdrawal_gst_charges'=>$gst_charge,
								 'withdrawal_net_amount'=>$total_epin_amount,
								 'withdrawal_payment_type'=>'EPIN',
								 'withdrawal_name_slip'=>'EPIN',
								 'withdrawal_status'=>'paid',
								 'withdrawal_paid_date'=>date('Y-m-d H:i:s'),
								 'withdrawal_request_date'=>date('Y-m-d H:i:s')
								);

					$in = $this->db->insert('isp_roi_withdrawal_request',$req);

					if ($in) 
					{
						$qty 				= $this->input->post('epin_quantity');
						$epin_package 		= $this->input->post('request_package');
						$request_member_id  = $member_id; 
						$package_data 		= getPackages($epin_package);
						$package_prefix	    = $package_data[0]->package_prefix;


						if($qty!='' && $request_member_id!='')
						{ 						
							for($i=0;$i<$qty;$i++)
							{
								$digit = date('i').date('s');
								$Last_char = $this->generateRandomString(); 
								$epin= $package_prefix.$digit.$Last_char;  
								
								$epinData = array('epin_member_id' =>$request_member_id,
								 			  'epin_package_id'=>$epin_package,
								 			  'epin'		   =>$epin,
								 			  'epin_added_date'=>date('Y-m-d H:i:s'),
								 			  'epin_status'    =>'Unused', 
								 			);
								$insert = $this->db->insert('epin',$epinData);
								$result = $i;
							} 
						}
					}
					unset($_POST);	 
				   $this->session->set_flashdata('success','E-pin genrate successfully'); 
				   redirect('member-epin/epin-genrate');
			}
			else
			{
				$this->session->set_flashdata('error','E-pin genrate fail'); 
			} 
		}	

		 $this->load->view('front/includes/template',$data);   

	} 

	 
	function generateRandomString($length = 2) 
	{
	    $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
	    $charactersLength = strlen($characters);
	    $randomString = '';
	    for ($i = 0; $i < $length; $i++) {
	        $randomString .= $characters[rand(0, $charactersLength - 1)];
	    }
	    return $randomString;
	}

	public function getPackages_amount()
	{
		$pack = $this->input->post('package');
		if ($pack)
		{
			$pdata = getPackages($pack);
			if ($pdata) 
			{
				 echo $pdata[0]->package_amount;
			}
			else
			{
				echo 0;
			}
		}
	}

	public function found_transfer()
	{   
		$data['main_content']      = "front/found_transfer"; 

		$member_data = $this->session->userdata('mlm_user_logged_in');
		$member_id   = $member_data['user_id'];

		/*ROI income*/
		$totalRoi_generated = $this->Home_model->get_total_generated_roi();
		$totalROI_paid 		= $this->Home_model->get_total_withdrawal_roi(); 
		/*level income*/
		$totalLevel_income = $this->Home_model->get_total_generated_binary();
		$totalLevel_paid   = $this->Home_model->get_total_withdrawal_binary();
		/*EPIN Amount*/ 
		$totalEpin_amount  = $this->Home_model->get_total_totalEpin_amount();
		/*Transfered Amount*/ 
		$totaltransfered_amt  = $this->Home_model->get_total_transfered_amount();

		$totRoi = 0; $totRoiPiad = 0; 
		$totLevel = 0; $totLevelPaid = 0; 
		$total_income = 0; $total_paid= 0; $total_balence = 0;

		if ($totalRoi_generated) 
		{
			$totRoi = $totalRoi_generated->total_roi; 
		}
		if ($totalROI_paid) 
		{
			$totRoiPiad = $totalROI_paid->totalWithdraw; 
		}
		if ($totalLevel_income) 
		{
			$totLevel = $totalLevel_income->total_binary; 
		}
		if ($totalLevel_paid) 
		{
			$totLevelPaid = $totalLevel_paid->totalWithdrawBinary; 
		} 

		$total_income  = $totRoi+$totLevel; 
		$total_pending = getTotalPendingWithdrawal($member_id);
		$total_paid    = $totRoiPiad+$totLevelPaid+$totalEpin_amount+$total_pending+$totaltransfered_amt; 
		$total_balence = $total_income-$total_paid;
 
		$data['total_income'] 	 = $total_income;
		$data['total_paid'] 	 = $total_paid;
		$data['total_balence'] 	 = $total_balence; 
	
		if($this->input->post('submit')=='submit')
		{	 
			$this->form_validation->set_rules('available_balance', 'Available Balance', 'required');  
			$this->form_validation->set_rules('member_id', 'member_id', 'required');  
			$this->form_validation->set_rules('transfer_total_amount', 'Epin Amount', 'required');  
	 
			if ($this->form_validation->run() == TRUE)
			{   	
				$transfer_to = $this->input->post('member_id'); 
				$traf_data   = $this->Home_model->get_member_id($transfer_to);
				if($traf_data!='')
				{ 
				  $transfer_to_member = $traf_data->member_id;	
				  $tra = $traf_data->member_name.' ('.$transfer_to.')';
				  $tax_amount = $this->input->post('tax_amount'); 
				  $total_tran_amount = $this->input->post('transfer_total_amount'); 
				  $transfer_amount = $this->input->post('transfer_amount'); 

					$req = array('withdrawal_request_type'=>'Transfer',
								 'member_id'=>$member_id,
								 'withdrawal_request_amount'=>$total_income,
								 'withdrawal_admin_charges'=>0,
								 'withdrawal_tds_charges'=>0,
								 'withdrawal_gst_charges'=>$tax_amount,
								 'withdrawal_net_amount'=>$total_tran_amount,
								 'withdrawal_payment_type'=>'Transfer',
								 'withdrawal_name_slip'=>$tra,
								 'withdrawal_status'=>'paid',
								 'withdrawal_paid_date'=>date('Y-m-d H:i:s'),
								 'withdrawal_request_date'=>date('Y-m-d H:i:s')
								);

					$in = $this->db->insert('isp_roi_withdrawal_request',$req);
					
					if ($in) 
					{ 
						$levelIncome = array('income_member_id' =>$transfer_to_member,
											 'income_member_by' =>$member_id,
											 'income_level' 	=>0,
											 'income_package_id'=>0,
											 'income_percentage'=>0,
											 'income_amount'    =>round($transfer_amount),
											 'income_date'      =>date('Y-m-d'),
											 'income_type'      =>'Transfered'
											); 
  
						$this->db->insert('level_income',$levelIncome);

						$history = array('transfer_to' 		=>$transfer_to_member,
										 'transfer_by' 		=>$member_id, 
										 'transfer_charges' =>round($tax_amount),
										 'transfer_amount'  =>round($transfer_amount),
										 'transfer_date'    =>date('Y-m-d') 
										); 
  
						$this->db->insert('found_transfer_history',$history);   
					}  

				   unset($_POST);	 
				   $this->session->set_flashdata('success','Found Transfered successfully'); 
				   redirect('member_epin/found_transfer');
				}
				else
				{
					$this->session->set_flashdata('error','Invalid Member Id'); 
				}    
			}
			else
			{
				$this->session->set_flashdata('error','Found Transfer fail'); 
			} 
		}	

		 $this->load->view('front/includes/template',$data);   

	} 

	public function topup_by_pin()
	{   
		$data['main_content']      = "front/topup-by-pin"; 

		$member_data = $this->session->userdata('mlm_user_logged_in');
		$member_id   = $member_data['user_id'];
		
		$this->form_validation->set_rules('type', 'type', 'required');
		$this->form_validation->set_rules('member_id', 'Member id', 'required');  
		$this->form_validation->set_rules('epin', 'E-pin', 'required');  
 
		if ($this->form_validation->run() == TRUE)
		{ 
			$roi_days = $this->config->item('config_daily_roi_days');

			$todayDate = date('Y-m-d');
			$toDate = date('Y-m-d', strtotime($todayDate. ' + '.$roi_days.' days'));

			$type = escapeStr($this->input->post('type'));
			if ($type=='BYEPIN')  //Account active by Epin
			{
				$login_id = escapeStr($this->input->post('member_id'));
				$memberData = getMemberData($login_id);

				$epin = escapeStr($this->input->post('epin'));
				$epinData = checkEpin($epin);

				if ($epinData) 
				{
					$sponsorMember = $memberData->member_sponsored;
					$member_id = $memberData->member_id;

					$package_id = $epinData->package_id;
					$amount = $epinData->package_amount;

					$this->db->where('member_id',$member_id);
			 		$this->db->set('is_paid','Yes');  
			 		$this->db->set('member_status','Approve');  
			 		$this->db->set('member_package_id',$package_id); 
			 		$this->db->set('member_current_package',$package_id); 
			 		$this->db->set('member_active_date',$todayDate);
			 		$this->db->set('member_expired_date',$toDate);
			 		$this->db->set('member_epin_id',$epinData->epin_id);
			 		$this->db->update('members');

					$epin_params=array('epin_status'=>'Used','epin_used_date'=>date('Y-m-d'));
					$this->db->where('epin_id',$epinData->epin_id);
					$this->db->update('epin',$epin_params);

					$this->Home_model->add_sponsor_income($sponsorMember,$member_id,$amount);

				   unset($_POST);	 
				   $this->session->set_flashdata('success','Account active successfully'); 
				   redirect('home/dashboard');
				}
				else
				{
					$this->session->set_flashdata('error','Invalid E-pin'); 
				}
			}
		}	
		else
		{
			$this->session->set_flashdata('error','Invalid E-pin'); 
		}

		 $this->load->view('front/includes/template',$data);   

	}

	public function verifyloginID()
	{  
		$login_id = $this->input->post('id');
		$this->db->select('*');
		$this->db->from('members'); 
		$this->db->where('member_login_id',$login_id);
		$this->db->where('member_status','Pending');
		$q= $this->db->get();
 		$check = $q->row();

		if($check!='')
		{
			echo $check->member_name;
		}
		else
		{
			echo 0;
		}
	}

	public function verify_epin()
	{  
		$epin = $this->input->post('epin');
		$this->db->select('*');
		$this->db->from('epin');
		$this->db->join('pckages','pckages.package_id=epin.epin_package_id');
		$this->db->where('epin.epin',$epin);
		$this->db->where('epin.epin_status','Unused');
		$this->db->where('epin.epin_type','Registration');
		$q= $this->db->get();
 		$check_epin = $q->row();

		if($check_epin!='')
		{
			echo $check_epin->package_amount;
		}
		else
		{
			echo 0;
		}
	}

	public function account_active()
	{

	}

} //class closed