<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Member_network extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->helper(array('form', 'url','all_function'));
		$this->load->helper('security');
		$this->load->library('form_validation');
		$this->load->library('session');  
		$this->load->model('Member_network_mdl');
		$this->load->model('Home_model');
		date_default_timezone_set('Asia/Kolkata');  
		if(!$this->session->userdata('mlm_user_logged_in'))
		{
			redirect('home');
		}
	}
	 
	public function my_directs()
	{		 
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id = $user_data['user_id'];
		$data['direct_network'] = $this->Member_network_mdl->get_direct_member_list($member_id);
		
		$data['main_content']      = "front/my_directs"; 
		$this->load->view('front/includes/template',$data);
	}

	public function my_network()
	{		 
		$level=$this->uri->segment('3');
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id = $user_data['user_id'];
		$data['direct_network'] = $this->Member_network_mdl->get_direct_member_list($member_id);
		
		$data['main_content']      = "front/my_directs"; 
		$this->load->view('front/includes/template',$data);
	}

  
	public function success()
	{ 
		
		$data['main_content']      = "front/reg_success_2"; 
		$this->load->view('front/includes/template',$data); 
	}
	

// 	public function network_list()
// 	{
	   
// 	    $user_data = $this->session->userdata('mlm_user_logged_in');
// 	   // print_r($user_data);die;
// 		$member_id = $user_data['user_id'];
// 	    if($this->input->post("btn_submit"))
// 		{
// 			$level_no=$this->input->post("level_no");
// 			if($level_no!='All')
//     		{
// 			    $details=$this->Member_network_mdl->get_level_member_list($member_id,$level_no);
//     		    $data['network_list']= $details;
//     		    $data['level']=$level_no;
//     			$names = getSponsor($member_id); 
// 			}
// 			else
// 			{
// 			    $details=$this->Member_network_mdl->get_all_level_member($member_id);
//     		    $data['network_list']= $details;
//     		    $data['level']='All';
// 			    $names = getSponsor($member_id); 
// 			}
// 	    }
// 	    else
// 		{
//             $data['network_list']= $details=$this->Member_network_mdl->get_all_level_member($member_id);
//     		$data['level']='All';
//     // 		echo $this->db->last_query();die;
// 		}
// // 		print_r($data);die;
// 	    $data['upline'] = getUplineId($member_id);
// 	    $data['con_levels']= $this->config->item('config_levels');
// 	    $data['type_levels']= $this->config->item('level_type');
// 	    $user_details=$this->db->get_where('isp_members',array('member_id'=>$user_data['user_id']))->row();	
       
	
// 		$data['main_content']      = "front/my_network_list"; 
// 		$this->load->view('front/includes/template',$data);
// 	}

    public function network_list()
	{
		
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id = $user_data['user_id'];
		if($this->input->post("btn_submit"))
		{
			$level_no=$this->input->post("level_no");
			
			$details=$this->Member_network_mdl->get_level_member_list($member_id,$level_no);
		
		    $data['network_list']= $details;
		    $data['level']=$level_no;
			$names = getSponsor($member_id); 
		}
		else
		{
			$data['level']=1;
			$details=$this->Member_network_mdl->get_level_member_list($member_id,1);
		    $data['network_list']= $details;
		}

  	    $data['con_levels']= $this->config->item('config_levels');
	    $data['type_levels']= $this->config->item('level_type');

		$data['upline'] = getUplineId($member_id);
		
		$data['main_content']      = "front/my_network_list"; 
		$this->load->view('front/includes/template',$data);
	}


public function binary_list()
{     
      $user_data = $this->session->userdata('mlm_user_logged_in');
      $member_id = $user_data['user_id'];
     // $data['data']=$this->Member_network_mdl->binary_data();
     $data['network_list'] = $this->Member_network_mdl->binary_data($member_id);
      
      $result['data']=$this->Member_network_mdl->binary_data();
     // $this->load->view('binary-team',$result);
      $data['main_content'] = "front/binary-team"; 
	  $this->load->view('front/includes/template',$data);
	  
  
  
}


	public function directs_list()
	{
	    $user_data = $this->session->userdata('mlm_user_logged_in');
	  
	
			$member_id = $user_data['user_id'];
			
			$details=$this->db->get_where('isp_members',array('member_id'=>$member_id))->row();
		
		    $data['my_details']= $details;
		   
			$names = getSponsor($member_id); 
	
		$data['upline'] = getUplineId($member_id);
	
		$data['network_list'] = $this->Member_network_mdl->get_direct_member_list($member_id);
		
		$user_details=$this->db->get_where('isp_members',array('member_id'=>$user_data['user_id']))->row();	
       
// 		if($user_data['user_is_paid']=='No' && $user_details->member_is_verify=='No')
// 		{
		     
// 		    $this->session->set_flashdata('fail', 'You need to select package first.');
// 		    redirect('home/dashboard'); 
// 		}
        
		$data['main_content']      = "front/direct-team"; 
		$this->load->view('front/includes/template',$data);
	}
	 
	public function member_tree()
 	{
 	     
 		$data['page_title']   = "Binary tree";
	    if($this->uri->segment('3'))
		{
			$member_id = $this->uri->segment('3'); 

			$trees  = $this->Member_network_mdl->getmemberTree($member_id);
			 
			if ($trees) 
			{		
				$data['memberPosi_1'] =''; $data['memberPosi_2'] =''; 

				foreach ($trees as $key) 
				{
				    $myposi = getMyPosition($key->member_id,$member_id);
				    
				    if ($myposi=='member_position_left'){
				    	$data['memberPosi_1'] = $key;
				    }elseif ($myposi=='member_position_right'){
				    	$data['memberPosi_2'] = $key;
				    }else {}
				} 
			} 

		}
		else
		{
			$user_data = $this->session->userdata('mlm_user_logged_in');
			$member_id = $user_data['user_id']; 

			$trees  = $this->Member_network_mdl->getmemberTree($member_id);
// 			echo $this->db->last_query();die;
 			//  print_r($trees);die;
			if ($trees) 
			{	
			 //   echo "dfghkdf";die;
				$data['memberPosi_1'] =''; $data['memberPosi_2'] =''; 

				foreach ($trees as $key) 
				{
				    $myposi = getMyPosition($key->member_id,$member_id);
				
				    if ($myposi=='member_position_left'){
				    	 
				    	$data['memberPosi_1'] = $key;
				    	
				    }elseif ($myposi=='member_position_right'){
				    	$data['memberPosi_2'] = $key;
				    	 
				    }else {}

				} 
			} 

		}
// 		print_r($data);die;
		//$data['memberTree'] = $this->Member_network_mdl->getTree();
 		$data['main_content'] = "front/my_tree";  
		$this->load->view('front/includes/template',$data); 
	}
	

	
	public function epin_unseused()
	{ 
		if(!$this->session->userdata('mlm_user_logged_in'))
		{
			redirect('home');
		}

		$center = $this->session->userdata('mlm_user_logged_in');

		$data['main_content']      = "front/epin_unseused_list";
		$data['epin_data'] =  $this->db->get_where('epin',array('epin_member_id' =>$center['user_id'],'epin_status'=>'Unused'))->result();   
		$this->load->view('front/includes/template',$data);
	}

	public function epin_used()
	{ 
		if(!$this->session->userdata('mlm_user_logged_in'))
		{
			redirect('home');
		}

		$center = $this->session->userdata('mlm_user_logged_in');

		$data['main_content']      = "front/epin_used_list";
		$data['epin_data'] =  $this->db->get_where('epin',array('epin_member_id' =>$center['user_id'],'epin_status'=>'Used'))->result();   
		 
		$this->load->view('front/includes/template',$data);
	}
    
    
    public function downline_list()
	{
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$memberID = $user_data['user_id'];
		 
		if (isset($_POST['search']))
 		{ 
 			$level = $this->input->post('sr_level');
 			$data['sr_level'] = $this->input->post('sr_level'); 
 			$data['downlines'] = $this->Home_model->getLevelsMember($memberID,$level); //get income
 		} 
 		else
 		{
 			$data['sr_level'] = 1;
			$data['downlines'] = $this->Home_model->getLevelsMember($memberID,$level=1); //get income
		}

		$data['main_content']  = "front/my_downline_level"; 
		$this->load->view('front/includes/template',$data);
	}


} //class closed..