<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Member_reports extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->helper(array('form', 'url','all_function'));
		$this->load->helper('security');
		$this->load->library('form_validation');
		$this->load->library('session');  
		date_default_timezone_set('Asia/Kolkata');  
		$this->load->model('Member_epin_mdl');
		
		$this->load->model('Member_network_mdl');
		$this->load->model('Home_model');
		$this->load->model('Payments_model'); 
			if(!$this->session->userdata('mlm_user_logged_in'))
			{
				redirect('home');
			}
	}
	 
	public function member_summary()
	{		 
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];
		$this->db->order_by("re_entry_id", "DESC");
		$data['all_level']=$this->db->get_where('isp_re_entry',array('member_id'=>$member_id))->result();	
		$data['main_content']      = "front/member_summary"; 
		$this->load->view('front/includes/template',$data);
	}
  
	public function received_payment()
	{		 
		

		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id']; 
		
		$res = $this->db->get_where('members',array('member_id'=>$member_id))->row();
	 	  
		if ($res->member_type=="admin_member") {
			$data['payment'] = $this->db->get_where('donations',array('donate_to'=>$member_id,'donate_status'=>'paid'))->result();
			$data['main_content']      = "front/received_payment_admin";
		}else{ 			 
			 
			$data['main_content']      = "front/received_payment";
			$data['requestData'] = $this->Home_model->get_roi_requested_data();
		}
		 
		$this->load->view('front/includes/template',$data);	
	}
	
    public function award_rewards()
	{		 
		$data['main_content']      = "front/award_rewards_income";
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];	 
 		 			  
		$data['income']= getMemberAward_rewards($member_id);
		  
		$this->load->view('front/includes/template',$data);	
	}


	   
	public function error_handle()
	{	 
		$data['main_content']      = "front/404_error"; 
		$this->load->view('front/includes/template',$data);
	}
	

	public function ticket_support()
	{	 
		$data['main_content']      = "front/ticket-support"; 

		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id = $user_data['user_id'];

		if(isset($_POST['ticket-btn']))
		{	 
		  //  echo "dfgsdjfgsdfgh";die;
			$this->form_validation->set_rules('subject', 'subject', 'required');  
			$this->form_validation->set_rules('description', 'description', 'required');  
			
			if (empty($_FILES['ticket-image']['name']))
			{
			//	$this->form_validation->set_rules('ticket-image', 'Ticket image', 'required');
			} 	

			if ($this->form_validation->run() == TRUE)
			{ 
				$fileName ='';
				if(!empty($_FILES['ticket-image']['name']))
				{	
					$new_name						=  $new_name = time() . '-' .substr($_FILES["ticket-image"]['name'], 0, 5); 
					$config['upload_path']          = './assets/front/ticket_img/';
	                $config['allowed_types']        = 'gif|jpg|png';
	                $config['max_size']             = 1000;
	                $config['file_name'] 			= $new_name; 
	                $this->load->library('upload', $config);

	                if ($this->upload->do_upload('ticket-image'))
	                {
	                   $fdata = array('upload_data' => $this->upload->data());
	                   $fileName = $fdata['upload_data']['file_name'];	                    
	                } 
				}

				$ar = array('ticket_subject' =>escapeStr($this->input->post('subject')),
							'ticket_description'=>escapeStr($this->input->post('description')),
							'ticket_member_id'=>$member_id,
							'ticket_image'=>$fileName,
							'ticket_status'=>'Pending',
							'ticket_date'=>date('Y-m-d H:i:s')
							);
				$this->db->insert('isp_ticket_support',$ar);
				
				$this->session->set_flashdata('success', 'Ticket send successful.');
				redirect('member-report/ticket-support');				 
			}			 
		} 

		$data['ticket_data'] = $this->db->order_by('ticket_id','DESC')->get_where('isp_ticket_support',array('ticket_member_id'=>$member_id))->result();

		$this->load->view('front/includes/template',$data);
	}
	
	public function direct_income()
	{		 
		$data['main_content']      = "front/sponser-income";
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];	 
 
		$data['sponsor_income']=$this->db->get_where('sponser_income',array('income_to'=>$member_id))->result();	 
// 		 print_r($data['sponsor_income']);die;
		$this->load->view('front/includes/template',$data);	
	}

	public function binary_income()
	{		 
		$data['main_content']      = "front/binary-team";
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];	 
 
		$data['network_list']=$this->db->get_where('binary_income',array('binary_member_id'=>$member_id))->result();	 
		 
		$this->load->view('front/includes/template',$data);	
	}

	public function daily_income()
	{		 
	   // $monthdetail=getmonth();
	   //  echo $monthdetail->MONTH;die;
		$data['main_content']      = "front/roi_income";
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];	 
 
		$data['income']=$this->db->order_by('date','DESC')->get_where('roi_wallet',array('member_id'=>$member_id))->result();
// 		echo $this->db->last_query() ;die;
		$user_details=$this->db->get_where('members',array('member_id'=>$user_data['user_id']))->row();	
// 		 if($user_data['user_is_paid']=='No' && $user_details->member_is_verify=='No')
// 		{
// 		    $this->session->set_flashdata('fail', 'You need to select package first.');
// 		    redirect('home/dashboard'); 
// 		}
		$this->load->view('front/includes/template',$data);	
	}
public function daimond_income()
	{		 
		$data['main_content']      = "front/daimond_income";
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];	 
 
		$data['income']=$this->db->order_by('added_date','DESC')->get_where('diamond_bonus',array('member_id'=>$member_id))->result();

		$user_details=$this->db->get_where('members',array('member_id'=>$user_data['user_id']))->row();	

		$this->load->view('front/includes/template',$data);	
	}
	public function leadership_income()
	{		 
		$data['main_content']      = "front/leadership_income";
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];	 
 
		$data['income']=$this->db->order_by('added_date','DESC')->get_where('leadership_bonus',array('bonus_member_to'=>$member_id))->result();
		$user_details=$this->db->get_where('members',array('member_id'=>$user_data['user_id']))->row();	

		$this->load->view('front/includes/template',$data);	
	}
	public function reference_income()
	{		 
		$data['main_content']      = "front/level_income";
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];	 
 		if($this->input->post("btn_submit"))
		{
			$level_no=$this->input->post("level_no");
			if($level_no!='All')
			{
				$data['income']=$this->db->order_by('income_id','DESC')->get_where('level_income',array('income_member_id'=>$member_id,'income_level'=>$level_no))->result();	
				$data['level']=$level_no;
			}
			else
			{
				$data['income']=$this->db->order_by('income_id','DESC')->get_where('level_income',array('income_member_id'=>$member_id))->result();	
					$data['level']='All';
			}
			
		}

		else
		{
			$data['income']=$this->db->order_by('income_id','DESC')->get_where('level_income',array('income_member_id'=>$member_id))->result();	
			$data['level']='All';
		}	
// 		  if($user_data['user_is_paid']=='No')
// 		{
// 		    $this->session->set_flashdata('fail', 'You need to select package first.');
// 		    redirect('home/dashboard'); 
// 		}
		$this->load->view('front/includes/template',$data);	
	}

	public function sponsor_income()
	{		 
		$data['main_content']      = "front/sponsor_income";
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];	 
 
		$data['income']=$this->db->order_by('income_id','DESC')->get_where('level_income',array('income_member_id'=>$member_id,'income_level'=>'1'))->result();	 
		 
		$this->load->view('front/includes/template',$data);	
	}

	public function topup_income()
	{		 
		$data['main_content']      = "front/topup_income";
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];	 
 	
 		$income1= array();	
 		$income2= array();	
 		
		$income1=$this->db->order_by('income_id','DESC')->get_where('topup_income',array('income_member_id'=>$member_id))->result();

		$income2=$this->db->order_by('income_id','DESC')->get_where('topup_upgrade_income',array('income_member_id'=>$member_id))->result();	 

		$data['income']= array_merge($income1,$income2);	 
		 
		$this->load->view('front/includes/template',$data);	
	}

	public function withdrawal_list()
	{		 
		$data['main_content']      = "front/roi_withdrawal_list";
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];	 
		$data['pendingRequest'] = $this->Home_model->get_roi_requested_data();       
		// dd($data['pendingRequest']);
		$this->load->view('front/includes/template',$data);	
	}
	public function award_list()
	{		 
		$data['main_content']      = "front/award-list";
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];	 
 		$data['pendingRequest'] = $this->Home_model->get_award_requested_data();       
		// dd($data['pendingRequest']);
		$this->load->view('front/includes/template',$data);	
	}
	public function global_pool()
	{		 
	  
		$data['main_content']      = "front/global-pool";
		$user_data = $this->session->userdata('mlm_user_logged_in');
	    $data['member_id']=	$member_id=$user_data['user_id'];	 
	    $downlineMemberId 	= [];
	    $direct_downlines 	= get_direct_downline($member_id, 1);
	    $totalTeamInvestmentAmount = 0;
	    if($direct_downlines){

			foreach($direct_downlines as $direct_downline){
				
				$downlineMemberId = getAllDownlineID($direct_downline, $downlineMemberId, $count = 0);
				
			}
    				
            if($downlineMemberId)
            {
            	    $month_ini = new DateTime("first day of last month");
            		$month_end = new DateTime("last day of last month");
            //      	$last_month_start_date 	= $month_ini->format('Y-m-d'); // 2012-02-01
            //  		$last_month_end_date 	= $month_end->format('Y-m-d'); // 2012-02-29
            				
            		$last_month_start_date 	= date('Y-m-01'); // hard-coded '01' for first day
            		$last_month_end_date  	= date('Y-m-t');
            
            				//current_month_deposit
            		$totalTeamInvestmentAmount 	= getMemberPackageAmtSumBetweenDates($downlineMemberId,$last_month_start_date,$last_month_end_date);
            }
	    }   
	    
	    	
	    $data['user_details']=	$user_details=$this->db->get_where('members',array('member_id'=>$user_data['user_id']))->row();	
		$data['income']=$this->db->order_by('added_date','DESC')->get_where('global_income',array('member_id'=>$member_id))->result();
	    $data['inactive']=$this->Member_network_mdl->get_all_level_member_count($member_id);
        $data['details']=$this->Member_network_mdl->get_level_member_count($member_id,1);
        
		$data['details_amount'] = $totalTeamInvestmentAmount;

		$this->load->view('front/includes/template',$data);	
	}
	public function global_pool_report()
	{		 
	  
		$data['main_content']      = "front/global-pool-report";
		$user_data = $this->session->userdata('mlm_user_logged_in');
	    $data['member_id']=	$member_id=$user_data['user_id'];	 
	    $data['user_details']=	$user_details=$this->db->get_where('members',array('member_id'=>$user_data['user_id']))->row();	
		$data['income']=$this->db->order_by('added_date','DESC')->get_where('global_income',array('member_id'=>$member_id))->result();
	    $data['inactive']=$this->Member_network_mdl->get_all_level_member_count($member_id);
		$data['details']=$this->Member_network_mdl->get_level_member_count($member_id,1);
		$data['details_amount']=$this->Member_network_mdl->get_level_member_amount($member_id,1);

		$this->load->view('front/includes/template',$data);	
	}

	public function withdrawal_request()
	{

		if(!$this->session->userdata('mlm_user_logged_in'))
		{
			redirect('home');
		}
		
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$data['member_id']=	$member_id=$user_data['user_id'];

		$totalIncome 			= getTotalIncome($member_id); //get Available Balance
		$totalWithdraw 			= getTotalWithdrawal1($member_id);
		$pending_withdrawal 	= getTotalPendingWithdrawal1($member_id);
	    $totalbalence 			= $totalIncome - $totalWithdraw -$pending_withdrawal;
		$data['totalIncome'] 	= $totalIncome;
		$data['totalbalence'] 	= $totalbalence;
        $data['main_content']      = "front/roi_withdrawal"; 
		$this->load->view('front/includes/template',$data); 
	}
	 public function activate_account()
	{
	   
		if(!$this->session->userdata('mlm_user_logged_in'))
		{
			redirect('home');
		}
		
		$user_data = $this->session->userdata('mlm_user_logged_in');
	    $data['member_id']=	$member_id=$user_data['user_id'];
	
//  	print_r($_POST);die;

        if($this->input->method() == 'post')
		{	 
	        $this->form_validation->set_rules('epin','Epin','required|trim');
			if($this->form_validation->run()=='TRUE')
			{
        		
            	    $data['member_id']    =  $member_id;
            		$epin=$this->input->post('epin');
			        $check_epin=$this->db->get_where('isp_epin',array('epin'=>$this->input->post('epin'),'epin_status'=>'Unused'))->row();
			     //   print_r($check_epin);die;
			        $member_epin = $check_epin->epin_id;
					$member_epin_type = $check_epin->epin_type;

    				$this->db->where('epin_id',$member_epin); 
			 		$this->db->set('epin_status','Used'); 
			 		$this->db->update('epin'); 
				
				    $this->db->where('member_id',$member_id); 
			 		$this->db->set('member_epin_id',$member_epin); 
			 		$this->db->update('members'); 
				
				    $this->session->set_flashdata('pass_message', 'Account Activated Successfully.');
        			echo 1;
            }
    	    else
		    { 
        		$data['pass_eror'] = validation_errors();
        		$this->session->set_flashdata('pass_eror',$data['pass_eror']); 
        	}
	   }
    }
	public function activate_epin()
	{

		if(!$this->session->userdata('mlm_user_logged_in'))
		{
			redirect('home');
		}
		
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$data['member_id']=	$member_id=$user_data['user_id'];

		$totalIncome 			= getTotalIncome($member_id); //get Available Balance
		$totalWithdraw 			= getTotalWithdrawal1($member_id);
		$pending_withdrawal 	= getTotalPendingWithdrawal1($member_id);
	    $totalbalence 			= $totalIncome - $totalWithdraw -$pending_withdrawal;
		$data['totalIncome'] 	= $totalIncome;
		$data['totalbalence'] 	= $totalbalence;
        $data['main_content']      = "front/active_epin"; 
		$this->load->view('front/includes/template',$data); 
	}
	
 public function submit_withdraw_req()
	{
	   
		if(!$this->session->userdata('mlm_user_logged_in'))
		{
			redirect('home');
		}
		
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$data['member_id']=	$member_id=$user_data['user_id'];
		$sponserID=getSponsorid($member_id);

		$data['totalIncome']=$totalIncome 			= getTotalIncome($member_id); //get Available Balance
		$totalWithdraw 			= getTotalWithdrawal1($member_id);
		$pending_withdrawal 	= getTotalPendingWithdrawal1($member_id);
	    $data['totalbalence'] 	=$totalbalence 			= $totalIncome - $totalWithdraw -$pending_withdrawal;
	    $wallet_details = getwalletDetails($member_id);
		if($wallet_details!="")
		{
		    if($wallet_details->member_payment_option=="btc_address"){ $data['address']=$address=$wallet_details->member_btc_address; }
		    if($wallet_details->member_payment_option=="usdt_address"){ $data['address']=$address=$wallet_details->member_usdt_address; }
		    if($wallet_details->member_payment_option=="eth_address"){ $data['address']=$address=$wallet_details->member_eth_address;  }
	
		}

        if($this->input->method() == 'post')
		{	 
	        $this->form_validation->set_rules('usdt_withdrawal','Request Amount','required|trim');
			if($this->form_validation->run()=='TRUE')
			{
        		
            	    $data['member_id']    =  $member_id;
            		$usdt_withdrawal=$this->input->post('usdt_withdrawal');
			        
    				$response = $this->Home_model->add_roi_withdraw_request('Bonus'); 
					if($response['status'] == 1)
					{
					    $this->session->set_flashdata('pass_message', 'Withdrawal Request Sent Successfully.');
            			echo '<script language="javascript">' .
                            'setTimeout(function(){ window.location.href = "'.base_url().'member-reports/my-payments"; }, 100);' .
                             '</script>';
            		}
            		else
            		{
            			$this->session->set_flashdata('pass_eror', 'Withdrawal Request Failed.'.$response);
            			echo '<script language="javascript">' .
                            'setTimeout(function(){ window.location.href = "'.base_url().'member-reports/withdrawal"; }, 100);' .
                             '</script>';
		            } 
		       
		    }
    	    else
		    { 
        		$data['pass_eror'] = validation_errors();
        		$this->session->set_flashdata('pass_eror',$data['pass_eror']); 
        	}
	   }
    }
}