<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Members extends CI_Controller {
	function __construct()
	{
		parent::__construct();
		$this->load->helper(array('form', 'url','all_function'));
		$this->load->helper('security');
		$this->load->library('form_validation');
		$this->load->model('login_database');
		$this->load->model('Member_model');
		$this->load->model('Home_model');
		
		//$this->load->database($db);
		date_default_timezone_set("Asia/Calcutta");
		if(!isset($this->session->userdata['Gmlm_admin_logged_in']))
		{
			redirect('admin/index');
		}
	}
	
 	public function view_members()
 	{
 		$data['page_title']   = "View Members List";
 		$data['main_content'] = "admin/view_member_list";  

 		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');       
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date');

 			
 			$data['members_data'] = $this->Member_model->get_members_search($from_date,$to_date);  

 		}
 		
 		else
 		{
 		  $data['stage_le']='';
 		  $data['members_data'] = $this->Member_model->get_members($member_id='');		
 		   
 		}  
 		
		$this->load->view('admin/includes/template',$data); 
 	}

 	public function view_pending_members()
 	{
 		$data['page_title']   = "View Pending Members List";
 		$data['main_content'] = "admin/view_pending_member_list";  

 		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');       
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date');

 			
 			$data['members_data'] = $this->Member_model->get_pending_members_search($from_date,$to_date);  

 		}
 		
 		else
 		{
 		  $data['stage_le']='';
 		  $data['members_data'] = $this->Member_model->get_pending_members($member_id='');		
 		   
 		}  
 		
		$this->load->view('admin/includes/template',$data); 
 	}
	

		public function verify_login_id()
 	{
 		$id = $this->input->post('id');
 		$epin_qty = $this->input->post('epin_qty');
 		
 		$details = $this->Member_model->get_members_login_id($id);
 		if($details)
 		{
			echo "<div class='form-group'>
            <label class='' for='name'>Name</label>
            ".$details[0]->member_name."
        	</div>
        	<div class='form-group'>
	            <label class='' for='name'>City</label>
	            ".$details[0]->member_city."
        	</div>
        	<div class='form-group'>
        		<input type='hidden' class='input-group' id='request_member_id' value=".$details[0]->member_id." name='request_member_id'>
	            <label class='' for='name'>Mobile</label>
	            ".$details[0]->member_mobile."
        	</div>
        	<div class='modal-footer text-left'>
                <button type='submit' id='submit' name='submit' value='submit' class='btn btn-success waves-effect waves-light m-r-10'>Submit</button>
                <button type='button' class='btn btn-default' data-dismiss='modal'>Close</button>
            </div>";
 		}
 		else
 		{
 			echo "Invalid Member Login Id";
 		}
 	}
 	public function verify_sponsor_id()
 	{
 		$id = $this->input->post('id');
 		
 		$details = $this->Member_model->get_members_login_id($id);
 		if($details)
 		{
			echo $details[0]->member_name;
 		}
 		else
 		{
 			echo "Invalid Member Login Id";
 		}
 	}
 

 	public function view_member_detail()
 	{
 		$data['page_title']   = "View Members Details";
 		$data['main_content'] = "admin/view_member_detail";
 		$member_id            = $this->uri->segment(3);
 		$data['back_page']    = $this->uri->segment(4);  
 		
		$data['my_directs']	=$this->db->get_where('members',array('member_sponsored'=>$member_id))->result();	
		
 		$data['members_details'] = $this->Member_model->get_members_details($member_id); 

		$this->load->view('admin/includes/template',$data); 
 	}
	
	public function accept_payment()
 	{
 		$data['page_title']   = "Accept payment";
 		$data['main_content'] = "admin/accept_payment";
 		$from_id            = $this->uri->segment(3);
 		$to_id    = $this->uri->segment(4);
		
		if($from_id!='' && $to_id!='')
			{
				
				$is_donate=$this->db->get_where('donation',array('d_donor'=>$from_id,'d_receiver'=>$to_id))->row();
				if(!$is_donate)
				{
					$check=$this->db->get_where('members',array('member_id'=>$from_id))->row();
					$check2=$this->db->get_where('members',array('member_id'=>$to_id))->row();					
					if(!$check || !$check2)
					{
						redirect('members/accept_payment');
					}
				}
				else{
					redirect('members/accept_payment');
				}
			}
		
		if($_POST)
		{
			
				$this->form_validation->set_rules('sponsor_receiver','Receiver','required');
				$this->form_validation->set_rules('sponsor_donor','Donor','required');
				$this->form_validation->set_rules('amount','amount','required');
				$this->form_validation->set_rules('remark','remark','required'); 		

 			if ($this->form_validation->run() == TRUE)
            {
			
				
				if($from_id!='' && $to_id!='')
				{
					$sponsor_donor=$from_id;
					$sponsor_receiver=$to_id;				
				}
				else{
					
					$sponsor_receiver=getMemberID($this->input->post('sponsor_receiver'));
					$sponsor_donor=getMemberID($this->input->post('sponsor_donor'));
					
				}
				
				$is_donate=$this->db->get_where('donation',array('d_donor'=>$sponsor_donor,'d_receiver'=>$sponsor_receiver))->row();
				if(!$is_donate)
				{
					$amount=$this->input->post('amount');
					$remark=$this->input->post('remark');
					$pnr=$this->input->post('pnr_no');
					$added_date=$this->input->post('added_date');
					$params=array(
					'd_donor'=>$sponsor_donor,
					'd_receiver'=>$sponsor_receiver,
					'd_income'=>$amount,
					'd_pnr'=>$pnr,
					'd_remark'=>$remark,
					'd_added_date'=>$added_date
					);
					$this->db->insert('donation',$params);
					$this->session->set_flashdata('success','Donation added successfully...');
					redirect('admin-income/donation');
					}
				
				else{
					$this->session->set_flashdata('error','Sorry you have allready donated');
					redirect('members/accept_payment');
				}
			}
		}
		
		$this->load->view('admin/includes/template',$data); 
 	}

 	public function members_det($id)
 	{
 		return $this->Member_model->get_members($id);

 	}

 	public function edit_member_detail()
 	{
 		$data['page_title']   = "Edit Members Details";
 		$data['main_content'] = "admin/edit_member_detail";
 		$member_id            = $this->uri->segment(3);
 		$data['members_details'] = $this->Member_model->get_members($member_id);

 		if (isset($_POST['update-profile']))
 		{
 			$this->form_validation->set_rules('name','Name','required');
 			$this->form_validation->set_rules('password','Password','required'); 

 			if ($this->form_validation->run() == TRUE)
            {

 			 $updateData = array('member_title' => $this->input->post('title'),
 			 					 'member_name' => $this->input->post('name'), 			 					
 			 					 'member_password' => base64_encode($this->input->post('password')),
 			 					 'member_email_id' => $this->input->post('email'),
 			 					 'member_mobile' => $this->input->post('mobile'),
 			 					 'member_address' => $this->input->post('postal_address'),
 			 					 'member_state' => $this->input->post('state'),
 			 					 'member_city' => $this->input->post('city'),
 			 					 'member_pin_code' => $this->input->post('pin_code'),
 			 					 'member_nom_name' => $this->input->post('nom_name'),
 			 					 'member_nom_relation' => $this->input->post('nom_relation'),
 			 					 'member_nom_address' => $this->input->post('nom_address'),
 			 					 'member_nom_city' => $this->input->post('nom_city'),
 			 					 'member_nom_mobile' => $this->input->post('nom_mobile'),
 			 					
 			 						 );  
 

 			$update = $this->Member_model->update($updateData,'member_id='.$member_id,'members'); 
 			$this->session->set_flashdata('success','Profile update successfully...');
			redirect('members/view_members');  
		  }	

 		}

		$this->load->view('admin/includes/template',$data); 
 	}

 	public function block_memberOLD()
 	{
 		$member_id         = $this->uri->segment(3);
 		$status            = $this->uri->segment(4);
		$date=date('Y-m-d H:i:s');	
 		$result  = array('member_status' =>$status,'member_active_date'=>$date);
	$count=0;
 		$update = $this->Member_model->update($result,'member_id='.$member_id,'members'); 
 		
 		if ($status=='Pending') {
 			$this->session->set_flashdata('success','Member Bloked successfully...');	 
 		}else{
			$get_all=$this->db->get_where('members',array('member_id'=>$member_id))->row();
			
			$tot_sponsor=$this->db->get_where('members',array('member_sponsored'=>$get_all->member_sponsored))->result();
		if($tot_sponsor)
		{
			$count=count($tot_sponsor);
		}	
	
			if($count>=4)
			{
				$incomeuser='{"1":1000}';
			$check_income=$this->db->get_where('income',array('incometomember'=>$get_all->member_sponsored,'incometype'=>'generation'))->row();
			if(!$check_income)
			{
		
			$gen_array=array('1'=>1000,'2'=>1000,'3'=>1000,'4'=>1050,'5'=>1050,'6'=>1050);
			
					
						$flag=0;			
							for($i=1;$i<=6;$i++)
							{	
						
								
									if (array_key_exists($i, $gen_array))
									{
										if($i==1)
										{
											
												$sponser_id=$get_all->member_sponsored;
												$first_member=$sponser_id;
												$flag=1;
												$nw_array["$sponser_id"]=$gen_array[$i];
											
										}
										else{
											
											$get_sponsor_id=$this->db->get_where('isp_members',array('member_id'=>$sponser_id))->row();
											if($get_sponsor_id)
											{
												if($get_sponsor_id->member_sponsored!=0){
												$sponser_id=$get_sponsor_id->member_sponsored;
												$nw_array["$sponser_id"]=$gen_array[$i];
												$flag=1;}
												else{
												$flag=0;
												}
											}
											else{
											$flag=0;
											}
										}
										
										
									}							
									
							}
							
							if(count($nw_array)>0)
										{
												$gen_income=array(
												'incomeuser'=>json_encode($nw_array),
												'incomememberid'=>$member_id,
												'incometomember'=>$first_member,
												'incomedate'=>$date	,
												'incomestatus'=>'Hold',
												'incometype'=>'generation'
												);
												$this->db->insert('isp_income',$gen_income);
										}
			}
			}
			
			
 			$this->session->set_flashdata('success','Member Unblock successfully...');
 		}
 		
		redirect('members/view_pending_members');  
 	}		

  public function block_member()
  { 
 		$mem_id         = $this->uri->segment(3);
 		$status            = $this->uri->segment(4); 

 		if ($status=='Approve') {  
				
			$details=$this->db->get_where('pending_members',array('member_id'=>$mem_id))->row();
			
			$insertData = array(
									'member_name'      	  =>$details->member_name,							
									'member_password'  	  =>$details->member_password,
									'member_mobile'    	  =>$details->member_mobile,
									'member_login_id'     =>$details->member_login_id,
									'member_email_id'  	  =>$details->member_email_id,									
									'member_sponsored' 	  =>$details->member_sponsored,
									'member_address'   	  =>$details->member_address,									
									'member_city' 	   	  =>$details->member_city,									
									'member_pin_code'  	  =>$details->member_pin_code,
									'member_nom_name'  	  =>$details->member_nom_name,
									'member_nom_relation' =>$details->member_nom_relation, 
									'member_nom_address'  =>$details->member_nom_address,
									'member_nom_mobile'   =>$details->member_nom_mobile,
									'member_status'       =>'Approve',		
									'member_added_date'   =>$details->member_added_date 
									 ); 

						
						$down_user=$this->db->get_where('members',array('member_downline_id'=>0))->row();						
						$member_upline_id=$down_user->member_id;		
						$this->Home_model->insert_data('members',$insertData);
						$member_id = $this->db->insert_id();	
					
						$sponser_id = $details->member_sponsored;
						
											
						$params=array(
						'member_upline_id'	=>	$member_upline_id,
						'member_downline_id'=>0,							
						);
						$this->db->where('member_id',$member_id);
						$is_update=$this->db->update('members',$params);
						if($is_update)
						{
							$second_params=array(
							'member_downline_id'=>$member_id
							);
							$this->db->where('member_id',$member_upline_id);
							$this->db->update('members',$second_params);
							
						}
						$login_id=$details->member_login_id;
						$password=base64_decode($details->member_password);
						$msg='Thank you for registration with Greenglory. Here are your login credentials login: '.$login_id.' and password: '.$password.'. Login to www.greenclory.co.in';
						$this->Home_model->send_sms($this->input->post('mobile_no'),$msg);
							
							$this->db->where('member_id',$mem_id);
							$this->db->delete('pending_members');	
			
			
			
 		
 			$this->session->set_flashdata('success','Member Approve successfully...');	 
 		}
 		if ($status=='Deleted') {
 			$this->Member_model->update(array('member_status' =>$status),array('member_id' =>$mem_id),'pending_members'); 
 			$this->session->set_flashdata('success','Member Deleted successfully...');	 
 		}
 	redirect('members/view_pending_members');	
  }

}