<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Payment extends CI_Controller {

    function __construct()
    {
        parent::__construct(); 
        
        $this->load->helper(array('form', 'url','all_function'));
        $this->load->helper('security');
        $this->load->library('form_validation');
        $this->load->library('session');  
        $this->load->library('email'); 
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('Home_model');

        if(!$this->session->userdata('regUserDetails')) {
            redirect(base_url());
        } 
    }

	public function pay($package_id) { 

        if(isset($package_id))
        {    
           $packages = getPackages($package_id);
          if ($packages) 
          {
            $p_id               = $package_id;
            $p_amount           = $packages[0]->package_amount;
            $p_ROI_percentage   = $packages[0]->package_ROI_percentage;
            $p_ROI_days         = $packages[0]->package_ROI_to;

            $packData = array('p_id'            =>$p_id,
                              'p_amount'        =>$p_amount,
                              'p_ROI_percentage'=>$p_ROI_percentage,
                              'p_ROI_days'      =>$p_ROI_days,
                          );

            $this->session->set_userdata('paymentData',$packData);

            //redirect(base_url('payment/success')); 

            $data['main_content']      = "home/packagesPayment"; 
            $this->load->view('home/includes/template',$data); 

          }
          else
          {
            redirect(base_url('payment/failed'));
          }
        }
        else
        {
            redirect(base_url());
        } 
	}
  

    public function pay1($package_id,$member_id) { 

        if(isset($package_id))
        {   
            $data = array(
                'member_package_id'  => $package_id
            );
            $this->db->where('member_id',$member_id);
            $this->db->update('members',$data);  
           $packages = getPackages($package_id);
          if ($packages) 
          {
            $p_id               = $package_id;
            $p_amount           = $packages[0]->package_amount;
            $p_ROI_percentage   = $packages[0]->package_ROI_percentage;
            $p_ROI_days         = $packages[0]->package_ROI_to;

            $packData = array('p_id'            =>$p_id,
                              'p_amount'        =>$p_amount,
                              'p_ROI_percentage'=>$p_ROI_percentage,
                              'p_ROI_days'      =>$p_ROI_days,
                          );

            $this->session->set_userdata('paymentData',$packData);
            $data['main_content']      = "home/packagesPayment"; 
            redirect(base_url('payment/success')); 

            // $data['main_content']      = "front/new_reg_packages"; 
             $this->load->view('home/includes/template',$data); 
    //          $this->load->view('front/includes/header-member-pending');
    //      $this->load->view('front/pendin_dashboard',$data);
    //      $this->load->view('front/includes/footer-member');

          }
          else
          {
            redirect(base_url('payment/failed'));
          }
        }
        else
        {
            redirect(base_url());
        } 
    }
    public function success() 
    { 
      
        $transaction_id = rand();
        if($transaction_id!='' && $this->session->userdata('paymentData')!='')
        { 
            $invoice_no = time(); 

            $paydata    = $this->session->userdata('paymentData');            
            $session_details = $this->session->userdata('regUserDetails');            
            $upline_id=0;    
            $upline_id = $session_details['userData']['member_upline_id'];   

            $login_id = $session_details['userData']['member_login_id'];
            $password = base64_decode($session_details['userData']['member_password']); 
            $mobileNo = $session_details['userData']['member_mobile']; 
            
            $regIsExist = $this->db->get_where('members',array('member_login_id'=>$login_id,'member_mobile'=>$session_details['userData']['member_mobile'],'member_type'=>'member'))->num_rows();
           
            if ($regIsExist==0) 
            {     
                unset($session_details['userData']['member_position']);

                $this->Home_model->insert_data('members',$session_details['userData']); 
   
                $member_id = $this->db->insert_id(); 

                $acti_date = date('Y-m-d');
                $exp_date = date('Y-m-d', strtotime('+2 years', strtotime($acti_date)));

                $roi_amount = 0;

                $roi_amount = ($paydata['p_ROI_percentage']*$paydata['p_amount'])/100;

                $this->db->where('member_id',$member_id);   
                $this->db->set('member_package_id',$paydata['p_id']);  
                $this->db->set('member_active_date',$acti_date);  
                $this->db->set('member_expired_date',$exp_date);  
                $this->db->set('member_package_ROI_percent',$paydata['p_ROI_percentage']);  
                $this->db->set('member_package_ROI_amount',$roi_amount);  
                $this->db->set('member_ROI_days',$paydata['p_ROI_days']);  
                $this->db->set('member_transactionId',$transaction_id);  
                $this->db->set('is_paid','No');  
                $this->db->set('member_status','Pending');  
                $this->db->update('members');

                $this->Home_model->add_upline_level_members($member_id,$upline_id); 

                $totSponsored = 0;
                $totSponsored = CountSponsored($upline_id);
                if($totSponsored>=2)
                {  
                    $this->Home_model->add_jackpot_income($upline_id); 
                } 

                $message='Thank you for registration with '.$this->config->item('title').'. Here are your login credentials ID: '.$login_id.' and password: '.$password.'. Login to '.$this->config->item('website_name').'';
                $this->Home_model->send_sms($mobileNo,$message);   

                $this->session->set_flashdata('message', 'Member registration Successful Transaction ID: '.$transaction_id.'. Loginid : '.$login_id.'  Password : '.$password.'');
                redirect('home/register-success');

            } 

        } 
        else{
            redirect(base_url());
        }
         
    }

    public function epin_success() 
    {  
        //   print_r($this->session->userdata('regUserDetails'));echo "<br>";
        if($this->session->userdata('paymentData')!='')
        { 
            
            $invoice_no = time(); 

            $paydata    = $this->session->userdata('paymentData');            
            $session_details = $this->session->userdata('regUserDetails');   
      
            $upline_id=0;   $member_epin=0; 
            $upline_id = $session_details['userData']['member_upline_id'];  
            $member_epin = $session_details['userData']['member_epin_id'];

            $login_id = $session_details['userData']['member_login_id'];
            $password = base64_decode($session_details['userData']['member_password']); 
            $mobileNo = $session_details['userData']['member_mobile'];   
            
            $regIsExist = $this->db->get_where('members',array('member_login_id'=>$login_id,'member_mobile'=>$session_details['userData']['member_mobile'],'member_type'=>'member'))->num_rows();
         
            if ($regIsExist==0) 
            {     
                unset($session_details['userData']['member_position']);

                $this->Home_model->insert_data('members',$session_details['userData']); 
   
                $member_id = $this->db->insert_id();
                $arr=array(
                    	'member_id'       =>$member_id,
						'package_id'       =>$paydata['p_id'],
						'epin'   =>$member_epin 
						);
                 $this->Home_model->insert_data('member_packages',$arr); 
                if($member_epin!=0)
                {    

                    $epinPackage=$this->db->get_where('isp_epin',array('epin_id'=>$member_epin,'epin_status'=>'Unused'))->row(); 

                    $this->db->where('epin_id',$member_epin);   
                    $this->db->set('epin_status','Used');  
                    $this->db->update('epin');  

                    $transaction_id =  $epinPackage->epin;
                }
                $acti_date = date('Y-m-d');
                $exp_date = date('Y-m-d', strtotime('+2 years', strtotime($acti_date)));

                $roi_amount = 0;

                $roi_amount = ($paydata['p_ROI_percentage']*$paydata['p_amount'])/100;

                $this->db->where('member_id',$member_id);   
                $this->db->set('member_package_id',$paydata['p_id']);  
                $this->db->set('member_active_date',$acti_date);  
                $this->db->set('member_expired_date',$exp_date);  
                $this->db->set('member_package_ROI_percent',$paydata['p_ROI_percentage']);  
                $this->db->set('member_package_ROI_amount',$roi_amount);  
                $this->db->set('member_ROI_days',$paydata['p_ROI_days']);  
                $this->db->set('member_transactionId',$transaction_id);  
                $this->db->set('is_paid','Yes');  
                $this->db->update('members');
                $this->Home_model->add_upline_level_members($member_id,$upline_id); 

                $totSponsored = 0;
                $totSponsored = CountSponsored($upline_id);
                if($totSponsored>=2)
                {  
                    $this->Home_model->add_jackpot_income($upline_id); 
                } 

                $message='Thank you for registration with '.$this->config->item('title').'. Here are your login credentials ID: '.$login_id.' and password: '.$password.'. Login to '.$this->config->item('website_name').'';
                $this->Home_model->send_sms($mobileNo,$message);   

                $this->session->set_flashdata('message', 'Member registration Successful Transaction ID: '.$transaction_id.'. Loginid : '.$login_id.'  Password : '.$password.'');
                redirect('home/register-success');

            } 

        } 
        else{
            redirect(base_url());
        }
         
    }  
    
    public function failed() {
        $data['title'] = 'Failed | TechArise';  
        echo "<h4>Your transaction got Failed</h4>";            
        echo "<br/>";
        echo "Transaction ID: ".rand();
        echo "<br/>"; 
    } 

}