<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Signin extends CI_Controller {
	function __construct()
	{
		parent::__construct();
		$this->load->helper(array('form', 'url','all_function'));
		$this->load->helper('security');
		$this->load->library('form_validation');
		$this->load->library('session');
		$this->load->model('login_database');
		//$this->load->database($db);

	}
	public function index()
	{
		if (isset($this->session->userdata['mlm_admin_logged_in'])) 
		{
			redirect('home');
		}

		$this->load->view('index');
		/*$data['main_content'] = "index";
		$this->load->view('includes/template',$data); */
	}
	public function login()
	{
		$this->form_validation->set_rules('username', 'Username', 'trim|required|xss_clean');
		$this->form_validation->set_rules('password', 'Password', 'trim|required|xss_clean');
		if ($this->form_validation->run() == FALSE)
		{
			if(isset($this->session->userdata['mlm_admin_logged_in']))
			{
				$this->load->view('Home');
			}
			else
			{
				redirect('Signin/index');
			}
		}
		else
		{
			$data = array(
			'username' => $this->input->post('username'),
			'password' => md5($this->input->post('password'))
			);
			$result = $this->login_database->login($data);


			//print_r($result); die;
			if ($result == TRUE)
			{
				$username = $this->input->post('username');
				$result = $this->login_database->read_user_information($username);
				if ($result != false)
				{
					$session_data = array(
						'username' => $result[0]->login_id,
						'admin_id' => $result[0]->admin_id,
						'first_name' => $result[0]->first_name,						
						'super_admin' => $result[0]->super_admin,
						'admin_type' => $result[0]->admin_type,
						);
					$this->session->set_userdata('mlm_admin_logged_in', $session_data);

					
					//print_r($_SESSION); die;
					redirect('Home');
					//$this->load->view('home/dashboard');
				}
			}
			else 
			{

				$this->session->set_flashdata("invalid_user","Invalid Username or Password");
				/*$data = array(
				'error_message' => 'Invalid Username or Password'
				);*/
				$this->load->view('index', $data);
			}
		}
	}
	public function logout() 
	{
		// Removing session data
		$sess_array = array(
		'username' => ''
		);
		$this->session->unset_userdata('mlm_admin_logged_in', $sess_array);
		$data['message_display'] = 'Successfully Logout';

		$this->session->set_flashdata('logout_message', 'Logout Seccessfully');
		redirect('sign-in');
		//$this->load->view('index', $data);
	}
	public function backup_db(){
		
		$this->load->helper('url');	
		$this->load->helper('file');	
		$this->load->helper('download');	
		$this->load->library('zip');	
		$this->load->dbutil();		
		$db_format=array('format'=>'zip','filename'=>'my_db_backup.sql');	
		$backup=& $this->dbutil->backup($db_format);
		$dbname='backup-on-'.date('Y-m-d').'.zip';		
		$save=base_url().'assets/db/'.$dbname;	
		write_file($save,$backup);		
		force_download($dbname,$backup);	
	}
 
 

}