<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Mlm_new extends CI_Controller {
	
	function __construct()
	{
	 
		parent::__construct();
	    $this->load->helper(array('form','url','new_function_helper'));
		$this->load->helper('security');
	    $this->load->library('form_validation');
    	$this->load->model('New_database');
    	$this->load->library('GoogleAuthenticator');
	
		
		if(isset($this->session->userdata['mlm_new_logged_in']))
		{
		   
			redirect('Mlm_new/index');
		}
		else{
		 
		}
		
		
	}
	public function index()
	{

		$data['page_title'] = "Admin Login";
		$this->load->view('new_admin/login',$data);
	}

	public function dashboard()
	{
 		$data['page_title'] = "Admin Dashboard";
		$data['main_content'] = "new_admin/dashboard";
		$this->load->view('new_admin/includes/template',$data);
	}

	public function login()
	{

        $data=[];
		$this->form_validation->set_rules('username', 'Username', 'trim|required|xss_clean');
		$this->form_validation->set_rules('password', 'Password', 'trim|required|xss_clean');
		if ($this->form_validation->run() == FALSE)
		{
			
		}
		else
		{
			
            
					$data = array(
						'username' => $this->input->post('username'),
						'password' => md5($this->input->post('password'))
					);
					$result = $this->New_database->login($data);
			
				
					if ($result == TRUE)
					{
						$username = $this->input->post('username');
						$result = $this->New_database->read_user_information($username);
						if ($result != false)
						{
							$session_data = array(
								'username' => $result[0]->admin_login_id,
								'admin_id' => $result[0]->admin_id,
								'first_name' => $result[0]->admn_first_name,						
								'super_admin' => $result[0]->admin_super_admin,
								'admin_type' => $result[0]->admin_type,
								);
							$this->session->set_userdata('mlm_admin_logged_in', $session_data);
						
							redirect('Mlm_new/new_dashboard');
						
						}
					}
					else 
					{
						$this->session->set_flashdata("invalid_user","Invalid Username or Password");				
						
					}
			
		}
		$this->load->view('new_admin/login', $data);
	}
		public function new_dashboard()
	{
		
		$data['page_title'] = "Admin Dashboard";
		$data['main_content'] = "new_admin/new_dashboard";
		
	
		$mysqlUserName      = $this->db->username;
		$mysqlPassword      = $this->db->password;
		$mysqlHostName      = $this->db->hostname;
		$DbName             = $this->db->database;
		$backup_name        = "NewSkillHolidays-DB.sql";
		$tables             = "";

		
		$this->load->view('new_admin/includes/template',$data);
	}
	public function register_members()
 	{
 		$data['page_title']   = "View Register Members List";
 		$data['main_content'] = "new_admin/view_register_member_list";  
        $data['members_data'] = $this->New_database->get_view_regmembers_data();
        $this->load->view('new_admin/includes/template',$data); 
 	}
 	public function view_registered_members()
 	{
 		$data['page_title']   = "View Members Details";
 		$data['main_content'] = "new_admin/register_member_view";
 		$member_id            = $this->uri->segment(3);
        $data['network_data'] = $this->New_database->get_member_network_data($member_id); 
 
 			
 		$data['members_details'] = $this->New_database->get_members($member_id);
		$this->load->view('new_admin/includes/template',$data); 
 	}
 	    public function send_email_reg($id)
 	{
 		$member_id            = $this->uri->segment(3);
       	$data['members_details'] = $this->New_database->get_members($member_id);
		$name=getSponsorName($member_id);
		
        $to=getMemberemail($member_id);
        $subject="Login Credentials from Maxxgain Bazzar";
        $login_id=getMemberLoginID($member_id);   
        $password=getMemberpassword($member_id);   
        $message='Hello '.$name.',>';
        $message.=" Here's your Login Credentials.";
        $message.=' Your login information : ';
        $message.=' Login :'.$login_id.'.';
        $message.=' Password :'.$password.'.';
        $message.=' You can login here :'.$this->config->item('website_name').'.';
        $message.=' Contact us immediately if you did not authorize this registration.';
        $message.=' Thank you.';
  
        send_email($to,$subject,$message);
        $this->session->set_flashdata('success','Email Send successfully...'); 
        redirect('Mlm_new/register_members');
 	}
 		public function view_members()
 	{
 		$data['page_title']   = "View Active Members List";
 		$data['main_content'] = "new_admin/view_member_list";  
 		$data['stage_le']=''; 	
 		$data['members_data'] = $this->New_database->get_view_members_data();
 	    $this->load->view('admin/includes/template',$data); 
 	}
 		public function view_member_detail()
 	{
 		$data['page_title']   = "View Members Details";
 		$data['main_content'] = "new_admin/view_member_detail";
 		$member_id            = $this->uri->segment(3);
 	    $data['pdf_path']=	$_SERVER['SERVER_NAME']."/data/pay_receipt/";
 	   
	    $data['payment_details']=$this->db->order_by('mp_id','DESC')->get_where('isp_member_payment',array('m_id'=>$member_id))->row();	
	    $data['order_data'] = $this->New_database->get_view_members_orders($member_id);
	    
	    if($this->input->post("btn_submit1"))
		{
			$level_no=$this->input->post("level_no");
			if($level_no!='All')
			{
				$data['ref_income']=$this->db->order_by('income_id','DESC')->get_where('isp_level_income',array('income_member_id'=>$member_id,'income_level'=>$level_no))->result();	
				$data['level']=$level_no;
			}
			else
			{
				$data['ref_income']=$this->db->order_by('income_id','DESC')->get_where('isp_level_income',array('income_member_id'=>$member_id))->result();	
					$data['level']='All';
			}
			
		}
        else
		{
			$data['ref_income']=$this->db->order_by('income_id','DESC')->get_where('isp_level_income',array('income_member_id'=>$member_id))->result();	
			$data['level']='All';
		}	
 		
 		$data['members_details'] = $this->New_database->get_members($member_id);
		$this->load->view('new_admin/includes/template',$data); 
 	}
 		public function view_member_orders()
 	{
 		$data['page_title']   = "View Member Orders";
 		$data['main_content'] = "new_admin/view_member_orders";  
 		$id = $this->uri->segment(3);

 		$data['members_data'] = $this->New_database->get_view_members_orders($id);
 	    $this->load->view('admin/includes/template',$data); 
 	}
 		public function my_team()
	{
	    $data['page_title']   = "My Team";
	    $data['member_id']=	$member_id = $this->uri->segment(3);
		if($this->input->post("btn_submit"))
		{
			$level_no=$this->input->post("level_no");
			
			$details=$this->New_database->get_level_member_list($member_id,$level_no);
		    $data['network_list']= $details;
		    $data['level']=$level_no;
			$names = getSponsor($member_id); 
		}
		else
		{
			$data['level']=1;
			$details=$this->New_database->get_level_member_list($member_id,1);
		    $data['network_list']= $details;
		}

  	    $data['con_levels']= $this->config->item('config_levels');
	    $data['type_levels']= $this->config->item('level_type');

		$data['upline'] = getUplineId($member_id);
		
		$data['main_content']      = "new_admin/my_team"; 
		$this->load->view('new_admin/includes/template',$data);
	}
		 public function send_payment_receipt($id)
 	{
 		$member_id            = $this->uri->segment(3);
       	$data['members_details'] = $this->New_database->get_members($member_id);
		$members_data = $this->New_database->get_member_regi($member_id); 
        $customer_name = $members_data[0]->member_name;
        $email = $members_data[0]->member_email_id;
        $amount =$members_data[0]->package;
        $package_type =$members_data[0]->package_type;
        $c_id = $members_data[0]->member_id;
        
        $payment_details=$this->db->order_by('mp_id','DESC')->get_where('isp_member_payment',array('m_id'=>$member_id))->row();
        $pdf_path = $payment_details->pdf_path;
        // print_r($payment_details);die;
  
        $mesg = " Dear $customer_name Congratulations, Your membership is activated your payment of Rs.$amount is received successfully and your receipt no. is $c_id. You can download your receipt from the link. ".$pdf_path." Regards, MaxxGain Bazzar, MAGACN"; 
        $subject="Payment receipt from Maxxgain";
        send_email($email,$subject,$mesg);
        
        $this->session->set_flashdata('success','Email Send successfully...'); 
        redirect('Mlm_new/view_members');
 	}
 	public function edit_members()
 	{
 		$data['page_title']   = "Edit Register Members";
 		$data['main_content'] = "new_admin/edit-register-members";
 		$data['members_data']="";
 		$data['username']="";
        if (isset($_POST['search'])) 
 		{
 		  $type =  $this->input->post('username_type');     
 		  $data['username']= $username =  $this->input->post('username');       
 			if($type=='email')
 			{
 			    $data['members_data'] = $this->New_database->get_member_data_email($username);   
 			}
 			else if($type=='member_name')
 			{
 			    $data['members_data'] = $this->New_database->get_member_data_name($username);  
 			}
 				else if($type=='login_id')
 			{
 			    $data['members_data'] = $this->New_database->get_member_data_login_id($username);  
 			}
 
 		
 		} 

 	
 		if ($this->input->post('update-profile')=='update') 
 		{
 		
 		    $member_id = $this->input->post('member_id');
 			$login_id = getMemberLoginID($member_id);
 			$members_data = $this->New_database->get_member_data_login_id($login_id);  
 			$name = $members_data->member_name;
 	     
					$member_mobile 		= $this->input->post('mobile_no');
					$member_email	= $this->input->post('email');
					$member_Name 		= $this->input->post('member_Name');
					$member_gender	= $this->input->post('gender');
					$member_country		= $this->input->post('country');
					$member_password	= $this->input->post('password');
					$member_wallet_password	= $this->input->post('wallet_password');
					
				    $member_first_name	= $this->input->post('member_first_name'); 
					$member_middle_name = $this->input->post('member_middle_name'); 
					$member_last_name 	= $this->input->post('member_last_name');
					$member_dob 		= $this->input->post('member_dob');
					$member_address 	= $this->input->post('address');
					$aadhar_id 			= $this->input->post('aadhaar_detail');
					$passport_id 		= $this->input->post('member_passport_detail');
					$driving_lic_id 	= $this->input->post('member_driving_license_detail');
					$id_proof 			= $this->input->post('member_address_doc_details');
					$address_varify 	= $this->input->post('member_address_doc_details');
					
					$is_error		= true;
					$passport_front = $passport_back = $adhar_front = $adhar_back = $driving_front = $driving_back = '';$userphoto = '';
				// 	 echo $is_error;echo "<pre>";
					if($id_proof == 'passport')
					{
					  
						if($_FILES['passport_front']['size'] > 0 && $_FILES['passport_back']['size'] > 0 && !empty($passport_id))
						{
						     
							$config['upload_path'] 		= './assets/profile/';
							$config['allowed_types'] 	= 'jpg|jpeg|png';
							$config['file_name'] 		= $_FILES['passport_front']['name'];
							$this->load->library('upload',$config);
							$this->upload->initialize($config);							
							if($this->upload->do_upload('passport_front'))
							{
								$uploadData = $this->upload->data();
								$passport_front= $uploadData['file_name'];
							}
								
							$config['file_name'] = $_FILES['passport_back']['name'];
							$this->load->library('upload',$config);
							$this->upload->initialize($config);
							if($this->upload->do_upload('passport_back'))
							{
								$uploadData = $this->upload->data();
								$passport_back= $uploadData['file_name'];
							}
						
							$is_error		= false;
						
						}
					}else if($id_proof == 'adhaar_card'){
						if($_FILES['adhar_front']['size'] > 0 && $_FILES['adhar_back']['size'] > 0 && !empty($aadhar_id)){
							$config['upload_path'] 		= './assets/profile/';
							$config['allowed_types'] 	= 'jpg|jpeg|png';
							$config['file_name'] 		= $_FILES['adhar_front']['name'];
							
							$this->load->library('upload',$config);
							$this->upload->initialize($config);							
							if($this->upload->do_upload('adhar_front'))
							{
								$uploadData = $this->upload->data();
								$adhar_front= $uploadData['file_name'];
							}	
							$config['file_name'] = $_FILES['adhar_back']['name'];
							$this->load->library('upload',$config);
							$this->upload->initialize($config);
								
							if($this->upload->do_upload('adhar_back'))
							{
								$uploadData = $this->upload->data();
								$adhar_back= $uploadData['file_name'];
							}
							$is_error		= false;
						}						
					}else if($id_proof == 'driving_licence'){
						if($_FILES['driving_front']['size'] > 0 && $_FILES['driving_back']['size'] > 0 && !empty($driving_lic_id)){
							$config['upload_path'] 		= './assets/profile/';
							$config['allowed_types'] 	= 'jpg|jpeg|png';
							$config['file_name'] 		= $_FILES['driving_front']['name'];
							$this->load->library('upload',$config);
							$this->upload->initialize($config);							
							if($this->upload->do_upload('driving_front'))
							{
								$uploadData = $this->upload->data();
								$driving_front= $uploadData['file_name'];
							}	
							$config['file_name'] = $_FILES['driving_back']['name'];
							$this->load->library('upload',$config);
							$this->upload->initialize($config);
								
							if($this->upload->do_upload('driving_back'))
							{
								$uploadData = $this->upload->data();
								$driving_back= $uploadData['file_name'];
							}
							$is_error		= false;							
						}
					}
			
				 if (!empty($_FILES['selfie']['name'])) {
    $config['upload_path'] = './assets/profile/';
    $config['allowed_types'] = 'jpg|jpeg|png|pdf';

    $config['file_name'] = $_FILES['selfie']['name'];
    $this->load->library('upload', $config);
    $this->upload->initialize($config);

    if ($this->upload->do_upload('selfie')) {
        $uploadData = $this->upload->data();
        $userphoto = $uploadData['file_name'];
    } else {
        $userphoto = '';
    }
}

	if (empty($_FILES['selfie']['name']) && empty($userphoto)) {
   
    $userphoto = $members_data->member_photo;
}
					if($userphoto == '' && $adhar_front == '')
					{
					    $userphoto=$members_data->adhar_card_doc;
					}
				    if($userphoto == '' && $adhar_back == '')
					{
					    $userphoto=$members_data->adhar_card_back;
					}
					if($userphoto == '' && $passport_front == '')
					{
					    $userphoto=$members_data->passport_doc;
					}
				    if($userphoto == '' &&  $passport_back == '')
					{
					    $userphoto=$members_data->passport_back_doc;
					}
					if($userphoto == '' && $driving_front == '')
					{
					    $userphoto=$members_data->driving_lic_doc;
					}
				    if($userphoto == '' && $driving_back == '')
					{
					    $userphoto=$members_data->driving_lic_back_doc;
					}
					    $arr=array(
							'member_id'       		=>$member_id,
							'first_name'			=>$member_first_name,
							'middle_name'			=>$member_middle_name,
							'last_name'				=>$member_last_name,
							'birthdate'				=>$member_dob,
							'aadhar_id'				=>$aadhar_id,
							'adhar_card_doc'		=>$adhar_front,
							'adhar_card_back'		=>$adhar_back,
							'passport_id'			=>$passport_id,
							'passport_doc'			=>$passport_front,
							'passport_back_doc'		=>$passport_back,
							'driving_lic_id	'		=>$driving_lic_id,
							'driving_lic_doc'		=>$driving_front,
							'driving_lic_back_doc'	=>$driving_back,
							'address_verify_option'	=>$address_varify,
							'address'				=>$member_address,
							'member_photo'			=>$userphoto,
					
						);
						
						$this->db->where('member_id',$member_id);
							$update = $this->db->update('isp_profile_doc_details',$arr);
						
							if($update){
								
								$u_data=array(
								    	'member_name'=>$member_first_name." ".$member_last_name,
									'member_profile'=>$userphoto,
									'member_dob'	=>$member_dob,
									'member_email_id'	=>$member_email,
									'member_mobile'	=>$member_mobile,
									'member_password'	=>base64_encode($member_password),
								// 	'wallet_password'=>base64_encode($member_wallet_password),
								// 	'member_country'	=>$member_country,
									'member_gender'	=>$member_gender,
								);
								$this->db->where('member_id',$member_id);
								$this->db->update('isp_members',$u_data);
				// 			echo	$this->db->last_query();die;
							}
					
					   // }
 
                $str= $name." Details Updated successfully...";
			
				$this->session->set_flashdata('success',$str);
				redirect('Mlm_new/edit_members');  
		  
			
 		}
		$this->load->view('new_admin/includes/template',$data); 
 	} 
 	 public function view_kyc_members()
 	{
 		$data['page_title']   = "View KYC Members List";
 		$data['main_content'] = "new_admin/view_kyc_member_list";  
        $data['members_data'] = $this->New_database->view_kyc_members();
        $this->load->view('new_admin/includes/template',$data); 
 	}
 		public function order()
	{    
 
    	$data['page_title']   = "Upcoming Order List";
    	$data['main_content']  = "new_admin/order";
    	$data['orders'] = $this->db->order_by('o_id', 'desc')->get_where('isp_order')->result();
    	
        $data['orders'] = $this->db->get_where('isp_order', array('status' => 'upcoming'))->result();
      
 	  $this->load->view('new_admin/includes/template',$data); 
	}
		public function pending()
	{    
 
        $data['page_title']   = "Pending Order List";
        $data['main_content']  = "new_admin/pending";
        $data['orders'] = $this->db->get_where('isp_order', array('status' => 'pending'))->result();
 	    $this->load->view('new_admin/includes/template',$data); 
	}
	public function approve_confirm()
	{  
        $confirm_date  = $_POST['confirm_date'];
        if($confirm_date=="")
        {
            $confirm_date=date('Y-m-d');
        }
         $member_name = $_POST['name'];
        $remark  = $_POST['remark'];
         $bill_no  = $_POST['bill_no'];
        $o_id  = $_POST['o_id'];
        $member_id  = $_POST['member_id'];
        $order_no = $data['order_no'] = $_POST['order_no'];
        $data['confirm_date']  = $_POST['confirm_date'];
        $date =$o_id; 
        $d=date("my");
        $order_id  = "MO".$d.str_pad($date, 4, '0', STR_PAD_LEFT);
	    if(!empty($_FILES['receipt']['name']))
        {
        
            $config['upload_path'] = './assets/uploads/';
            $config['allowed_types'] = 'jpg|jpeg|png|pdf';
            $config['file_name'] = $_FILES['receipt']['name'];
           
            //Load upload library and initialize configuration
            $this->load->library('upload',$config);
            $this->upload->initialize($config);
            
            if($this->upload->do_upload('receipt'))
            {
                $uploadData = $this->upload->data();
                $receipt= $uploadData['file_name'];
            }
            else
            {
                $receipt = '';
            }
        }
        else
        {
            $receipt = '';
        }  
        // if($receipt !="")
        // {
             $v_id=18;
             
   	        $this->db->where('o_id',$o_id); 
			$this->db->set('status','confirmed');
			$this->db->set('remark',$remark);
			$this->db->set('v_id',$v_id);
			$this->db->set('bill_no',$bill_no);
			$this->db->set('order_id',$order_id);
			$this->db->set('receipt',$receipt);
			$this->db->set('confirm_date',$confirm_date);
		    $a=	$this->db->update('isp_order');
		  //  echo $this->db->last_query();die;
		   
		    $bill_no  = $this->input->post('bill_no');
		    if($bill_no=='' || empty($bill_no)){
		        $bill_no="0000";
		    }

            
             $this->db->where('c_id',$member_id);
            $this->db->where('order_no',$order_no); 
			$this->db->set('status','confirmed');
			$this->db->set('remark',$remark);
			$this->db->set('v_id',$v_id);
			$this->db->set('bill_no',$bill_no);
			$this->db->set('order_id',$order_id);
			$this->db->set('receipt',$receipt);
			$this->db->set('confirm_date',$confirm_date);
		    $aa =	$this->db->update('mg_customer_order');
		  
		  	$type  ='Member';
		
        				$id    = $member_id;
        				$title ='Your order '.$order_no.' is  confirmed';
        				$body  ='Dear   '.$member_name.', Your order '.$order_no.' is  confirmed';
        				
        				$date = date('Y-m-d H:i:s');
    					$notifyData = array(
    					        'notification_type'     => $type,
    					        'ven_cust_id'           => $id,
    					        'notification_subject'  => $title,
    					        'notification_message'  => $body,
    					        'created_at'            => $date,
    					    );
    					    
    					$last_id = $this->New_database->insertDataapi('bs_notifications',$notifyData);
    					if($last_id)
    					{
    				
        				     send_Notify($type,$id,$title,$body);
        				    
    					}
		  
	        $id = $this->uri->segment(3);
            $details=$this->db->get_where('isp_members',array('member_id'=>$id))->row();
    
            $data['customer']   = $details;
            $customer_ID = $details->member_login_id;
            

            if (strlen($order_no) == 1) 
            {
                $order_no = "0" . $order_no;
            }
            $filename ="pay_receipt_".$customer_ID.$order_no;
            $filename1=$filename.'.pdf';
            $this->load->library('pdf');
            $html = $this->load->view('receipt', $data, true);
         
            $this->pdf->createPDF($html, $filename, false);
            $attched_file= $_SERVER["DOCUMENT_ROOT"]."/maxxgain/data/pay_receipt/".$filename.'.pdf';
           
            $attched_file1= $_SERVER['SERVER_NAME']."/maxxgain/data/pay_receipt/".$filename.'.pdf';
            $pdf=$filename.'.pdf';
                
            $data1=array('pdf'=>$pdf,'pdf_path'=>$attched_file1); 
            $update = $this->New_database->update($data1,'o_id='.$o_id,'isp_order');
        
	    redirect('new_admin/pending');
 		$this->load->view('new_admin/includes/template',$data); 
	}
	public function confirm_orders()
{
    $data['page_title'] = "Confirm Order List";
    $data['main_content'] = "new_admin/confirm_list";

    if ($this->input->post("btn_submit")) {
        $date = $this->input->post('date');

        
        $data['selected_date'] = $date;

        $data['orders'] = $this->db->order_by('o_id', 'desc')->get_where('isp_order', array('status' => 'confirmed', 'confirm_date' => $date))->result();

       
    } else {
        $data['selected_date'] = ''; 
        $data['orders'] = $this->db->order_by('o_id', 'desc')->get_where('isp_order', array('status' => 'confirmed'))->result();
    }

    $this->load->view('new_admin/includes/template', $data);
}
 	public function income_list()
 	{
 		$data['page_title']   = "View  Income List";
 		$data['main_content'] = "new_admin/referral_income";  
        
       
        if($this->input->post("btn_submit"))
		{ 
		  
			$day_selected=$this->input->post("day_selected");
			$month_selected=$this->input->post("month_selected");
			$year_selected=$this->input->post("year_selected");
			$monthNumber = date_parse(date('Y') . '-' . $month_selected)['month'];
            if (strlen($monthNumber) == 1) 
            {
                $monthNumber = "0" . $monthNumber;
            }
          
			if($day_selected!='All')
			{
		        $date = $year_selected."-".$monthNumber."-".$day_selected;
		    
				$data['income'] = $this->New_database->get_referral_income_datewisedata2($date);
			
				$data['day_selected']=$day_selected;
				$data['month_selected']=$month_selected;
				$data['year_selected']=$year_selected;
			}
			else
			{
				
					$data['income'] = array();
				$data['day_selected']='All';
    			$data['month_selected']='All';
    			$data['year_selected']='All';
			}
			
		}

		else
		{
		 
		    	$data['income'] = array();
			$data['day_selected']='All';
			$data['month_selected']='All';
			$data['year_selected']='All';
		}	
		
		if($this->input->post("csv_submit"))
		{ 
		 
			$day_selected=$this->input->post("day_selected");
			$month_selected=$this->input->post("month_selected");
			$year_selected=$this->input->post("year_selected");
			$monthNumber = date_parse(date('Y') . '-' . $month_selected)['month'];
            if (strlen($monthNumber) == 1) 
            {
                $monthNumber = "0" . $monthNumber;
            }
          
		    $date = $year_selected."-".$monthNumber."-".$day_selected;
			if($date!="")
			{
		        //csv file name
		        $filename = 'referral_income_'.$date.'.csv';

        		header("Content-Description: File Transfer");
        		header("Content-Disposition: attachment; filename=$filename");
        		header("Content-Type: application/csv; "); 

		        $usersData = $this->New_database->get_referral_income_datewisedata1($date);
              
		        $file = fopen('php://output', 'w');
		        $header = array("Sr. No.","Income Level","Income Member Name / Username","Income Member By / Username","Order ID","Income","Package","Percentage","Date");
		        fputcsv($file, $header);
		        $i=1;
		        foreach ($usersData as $key=>$line)
		        {
		          
		          
		            $line = array(
    									'income_id'      	  =>$i,	 
    									'income_level'  	  =>$line->income_level,
    									'income_member_id'	  =>getSponsor($line->income_member_id)." / ".getMemberLoginID($line->income_member_id),
    									'income_member_by'    =>getSponsor($line->income_member_by)." / ".getMemberLoginID($line->income_member_by),
    									'order_id'  	      =>$line->order_id, 
    									'income_amount' 	  =>$line->income_amount, 							
    									'package_amount' 	  =>$line->package_amount, 
    									'income_percentage'   =>$line->income_percentage,	  
    									'income_date'         =>$line->income_date
    									 ); 
		           $i++;
		          fputcsv($file, (array) $line);
                }
                fclose($file);
		        exit;
	       }
		}
        $data['months'] = $this->config->item('months');
        $this->load->view('new_admin/includes/template',$data); 
 	}
 		public function bank_details()
 	{
 		$data['page_title']   = "View Bank Details";
 		$data['main_content'] = "new_admin/bank_details";  
        
        if($this->input->post("btn_submit"))
		{ 
		  
			$day_selected=$this->input->post("day_selected");
			$month_selected=$this->input->post("month_selected");
			$year_selected=$this->input->post("year_selected");
			$monthNumber = date_parse(date('Y') . '-' . $month_selected)['month'];
            if (strlen($monthNumber) == 1) 
            {
                $monthNumber = "0" . $monthNumber;
            }
          
			if($day_selected!='All')
			{
		        $date = $year_selected."-".$monthNumber."-".$day_selected;

				$data['income'] = $this->New_database->get_referral_income_bank_datewisedata($date);
				 //echo $this->db->last_query();die;
				$data['day_selected']=$day_selected;
				$data['month_selected']=$month_selected;
				$data['year_selected']=$year_selected;
			}
			else
			{
				// $data['income'] = $this->Epin_model->get_referral_income_bank_data();
				$data['income'] =array();
				$data['day_selected']='All';
    			$data['month_selected']='All';
    			$data['year_selected']='All';
			}
			
		}

		else
		{
		  //  $data['income'] = $this->Epin_model->get_referral_income_bank_data();
		    $data['income'] =array();
			$data['day_selected']='All';
			$data['month_selected']='All';
			$data['year_selected']='All';
		}	
		
		
		if($this->input->post("csv_submit"))
		{ 
		 
			$day_selected=$this->input->post("day_selected");
			$month_selected=$this->input->post("month_selected");
			$year_selected=$this->input->post("year_selected");
			$monthNumber = date_parse(date('Y') . '-' . $month_selected)['month'];
            if (strlen($monthNumber) == 1) 
            {
                $monthNumber = "0" . $monthNumber;
            }
          
		    $date = $year_selected."-".$monthNumber."-".$day_selected;
			if($date!="")
			{
		        //csv file name
		        $filename = 'referral_income_bank_details_'.$date.'.csv';

        		header("Content-Description: File Transfer");
        		header("Content-Disposition: attachment; filename=$filename");
        		header("Content-Type: application/csv; "); 

		        $usersData = $this->New_database->get_referral_income_bank_datewisedata($date);
                // print_r($usersData);die;
	            // file creation
		        $file = fopen('php://output', 'w');
		        $header = array("Sr. No.","Income Member Name / Username","Account Holder Name","Account No","Bank Name","IFSC Code","Total Amount","Date");
		        fputcsv($file, $header);
		          $i=1;
		        foreach ($usersData as $key=>$line)
		        {
		          // print_r($line);
		          // echo $line->income_member_id;die;
		          $bank= get_bank_detailsByid($line->income_member_id);
		    
		      if($bank==null || empty($bank))
		      {
		          $member_account_name="Not Available";
		          $member_account_no="Not Available";
		          $member_bank_name="Not Available";
		          $member_ifsc_code="Not Available";
		      }
		      else
		      {
		          $member_account_name=$bank->member_account_name;
		          $member_account_no=$bank->member_account_no;
		          $member_bank_name=$bank->member_bank_name;
		          $member_ifsc_code=$bank->member_ifsc_code;
		      }
		    
		            $line = array(
    									'income_id'      	  =>$i,	
    									'income_member_id'	  =>getSponsor($line->income_member_id)." / ".getMemberLoginID($line->income_member_id),
    									'acc_holder_name'     =>$member_account_name,
    									'acc_no'                =>$member_account_no,
    									'bank_name'           =>$member_bank_name,
    									'ifsc_code'           =>$member_ifsc_code,
    								
    									'total_income' 	  =>$line->total_income, 		  
    									'income_date'         =>$line->income_date
    									 ); 
		           $i++;
		          fputcsv($file, (array) $line);
                }
                fclose($file);
		        exit;
	       }
		}
        // echo $this->db->last_query();die;
        
        $data['months'] = $this->config->item('months');
        $this->load->view('new_admin/includes/template',$data); 
 	}
 			public function income_bk_details()
 	{
 		$data['page_title']   = "View Income Details";
 		$data['main_content'] = "new_admin/income_details";  
 		$id = $this->uri->segment(3);
        $data['members'] = $this->New_database->get_level_income($id);
 
        $this->load->view('new_admin/includes/template',$data); 
 	}
 		public function ticket_support()
	{
		$data['page_title'] = "Support Ticket";
		$data['main_content'] = "new_admin/ticket_support";

		if (isset($_POST['search'])) 
 		{
 			$from_date =''; $to_date   ='';
 			$from_date =  $this->input->post('from_date');   
 			$to_date   =  $this->input->post('to_date');        
 			
 			$data['from_date'] = $this->input->post('from_date');
 			$data['to_date']   = $this->input->post('to_date'); 

 			$data['members_data'] = $this->New_database->get_tickets_data($from_date,$to_date);   
 		} 
 		else
 		{
 		  $data['from_date']=''; 
 		  $data['to_date']='';		
 		  $data['members_data'] = $this->New_database->get_tickets_data($from_date='',$to_date='');		 
 		} 

		$this->load->view('new_admin/includes/template',$data);
	}
		public function ticket_reply()
	{
		$reply = $this->input->post('ticket_reply');
		$id = $this->input->post('ticket_id');

		if ($id!='' && $reply!='') 
		{
			$ar = array('ticket_reply' =>$reply,'ticket_status'=>'Replied');
			$this->db->where('ticket_id',$id);
			$this->db->update('ticket_support',$ar);

			$this->session->set_flashdata('success', 'Ticket reply send successful.');
			redirect('Mlm_new/ticket_support');
		}
	}
		public function add_daily_news()
	{
		$data['page_title'] = "Add Daily News";
		if(isset($_POST['submit']))
		{
			$this->form_validation->set_rules('news_title','News Title', 'trim|required');  
			$this->form_validation->set_rules('news_details','News Description', 'trim|required');  
 
			if ($this->form_validation->run() == TRUE)
			{
				$newsData = array('news_title' =>$this->input->post('news_title'), 
									'news_details' =>$this->input->post('news_details'), 
									 'news_date'=>date('Y-m-d')
									); 
				$insert = $this->db->insert('isp_dailynews',$newsData); 

				if($insert)
				{
					$this->session->set_flashdata('success','News Added Successfully');
				}
				else
				{
					$this->session->set_flashdata('fail','Something Went wrong, Please Try again later');
				}
				redirect('Mlm_new/dailynews'); 
			}
			else
			{
				$this->session->set_flashdata('fail',validation_errors());
				redirect('Mlm_new/add_daily_news');
			}
		}
		$data['main_content'] = "new_admin/add_dailynews";
		$this->load->view('new_admin/includes/template',$data);
	}
		public function dailynews_change_status()
	{
		$status = $this->uri->segment('3');
		$id = $this->uri->segment('4');
		if($id!='' && $status!='')
		{
			$this->db->where('news_id',$id);
			$this->db->update('isp_dailynews',array('status'=>$status));
			redirect('Mlm_new/dailynews');
		}
	}
	public function dailynews_delete()
	{
		$id = $this->uri->segment('3');
		if($id!='')
		{
			$this->db->where('news_id',$id);
			$this->db->update('isp_dailynews',array('status'=>'deleted'));
			redirect('Mlm_new/dailynews');
		}
	}
	public function change_password()
	{
		$data['page_title'] = "Change Password";
		$data['main_content'] = "new_admin/change_password";

	 	$adminData =$this->session->userdata('mlm_new_logged_in'); 
		$adminId   = $adminData['admin_id']; 
   	
   		if (isset($_POST['change-pwd']))
   		{  
   		
		    $this->form_validation->set_rules('old_password', 'old password', 'required');  
			$this->form_validation->set_rules('new_password', 'new password', 'required');  
			//$this->form_validation->set_rules('con_password', 'Confirm Password', 'required|matches[new_password]'); 

			if ($this->form_validation->run() == TRUE)
			{ 
				$data['old_password'] = md5($this->input->post('old_password'));
				// echo $data['old_password'];die;
				$data['admin_id']    = $adminId;

				$result = $this->New_database->check_password($data);
			 //print_r($result);die;
				if (!empty($result))
				{
				  	$pass_data = array('admin_login_password' => md5($this->input->post('new_password')) );
				  	 
				  	$this->New_database->change_password($adminId,$pass_data);
				  	
				//   	$password=$this->input->post('new_password');
				//   	$msg ='Admin Password Change successfully Your New Password is, '.$password .' ';
				//   	$mobile ='9022889743';	
				//   	$this->Home_model->send_sms($mobile,$msg);
				  	
				  	$this->session->set_flashdata('pass_message','Password changed success'); 
				}
				else
				{
				  	$this->session->set_flashdata('pass_eror','Old Password not macth'); 
				 
				}
			}
		}	
		$this->load->view('new_admin/includes/template',$data);
	}
	public function logout() 
	{
		// Removing session data
		$sess_array = array(
		'username' => ''
		);
		$this->session->unset_userdata('mlm_new_logged_in', $sess_array);
		$data['message_display'] = 'Successfully Logout';

		$this->session->set_flashdata('logout_message', 'Logout Successfully');
		redirect('Mlm_new');
		//$this->load->view('index', $data);
	}
		public function dailynews()
	{
		$data['page_title'] = "Daily News List";
		 
		$data['dailynews'] = $this->db->get_where('isp_dailynews',array('status !='=>'deleted'))->result();
		$data['main_content'] = "new_admin/daily_news_list";
		$this->load->view('new_admin/includes/template',$data);
	}
	
    public function roi_update()
	{
		$pid = $this->input->post('packId');
		$roiPerc = $this->input->post('roiPerc');

		$this->db->where('package_id',$pid);
		$this->db->set('package_ROI_percentage',$roiPerc);
		$this->db->update('pckages');
	}
	 public function inc_percent()
	{
			$data['page_title'] = "Level Income Percentage";
		 
		$data['percent'] = $this->db->get_where('isp_level_inc_percent',array('status !='=>'Deleted'))->result();

		$data['main_content'] = "new_admin/inc_percent";
		$this->load->view('new_admin/includes/template',$data);
	}
	public function update_new()
    {

         $pid = $this->input->post('id');
      // $data = $this->input->post('rating');
     
         $data = array( 
                'income_percent'   => $this->input->post('rating'),
                );
                
      
        $this->db->set($data);
        $this->db->where('id', $pid); 
        $this->db->update('isp_level_inc_percent');
        

    }
	public function backup_db(){
		
		$this->load->helper('url');	
		$this->load->helper('file');	
		$this->load->helper('download');	
		$this->load->library('zip');	
		$this->load->dbutil();		
		$db_format=array('format'=>'zip','filename'=>'my_db_backup.sql');	
		$backup=& $this->dbutil->backup($db_format);
		$dbname='backup-on-'.date('Y-m-d').'.zip';		
		$save=base_url().'assets/db/'.$dbname;	
		write_file($save,$backup);		
		force_download($dbname,$backup);	
	}
	public function install(){

		$this->load->library('GoogleAuthenticator');
		
		$data['page_title'] = "Google Authentication";
		
		$gaobj = new GoogleAuthenticator();
        //$secret = $gaobj->createSecret();
		$secret = "MD6KIZ57ELMIPFCF";
		$name ="http://www.tanishqhelp.com";
		$res = $gaobj->getQRCodeGoogleUrl($name, $secret, $title = null, $params = array());
		$data['qrcode']=$res;
		
		$this->load->view('admin/google-authentication', $data);
	}
	 public function verify_kyc_members()
 	{
 		$data['page_title']   = "View Members Details";
 		$data['main_content'] = "admin/verify_kyc_members";
 		$member_id            = $this->uri->segment(3);
        $data['network_data'] = $this->New_database->get_member_network_data($member_id);  		

 			
 		$data['members_details'] = $this->New_database->get_members($member_id);
		$this->load->view('admin/includes/template',$data); 
 	}
}