<?php
Class Epin_model extends CI_Model
{
   public  function __construct()
	{
		parent::__construct();
		 $this->tableName3 = 'isp_order';
	} 
	public function insert3($data = array()){
        if(!array_key_exists("added_date",$data)){
            $data['added_date'] = date("Y-m-d H:i:s");
        }
        if(!array_key_exists("modified_date",$data)){
            $data['modified_date'] = date("Y-m-d H:i:s");
        }
        $insert = $this->db->insert($this->tableName3,$data);
        
        if($insert){
            return $this->db->insert_id();
        }else{
            return false;    
        }
    }
    	public function insert4($data = array()){
        if(!array_key_exists("added_date",$data)){
            $data['added_date'] = date("Y-m-d H:i:s");
        }
        if(!array_key_exists("modified_date",$data)){
            $data['modified_date'] = date("Y-m-d H:i:s");
        }
        $insert = $this->db->insert('mg_customer_order',$data);
        
        if($insert){
            return $this->db->insert_id();
        }else{
            return false;    
        }
    }
	public function get_epin_request($filters)
	{
		$this->db->select('epin_request.*,isp_members.member_name,isp_members.member_login_id');
		$this->db->from('epin_request');
		$this->db->join('isp_members','epin_request.request_member_id = isp_members.member_id');
		//$this->db->where('epin_request.request_status!=','Cancel');
        if (!empty($filters))
        {
          $this->db->where('epin_request.request_status',$filters);
        }
        $this->db->order_by('epin_request.request_status','Pending');
        $this->db->order_by('epin_request.request_date','DESC');
		$result = $this->db->get();
		return $result->result();
	}
	  public function getData($table, $where,$orderBy)
    {
      
        $this->db->select('*');
        $this->db->from($table);
        if ($where!='') 
        { 
            $this->db->where($where);
        }
       if ($orderBy!='') 
        { 
            $this->db->order_by($orderBy);
        }
        
        $query = $this->db->get();
        $result = $query->result();
        return $result;
    }
	public function cancel_request($id)
	{
		$this->db->where('request_id=',$id);
	 	$this->db->update('epin_request',array('request_status'=>'Cancel'));	 	
	 	if ($this->db->affected_rows() > 0) 
	 	{
	 		return true;
	 	}
	 	else
	 	{
	 		return false;
	 	}
	}
	public function get_quantity($id)
	{
		$this->db->select('epin_request.*');
		$this->db->from('epin_request');
		$this->db->where('request_id',$id);
		$result = $this->db->get();
		return $result->row();
	}
    
    public function get_epin_count($id)
    {
        $this->db->select('count(epin_id) as total_epins');
        $this->db->from('epin');
        $this->db->where('epin_member_id',$id);
        $this->db->where('epin_member_id',$id);
        $result = $this->db->get();
        //echo $this->db->last_query(); die;
        return $result->result();
    }
	function update($data,$conditions,$tablename="")
	{
		if($tablename=="")
		$tablename = $this->table;
		$this->db->where($conditions);
		$this->db->update($tablename,$data);
		return $this->db->affected_rows();
	}
		function set_payment_status($data)
	{
$this->db->where('member_id', $data);
$this->db->set('payment_status', 'complete');
$this->db->set('member_status', 'Approve');
$this->db->update('isp_members');
return $this->db->affected_rows();
	
	}
	function select_single_row($table, $where)
	{
		$this->db->select('*');
		$this->db->from($table);
		$this->db->where($where);
		$query = $this->db->get();
		$result = $query->row();
		return $result;
	}
    function insertData( $table )
    {
        $fields = $this->db->list_fields( $table );
        $data = array();
        foreach ( $fields as $field )
        {
            if (isset($_POST[$field]))
			{
                $data[$field]= $this->input->post($field);
                if (is_array($_POST[$field])) 
				{
				 $data[$field] = implode( ',',array_map('strtolower',$this->input->post($field)) );
				}
				else
				{
					$data[$field]= $this->input->post($field);
				}
            }
        }
        $result=$this->db->insert($table, $data);
		return $result;
    }

    public function get_epin_data()
    {	 
    	$this->db->select('epin.*,isp_members.member_name,isp_members.member_title');
    	$this->db->from('epin');
        $this->db->join('isp_members','isp_members.member_epin_id = epin.epin_id'); 
    	$this->db->where('epin_status','Used');
    	$this->db->order_by('epin.epin_member_id', 'desc'); 
    	$q = $this->db->get();
    	return $q->result();  
    }
    public function get_unused_epin_data()
    {	 
    	$this->db->select('epin.*,isp_members.member_name,isp_members.member_title');
    	$this->db->from('epin');
    	$this->db->join('isp_members','isp_members.member_id = epin.epin_member_id');  
    	$this->db->where('epin_status','Unused');
    	$this->db->order_by('epin.epin_member_id', 'desc'); 
    	$q = $this->db->get();
    	return $q->result();  
    }

    public function get_isp_members($member_id)
    {  
        $this->db->select('*');
        $this->db->from('isp_members'); 
        if (!empty($member_id)) 
        {
          $this->db->where('member_id',$member_id);
        } 
        $q = $this->db->get();
        return $q->result();  
 
    } 

    public function get_isp_members_stage($stage) 
    {  
        $this->db->select('count(r.re_entry_id) as stage_level ,m.*,r.*');
        $this->db->from('re_entry r,isp_members m');
        $this->db->where('m.member_id = r.member_id');  
        $this->db->where('r.re_entry_stage',$stage); 
        $this->db->group_by('r.member_id');   
        $q = $this->db->get();
        return $q->result();  
    }


    
    public function get_isp_members_login_id($id)
    {	 
    	$this->db->select('member_name,member_mobile,member_id');
    	$this->db->from('isp_members'); 
    	$this->db->where('member_login_id',$id);
    	$q = $this->db->get();
        //echo $this->db->last_query(); die;
    	if($q->num_rows()>0)
    	{
    		return $q->result();  
    	}
    	else
    	{
    		return false;
    	}
    }


    public function get_isp_members_search($from_date,$to_date,$status,$type)
    {    
        $query = $this->db->query("SELECT * FROM isp_members WHERE member_status = '$status' AND is_paid='$type'
                                                                AND DATE(member_added_date) >= DATE('$from_date') 
                                                                AND DATE(member_added_date) <= DATE('$to_date') 
                                                                OR DATE(member_added_date) = DATE('$from_date')
                                                                OR DATE(member_added_date) = DATE('$to_date') ");  

        return $query->result();  
    }


    public function get_member_epin_request($member_id)
    {
        $this->db->select('epin_request.*,isp_members.member_name,isp_members.member_title');
        $this->db->from('epin_request');
        $this->db->join('isp_members','epin_request.request_member_id = isp_members.member_id');
        $this->db->where('epin_request.request_member_id',$member_id);
        $result = $this->db->get();
        return $result->result();
    }

     public function get_member_epin_data($member_id,$status)
    {    
        $this->db->select('epin.*,isp_members.member_name,isp_members.member_title');
        $this->db->from('epin');
        $this->db->join('isp_members','isp_members.member_id = epin.epin_member_id');  
        $this->db->where('epin_status',$status);
        $this->db->where('epin.epin_member_id',$member_id);
        $this->db->order_by('epin.epin_member_id', 'desc'); 
        $q = $this->db->get();
        return $q->result();  
    }

    public function get_member_transfer_epin($member_id)
    {
        $this->db->select('epin.*,isp_members.member_name,isp_members.member_title,isp_members.member_epin_id,count(*) as tot_transfer');
        $this->db->from('epin');
        $this->db->join('isp_members','isp_members.member_id = epin.epin_member_id'); 
        $this->db->where('epin.old_epin_member_id',$member_id);
        $this->db->order_by('epin.epin_member_id', 'desc'); 
        $this->db->group_by('epin.epin_member_id');
        $q = $this->db->get();
        return $q->result();
    }

    public function get_member_network_data($member_id)
    {
        $this->db->select('member_id,member_login_id,member_name,member_added_date,member_mobile');
        $this->db->from('isp_members'); 
        $this->db->where('member_sponsored',$member_id);
        // $this->db->order_by("name", "asc");
        //$this->db->where('member_downline_id !=','0');
        $q = $this->db->get();
        return $q->result();
    }
      public function get_member_regi($member_id)
    {
        $this->db->select('*');
        $this->db->from('isp_members'); 
        $this->db->where('member_id',$member_id);
        $q = $this->db->get();
        return $q->result();
    }
    public function get_membernetworkdata($member_id)
    {
      	
		$this->db->select('level_member_id');
		$this->db->from('roi_upline_level'); 
		$this->db->where('level_'.$level_no,$member_id);
		//$this->db->where('member_downline_id !=','0');
		$q = $this->db->get();
		$memb = $q->result_array();
// echo $this->db->last_query();die;
		
		if($memb)
		{

  foreach($memb as $result){
   $ids[]=$result['level_member_id'];
  }

		$this->db->select('member_id,member_login_id,member_name,member_added_date,member_mobile,member_email_id,member_package_id,member_upline_id,member_active_date');
		$this->db->from('isp_members'); 
		$this->db->where_in('member_id',$ids);
		$q = $this->db->get();
		$memb1 = $q->result();

	}
	else
	{
		$memb1=null;
	}

	
		return $memb1;
		

		
	
    }

    public function get_member_re_entry_data($member_id)
    {
        $this->db->select('*');
        $this->db->from('re_entry'); 
        $this->db->where('member_id',$member_id); 
        $q = $this->db->get();
        return $q->result();
    }

    public function get_search_epin_data($from_date,$to_date)
    {    
        $query = $this->db->query("SELECT * FROM isp_epin WHERE epin_status ='Used'
                                                                AND DATE(epin_added_date) >= DATE('$from_date') 
                                                                AND DATE(epin_added_date) <= DATE('$to_date') 
                                                                OR DATE(epin_added_date) = DATE('$from_date')
                                                                OR DATE(epin_added_date) = DATE('$to_date') ");  
        return $query->result(); 
    }
 public function get_transfer_list()
	{
	
		
		$this->db->select('COUNT(`history_id`) as total,transfer_to ,transfer_from ,transfer_date,epin_id');
		$this->db->from('epin_history'); 		
		$this->db->order_by('transfer_date','desc');
		$this->db->group_by('DATE(transfer_date)');
		$this->db->group_by('transfer_to');			
		$q = $this->db->get();		
		return $q->result();
	}
	 public function get_requested()
	{
	
		
		$this->db->select('*');
		$this->db->from('request_epin'); 		
	    $q = $this->db->get();
	   
		return $q->result();
	}
	   
    public function get_isp_members_data($conditions)
    {  
        $this->db->select('*');
        $this->db->from('isp_members'); 
        if ($conditions!='') 
        {
          $this->db->where($conditions);
        } 
        $this->db->order_by('member_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    }  
    public function get_kyc_isp_members_data()
    {  
        // array('kyc_status'=>'Under_process','member_is_verify'=>'No');
         $where = "member_is_verify='No' AND (kyc_status='Under_process' OR kyc_status='Pending' )";
        $this->db->select('*');
        $this->db->from('isp_members'); 
        $this->db->where($where);
        $this->db->order_by('member_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    }  
    public function view_kyc_members()
    {  
        // array('kyc_status'=>'Under_process','member_is_verify'=>'No');
         $where = "member_is_verify='No' AND (member_type='member' OR member_type='admin_member' ) AND member_status='Pending' AND kyc_status='Under_process' AND is_paid='No'";
        $this->db->select('*');
        $this->db->from('isp_members'); 
        $this->db->where($where);
        $this->db->order_by('member_id','desc');
        $q = $this->db->get();
        //echo $this->db->last_query();die;
        return $q->result();  
 
    }  
     public function get_view_isp_members_data()
    {  
        $this->db->select('*');
        $this->db->from('isp_members'); 
        // if($conditions!='') 
        // {
        //   $this->db->where($conditions);
        // } 
        // $this->db->where($conditions);
        //  $this->db->where('member_type','member');
        $this->db->where('is_paid','Yes');
        $this->db->where('member_status','Approve');
        $where = '(member_type="member" or member_type = "admin_member")';
        $this->db->where($where);
        $this->db->order_by('member_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    }  
     public function get_daily_income_data()
    {  
        $this->db->select('*');
        $this->db->from('roi_wallet'); 
        $this->db->order_by('roi_wallet_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    }  
     public function get_daimond_income_data()
    {  
        $this->db->select('*');
        $this->db->from('diamond_bonus'); 
       
        $this->db->order_by('diamond_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    }  
     public function get_global_income_data()
    {  
        $this->db->select('*');
        $this->db->from('global_income'); 
        $this->db->order_by('global_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    } 
    public function get_leadership_bonus_data()
    {  
        $this->db->select('*');
        $this->db->from('leadership_bonus'); 
        $this->db->order_by('leadership_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    }  
    public function get_reinvestment_data()
    {  
        $this->db->select('*');
        $this->db->from('isp_roi_withdrawal_request'); 
        $where = '(withdrawal_request_type="Reinvestment" or withdrawal_request_type = "Reinvestment-Staking")';
        $this->db->where($where);
        $this->db->order_by('roi_withdrawal_request_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    }  
     public function get_referral_income_with_level_data($level_no)
    {  
        $this->db->select('*');
        $this->db->from('isp_level_income'); 
        $this->db->where('income_level',$level_no);
        $this->db->order_by('income_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    }  
    
    public function get_memberpackage_data()
    {	 
    	$this->db->select('member_packages.*,isp_members.*');
    	$this->db->from('member_packages');
        $this->db->join('isp_members','isp_members.member_id = member_packages.member_id'); 
    	$this->db->where('member_packages.payment_status','pending');
    	$this->db->order_by('member_packages.member_packageid', 'desc'); 
    	$q = $this->db->get();
    //  	echo $this->db->last_query();
    	return $q->result();  
    }
    public function get_package_data($member_packageid)
    {	 
    	$this->db->select('member_packages.*,isp_members.*');
    	$this->db->from('member_packages');
        $this->db->join('isp_members','isp_members.member_id = member_packages.member_id'); 
    	$this->db->where('member_packages.member_packageid',$member_packageid);
    	$this->db->order_by('member_packages.member_packageid', 'desc'); 
    	$q = $this->db->get();
    	return $q->result();  
    }
    public function get_search_isp_members_data($conditions,$from_date,$to_date)
    {  
        $this->db->select('*');
        $this->db->from('isp_members'); 
        if ($conditions!='') 
        {
          $this->db->where($conditions);
        } 

        if ($from_date && $to_date=='') 
        {
             $from_date= $from_date.' 00:00:00';
             $this->db->where('member_added_date >=',$from_date); 
        }
       if ($from_date=='' && $to_date) 
        {
            $to_date  = $to_date.' 23:59:55';
            $this->db->where('member_added_date <=',$to_date); 
        }
        if ($from_date && $to_date) 
        {
            $from_date= $from_date.' 00:00:00';
            $to_date  = $to_date.' 23:59:55';
              
            $this->db->where('member_added_date >=',$from_date); 
            $this->db->where('member_added_date <=',$to_date); 
        }

        $q = $this->db->get();
        return $q->result();   
    } 

    
    public function get_member_donation_data($where)
    {
        $this->db->select('*');
        $this->db->from('donations');  
        if($where)
        {        
            $this->db->where($where);   
        }
        $q = $this->db->get();
        return $q->result();
    }

    public function get_member_package_data($member_id)
    {
        $this->db->select('pckages.*');
        $this->db->from('pckages');
        $this->db->join('isp_members','isp_members.member_package_id=pckages.package_id');
        $this->db->where('isp_members.member_id',$member_id); 
        $q = $this->db->get();
        return $res = $q->row(); 
    }
    
     public function get_memberpackagedata($member_id)
    {
        $this->db->select('member_packages.*');
        $this->db->from('member_packages');
    
        $this->db->where('member_packages.member_id',$member_id); 
        $q = $this->db->get();
        return $res = $q->row(); 
    }
    public function get_donor_isp_members($package_id)
    { 
        $this->db->select('*');
        $this->db->from('isp_members'); 
        $this->db->join('donations','donations.donate_by=isp_members.member_id'); 
        if ($package_id) {
            $this->db->where('isp_members.member_package_id',$package_id);  
        }
        $this->db->where('isp_members.member_status','Approve');  
        $this->db->where('donations.donate_plan !=','member');  
        $this->db->where('donations.donate_status','paid');  
        $this->db->group_by('isp_members.member_id');  
        $q = $this->db->get();
 
        return $res = $q->result(); 
    }

    public function get_donation_to_isp_members()
    {
        $this->db->select('*');
        $this->db->from('isp_members'); 
        $this->db->join('donations','donations.donate_by=isp_members.member_id');  
        $this->db->where('isp_members.member_status','Approve');    
        $this->db->where('donations.donate_status','paid'); 
        $this->db->where('donations.donate_plan','member'); 
        $this->db->group_by('isp_members.member_id');  
        $q = $this->db->get(); 
        $all_app = $q->result(); 
        
        if ($all_app) 
        {             
            return $all_app;
        }
        else
        {
            $this->db->select('*');
            $this->db->from('isp_members'); 
            $this->db->where('member_type','admin_member'); 
            $this->db->where('member_status','Approve'); 
            $this->db->order_by('member_id','ASC'); 
            $this->db->limit('1'); 
            $q = $this->db->get();
            return $q->result();
        }
    }

    /*public function get_donation_receiver_isp_members($package_id)
    {
        $this->db->select('isp_members.member_payment_days_count,isp_members.member_type,isp_members.member_id,isp_members.member_name,isp_members.member_login_id,isp_members.member_password,isp_members.member_package_id');
        $this->db->from('isp_members'); 
        $this->db->join('donations','donations.donate_by=isp_members.member_id');  
        $this->db->where('isp_members.member_status','Received');    
        $this->db->where('donations.donate_status','paid'); 
        $this->db->where('donations.donate_plan','member'); 
         $this->db->where('isp_members.member_package_id',$package_id);
        $this->db->group_by('isp_members.member_id');  
        $q = $this->db->get(); 
        $all_isp_members = $q->result();

        $this->db->select('isp_members.member_payment_days_count,isp_members.member_type,isp_members.member_id,isp_members.member_name,isp_members.member_login_id,isp_members.member_password,isp_members.member_package_id');
        $this->db->from('isp_members'); 
        $this->db->where('member_type','admin_member'); 
        $this->db->where('member_status','Approve'); 
        $this->db->where('member_package_id',$package_id); 
        $this->db->order_by('member_id','ASC'); 
        $this->db->limit('1'); 
        $a = $this->db->get();
        $all_admins = $a->row();

        $admins = array();
        $isp_members = array();

        if ($all_isp_members=='') 
        { 
            return $admins = array('member_name' =>$all_admins->member_name,
                                   'member_login_id' =>$all_admins->member_login_id, 
                                   'member_password' =>$all_admins->member_password, 
                                   'member_type' =>$all_admins->member_type, 
                                   'member_package_id' =>$all_admins->member_package_id, 
                                   'member_id' =>$all_admins->member_id, 
                                  );
        }else{ 
            foreach ($all_isp_members as $key) 
            {
                 for ($i=1; $i <=$key->member_payment_days_count ; $i++) 
                 { 
                     $isp_members[] = array('member_name' =>$key->member_name,
                                   'member_login_id' =>$key->member_login_id, 
                                   'member_password' =>$key->member_password, 
                                   'member_type' =>$key->member_type, 
                                   'member_package_id' =>$key->member_package_id, 
                                   'member_id' =>$key->member_id, 
                                  );
                 }
            }

            $admins[] = array('member_name' =>$all_admins->member_name,
                           'member_login_id' =>$all_admins->member_login_id, 
                           'member_password' =>$all_admins->member_password, 
                           'member_type' =>$all_admins->member_type, 
                           'member_package_id' =>$all_admins->member_package_id, 
                           'member_id' =>$all_admins->member_id, 
                          );
 
            return array_merge($admins,$isp_members); 
        }         
    }*/

    /*public function get_donation_receiver_isp_members($package_id)
    {
        $today = date('Y-m-d'); 
        $sql = 'SELECT isp_members.member_payment_days_count,isp_members.member_type,isp_members.member_id,isp_members.member_name,isp_members.member_login_id,isp_members.member_password,isp_members.member_package_id 
                FROM isp_members as isp_members 
                INNER JOIN isp_donations as donations ON isp_members.member_id = donations.donate_by 
                WHERE isp_members.member_package_id='.$package_id.' 
                      AND isp_members.member_status="Received" 
                      AND DATE(donations.donate_assign_date) !="'.$today.'" 
                GROUP BY isp_members.member_id';
        $query = $this->db->query($sql);
        $all_isp_members = $query->result();         
         
        $this->db->select('isp_members.member_payment_days_count,isp_members.member_type,isp_members.member_id,isp_members.member_name,isp_members.member_login_id,isp_members.member_password,isp_members.member_package_id');
        $this->db->from('isp_members'); 
        $this->db->where('member_type','admin_member'); 
        $this->db->where('member_status','Approve'); 
        $this->db->where('member_package_id',$package_id); 
        $this->db->order_by('member_id','ASC'); 
        $this->db->limit('1'); 
        $a = $this->db->get();
        $all_admins = $a->result(); 

        if ($all_isp_members==''){  
            $l = $all_admins;
        }else{   
            $l = array_merge($all_admins,$all_isp_members); 
        }      
         
        return $l;  
    }*/

    public function get_donation_receiver_isp_members()
    {
        $this->db->select('*');
        $this->db->from('isp_members'); 
        $this->db->join('roi_withdrawal_request','roi_withdrawal_request.member_id=isp_members.member_id');  
        $this->db->where('isp_members.member_status','Received');    
        $this->db->where('roi_withdrawal_request.withdrawal_status','pending');  
        $query = $this->db->get();   
        $all_isp_members = $query->result();         
         
        $this->db->select('isp_members.member_payment_days_count,isp_members.member_type,isp_members.member_id,isp_members.member_name,isp_members.member_login_id,isp_members.member_password,isp_members.member_package_id');
        $this->db->from('isp_members'); 
        $this->db->where('member_type','admin_member');  
        $this->db->order_by('member_id','ASC'); 
        $this->db->limit('1'); 
        $a = $this->db->get();
        $all_admins = $a->result(); 

        if ($all_isp_members==''){  
            $l = $all_admins;
        }else{   
            $l = array_merge($all_admins,$all_isp_members); 
        }      
         
        return $l;  
    }


    public function checkAlreadyAssigned($id)
    { 
        $today = date('Y-m-d'); 
        $sql = "SELECT * FROM `isp_donations` WHERE `donate_plan` = 'member' AND `donate_to` = '$id' AND DATE(`donate_assign_date`) = '$today'";
        $query = $this->db->query($sql);

        if ($query->num_rows() > 0) {
            return 1;
        } else {
            return 0;
        } 
    }

    public function get_receiversData()
    {
		$this->db->select('*');
        $this->db->from('isp_members'); 
        $this->db->join('roi_withdrawal_request','roi_withdrawal_request.member_id=isp_members.member_id'); 
        $this->db->where('isp_members.member_status','Received');  
        $this->db->where('roi_withdrawal_request.withdrawal_status','pending');  
        $q = $this->db->get();
        return $res = $q->result(); 
    }
	public function get_donarData()
    {
        $this->db->select('*');
        $this->db->from('isp_members'); 
        $this->db->where('member_status','Approve');  
        $this->db->where('member_type','member');  
        $q = $this->db->get();
        return $res = $q->result(); 
    }
	public function get_receivers_isp_members($package_id)
    {
        $this->db->select('*');
        $this->db->from('isp_members'); 
        $this->db->join('donations','donations.donate_by=isp_members.member_id'); 
        if ($package_id) {
            $this->db->where('isp_members.member_package_id',$package_id);  
        }    
        $this->db->where('isp_members.member_status','received');  
        $this->db->group_by('isp_members.member_id');  
        $q = $this->db->get();
 
        return $res = $q->result(); 
    }
	public function get_total_receivers_amount()
    {
		$this->db->select('sum(withdrawal_request_amount) as totalReciev, count(roi_withdrawal_request_id) as count');
        $this->db->from('isp_members'); 
        $this->db->join('roi_withdrawal_request','roi_withdrawal_request.member_id=isp_members.member_id'); 
        $this->db->where('isp_members.member_status','Received');  
        $this->db->where('roi_withdrawal_request.withdrawal_status','pending');  
        $q = $this->db->get();
        return $res = $q->row();
    }
	public function get_total_donar_amount()
    { 
       /* $ this->db->select('*');
        $this->db->from('isp_members'); 
        $this->db->join('donations','donations.donate_by=isp_members.member_id'); 
        $this->db->where('isp_members.member_status','Approve');  
        $this->db->where('donations.donate_plan !=','member');  
        $this->db->where('donations.donate_status','paid');  
        $this->db->group_by('isp_members.member_id');  
        $q = $this->db->get();
 
        return $res = $q->result();  */
		
		$this->db->select('sum(member_member_amount) as totalAmount,count(member_id) as count');
        $this->db->from('isp_members'); 
        $this->db->where('member_status','Approve');  
        $this->db->where('member_type','member');  
        $q = $this->db->get();
        return $res = $q->row(); 
		
		
    }

    public function get_eentry_donor_isp_members()
    { 
        $this->db->select('reentry_isp_members.*');
        $this->db->from('reentry_isp_members'); 
        $this->db->join('donations','donations.donate_by=reentry_isp_members.member_id'); 
        $this->db->where('reentry_isp_members.member_status','Approve');  
        $this->db->where('donations.donate_type','Reentry');  
        $this->db->where('donations.donate_status','paid');  
        $this->db->group_by('reentry_isp_members.member_id');  
        $q = $this->db->get();
        $res = $q->result(); 
        /*echo "<pre>";
        print_r($res); die();*/
        return $res;
    }

     public function get_reentry_member_package_data($member_id)
    {
        $this->db->select('pckages.*');
        $this->db->from('pckages');
        $this->db->join('reentry_isp_members','reentry_isp_members.member_package_id=pckages.package_id');
        $this->db->where('reentry_isp_members.member_id',$member_id); 
        $q = $this->db->get();
        return $res = $q->row(); 
    }

    public function getused_epins()
    {    
        $this->db->select('epin.*');
        $this->db->from('epin');
        //$this->db->join('epin_center','epin_center.center_id = epin.epin_member_id');  
        //$this->db->where('epin_status','used');
        $this->db->order_by('epin.epin_id', 'desc'); 
        $q = $this->db->get();
        return $q->result();  
    }
    
  
    
    
     public function get_topup_membes($from_date,$to_date,$level,$sel_pk)   
    {
        $this->db->select('isp_members.member_name,isp_members.member_id,topup_isp_members.member_topup_level,isp_members.member_mobile,isp_members.member_login_id,isp_members.member_password,topup_isp_members.member_added_date');
        $this->db->from('topup_isp_members');
        $this->db->join('isp_members','isp_members.member_id = topup_isp_members.member_id');  
        $this->db->order_by('topup_isp_members.topup_id', 'desc');
        if ($level) 
        {
            $this->db->where('topup_isp_members.member_topup_level',$level);      
        }  
        
        if ($from_date && $to_date=='') 
        {
             $from_date= $from_date.' 00:00:00';
             $this->db->where('topup_isp_members.member_added_date >=',$from_date); 
        }
       if ($from_date=='' && $to_date) 
        {
            $to_date  = $to_date.' 23:59:55';
            $this->db->where('topup_isp_members.member_added_date <=',$to_date); 
        }
        if ($from_date && $to_date) 
        {
            $from_date= $from_date.' 00:00:00';
            $to_date  = $to_date.' 23:59:55';
              
            $this->db->where('topup_isp_members.member_added_date >=',$from_date); 
            $this->db->where('topup_isp_members.member_added_date <=',$to_date); 
        }

        $this->db->where('topup_isp_members.member_status','Approve'); 
        $q = $this->db->get();
        $m = $q->result();  

        return $m;
    }

    public function get_packageEpin($package_id,$member_logid)
    {    
        $isEpin = null; $insert = null;
        $this->db->select('epin.*,pckages.*');
        $this->db->from('epin');
        $this->db->join('pckages','pckages.package_id = epin.epin_package_id');  
        $this->db->join('isp_members','isp_members.member_id = epin.epin_member_id');  
        $this->db->where('epin.epin_status','Unused'); 
        $this->db->where('isp_members.member_login_id',$member_logid); 
        $this->db->where('epin.epin_member_id','isp_members.member_id'); 
        $q = $this->db->get();
        $isEpin = $q->row();
        
        if($isEpin==null)
        {
            $package_data       = getPackages($package_id);
            $package_prefix     = $package_data[0]->package_prefix; 

            $memberData = getMemberData($member_logid);

            $digit = date('i').date('s');
            $Last_char = $this->generateRandomString(); 
            $epin= $package_prefix.$digit.$Last_char; 

            $epinData = array();
            $epinData['epin_member_id'] = $memberData->member_id;
            $epinData['epin_package_id'] = $package_id;
            $epinData['epin'] = $epin; 
            $epinData['epin_added_date'] = date('Y-m-d H:i:s');
            $epinData['epin_status'] = 'Unused';
            $insert = $this->db->insert('epin',$epinData);
        }
        else
        {
            $insert=1;
        }

        if ($insert) 
        { 
            $this->db->select('epin.*,pckages.*');
            $this->db->from('epin');
            $this->db->join('pckages','pckages.package_id = epin.epin_package_id');  
            $this->db->join('isp_members','isp_members.member_id = epin.epin_member_id');  
            $this->db->where('epin.epin_status','Unused'); 
            $this->db->where('isp_members.member_login_id',$member_logid);  
            $q = $this->db->get();             
            return $q->row();  
        }
        return null;
    }

    function generateRandomString($length = 2) 
    {
        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
    
	public function get_level_member_list($member_id,$level_no)
	{
		$this->db->select('level_member_id');
		$this->db->from('roi_upline_level'); 
		$this->db->where('level_'.$level_no,$member_id);
		//$this->db->where('member_downline_id !=','0');
		$q = $this->db->get();
		$memb = $q->result_array();
// echo $this->db->last_query();die;
		
		if($memb)
		{

  foreach($memb as $result){
   $ids[]=$result['level_member_id'];
  }

		$this->db->select('member_id,member_login_id,member_name,member_added_date,member_mobile,member_email_id,member_package_id,member_upline_id,member_active_date');
		$this->db->from('isp_members'); 
		$this->db->where_in('member_id',$ids);
		$q = $this->db->get();
		$memb1 = $q->result();

	}
	else
	{
		$memb1=null;
	}

		$topup = null;

		if ($topup==null) 
		{
			$f = $memb1; 
		}
		else
		{
			$f = array_merge($memb1,$topup);
		}


		return $f;
		

		
	}
		public function get_levels($memberID)
    {
        //  echo $memberID;die;
    	$this->db->select('isp_members.member_package_ROI_amount as amount,roi_upline_level.*');
    	$this->db->from('roi_upline_level'); 
    	$this->db->join('isp_members','isp_members.member_id=roi_upline_level.level_member_id');
    	$this->db->where('roi_upline_level.level_member_id',$memberID);
    	$this->db->where('isp_members.member_status','Approve'); 
    	$q = $this->db->get();    	 
  echo "<pre>";echo $this->db->last_query();die;
    	return $q->result();
    }
    public function get_view_regisp_members_data()
    {  
        $this->db->select('*');
        $this->db->from('isp_members'); 
        // $where = '(kyc_status="Pending" or kyc_status = "Rejected")';
        // $this->db->where($where);
        $this->db->order_by('member_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    }  
    public function get_no_epin_regisp_members_data()
    {  
        $this->db->select('*');
        $this->db->from('isp_members'); 
        
        $where = '(member_epin_id="0")';
        $this->db->where($where);
        $this->db->order_by('member_id','desc');
        $q = $this->db->get();
        //  echo $this->db->last_query();die;
        return $q->result();  
 
    }  
     public function get_member_data_email($username)
    {    
        $this->db->select('isp_members.*,isp_profile_doc_details.*');
        $this->db->from('isp_members');
        $this->db->join('isp_profile_doc_details','isp_profile_doc_details.member_id = isp_members.member_id');  
        $this->db->where('isp_members.member_email_id',$username);
        // $where = '(isp_members.member_name='.$username.' or isp_members.member_login_id ='.$username.' or isp_members.member_email_id ='.$username.')';
        // $this->db->where($where);
        $q = $this->db->get();
        // echo $this->db->last_query();die;
         return $res = $q->row(); 
    }
      public function get_member_data_name($username)
    {    
        $this->db->select('isp_members.*,isp_profile_doc_details.*');
        $this->db->from('isp_members');
        $this->db->join('isp_profile_doc_details','isp_profile_doc_details.member_id = isp_members.member_id');  
        $this->db->where('isp_members.member_name',$username);
        // $where = '(isp_members.member_name='.$username.' or isp_members.member_login_id ='.$username.' or isp_members.member_email_id ='.$username.')';
        // $this->db->where($where);
        $q = $this->db->get();
        // echo $this->db->last_query();die;
         return $res = $q->row(); 
    }
      public function get_member_data_login_id($username)
    {    
        $this->db->select('isp_members.*,isp_profile_doc_details.*');
        $this->db->from('isp_members');
        $this->db->join('isp_profile_doc_details','isp_profile_doc_details.member_id = isp_members.member_id');  
        $this->db->where('isp_members.member_login_id',$username);
        // $where = '(isp_members.member_name='.$username.' or isp_members.member_login_id ='.$username.' or isp_members.member_email_id ='.$username.')';
        // $this->db->where($where);
        $q = $this->db->get();
        // echo $this->db->last_query();die;
         return $res = $q->row(); 
    }
    
     public function get_binary_income_data()
    {  
        $this->db->select('*');
        $this->db->from('isp_binary_income'); 
        $this->db->order_by('binary_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    }  
     public function get_withdrawal_data()
    {  
        $this->db->select('*');
        $this->db->from('roi_withdrawal_request'); 
        $this->db->order_by('roi_withdrawal_request_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    }  
     public function get_view_members_data()
    {  
        $this->db->select('*');
        $this->db->from('isp_members'); 
        $this->db->where('member_status','Approve');
         //$this->db->where('kyc_status','Approve');
         $this->db->where('payment_status','complete');
        // $where = '(member_type="member" or member_type = "admin_member")';
        // $this->db->where($where);
        $this->db->order_by('member_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    }  
     public function get_view_members_orders($id)
    {  
        $this->db->select('*');
        $this->db->from('isp_order'); 
        $this->db->where('member_id',$id);
        $q = $this->db->get();
        return $q->result();  
 
    }
    public function get_members($member_id)
    {  
        $this->db->select('*');
        $this->db->from('isp_members'); 
        if (!empty($member_id)) 
        {
          $this->db->where('member_id',$member_id);
        } 
        $q = $this->db->get();
        return $q->result();  
 
    } 
       public function get_view_regmembers_data()
    {  
        $this->db->select('*');
        $this->db->from('isp_members'); 
      
        // $where = '(kyc_status="Pending" or kyc_status = "Rejected" or kyc_status = "Approve")';
         $where = '(member_status="Pending" or payment_status = "Pending" )';
        $this->db->where($where);
        $this->db->order_by('member_id','desc');
        $q = $this->db->get();
        // echo $this->db->last_query();die;
        return $q->result();  
 
    } 
     public function get_members_data($conditions)
    {  
        $this->db->select('*');
        $this->db->from('isp_members'); 
        if ($conditions!='') 
        {
          $this->db->where($conditions);
        } 
        $this->db->order_by('member_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    }  
    public function get_tickets_data($from_date,$to_date)
    {  
        $this->db->select('*');
        $this->db->from('isp_ticket_support'); 
        
        if ($from_date && $to_date=='') 
        {
             $from_date= $from_date.' 00:00:00';
             $this->db->where('ticket_date >=',$from_date); 
        }
       if ($from_date=='' && $to_date) 
        {
            $to_date  = $to_date.' 23:59:55';
            $this->db->where('ticket_date <=',$to_date); 
        }
        if ($from_date && $to_date) 
        {
            $from_date= $from_date.' 00:00:00';
            $to_date  = $to_date.' 23:59:55';
              
            $this->db->where('ticket_date >=',$from_date); 
            $this->db->where('ticket_date <=',$to_date); 
        } 
        $this->db->where('ticket_status!=','Deleted');
        $this->db->order_by('ticket_id','DESC');
        $q = $this->db->get();
        return $q->result();   
    } 
    public function get_referral_income_data()
    {  
        $this->db->select('*');
        $this->db->from('isp_level_income'); 
        $this->db->order_by('income_id','desc');
        $q = $this->db->get();
        return $q->result();  
    }  
     public function get_referral_income_datewisedata($from_date,$user_id)
    {  
        
        $this->db->select('*');
        $this->db->from('isp_level_income'); 
        $this->db->where('income_date =',$from_date); 
        $this->db->where('income_member_id =',$user_id);
        $this->db->order_by('income_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    } 
     public function get_referral_income_datewisedata2($from_date)
    {  
        
        $this->db->select('*');
        $this->db->from('isp_level_income'); 
        $this->db->where('income_date =',$from_date); 
       
        $this->db->order_by('income_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    } 
    
    public function get_referral_income_datewisedata1($from_date,$user_id)
    {  
        $this->db->select('income_id,income_level,income_member_id,income_member_by,order_id,income_amount,package_amount,income_percentage,income_date');
        $this->db->from('isp_level_income'); 
        $this->db->where('income_date =',$from_date); 
        $this->db->where('income_member_id =',$user_id);
        $this->db->order_by('income_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    }  
    public function get_referral_income_bank_data()
    {  
        // $this->db->select('*');
        // $this->db->from('isp_level_income'); 
        // $this->db->group_by('income_date');
        // $this->db->order_by('income_id','desc');
        // $q = $this->db->get();
        $this->db->select('income_date, SUM(income_amount) AS total_income,income_id,income_member_id,income_status');
        $this->db->from('isp_level_income');
        $this->db->group_by('income_date');
        $this->db->order_by('income_id', 'desc');
        $q = $this->db->get();
        //echo $this->db->last_query();die;
        return $q->result();  
    }  
     public function get_referral_income_bank_datewisedata($from_date)
    {  
        $this->db->select('*, SUM(income_amount) AS total_income');
        $this->db->from('isp_level_income'); 
        $this->db->where('income_date =',$from_date); 
        $this->db->group_by('income_member_id');
        $this->db->order_by('income_id', 'desc');
        $q = $this->db->get();
        //echo $this->db->last_query();die;
        return $q->result();  
 
    }  
    public function get_level_income($id)
    {  
        $this->db->select('*');
        $this->db->from('isp_level_income'); 
        $this->db->where('income_member_id',$id);
        //$this->db->order_by('income_id','desc');
        $q = $this->db->get();
        return $q->result();  
 
    }  
    
    
}  //class close
