<?php
Class Home_model extends CI_Model
{
   public  function __construct()
	{
		parent::__construct();
	} 

	public function check_user_login($log_data)
	{ 
		$this->db->select('*');
		$this->db->from('isp_members');
		$this->db->where('member_login_id',escapeStr($log_data['login_id']));
		$this->db->where('member_password',escapeStr($log_data['login_pass']));
		$this->db->where('member_status !=','Deleted');
		$q = $this->db->get();  
		return $q->result();
    }
 public function get_members_login($id)
    {	
    
    	$this->db->select('member_name,member_id');
    	$this->db->from('members'); 
    	$this->db->where('member_login_id',$id);
    	$q = $this->db->get();
        
    	if($q->num_rows()>0)
    	{
    		return $q->result();  
    	}
    	else
    	{
    		return false;
    	}
    }
	public function check_user_login2($log_data)
	{
		$this->db->select('*');
		$this->db->from('pending_members');
		$this->db->where('member_login_id',$log_data['login_id']);
		$this->db->where('member_password',$log_data['login_pass']);
		$this->db->where('member_status !=','Deleted');
		$q = $this->db->get();
		return $q->result();
	}
    public function insert_data($table,$insertData)
	{
		$this->db->insert($table,$insertData);		
	}

	public function get_member_profile($member_id)
	{
		$this->db->select('*');
		$this->db->from('isp_members'); 
		$this->db->where('member_id',$member_id);
		$q = $this->db->get();
		return $q->result();
	}
    public function get_member_profile_details($member_id)
	{
		$this->db->select('profile_doc_details.*,members.*');
		$this->db->from('profile_doc_details'); 
		$this->db->join('members','members.member_id=profile_doc_details.member_id');
		$this->db->where('members.member_id',$member_id);
		$q = $this->db->get();
// 		echo $this->db->last_query();die;
		return $q->result();
	}


	public function get_first_epin($member_id)
	{
		$this->db->select('epin');
		$this->db->from('epin'); 
		$this->db->where('epin_member_id',$member_id);
		$this->db->where('epin_status','Unused');
		$this->db->order_by('epin_id','asc');
		$this->db->limit('1');
		$q = $this->db->get();
		if($q->num_rows()>0)
		{
			//echo $this->db->last_query(); die;
			return $q->result();
		}
		else
		{
			return false;
		}
	}
	
	public function check_password($data)
	{
		$this->db->select('*');
		$this->db->from('members'); 
		$this->db->where('member_id',$data['member_id']);
		$this->db->where('member_password',$data['old_password']);
		$q = $this->db->get();
// 		echo $this->db->last_query();die;
		return $q->result();
	}
	public function check_wallet_password($data)
	{
		$this->db->select('*');
		$this->db->from('members'); 
		$this->db->where('member_id',$data['member_id']);
		$this->db->where('wallet_password',$data['old_password']);
		$q = $this->db->get();
//  		echo $this->db->last_query();die;
		return $q->result();
	}
	public function check_wallet_password1($data)
	{
		$this->db->select('*');
		$this->db->from('members'); 
		$this->db->where('member_id',$data['member_id']);
		$this->db->where('wallet_password',$data['password']);
		$q = $this->db->get();
		// echo $this->db->last_query();die;
		return $q->result();
	}
	public function change_password($member_id,$new_password)
	{
		$this->db->where('member_id',$member_id);
		$this->db->update('isp_members',$new_password);	 
	}
	function update($data,$conditions,$tablename="")
	{
		if($tablename=="")
		$tablename = $this->table;
		$this->db->where($conditions);
		$this->db->update($tablename,$data);
		return $this->db->affected_rows();
	}

public function change_wallet_password($member_id,$new_password)
	{
		$this->db->where('member_id',$member_id);
		$this->db->update('members',$new_password);	 
// 		echo $this->db->last_query();die;
	}
	public function update_profile($member_id,$updateData)
	{
		$this->db->where('member_id',$member_id);
		$this->db->update('isp_members',$updateData);	 
	}
	public function exist_update($member_id,$level)
	{
		$checking_entry=$this->db->get_where('isp_payout',array('level'=>$level,'member_id'=>$member_id,'status'=>'Hold'))->row();
		if($checking_entry)
		{
		$data=array(
		'status'=>'Pending'
		);
		$this->db->where('member_id',$member_id);
		$this->db->where('level',$level);
		$this->db->update('payout',$data);	 
		}
	}
	
	public function send_sms($mobile_no,$msg)
	{		 
		if ($this->config->item('config_SMS')==TRUE) 
		{ 
			$senderID = $this->config->item('config_SMS_senderId');
			$userName = $this->config->item('config_SMS_username');
			$passWord = $this->config->item('config_SMS_password');

			if ($senderID && $userName && $passWord) 
			{     
				$url ="http://49.50.67.32/smsapi/httpapi.jsp?username=".$userName."&password=".$passWord."&from=".$senderID."&to=".$mobile_no."&text=".$msg."";
				$url_f =str_replace(" ", "%20", $url);
				file($url_f); 
			}
		}
	}
	
    // code change by susheel
	public function get_downline($member_id)
	{
		$this->db->select('member_id');
		$this->db->from('members'); 
		$this->db->where_in('member_upline_id',$member_id);
		$this->db->where('member_status','Approve');
		$q = $this->db->get();
		// echo $this->db->last_query();		
		return $q->result();
	}
    public function get_total_downline($member_id)
	{
		$this->db->select('*');
		$this->db->from('members'); 
		$this->db->where('member_downline_id',$member_id);			
		$q = $this->db->get();		
		return $q->result();
	}

	public function get_members_login_id($id)
    {	 
    	$this->db->select('member_name,member_city,member_mobile,member_id');
    	$this->db->from('members'); 
    	$this->db->where('member_login_id',$id);
		$this->db->where('member_status','Approve');
    	$q = $this->db->get();
    	
    	if($q->num_rows()>0)
    	{
    		return $q->result();  
    	}
    	else
    	{
    		return false;
    	}
    }
    public function get_login_id($id)
    {	 
    	$this->db->select('member_login_id');
    	$this->db->from('members'); 
    	$this->db->where('member_id',$id);
    	$q = $this->db->get();
    	if($q->num_rows()>0)
    	{
    		return $q->row();  
    	}
    	else
    	{
    		return false;
    	}
    
    }
    public function get_member_id($id)
    {	 
    	$this->db->select('*');
    	$this->db->from('isp_members'); 
    	$this->db->where('member_login_id',$id);
    	$q = $this->db->get();
    	if($q->num_rows()>0)
    	{
    		return $q->row();  
    	}
    	else
    	{
    		return false;
    	}
    
    }
    public function get_epin_to_transfer($memberId,$epin_qty,$package_id)
    {
    	$this->db->select('epin_id');
		$this->db->from('epin');
		$this->db->where('epin_member_id',$memberId);
		$this->db->where('epin_package_id',$package_id);
		$this->db->where('epin_status','Unused');
		$this->db->order_by('epin_id','asc');
		$this->db->limit($epin_qty);
		$q = $this->db->get();
    	if($q->num_rows()>0)
    	{
    		return $q->result();  
    	}
    	else
    	{
    		return false;
    	}

    }

    public function total_epin($id,$epin_package)
    {	 
    	$this->db->select('count(epin_id) as total_epin');
    	$this->db->from('epin'); 
    	$this->db->where('epin_member_id',$id);
    	if ($epin_package) {
    		$this->db->where('epin_package_id',$epin_package); 
    	}
    	$this->db->where('epin_status','Unused');
    	$q = $this->db->get();
    	if($q->num_rows()>0)
    	{ 
    		return $q->row();  
    	}
    	else
    	{
    		return false;
    	}
    }


    public function get_forgot_data($mobile_no)
	{
		$this->db->select('member_mobile,member_password');
		$this->db->from('members'); 
		$this->db->where('member_mobile',$mobile_no);		
		$q = $this->db->get();
		return $q->row();
	}
	
		public function get_reentry_count($user_id)
	{
		
		$sql= 'select * from isp_members where member_id ="'.$user_id.'"';
		$get_register_date=$this->db->query($sql);
		$rows = $get_register_date->row();
		if($rows)
		{
			$reg_date=$rows->member_added_date;		
			$sql= 'select sum(re_entry_count) as sum from isp_re_entry where re_entry_date >="'.$reg_date.'"';
			$query=$this->db->query($sql);
			$row = $query->row();
			if($row)
			{
				return $row->sum;
			}
			else
			{
				return false;
			}
		}
	}
	
	public function random_string_file_nm($length=6,$file_nm = null){
		$doc_ext_arr = explode(".",$_FILES[$file_nm]['name']);	
		$doc_ext = end($doc_ext_arr);
		$str_1 = substr(str_shuffle("Aa1Bb2Cc3Dd4Ee5Ff6Gg7Hh8Ii9Jj0Kk1Ll2Mm3Nn4Oo5Pp6Qq7Rr8Ss9Tt0Uu1Vv2Ww3Xx4Yy5Zz6"), 0, $length);
		$str_2 = substr(str_shuffle("aA1bB2cC3dD4eE5fF6gG7hH8iI9jJ0kK1lL2mM3nN4oO5pP6qQ7rR8sS9tT0uU1vV2wW3xX4yY5zZ6"), 0, $length);
		$str_3 = substr(str_shuffle("1Aa2Bb3Cc4Dd5Ee6Ff7Gg8Hh9Ii0Jj1Kk2Ll3Mm4Nn5Oo6Pp7Qq8Rr9Ss0Tt1Uu2Vv3Ww4Xx5Yy6Zz"), 0, $length);
		$str_4 = substr(str_shuffle("1aA2bB3cC4dD5eE6fF7gG8hH9iI0jJ1kK2lL3mM4nN5oO6pP7qQ8rR9sS0tT1uU2vV3wW4xX5yY6zZ"), 0, $length);
		$str_5 = substr(str_shuffle(time()), 0, $length);
		$str   = $str_1.'_'.$str_2.'_'.$str_3.'_'.$str_4.'_'.$str_5;
		return $str.".".$doc_ext;
	}
	
	public function doc_upload($length,$file,$path=null){
		$dir = "{$path}";
		$new =null;
		if(!empty($_FILES[$file]['name'])){
			$new = $this->random_string_file_nm(6,$file);
			move_uploaded_file($_FILES[$file]['tmp_name'],$dir.'/'.$new);
		}
		return $new;
	}
	

	public function get_members($id)
	{
		$this->db->select('*');
    	$this->db->from('members'); 
    	$this->db->where('member_id <=',$id);
    	$this->db->where('member_status','Approve');
    	$this->db->order_by('member_id','DESC');
    	$q = $this->db->get();
    	return $q->result();   
	}
function generateRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}
	
function count_my_downline_level($upline_id)
{	
	 $sql ='SELECT member_downline1,
		         member_downline2,
		         member_downline3,
		         member_downline4,
		         CASE WHEN member_downline1 IS NOT NULL THEN 1 ELSE 0 END + 
		         CASE WHEN member_downline2 IS NOT NULL THEN 1 ELSE 0 END + 
		         CASE WHEN member_downline3 IS NOT NULL THEN 1 ELSE 0 END + 
		         CASE WHEN member_downline4 IS NOT NULL THEN 1 ELSE 0 END AS columns
			FROM  isp_members
			WHERE member_login_id="'.$upline_id.'" ';
	
	$ci=& get_instance();
	$ci->load->database(); 
	$query = $ci->db->query($sql);
    $row = $query->row();
    if ($row=='') {
    	return 0;	 
    }else{	
	    return $row->columns; 
	}
}	 

public function getTotalCount($member_id)
	{
	     $where = "member_upline_id='".$member_id."' AND (member_status='Approve' OR member_status='Received' OR member_status='Pending')";
	    $this->db->select('*');
		$this->db->from('members'); 
		$this->db->where($where);
		$q = $this->db->get();
		return $q->result();
	}

/*public function get_sponsorUser1($uplineId)
{
	$this->db->select('*');
	$this->db->from('members'); 
	$this->db->where('member_id',$uplineId);
	$q = $this->db->get();
	$mData = $q->row();

	if ($mData!='' && $mData->member_status=='Blocked') 
	{
		$this->db->select('*');
		$this->db->from('members'); 
		$this->db->where('member_type','admin_member');
		$this->db->where('member_status','Approve');
		$this->db->order_by('member_id','DESC');
		$q = $this->db->get();
		return $mData = $q->row(); 
	}else{
		return $mData;
	}
}*/	

public function get_admin_member()
{
	$this->db->select('*');
	$this->db->from('members'); 
	$this->db->where('member_type','admin_member');
	$this->db->where('member_status','Approve');
	//$this->db->order_by('member_id','DESC');
	$this->db->order_by('rand()');
	$this->db->limit(1);
	$q = $this->db->get();
	return $mData = $q->row(); 
}

public function get_packages($id)
{
	$this->db->select('*');
	$this->db->from('pckages');   
	if ($id) 
	{
		$this->db->where('package_id',$id); 
	}   
	$this->db->where('package_status','Active');	
	$this->db->order_by('package_amount','ASC');
	$q = $this->db->get();
	return $q->result();
}

public function get_members_packages($member_id)
{
	$this->db->select('pckages.*');
	$this->db->from('pckages');
	$this->db->join('members','members.member_package_id=pckages.package_id');
	$this->db->where('members.member_login_id',$member_id); 
	$q = $this->db->get();
    return $q->row(); 
}

public function get_members_login_id2($id)
{	 

	$query2 = $this->db->query("SELECT * FROM isp_members where (member_login_id='".$id."') AND (kyc_status='Approve')");
	$app = $query2->row();

	if($app)
	{
		return $app;  
	}
	else
	{
		return false;
	} 
}

public function get_donations_data($member_id)
{
    $where = "donate_by='".$member_id."' AND member_status='send' ";
    $this->db->select('*');
	$this->db->from('donations'); 
	$this->db->where($where);
	$q = $this->db->get();
	return $q->result();
}
	public function add_roi_wallet($member_id,$package_id)
	{
		//$this->deleted_old_roi($member_id,$package_id);

		$this->db->select('holiday_date');
		$this->db->from('isp_holidays'); 
		$this->db->where('status','Active');
		$this->db->where('holiday_date >=',date('Y-m-d'));
		$q = $this->db->get();
		$holidays = $q->result();
		
		$totDays = 1;
		$tommorow = new DateTime('tomorrow');
		$tommorowDate = $tommorow->format('Y-m-d');
		
		$memberPackageAmt  = getMemberPackageAmt($member_id);
		$dailyPercentage = $this->config->item('config_daily_percentage');
		$finalDailyAmt=($memberPackageAmt) * $dailyPercentage/100;
		
		foreach($holidays as $holid)
		{
			$holidayArray[] = $holid->holiday_date;
		}
		 
		$roi_days = $this->config->item('config_daily_roi_days');
		while($totDays <= $roi_days)
		{
			if(!empty($holidays))
			{
				if(date('D',strtotime($tommorowDate))=='Sat' || date('D',strtotime($tommorowDate))=='Sun' || in_array($tommorowDate,$holidayArray))
				{
				}
				else{
				    $isExist = $this->db->get_where('roi_wallet',array('member_id' =>$member_id,'date'=>$tommorowDate,'package_id'=>$package_id))->num_rows();
					if($isExist==0)
					{
					    $array = array('member_id'=>$member_id,'amount'=>$finalDailyAmt,'date'=>$tommorowDate,'package_id'=>$package_id);
					    $this->db->insert('roi_wallet',$array );
					}
					$totDays++;
				}
				$tommorowDate = date('Y-m-d', strtotime($tommorowDate . ' +1 day'));
			}
			else{
				if(date('D',strtotime($tommorowDate))=='Sat' || date('D',strtotime($tommorowDate))=='Sun')
				{
				}
				else{
				    $isExist = $this->db->get_where('roi_wallet',array('member_id' =>$member_id,'date'=>$tommorowDate,'package_id'=>$package_id))->num_rows();
					if($isExist==0)
					{
					    $array = array('member_id'=>$member_id,'amount'=>$finalDailyAmt,'date'=>$tommorowDate,'package_id'=>$package_id);
					    $this->db->insert('roi_wallet',$array );
					}
					$totDays++;
				}
				$tommorowDate = date('Y-m-d', strtotime($tommorowDate . ' +1 day'));
			}
		}
	}
	public function get_roi_list()
	{
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];
		
		$this->db->select('*');
		$this->db->from('isp_roi_wallet'); 
		$this->db->where('member_id',$member_id);
		$this->db->where('status !=','deleted');
		$q = $this->db->get();
		return $q->result();
	}

	public function get_roi_list2()
	{
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];
		
		$this->db->select('*');
		$this->db->from('isp_roi_wallet'); 
		$this->db->where('member_id',$member_id);
		$this->db->where('date <=',date('Y-m-d'));
		$this->db->where('status !=','deleted');
		$this->db->order_by('date DESC');
		$q = $this->db->get();
		return $q->result();
	}
	public function get_roi_requested_data()
	{
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];
		
		$this->db->select('*');
		$this->db->from('isp_roi_withdrawal_request'); 
		$this->db->where('member_id',$member_id);
		//$this->db->where('withdrawal_request_type','ROI');
		$this->db->order_by('roi_withdrawal_request_id DESC');
		$q = $this->db->get();
		return $q->result();
	}
		public function get_award_requested_data()
	{
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];
		
		$this->db->select('*');
		$this->db->from('isp_award'); 
		$this->db->where('award_member_id',$member_id);
	    $this->db->order_by('award_id DESC');
		$q = $this->db->get();
		return $q->result();
	}
	public function get_total_generated_roi()
	{
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];
		
		$this->db->select('sum(amount) as total_roi');
		$this->db->from('isp_roi_wallet'); 
		$this->db->where('member_id',$member_id);
		$this->db->where('status','generate');
		$q = $this->db->get();
		return $q->row();
	}
	public function get_total_withdrawal_roi()
	{
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];
		
		$this->db->select('sum(withdrawal_net_amount) as totalWithdraw');
		$this->db->from('isp_roi_withdrawal_request'); 
		$this->db->where('member_id',$member_id);
		$this->db->where('withdrawal_status','paid');
		$this->db->where('withdrawal_request_type','ROI');
		$q = $this->db->get();
		return $q->row();
	}
	

	public function add_roi_withdraw_request($request_type)
	{		
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];
	    $request_amount=0;$tds=0;$service_charges=0;$net_payout=0;$admin_charges=0;$payment_option=0;
	    $withdrawal_status='';

	   	$totalIncome 			= getTotalIncome($member_id); //get Available Balance
		$totalWithdraw 			= getTotalWithdrawal1($member_id);
		$pending_withdrawal 	= getTotalPendingWithdrawal1($member_id);
	    $totalbalence 			= $totalIncome - $totalWithdraw -$pending_withdrawal;
	
		$usdt_address = $btc_address = $eth_address = null;
		$additional_cashback = 0;
		if($request_type == 'Bonus'){
			$request_amount = escapeStr($this->input->post('usdt_withdrawal'));
			$amt1 				= $request_amount;
			$net_payout			= $amt1; 
			
				$request_amount = escapeStr($this->input->post('usdt_withdrawal'));
			$amt1 				= $request_amount;
		
			$admin_charges		= (($amt1)*$this->config->item('config_admin_charges')/100); 
			$tds_charges		= (($amt1)*$this->config->item('config_tds_charges')/100); 
			$repurchase_charges		= (($amt1)*$this->config->item('config_repurchase_charges')/100); 
		
			$net_payout			= (($amt1) - $admin_charges - $tds_charges - $repurchase_charges);
			if($totalbalence < $net_payout )
			{
				$reponse = array(
					'status' 	=> "0",
					'additional_cashback' => $additional_cashback,
					'msg' 		=> "Request Amount is Greater than Balance amount"
				);
				return $reponse;
			}
		
	        $wallet_details = getwalletDetails($member_id);
			if($wallet_details!="")
			{
			  if($wallet_details->member_payment_option=="btc_address")
			  {
			      $btc_address=$wallet_details->member_btc_address;
			      $payment_option = $wallet_details->member_payment_option;
			  }
			  if($wallet_details->member_payment_option=="usdt_address")
			  {
			      $usdt_address=$wallet_details->member_usdt_address;
			      $payment_option = $wallet_details->member_payment_option;
			  }
			  if($wallet_details->member_payment_option=="eth_address")
			  {
			      $eth_address=$wallet_details->member_eth_address;
			      $payment_option = $wallet_details->member_payment_option;
			  }
			
			}

			$withdrawal_status  = 'pending';
		}
		$req = array('withdrawal_request_type'	=> $request_type,
					'member_id'					=> $member_id,
					'withdrawal_total_amount'	=> $totalbalence,
					'withdrawal_request_amount' => $request_amount,
					'withdrawal_admin_charges'	=> $admin_charges,
					'withdrawal_tds_charges'	=> $tds_charges, 
					'withdrawal_repurchase_charges'	=> $repurchase_charges, 
					'withdrawal_net_amount'		=> $net_payout,
					'withdrawal_request_date'	=> date('Y-m-d H:i:s'),						 
					'payment_option'			=> $payment_option,
					'withdrawal_status'			=> $withdrawal_status,
					'usdt_address'				=> $usdt_address,
					'btc_address'				=> $btc_address,
					'eth_address'				=> $eth_address
				);
		$this->db->insert('roi_withdrawal_request',$req);
		// dd($this->db->last_query());
		unset($_POST);
		$reponse = array(
			'status' 	=> "1",
			'additional_cashback' => $additional_cashback,
			'msg' 		=> "Withdrawal Request Sent Successfully"
		);
		return $reponse;
	}	
	public function get_pending_withdrawalData()
	{
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];

		$pendingRequest = $this->db->get_where('isp_roi_withdrawal_request',array('member_id'=>$member_id,'withdrawal_status'=>'pending'))->row();
		return $pendingRequest;
	}

	public function get_binary_requested_data()
	{
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];
		
		$this->db->select('*');
		$this->db->from('isp_roi_withdrawal_request'); 
		$this->db->where('member_id',$member_id);
		$this->db->where('withdrawal_request_type','Binary');
		$q = $this->db->get();
		return $q->result();
	}
	public function get_total_generated_binary()
	{
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];
		
		$this->db->select('sum(income_amount) as total_binary');
		$this->db->from('level_income'); 
		$this->db->where('income_member_id',$member_id);
		$this->db->where('income_amount !=','0');
		$q = $this->db->get();
		return $q->row();
	}
	public function get_total_withdrawal_binary()
	{
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];
		
		$this->db->select('sum(withdrawal_net_amount) as totalWithdrawBinary');
		$this->db->from('isp_roi_withdrawal_request'); 
		$this->db->where('member_id',$member_id);
		$this->db->where('withdrawal_status','paid');
		$this->db->where('withdrawal_request_type','Binary');
		$q = $this->db->get();
		return $q->row();
	}




    public function get_assigned_epin($id)
    {
    	$this->db->select('epin.epin');
        $this->db->from('members'); 
        $this->db->join('epin','epin.epin_id=members.member_epin_id');  
        $this->db->where('members.member_status','Pending');    
        $this->db->where('members.member_type','member'); 
        $this->db->where('epin.epin_status','Unused');  
        $this->db->where('members.member_id',$id); 
        $query = $this->db->get();   
        
        $epin = $query->row();
        if ($epin!='') 
        {
        	return $epin; 
        }
        else
        {
        	return null;
        }
    }

    public function add_upline_level_members($member_id,$upline_id)
    {
    	$ar= []; 
 		$upline_members = (object) $this->getUplineMembers($upline_id,$ar); 

 		if ($upline_members) 
 		{
 			$uplineData=[];
 			$uplineData['level_member_id'] = $member_id;
 			$uplineData['level_date'] = date('Y-m-d');
 			$level =1;
 		  foreach ($upline_members as $member) 
 		  { 
 		  	 $uplineData['level_'.$level++] = $member;
 		  }

 		  $this->db->insert('isp_roi_upline_level',$uplineData);
 		} 
    }
 	
 	public function getUplineMembers($upline_id,$ar)
    {  
    	$sql        = "select * from `isp_members` where `member_id` ='".$upline_id."' ";
		$result     = $this->db->query($sql);
	
		$getnnum    = $result->num_rows(); 
		
		if($getnnum >0)
		{
			$ar[] = $upline_id;  
			if(count($ar)>=$this->config->item('config_levels'))
			{  
				return $ar;
				exit();
			}
			$sql2        = "select * from `isp_members` where `member_id` ='".$upline_id."'";
			$result2     = $this->db->query($sql2);
			foreach($result2->result() as $row)
			{	 
				if($row->member_type=='member')
				{
					return $this->getUplineMembers($row->member_upline_id,$ar);  
				}
			}
		}  
		if ($ar!='') {
        	return $ar; 
        }else{
        	return 0;
        }  
    } 

    public function get_roi_levels($memberID,$currentPackage)
    {
    	$tot_levels = $this->config->item('config_upline_roi_levels');
    	$level = 1;
    	$level_l = 1;
    	$data  = ''; 

    	$finalLevelAmt = 0; $finalDailyAmt = 0;

    	$level_percentage = $this->config->item('binary_roi_levels');
 	 	
 	 	$isLevelActive = false;
    	for ($i=0; $i < $tot_levels; $i++) 
    	{  
			$data = $this->get_levels($memberID,$level);    	 	  

			if($level==1 || $level==2){
    			$level_l = $level;
    		}elseif($level==3){
    			$level_l = 2;
    		}elseif($level==4){
    			$level_l = 3;
    		}elseif($level==5){
    			$level_l = 4;
    		}elseif ($level==6 || $level==7 || $level==8) {
    			$level_l = 6;
    		}elseif ($level==9 || $level==10) {
    			$level_l = 9;
    		}elseif ($level>=11 || $level<=15) {
    			$level_l = 11;
    		}elseif ($level>=16 || $level<=20) {
    			$level_l = 16;
    		}

			//$total_level_amt = $this->get_levels_package_amt($memberID,$level); 
			$total_level_amt = $this->get_levels_package_amt($memberID,$level_l); 
			
			/*if ($level==1) {
				$isLevelActive = true; 
			}elseif ($level==2 && $total_level_amt >= $this->config->item('capping_level_2')){
				$isLevelActive = true;  
			}elseif ($level==3 && $total_level_amt >= $this->config->item('capping_level_3')){
				$isLevelActive = true;
			}elseif ($level==4 && $total_level_amt >= $this->config->item('capping_level_4')){
				$isLevelActive = true;
			}elseif ($level>=5 && $total_level_amt >= $this->config->item('capping_level_5') &&
					 $level<=8 && $total_level_amt >= $this->config->item('capping_level_5')){
				$isLevelActive = true;
			}elseif ($level>=9 && $total_level_amt >= $this->config->item('capping_level_9') &&
					 $level<=10 && $total_level_amt >= $this->config->item('capping_level_9')){
				$isLevelActive = true;
			}elseif ($level>=11 && $total_level_amt >= $this->config->item('capping_level_11') &&
					 $level<=15 && $total_level_amt >= $this->config->item('capping_level_11')){
				$isLevelActive = true;
			}elseif ($level>=16 && $total_level_amt >= $this->config->item('capping_level_16') &&
					 $level<=20 && $total_level_amt >= $this->config->item('capping_level_16')){
				$isLevelActive = true;
			}else{
				$isLevelActive = false;
			}*/ 

 			
 			if ($level==1 || $level==2) {
				$isLevelActive = true; 
			}elseif ($level==3 && $total_level_amt >= $this->config->item('capping_level_2')){
				$isLevelActive = true;
			}elseif ($level==4 && $total_level_amt >= $this->config->item('capping_level_3')){
				$isLevelActive = true;
			}elseif ($level==5 && $total_level_amt >= $this->config->item('capping_level_4')){
				$isLevelActive = true;
			}elseif ($level==6 && $total_level_amt >= $this->config->item('capping_level_5') || 
				$level==7 && $total_level_amt >= $this->config->item('capping_level_5') ||
				$level==8 && $total_level_amt >= $this->config->item('capping_level_5')){ 
				$isLevelActive = true; 
			}elseif ($level==9 && $total_level_amt >= $this->config->item('capping_level_9') || $level==10 && $total_level_amt >= $this->config->item('capping_level_9')){
				$isLevelActive = true;
			}elseif ($level>=11 && $total_level_amt >= $this->config->item('capping_level_11') &&
					 $level<=15 && $total_level_amt >= $this->config->item('capping_level_11')){
				$isLevelActive = true;
			}elseif ($level>=16 && $total_level_amt >= $this->config->item('capping_level_16') &&
					 $level<=20 && $total_level_amt >= $this->config->item('capping_level_16')){
				$isLevelActive = true;
			}else{
				$isLevelActive = false;
			}

			if ($data && $isLevelActive==true) 
			{ 
				foreach ($data as $res) 
				{ 
				  	$level_memberID 	= $res->level_member_id;
 					$memberPackageAmt   = getMemberPackageAmt($level_memberID);
					$dailyPercentage 	= $this->config->item('config_daily_percentage');
					$finalDailyAmt		= ($memberPackageAmt) * $dailyPercentage/100;
					
					if ($finalDailyAmt!='') 
					{   
						$finalLevelAmt	= ($finalDailyAmt) * $level_percentage[$level]/100; 
						$levelIncome = array('income_member_id' =>$memberID,
											 'income_member_by' =>$level_memberID,
											 'income_level' 	=>$level,
											 'income_package_id'=>$currentPackage,
											 'income_percentage'=>$level_percentage[$level],
											 'income_amount'    =>round($finalLevelAmt),
											 'income_date'      =>date('Y-m-d')
											); 

						$isExist = $this->db->get_where('level_income',array('income_member_id' =>$memberID,'income_member_by'=>$level_memberID))->row();
						
						if ($isExist=='') 
						{
							$this->db->insert('level_income',$levelIncome);  
						}
					}
				} 
			}

			$level++;
			$level_l++;
    	}    
    }

    public function get_level_income($memberID,$level = '')
    {
    	$this->db->select('*');
    	$this->db->from('level_income'); 
    	$this->db->where('income_member_id',$memberID); 
    	if ($level!='') 
    	{
    		$this->db->where('income_level',$level);  
    	}
    	$this->db->where('income_type','level');
    	$this->db->order_by('income_date DESC');
    	$q = $this->db->get();    	 
    	return $q->result();
    }

    public function get_levels($memberID,$level)
    {
    	$this->db->select('roi_upline_level.level_member_id,roi_upline_level.level_date,roi_upline_level.level_'.$level);
    	$this->db->from('roi_upline_level'); 
    	$this->db->join('members','members.member_id=roi_upline_level.level_member_id'); 
    	$this->db->where('roi_upline_level.level_'.$level,$memberID);
    	$this->db->where('members.member_status','Approve'); 
    	$q = $this->db->get();    	 

    	return $q->result();
    }

    /*public function get_levels_package_amt($memberID,$level)
    {
    	$this->db->select('SUM(package_amount) as total_amt');
    	$this->db->from('roi_upline_level'); 
    	$this->db->join('members','members.member_id=roi_upline_level.level_member_id'); 
    	$this->db->join('pckages','pckages.package_id=members.member_package_id'); 
    	$this->db->where('level_'.$level,$memberID); 
    	$this->db->group_by('level_'.$level);  
    	$q = $this->db->get();    	 
    	$responce = $q->row(); 
    	if ($responce) 
    	{
    		 return $responce->total_amt;
    	}
    } */
    
    public function get_levels_package_amt($memberID,$level)
    {
    	/*$this->db->select('SUM(package_amount) as total_amt,level_member_id');
    	$this->db->from('roi_upline_level'); 
    	$this->db->join('members','members.member_id=roi_upline_level.level_member_id'); 
    	$this->db->join('pckages','pckages.package_id=members.member_package_id'); 
    	$this->db->where('level_'.$level,$memberID); 
    	$this->db->group_by('level_'.$level.',level_member_id');  
    	$q = $this->db->get();    	 
    	$responce = $q->row(); 
    	  
    	if ($responce) 
    	{
    		 return $responce->total_amt;
    	}*/

    	$this->db->select('package_amount,member_id');
    	$this->db->from('roi_upline_level'); 
    	$this->db->join('members','members.member_id=roi_upline_level.level_member_id'); 
    	$this->db->join('pckages','pckages.package_id=members.member_package_id'); 
    	$this->db->where('level_'.$level,$memberID); 
    	$this->db->group_by('level_member_id'); 
    	$q = $this->db->get();    	 
    	$responce = $q->result();
    	$total =0; $total2 =0;
    	if ($responce) 
    	{    		
    		foreach ($responce as $key) 
    		{    			  
    			$total=$total+$key->package_amount; 

    			$topup = $this->get_topup_data($memberID,$key->member_id,$level); 
    			if ($topup) 
    			{
    				 
    				$pk = getMemberPackage($topup->member_package_id); 
    				$total=$total+$pk->package_amount; 
    			}   
    		} 
    	} 
    	 
    	$final = $total;
    	return $final; 
    } 

    public function get_topup_data($upline_id,$member_id,$level)
    {
    	$this->db->select('*');
		$this->db->from('members'); 
		$this->db->join('topup_members','topup_members.member_id=members.member_id'); 
		$this->db->where('members.member_sponsored',$upline_id); 
		$this->db->where('topup_members.member_id',$member_id); 
		$this->db->where('topup_members.member_topup_level',$level); 
		$q = $this->db->get();
		return $topup = $q->row();
    }
    public function check_topup_epin($topupEpin,$member_id)
    {
    	$this->db->select('*');
		$this->db->from('epin');   
		$this->db->join('pckages','pckages.package_id=epin.epin_package_id');   
		$this->db->where('epin.epin',$topupEpin);    
		$this->db->where('epin.epin_status','Unused');
		$q = $this->db->get();
	    $epin_res = $q->row(); 

	    $this->db->select('pckages.*');
		$this->db->from('members'); 
		$this->db->join('pckages','pckages.package_id=members.member_current_package');   
		$this->db->where('members.member_id',$member_id);    
		$this->db->where('members.member_status','Approve');    
		$q = $this->db->get();
	    $member_res = $q->row();  

	    if ($epin_res!='' && $member_res!='') 
	    { 
	    	 if ($epin_res->package_amount>$member_res->package_amount)
	    	 {
	    	 	 return $epin_res;
	    	 }
	    	 else
	    	 {
	    	 	return null;
	    	 }
	    }
	    else
	    {
	    	return null;
	    }
    }
    
    public function deleted_old_roi($member_id,$package_id)
    {
    	$result ='';   

    	 $this->db->select('*');
		 $this->db->from('roi_wallet');  
		 $this->db->where('status','Pending');
		 $this->db->where('member_id',$member_id); 
		 $this->db->where('package_id !=',$package_id);
		 $q = $this->db->get();
		 $result = $q->result(); 

		 if ($result) 
		 {		 	
		 	 $this->db->where('status','Pending');
		 	 $this->db->where('member_id',$member_id); 
		 	 $this->db->where('package_id !=',$package_id);
		 	 /*$this->db->set('status','deleted');
		 	 $this->db->update('roi_wallet');*/
		 	 $this->db->delete('roi_wallet');
		 }
    }
    
    public function get_e_wallet_list()
	{
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];
		
		$this->db->select('*');
		$this->db->from('isp_roi_wallet'); 
		$this->db->where('member_id',$member_id);
		$this->db->where('date <=',date('Y-m-d'));
		$this->db->where('status','generate');
		$q = $this->db->get();
		return $q->result();
	} 

    public function get_e_wallet($member_id,$date)
	{ 		
		//ROI Income
		$roi_amount = 0;
		$level_amount = 0;
		$this->db->select('amount');
		$this->db->from('isp_roi_wallet'); 
		$this->db->where('member_id',$member_id);
		$this->db->where('date',$date);
		$this->db->where('status','generate');
		$q = $this->db->get();
		$roi = $q->row();

		if ($roi) 
		{
			$roi_amount = $roi->amount;
		}

		//Level Income
		$this->db->select('SUM(income_amount) as level_income');
    	$this->db->from('level_income'); 
    	$this->db->where('income_member_id',$member_id);
    	$this->db->where('income_date',$date);
    	$this->db->group_by('income_date');
    	$q = $this->db->get();    	 
    	$level = $q->row();
    	 
    	if ($level) 
		{
			$level_amount = $level->level_income;
		}

		$wallet = array('roi_income' =>$roi_amount,'level_income'=>$level_amount);
		return $wallet;
	}
	
	
	public function add_roi_level_income($memberID,$currentPackage,$current_date)
    {
    	$tot_levels = $this->config->item('config_upline_roi_levels');
    	$level = 1;
    	$level_l = 1;
    	$data  = ''; 

    	$finalLevelAmt = 0; $finalDailyAmt = 0;

    	$level_percentage = $this->config->item('binary_roi_levels');
 	 	
 	 	$isLevelActive = false;
    	for ($i=0; $i < $tot_levels; $i++) 
    	{  
			$data = $this->get_levels($memberID,$level);    	 	  

			if($level==1 || $level==2){
    			$level_l = $level;
    		}elseif($level==3){
    			$level_l = 2;
    		}elseif($level==4){
    			$level_l = 3;
    		}elseif($level==5){
    			$level_l = 4;
    		}elseif ($level==6 || $level==7 || $level==8) {
    			$level_l = 6;
    		}elseif ($level==9 || $level==10) {
    			$level_l = 9;
    		}elseif ($level>=11 || $level<=15) {
    			$level_l = 11;
    		}elseif ($level>=16 || $level<=20) {
    			$level_l = 16;
    		}
  
			$total_level_amt = $this->get_levels_package_amt($memberID,$level_l);   
 			if ($level==1 || $level==2) {
				$isLevelActive = true; 
			}elseif ($level==3 && $total_level_amt >= $this->config->item('capping_level_2')){
				$isLevelActive = true;
			}elseif ($level==4 && $total_level_amt >= $this->config->item('capping_level_3')){
				$isLevelActive = true;
			}elseif ($level==5 && $total_level_amt >= $this->config->item('capping_level_4')){
				$isLevelActive = true;
			}elseif ($level==6 && $total_level_amt >= $this->config->item('capping_level_5') || 
				$level==7 && $total_level_amt >= $this->config->item('capping_level_5') ||
				$level==8 && $total_level_amt >= $this->config->item('capping_level_5')){ 
				$isLevelActive = true; 
			}elseif ($level==9 && $total_level_amt >= $this->config->item('capping_level_9') || $level==10 && $total_level_amt >= $this->config->item('capping_level_9')){
				$isLevelActive = true;
			}elseif ($level>=11 && $total_level_amt >= $this->config->item('capping_level_11') &&
					 $level<=15 && $total_level_amt >= $this->config->item('capping_level_11')){
				$isLevelActive = true;
			}elseif ($level>=16 && $total_level_amt >= $this->config->item('capping_level_16') &&
					 $level<=20 && $total_level_amt >= $this->config->item('capping_level_16')){
				$isLevelActive = true;
			}else{
				$isLevelActive = false;
			}

			if ($data && $isLevelActive==true) 
			{ 
				foreach ($data as $res) 
				{ 
				  	$level_memberID 	= $res->level_member_id;
 					$memberPackageAmt   = getMemberPackageAmt($level_memberID);
					$dailyPercentage 	= $this->config->item('config_daily_percentage');
					$finalDailyAmt		= ($memberPackageAmt) * $dailyPercentage/100;
					
				/*	if ($finalDailyAmt!='') 
					{   
						$finalLevelAmt	= ($finalDailyAmt) * $level_percentage[$level]/100; 
						$levelIncome = array('income_member_id' =>$memberID,
											 'income_member_by' =>$level_memberID,
											 'income_level' 	=>$level,
											 'income_package_id'=>$currentPackage,
											 'income_percentage'=>$level_percentage[$level],
											 'income_amount'    =>round($finalLevelAmt),
											 'income_date'      =>$current_date
											); 

						$isExist = $this->db->get_where('level_income',array('income_member_id' =>$memberID,'income_member_by'=>$level_memberID,'income_level'=>$level,'income_date'=>$current_date))->row();
						
						if ($isExist=='') 
						{
							$this->db->insert('level_income',$levelIncome);  
						}
					}*/
					
					$lmemb = getSponsorDetails($level_memberID); 
 	
 					if(date('D',strtotime($current_date))=='Sat' ||date('D',strtotime($current_date))=='Sun'){ 
 					}
					elseif ($finalDailyAmt!='' && $current_date>=$lmemb->member_active_date) 
					{   
						$finalLevelAmt	= ($finalDailyAmt) * $level_percentage[$level]/100; 
						$levelIncome = array('income_member_id' =>$memberID,
											 'income_member_by' =>$level_memberID,
											 'income_level' 	=>$level,
											 'income_package_id'=>$currentPackage,
											 'income_percentage'=>$level_percentage[$level],
											 'income_amount'    =>round($finalLevelAmt),
											 'income_date'      =>$current_date
											); 

						$isExist = $this->db->get_where('level_income',array('income_member_id' =>$memberID,'income_member_by'=>$level_memberID,'income_level'=>$level,'income_date'=>$current_date))->row();
						
						if ($isExist=='') 
						{
							$this->db->insert('level_income',$levelIncome);  
						}
					}else{}
				} 
			}

			$level++;
			$level_l++;
    	}    
    }
    
    public function add_withdraw_request($total_balence,$pendingRequest)
	{
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];
		 
		$request_amount = $this->input->post('request_amount');
		$request_type = $this->input->post('requestType');		 

		$totamt = $this->input->post('amt');
		$tds = $this->input->post('tds');
		$admin_charges = $this->input->post('admin_charges');

		//checking multiple of 500
		$remainder = ($request_amount%100);
		  
		if ($request_type=='ROI') 
		{ 			
			$balance = $total_balence; 
			//get max & min withdraw limit
			$min_limit = 50;
			$max_limit = 10000;
		} 
 		
 		if($request_amount > $balance )
		{
			$err = "Request Amount is Greater than Balance amount";
			$this->session->set_flashdata('fail', $err);
			redirect(base_url().'home/withdrawal_request');
		} 
		else if($pendingRequest)
		{
			$err="Withdrawal Request allready sent";
			$this->session->set_flashdata('fail', $err);
			redirect(base_url().'home/withdrawal_request');
		}
		else if($remainder!=0)
		{
			$err = "Request Amount should be multiple of 1000 rs";
			$this->session->set_flashdata('fail', $err);
			redirect(base_url().'home/withdrawal_request');
		}
		else 
		{   
			$gst_charge=0;	

			$req = array('withdrawal_request_type'=>$request_type,
						 'member_id'=>$member_id,
						 'withdrawal_request_amount'=>$totamt,
						 'withdrawal_admin_charges'=>$admin_charges,
						 'withdrawal_tds_charges'=>$tds,
						 'withdrawal_gst_charges'=>$gst_charge,
						 'withdrawal_net_amount'=>$request_amount,
						 'withdrawal_request_date'=>date('Y-m-d H:i:s')
						);
			$this->db->insert('isp_roi_withdrawal_request',$req);
			unset($_POST);
			return $err = "Withdrawal Request Sent Successfully";
		}
		
	}
	
	public function get_total_totalEpin_amount()
	{
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];
		
		$this->db->select('sum(withdrawal_net_amount) as totalWithdrawEPIN');
		$this->db->from('isp_roi_withdrawal_request'); 
		$this->db->where('member_id',$member_id);
		$this->db->where('withdrawal_status','paid');
		$this->db->where('withdrawal_request_type','EPIN');
		$q = $this->db->get();
		return $q->row()->totalWithdrawEPIN;
	}
        
    public function add_roi_wallet2($member_id,$package_id,$tommorowDate)
	{ 
		$this->db->select('holiday_date');
		$this->db->from('isp_holidays'); 
		$this->db->where('status','Active');
		$this->db->where('holiday_date >=',date('Y-m-d'));
		$q = $this->db->get();
		$holidays = $q->result();
		
		$totDays = 1;
		$tommorow = new DateTime('tomorrow');
		//$tommorowDate = $tommorow->format('Y-m-d'); 

		$memberPackageAmt  = getMemberPackageAmtROI($member_id);
		$dailyPercentage = $this->config->item('config_daily_percentage');
		$finalDailyAmt=($memberPackageAmt) * $dailyPercentage/100;
		
		foreach($holidays as $holid)
		{
			$holidayArray[] = $holid->holiday_date;
		}
		 
		$roi_days = $this->config->item('config_daily_roi_days');
		while($totDays <= $roi_days)
		{
			if(!empty($holidays))
			{
				if(date('D',strtotime($tommorowDate))=='Sat' || date('D',strtotime($tommorowDate))=='Sun' || in_array($tommorowDate,$holidayArray))
				{
				}
				else{
				    $isExist = $this->db->get_where('roi_wallet',array('member_id' =>$member_id,'date'=>$tommorowDate,'package_id'=>$package_id))->num_rows();
					if($isExist==0)
					{
					    $array = array('member_id'=>$member_id,'amount'=>$finalDailyAmt,'date'=>$tommorowDate,'package_id'=>$package_id);
					    $this->db->insert('roi_wallet',$array );
					}
					$totDays++;
				}
				$tommorowDate = date('Y-m-d', strtotime($tommorowDate . ' +1 day'));
			}
			else{
				if(date('D',strtotime($tommorowDate))=='Sat' || date('D',strtotime($tommorowDate))=='Sun')
				{
				}
				else{
				    $isExist = $this->db->get_where('roi_wallet',array('member_id' =>$member_id,'date'=>$tommorowDate,'package_id'=>$package_id))->num_rows();
					if($isExist==0)
					{
					    $array = array('member_id'=>$member_id,'amount'=>$finalDailyAmt,'date'=>$tommorowDate,'package_id'=>$package_id);
					    $this->db->insert('roi_wallet',$array );
					}
					$totDays++;
				}
				$tommorowDate = date('Y-m-d', strtotime($tommorowDate . ' +1 day'));
			}
		}
	}    
	
	public function get_total_transfered_amount()
	{
		$user_data = $this->session->userdata('mlm_user_logged_in');
		$member_id=$user_data['user_id'];
		
		$this->db->select('sum(withdrawal_net_amount) as totalWithdrawTransf');
		$this->db->from('isp_roi_withdrawal_request'); 
		$this->db->where('member_id',$member_id);
		$this->db->where('withdrawal_status','paid');
		$this->db->where('withdrawal_request_type','Transfer');
		$q = $this->db->get();
		return $q->row()->totalWithdrawTransf;
	}
    
    public function getLevelsMember($memberID,$level)
    {
    	$this->db->select('*');
    	$this->db->from('roi_upline_level');
    	if ($level!='') 
    	{
    		$this->db->where('level_'.$level,$memberID);  
    	} 
    	$this->db->group_by('level_member_id');
    	$this->db->order_by('level_date DESC');
    	$q = $this->db->get();    	 
    	return $q->result_array();
    	//echo $this->db->last_query(); die();
    }

    public function add_sponsor_income($member_id,$member_by)
    {  
       $amount = $this->config->item('sponsorIncome');
		$income = array('income_member_id' 	=>$member_id,
						'income_member_by'	=>$member_by,
						'income_amount'		=>$amount,
						'income_date'		=>date('Y-m-d')
						);
		$exist = null;
		$exist = $this->db->get_where('sponsor_income',array('income_member_id' =>$member_id,'income_member_by'=>$member_by))->row();
		
		if ($exist==null) 
		{
			$this->db->insert('sponsor_income',$income); 
		}
    }
   
   public function add_levelIncome($memberid)
    {
		$current_date = date('Y-m-d');

    	$this->db->select('*');
    	$this->db->from('roi_upline_level');    
    	$this->db->where('level_member_id',$memberid);  
    	$q = $this->db->get();   
    	$uplineMembers = $q->row();
    	if ($uplineMembers) 
    	{
    		$member_id = $memberid; 
    		$tot_levels = $this->config->item('config_upline_roi_levels');
    		$level_percent = $this->config->item('binary_roi_levels');
    		$level = 1;

    		for ($i=0; $i < $tot_levels; $i++) 
	    	{ 
	    		$level_percentage = $level_percent[$level];

	    		$isTrur = true;	
	    		if ($level == 1 && $uplineMembers->level_1 != null) { 
	    		 	$memberID = $uplineMembers->level_1; 
	    		}elseif ($level == 2  && $uplineMembers->level_2 != null) { 
	    		 	$memberID = $uplineMembers->level_2; 
	    		}elseif ($level == 3  && $uplineMembers->level_3 != null) { 
	    		 	$memberID = $uplineMembers->level_3; 
	    		}elseif ($level == 4  && $uplineMembers->level_4 != null) { 
	    		 	$memberID = $uplineMembers->level_4; 
	    		} elseif ($level == 5  && $uplineMembers->level_5 != null) { 
	    		 	$memberID = $uplineMembers->level_5; 
	    		} elseif ($level == 6  && $uplineMembers->level_6 != null) { 
	    		 	$memberID = $uplineMembers->level_6; 
	    		} elseif ($level == 7  && $uplineMembers->level_7 != null) { 
	    		 	$memberID = $uplineMembers->level_7; 
	    		} elseif ($level == 8  && $uplineMembers->level_8 != null) { 
	    		 	$memberID = $uplineMembers->level_8; 
	    		}elseif ($level == 9  && $uplineMembers->level_9 != null) { 
	    		 	$memberID = $uplineMembers->level_9; 
	    		}elseif ($level == 10  && $uplineMembers->level_10 != null) { 
	    		 	$memberID = $uplineMembers->level_10; 
	    		}else{
	    			$isTrur = false;
	    		} 

	    		 if ($isTrur==true) { 
							 
					$levelIncome = array('income_member_id' =>$memberID,
										 'income_member_by' =>$member_id,
										 'income_level' 	=>$level,  
										 'income_amount'    =>round($income_amount),
										 'income_date'      =>$current_date
										); 

					$isExist = $this->db->get_where('level_income',array('income_member_id' =>$memberID,'income_member_by'=>$member_id,'income_level'=>$level))->row();
					
					if ($isExist=='') 
					{
						$this->db->insert('level_income',$levelIncome);  
					}
	    		 }

	    		$level++; 
	    	} 
    	}
    }

   public function add_level_income($memberid)
    {	
    	$current_date = date('Y-m-d');

    	$this->db->select('member_id');
    	$this->db->from('members');   
    	$this->db->where('member_id <',$memberid);  
    	//$this->db->where('member_id',$memberid);  
    	$q = $this->db->get();   
    	$uplineMembers = $q->result();

    	if ($uplineMembers) 
    	{
    		foreach ($uplineMembers as $key) 
    		{  
    			$memberID = $key->member_id;

		    	$tot_levels = $this->config->item('config_upline_roi_levels');
		    	$level = 1;
		    	$level_l = 1;
		    	$data  = ''; 

		    	$finalLevelAmt = 0; $finalDailyAmt = 0;

		    	$level_percentage = $this->config->item('binary_roi_levels'); 
		 	 	 
		    	for ($i=0; $i < $tot_levels; $i++) 
		    	{  
					$data = $this->get_levels($memberID,$level);   
					  
					if ($data) 
					{ 
						foreach ($data as $res) 
						{ 
						  	$level_memberID  = $res->level_member_id; 
							
							$finalLevelAmt	= $level_percentage[$level]; 
							$levelIncome = array('income_member_id' =>$memberID,
												 'income_member_by' =>$level_memberID,
												 'income_level' 	=>$level,  
												 'income_amount'    =>round($finalLevelAmt),
												 'income_date'      =>$current_date
												); 

							$isExist = $this->db->get_where('level_income',array('income_member_id' =>$memberID,'income_member_by'=>$level_memberID,'income_level'=>$level))->row();
							
							if ($isExist=='') 
							{
								$this->db->insert('level_income',$levelIncome);  
							}
						}  
					}

					$level++; 
		    	}   

		    	
    	 	} 
    	} 
    }

    public function add_topup_member($member_byid,$member_id)
    {
		$current_date = date('Y-m-d');

		$toTopup = $this->db->get('topup_members')->num_rows();

		$upline_id = 1;
		$upline_member = 1;
    	$position ='';
    	$level = 1; 

    	$isTrue = true;

		if($toTopup>0)
		{
			$topupMember = $this->db->order_by('topup_id ASC')->get('topup_members')->row();

			$posi = $this->getTopupNullPosition($topupMember->member_id);
			 	 
			$upline_id = $posi['upline_id']; 
			$position = $posi['position']; 
			$upline_member = $posi['upline_member']; 
		}

    	if ($isTrue==true) 
    	{ 
			$topup_data['member_id'] 			= $member_id;   
			$topup_data['member_upline_id'] 	= $upline_id;   
			$topup_data['member_topup_level'] 	= $level;   
			$topup_data['member_added_date'] 	= $current_date; 
			$topup_data['member_status'] 		= 'Approve'; 
			$topup_data['member_type'] 			= 'member';

			$isExist = $this->db->get_where('topup_members',array('member_id' =>$member_id,'member_topup_level'=>$level))->num_rows();
			if($isExist==0)
			{
				$this->db->insert('topup_members',$topup_data);

				$topup_id = $this->db->insert_id();
	 			
				$this->db->where('member_id',$member_id); 
		 		$this->db->set('member_current_topup',$topup_id); 
		 		$this->db->update('members'); 

		 		if($position!='')
		 		{
		 			if ($position=='1') {
						$arrays=array( 
							"member_position_1"=>$member_id
						); 
					}else if($position=='2'){
						$arrays=array( 
							"member_position_2"=>$member_id
						); 
					}else{
						$arrays=array( 
							"member_position_3"=>$member_id
						); 
					}  	
					$this->db->where('member_id',$upline_id);
					$up=$this->db->update('topup_members',$arrays);
		 			
		 			$this->add_topup_income($member_id,$upline_member,$level); 
		 		}

			}
		}

    }

    public function add_topup_income($level_memberID,$memberID,$level='')
    {
    	$level = $this->db->order_by('topup_id DESC')->get_where('topup_members',array('member_id'=>$memberID))->row()->member_topup_level;

    	$current_date = date('Y-m-d'); 
    	$finalLevelAmt = 10;
    	$levelIncome = array('income_member_id' =>$memberID,
							 'income_member_by' =>$level_memberID,
							 'income_level' 	=>$level,  
							 'income_amount'    =>round($finalLevelAmt),
							 'income_date'      =>$current_date
							); 

		$isExist = $this->db->get_where('topup_income',array('income_member_id' =>$memberID,'income_member_by'=>$level_memberID,'income_level'=>$level))->row();
		
		if ($isExist=='') 
		{
			$this->db->insert('topup_income',$levelIncome);  
		}

		$allToppers = $this->db->get_where('topup_members',array('member_id !='=>$memberID,'member_topup_level'=>$level))->result();
		if($allToppers)
		{
			foreach ($allToppers as $row) 
			{
				$salfPosi = null; $upUser = null;

				$topMember_id = $row->member_id;
				$salfPosi = getTopupEmptyPosition($topMember_id);
				
				$upUser = getTopupUplineId($topMember_id,$level);

				  if ($salfPosi==null) 
				  { 
				  	if ($upUser!=null) 
				  	{ 
					  	$req = array('withdrawal_request_type'=>'NEXT AUTO UPGRED',
									 'member_id'=>$topMember_id, 
									 'withdrawal_net_amount'=>20,
									 'withdrawal_name_slip'=>getMemberName($topMember_id),
									 'withdrawal_payment_type'=>'NEXT AUTO UPGRED',
									 'withdrawal_status'=>'paid',
									 'withdrawal_request_date'=>date('Y-m-d H:i:s')
									);
					  	$isExist_w = $this->db->get_where('isp_roi_withdrawal_request',array('member_id' =>$topMember_id,'withdrawal_net_amount'=>20,'withdrawal_payment_type'=>'NEXT AUTO UPGRED'))->row();
		
						if ($isExist_w=='') 
						{
							$this->db->insert('isp_roi_withdrawal_request',$req);
						}
					}
				  }
				     
			  	$doenlines = countMyTopupTeam($topMember_id,$level);
			  	if($doenlines>=9)
			  	{
			  		

			    	$finalLevelAmt2 = 20;
			    	$levelIncome2 = array('income_member_id' =>$topMember_id,
										 'income_member_by' =>$level_memberID,
										 'income_level' 	=>$level,  
										 'income_amount'    =>round($finalLevelAmt2),
										 'income_date'      =>$current_date
										);  
					$isExist_i = $this->db->get_where('topup_income',array('income_member_id' =>$topMember_id,'income_member_by'=>$level_memberID,'income_level'=>$level))->row();

					$isExist_i20 = $this->db->get_where('topup_income',array('income_member_id' =>$topMember_id,'income_amount'=>$finalLevelAmt2,'income_level'=>$level))->num_rows();

					if ($isExist_i=='' && $isExist_i20<9) 
					{
						$this->db->insert('topup_income',$levelIncome2); 

						$req = array('withdrawal_request_type'=>'NEXT AUTO UPGRED',
									 'member_id'=>$topMember_id, 
									 'withdrawal_net_amount'=>110,
									 'withdrawal_name_slip'=>getMemberName($topMember_id),
									 'withdrawal_payment_type'=>'NEXT AUTO UPGRED',
									 'withdrawal_status'=>'paid',
									 'withdrawal_request_date'=>date('Y-m-d H:i:s')
									);
					  	$isExist_w = $this->db->get_where('isp_roi_withdrawal_request',array('member_id' =>$topMember_id,'withdrawal_net_amount'=>110,'withdrawal_payment_type'=>'NEXT AUTO UPGRED'))->row();
		
						if ($isExist_w=='') 
						{
							$this->db->insert('isp_roi_withdrawal_request',$req);
						}

					}
				}
				 
			}
		}

		
    }

    public function getEmptyPositionAutopool()
    {
    	$this->db->select('*'); 
    	$this->db->from('topup_members');  
    	$query = $this->db->get(); 
    	$members = $query->result();

    	$position=null;	

    	if ($members) 
    	{
    		foreach ($members as $value) 
    		{
    			$salfPosi=null;
    			$member_id = $value->member_id;
    			$salfPosi = getTopupEmptyPosition($member_id);
			 
				if ($salfPosi!=null) 
				{
					$position = $salfPosi;
					break;
				} 
    		}  
    	}

    	return $position;


    }
   
   public function getTopupNullPosition($member_id)
	{
	  $salfPosi = getTopupEmptyPosition($member_id);
	  if ($salfPosi!=null) {
	  	return $salfPosi;
	  }else{
	  	$p = $this->getMyDownlinePosition($member_id,$position = '1'); 
		if ($p) 
		{
			return $p;
		}
		else
		{
			return null;
		}
	  }
	}
	public function getMyDownlinePosition($member_id,$position)
	{ 
		$user = get_topupRow($member_id);
 		 
 		$ar = '';
		if ($user) 
		{ 
			$mem_1 = $user->member_position_1;
			$mem_2 = $user->member_position_2;
			$mem_3 = $user->member_position_3;	

			$salfPosi_1 = getTopupEmptyPosition($mem_1);
			$salfPosi_2 = getTopupEmptyPosition($mem_2);
			$salfPosi_3 = getTopupEmptyPosition($mem_3);

			if ($salfPosi_1!=null) 
			{
			  	$ar = $salfPosi_1;
			}
			else if ($salfPosi_2!=null) 
			{
				$ar = $salfPosi_2;
			}
			else if ($salfPosi_3!=null) 
			{
				$ar = $salfPosi_3;
			}
			else
			{
				$user2 = get_topupRow($mem_1);
				$mem_21 = $user2->member_position_1;
				$mem_22 = $user2->member_position_2;
				$mem_23 = $user2->member_position_3;	

				$salfPosi_21 = $mem_21 ? getTopupEmptyPosition($mem_21): null;
				$salfPosi_22 = $mem_22 ? getTopupEmptyPosition($mem_22) : null;
				$salfPosi_23 = $mem_23 ? getTopupEmptyPosition($mem_23) : null;

				if ($salfPosi_21!=null) 
				{
				  	$ar = $salfPosi_21;
				}
				else if ($salfPosi_22!=null) 
				{
					$ar = $salfPosi_22;
				}
				else if ($salfPosi_23!=null) 
				{
					$ar = $salfPosi_23;
				}
				else
				{
					$user3 = get_topupRow($mem_2);
					$mem_31 = $user3->member_position_1;
					$mem_32 = $user3->member_position_2;
					$mem_33 = $user3->member_position_3;	
 
					$salfPosi_31 = $mem_31 ? getTopupEmptyPosition($mem_31): null;
					$salfPosi_32 = $mem_32 ? getTopupEmptyPosition($mem_32) : null;
					$salfPosi_33 = $mem_33 ? getTopupEmptyPosition($mem_33) : null;

					if ($salfPosi_31!=null) 
					{
					  	$ar = $salfPosi_31;
					}
					else if ($salfPosi_32!=null) 
					{
						$ar = $salfPosi_32;
					}
					else if ($salfPosi_33!=null) 
					{
						$ar = $salfPosi_33;
					}
					else
					{
						$user4 = get_topupRow($mem_3);
						$mem_41 = $user4->member_position_1;
						$mem_42 = $user4->member_position_2;
						$mem_43 = $user4->member_position_3;	 

						$salfPosi_41 = $mem_31 ? getTopupEmptyPosition($mem_41): null;
						$salfPosi_42 = $mem_32 ? getTopupEmptyPosition($mem_42) : null;
						$salfPosi_43 = $mem_33 ? getTopupEmptyPosition($mem_43) : null;

						if ($salfPosi_41!=null) 
						{
						  	$ar = $salfPosi_41;
						}
						else if ($salfPosi_42!=null) 
						{
							$ar = $salfPosi_42;
						}
						else if ($salfPosi_43!=null) 
						{
							$ar = $salfPosi_43;
						}
						else
						{
							if($position=='1'){
								$position = '1';
							    $ar = $this->getMyDownlinePosition($mem_1,$position);
						    }else if($position=='2'){
						    	$position = '2';
						        $ar = $this->getMyDownlinePosition($mem_2,$position);
						    }else{
						    	$position = '3';
						        $ar = $this->getMyDownlinePosition($mem_3,$position);
						    } 
						}	
					}
				}
			} 
			 
			return $ar;
		}

	}

	public function getTopupMyNullPosition($member_id,$level)
	{
	  $salfPosi = getTopupMyEmptyPosition($member_id,$level);
	  if ($salfPosi!=null) {
	  	return $salfPosi;
	  }else{
	  	 
			return null; 
	  }
	}

 
	public function checkTopupLevel($member_id)
	{     	 
	  $this->db->select('*');
	  $this->db->from('topup_members');
	  $this->db->where('member_id',$member_id);
	  $this->db->order_by('topup_id','DESC');
	  $row = $this->db->get();
	  $isTopup = $row->row();

		if ($isTopup!=null) 
		{ 	
			$isTrue= false;
			$salfPosi = getTopupEmptyPosition($member_id);

			if ($salfPosi==null) 
			{
			 	$level = $isTopup->member_topup_level+1;

				$myDownlines = countMyTopupTeam($member_id);

				if ($level==2 && $myDownlines>=27) {  
					 
					$isTrue = true;
				}elseif ($level==3 && $myDownlines>=81) {  
					$isTrue = true;
				}else{
					$isTrue = false;
				} 
 
				if ($isTrue==true) 
		    	{ 
		    		$current_date = date('Y-m-d'); 

		    		$topupMember = $this->db->order_by('topup_id ASC')->get('topup_members')->row();
		    		$posi = $this->getTopupMyNullPosition($topupMember->member_id,$level);
			 	 	 
			 	 	if($posi==null)
			 	 	{
			 	 		$upline_id = 1;
			 	 		$upline_member = 1;
			 	 		$position = null;
			 	 	}else{
			 	 		$upline_id = $posi['upline_id']; 
						$position = $posi['position'];
						$upline_member = $posi['upline_member'];
			 	 	}
					

					$topup_data['member_id'] 			= $member_id;   
					$topup_data['member_upline_id'] 	= $upline_id;   
					$topup_data['member_topup_level'] 	= $level;   
					$topup_data['member_added_date'] 	= $current_date; 
					$topup_data['member_status'] 		= 'Approve'; 
					$topup_data['member_type'] 			= 'member';

					$isExist = $this->db->get_where('topup_members',array('member_id' =>$member_id,'member_topup_level'=>$level))->num_rows();


					if($isExist==0)
					{
						$this->db->insert('topup_members',$topup_data);

						$topup_id = $this->db->insert_id();
			 			
						$this->db->where('member_id',$member_id); 
				 		$this->db->set('member_current_topup',$topup_id); 
				 		$this->db->update('members'); 

				 		if($position!='')
				 		{
				 			if ($position=='1') {
								$arrays=array( 
									"member_position_1"=>$member_id
								); 
							}else if($position=='2'){
								$arrays=array( 
									"member_position_2"=>$member_id
								); 
							}else{
								$arrays=array( 
									"member_position_3"=>$member_id
								); 
							}  	
							$this->db->where('member_id',$upline_id);
							$up=$this->db->update('topup_members',$arrays);
				 			
				 			$this->add_topupIncome($member_id,$upline_member,$level); 
				 		}

					}
				}
			 } 
		} 
	}

	public function add_topupIncome($level_memberID,$memberID,$level='')
    { 
    	$topupPool = null;
		$topupPool = get_auto_pools($level);

		$myDownlinesMembers = countTopupMyDownlines($memberID,$level);
		if($myDownlinesMembers>0)
		{
			$salfPosi = checkTopupEmptyPosition($memberID,$level);
		 
			if($salfPosi!=null){ 
				$levelAmt = $topupPool[0]->pool_upgred;
				$levelMembers = $topupPool[0]->pool_members;
				$levelAuto_upgred = $topupPool[0]->pool_nextAuto_upgred;
			}else{
				$levelAmt = $topupPool[1]->pool_upgred;
				$levelMembers = $topupPool[1]->pool_members;
				$levelAuto_upgred = $topupPool[1]->pool_nextAuto_upgred;
			}	  

	    	$current_date = date('Y-m-d');  

	    	$levelIncome = array('income_member_id' =>$memberID,
								 'income_member_by' =>$level_memberID,
								 'income_level' 	=>$level,  
								 'income_amount'    =>round($levelAmt),
								 'income_date'      =>$current_date
								); 
	    	 
			$isExist = $this->db->get_where('topup_income',array('income_member_id' =>$memberID,'income_member_by'=>$level_memberID,'income_level'=>$level))->row();
			
			if ($isExist=='') 
			{
				$this->db->insert('topup_income',$levelIncome);   
			}

	 		if($myDownlinesMembers >=$levelMembers)
			{ 
	 			$upUser= getTopupUplineId($memberID,$level);

			  if ($salfPosi==null) 
			  {  
			  	if ($upUser==null) { 
				  	$req = array('withdrawal_request_type'=>'NEXT AUTO UPGRED',
								 'member_id'=>$memberID, 
								 'withdrawal_net_amount'=>$levelAuto_upgred,
								 'withdrawal_name_slip'=>getMemberName($memberID),
								 'withdrawal_payment_type'=>'NEXT AUTO UPGRED',
								 'withdrawal_status'=>'paid',
								 'withdrawal_request_date'=>date('Y-m-d H:i:s')
								);
					$this->db->insert('isp_roi_withdrawal_request',$req);
				}
			  } 

			  	if($myDownlinesMembers>=9)
			  	{ 
			    	$levelIncome2 = array('income_member_id' =>$upUser,
										 'income_member_by' =>$level_memberID,
										 'income_level' 	=>$level,  
										 'income_amount'    =>round($levelAmt),
										 'income_date'      =>$current_date
										);  
					 

					$isExist_i = $this->db->get_where('topup_income',array('income_member_id' =>$upUser,'income_member_by'=>$level_memberID,'income_level'=>$level))->row();

					$isExist_i20 = $this->db->get_where('topup_income',array('income_member_id' =>$upUser,'income_amount'=>$finalLevelAmt2,'income_level'=>$level))->num_rows();

					if ($isExist_i=='' && $isExist_i20<9) 
					{
						$this->db->insert('topup_income',$levelIncome2);  

						$req = array('withdrawal_request_type'=>'NEXT AUTO UPGRED',
								 'member_id'=>$memberID, 
								 'withdrawal_net_amount'=>$levelAuto_upgred,
								 'withdrawal_name_slip'=>getMemberName($memberID),
								 'withdrawal_payment_type'=>'NEXT AUTO UPGRED',
								 'withdrawal_status'=>'paid',
								 'withdrawal_request_date'=>date('Y-m-d H:i:s')
								);
						$this->db->insert('isp_roi_withdrawal_request',$req);

					}
				}
			} 
		}
		
    }

    public function addAutoPool($member_byid,$member_id)
    {
    	ini_set('max_execution_time', 0);

    	$current_date = date('Y-m-d');

		$toTopup = $this->db->get('topup_members')->num_rows();

		$upline_id = 0;
		$upline_member = 0;
    	$position ='';
    	$level = 1; 

    	$isTrue = true;

    	if($toTopup>0)
		{
			//$topupMember = $this->db->order_by('topup_id ASC')->get('topup_members')->row();

			//$posi = $this->getTopupNullPosition($topupMember->member_id);
			
			$posi = $this->Home_model->getEmptyPositionAutopool(); 	 

			$upline_id = $posi['upline_id']; 
			$position = $posi['position']; 
			$upline_member = $posi['upline_member']; 
		}

		if ($isTrue==true) 
    	{ 
			$topup_data['member_id'] 			= $member_id;   
			if($upline_id!=0){
				$topup_data['member_upline_id'] 	= $upline_id;   
			}
			$topup_data['member_topup_level'] 	= $level;   
			$topup_data['member_added_date'] 	= $current_date;  

			$isExist = $this->db->get_where('topup_members',array('member_id' =>$member_id))->num_rows();
			if($isExist==0)
			{
				$this->db->insert('topup_members',$topup_data); 
				$topup_id = $this->db->insert_id();

				$this->db->where('member_id',$member_id); 
		 		$this->db->set('member_current_topup',$topup_id); 
		 		$this->db->update('members'); 

		 		if($position!='')
		 		{
		 			if ($position=='1') {
						$arrays=array( 
							"member_position_1"=>$member_id
						); 
					}else if($position=='2'){
						$arrays=array( 
							"member_position_2"=>$member_id
						); 
					}else{
						$arrays=array( 
							"member_position_3"=>$member_id
						); 
					}  	
					$this->db->where('member_id',$upline_id);
					$up=$this->db->update('topup_members',$arrays);
		 			
		 			if($upline_id!=0){
			 			$this->add_AutopoolUpline_level_members($member_id,$upline_id);

			 			$levelIncome = array('income_member_id' =>$upline_id,
											 'income_member_by' =>$member_id,
											 'income_level' 	=>1,  
											 'income_rank' 		=>'Executive',  
											 'income_amount'    =>10,
											 'income_date'      =>$current_date
											); 
				    	
				    	$isExist = $this->db->get_where('topup_income',array('income_member_id' =>$upline_id,'income_member_by'=>$member_id,'income_level'=>1))->row();
					
						if ($isExist=='') 
						{
							$this->db->insert('topup_income',$levelIncome);   

							$this->db->where('member_id',$upline_id);
							$this->db->set('member_topupRank','Executive');
							$this->db->update('members');

							$data = $this->get_topupLevels($upline_id,1);
							$myDownlinesMembers = count($data);
							if($myDownlinesMembers>=3)
							{
								$req = array('withdrawal_request_type'=>'NEXT AUTO UPGRED',
											 'member_id'=>$upline_id, 
											 'withdrawal_net_amount'=>20,
											 'withdrawal_name_slip'=>getMemberName($upline_id),
											 'withdrawal_payment_type'=>'NEXT AUTO UPGRED',
											 'withdrawal_status'=>'paid',
											 'withdrawal_request_date'=>date('Y-m-d H:i:s')
											); 

								$isWith = $this->db->get_where('roi_withdrawal_request',array('member_id' =>$upline_id,'withdrawal_net_amount'=>20))->row();

								if ($isWith==null) {
									$this->db->insert('isp_roi_withdrawal_request',$req);
								}

								$upline2_id = null;  

								$upline_members= $this->getAutoUplineMembers($upline_id);
								if ($upline_members!=null) 
								{  
									$upLevel = 2; 
									$upline2_id = $upline_members['upline_'.$upLevel.''];
								}

								if($upline2_id==0)
								{
									$admin = $this->db->get_where('members',array('member_type'=>'admin_member'))->row()->member_id;
									$req = array( 
												 'income_member_id'=>$admin, 
												 'income_member_by'=>$upline_id, 
												 'income_level' 	=>1,  
												 'income_amount' 	=>20,    
											     'income_rank' 		=>'Silver-Admin',  
												 'income_date'=>date('Y-m-d')
												); 
 
									//$this->db->insert('isp_topup_upgrade_income',$req);  
								}
								else
								{  
									$req = array( 
												 'income_member_id'=>$upline2_id, 
												 'income_member_by'=>$upline_id, 
												 'income_level' 	=>2,  
												 'income_amount' 	=>20,    
											     'income_rank' 		=>'Silver',  
												 'income_date'=>date('Y-m-d')
												); 

									$isWith = $this->db->get_where('isp_topup_upgrade_income',array('income_member_id' =>$upline2_id,'income_member_by'=>$upline_id))->row();
									if ($isWith==null) {
										$this->db->insert('isp_topup_upgrade_income',$req); 
									} 
								}
								
							}
						}
					}
 
		 			//$this->upgrade_income();
		 			$this->upgradeAutopool_income();
		 		}
			}
		}

    } 

    public function getAutoUplineMembers($member_id)
    {  
    	$sql        = "select level_1 as upline_1,level_2 as upline_2,level_3 as upline_3,level_3 as upline_3,level_4 as upline_4,level_5 as upline_5,level_6 as upline_6 from `isp_topup_upline_level` where `level_member_id` ='".$member_id."' ";
		$result     = $this->db->query($sql);
		$getnnum = $result->result_array();  

		if ($getnnum) {
			return $getnnum[0]; 
		}else{
			return null;
		}
    } 

    

    function generateRandomPin($length = 2) 
	{	
		$digit = date('H').date('i').date('s'); 
	    $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
	    $charactersLength = strlen($characters);
	    $randomString = '';
	    for ($i = 0; $i < $length; $i++) {
	        $randomString .= $characters[rand(0, $charactersLength - 1)];
	    }
	    return $digit.$randomString;
	}

 public function check_mobile($id)
    {
        
        $this->db->select('members.*,count(*) as cnt');
        $this->db->from('members');
        $this->db->where('member_mobile',"+".$id);
        // $this->db->where('status','Pending');
        $query=$this->db->get();
        //echo $this->db->last_query();die;
        return $query->result();
    }

function insertData( $table ) {

        $fields = $this->db->list_fields( $table );
        $data = array();
        foreach ( $fields as $field ) {
            if (isset($_POST[$field]))
			{
                $data[$field]= $this->input->post($field);
                if (is_array($_POST[$field])) 
				{
				 $data[$field] = implode( ',',array_map('strtolower',$this->input->post($field)) );
				}
				else
				{
					$data[$field]= $this->input->post($field);
				}
            }
        }
        $result=$this->db->insert($table, $data);
		return $result;
    }
    public function get_latest_deposite()
    { 
    
    	$this->db->select('*');
    	$this->db->from('member_packages');
    	$this->db->where('status','Active');
 
    	//$this->db->where_not_in('package_id',$member_have);
    	$this->db->order_by('member_packageid','desc');
    	$this->db->limit(5);
    	$q = $this->db->get();    	 
    	return $q->result(); 
    }
   public function get_latest_withdrawal()
    { 
    
    	$this->db->select('*');
    	$this->db->from('isp_roi_withdrawal_request');
    	 $this->db->where('withdrawal_status','paid');  
    	$this->db->where('(withdrawal_request_type = "ROI" or withdrawal_request_type = "Bonus")');
    	$this->db->order_by('roi_withdrawal_request_id','desc');
    	$this->db->limit(5);
    	$q = $this->db->get();    	 
    	return $q->result(); 
    }
  
    public function get_sum_paid_amt()
    {
    	 $where = "withdrawal_status='paid' AND (withdrawal_request_type='ROI' OR withdrawal_request_type='Bonus')";
    	$this->db->select('SUM(withdrawal_request_amount) as total_amt');
    	$this->db->from('isp_roi_withdrawal_request'); 
    	$this->db->where($where); 
    	$q = $this->db->get();    	 
    	$responce = $q->row(); 
    	if ($responce) 
    	{
    		 return $responce->total_amt;
    	}
    }
     public function get_daily_new()
    {
    	$this->db->select('*');
    	$this->db->from('isp_dailynews'); 
    
    		$this->db->where('status','active'); 
    	$q = $this->db->get();    	 
    
    	return $q->result();
    }

public function getmemcount()
    {
        $this->db->select('members.member_id,members.is_paid,members.member_status');
		 $this->db->from('members'); 
 		 $this->db->where('members.member_status','Approve');
		 $this->db->where('members.is_paid','Yes');
		 $q = $this->db->get();
  		 $result = $q->result();
  	
  		 if($result!="")
  		 {
  		     $workers=0;$investors=0;
            foreach($result as $key)
            {
                $self_stak_invest=0; $direct_mem=0;
			    $self_stak_invest=getMemberPackageAmtsum($key->member_id);

    			if($self_stak_invest>=200)
    			{
    			   
			       $direct_mem=getMySponsor1($key->member_id);
			      if($direct_mem >= 3)
			      {
			          $workers=$workers+1;
			        
			      }
			      else
			      {
			          $investors=$investors+1;
			          
			      }
			 }
    	}
  		 }
  		 $data1=array($investors,$workers);
  		return $data1;
    }

public function add_dailystaking_withdraw_request($request_type)
{		
	$user_data = $this->session->userdata('mlm_user_logged_in');
    $member_id=$user_data['user_id'];

	$request_amount=0;$tds=0;$service_charges=0;$net_payout=0;$admin_charges=0;
// 	$totalIncome 			= getTotalIncome($member_id); //get Available Balance
// 	$totalWithdraw 			= getTotalWithdrawal($member_id);
// 	$pending_withdrawal 	= getTotalPendingWithdrawal($member_id);
// 	$totalbalence 			= $totalIncome - $totalWithdraw -$pending_withdrawal;
	
	    $data['totalIncome']=$totalIncome= getTotalROI($member_id); //get Available Balance
		$data['totalWithdraw'] =	$totalWithdraw 			= getTotalpaiddailyWithdrawal($member_id);
		$data['pending_withdrawal'] =	$pending_withdrawal 	= getTotaldailyPendingWithdrawal($member_id);
		$data['reinvestment_withdrawal'] =	$reinvestment_withdrawal 	= getTotalreinvestmentWithdrawal1($member_id);
		$totalbalence 			= $totalIncome - $totalWithdraw - $pending_withdrawal - $reinvestment_withdrawal;
		$data['totalbalence'] 	= $totalbalence;
	
		$usdt_address = $btc_address = $eth_address = null;
		$additional_cashback = 0;
		if($request_type == 'ROI'){
			$request_amount = escapeStr($this->input->post('usdt_withdrawal'));
			$amt1 				= $request_amount;
			
			$tds 				= (($amt1) * $this->config->item('config_tds_charges')/100);
			$admin_charges		= (($amt1)*$this->config->item('config_admin_charges')/100); 
			$service_charges	= (($amt1)*$this->config->item('config_service_charges')/100); 
			$net_payout			= (($amt1)-$tds-$service_charges-$admin_charges); 
			if($totalbalence < $net_payout )
			{
			    
				$response = array(
					'status' 	=> "0",
					'additional_cashback' => $additional_cashback,
					'msg' 		=> "Request Amount is Greater than Balance amount"
				);
				return $response;
			}
				$wallet_details = getwalletDetails($member_id);
			if($wallet_details!="")
			{
			  if($wallet_details->member_payment_option=="btc_address")
			  {
			      $btc_address=$wallet_details->member_btc_address;
			      $payment_option = $wallet_details->member_payment_option;
			  }
			  if($wallet_details->member_payment_option=="usdt_address")
			  {
			      $usdt_address=$wallet_details->member_usdt_address;
			      $payment_option = $wallet_details->member_payment_option;
			  }
			  if($wallet_details->member_payment_option=="eth_address")
			  {
			      $eth_address=$wallet_details->member_eth_address;
			      $payment_option = $wallet_details->member_payment_option;
			  }
			 //   if($wallet_details->member_payment_option=="usdt_address"){ $data['address']=$address=$wallet_details->member_usdt_address; }
			 //   if($wallet_details->member_payment_option=="eth_address"){ $data['address']=$address=$wallet_details->member_eth_address;  }
		
			}
		
// 			if($usdt_address!=''){
// 					$payment_option = 'usdt_address';
// 			}else if($btc_address!=''){
// 					$payment_option = 'btc_address';
// 			}else{
// 				$payment_option = 'eth_address';
// 			}
			$withdrawal_status  = 'pending';
		}else if($request_type == 'Reinvestment-Staking'){
			$request_amount = escapeStr($this->input->post('usdt_reinvestment'));
			$amt1 				= $request_amount;			
			$admin_charges		= +(($amt1* 5)/100);	
			$tds 				= 0;	
			$net_payout			= (($amt1)+$admin_charges);	
			$withdrawal_status  = 'paid';
			$payment_option 	= 0;	
			
// 			if($totalbalence < $net_payout )
// 			{
// 				$response = array(
// 					'status' 	=> "0",
// 					'additional_cashback' => $additional_cashback,
// 					'msg' 		=> "Request Amount is Greater than Balance amount"
// 				);
// 				return $response;
// 			}	
			$additional_cashback = $admin_charges;
		}
		$req = array('withdrawal_request_type'	=> $request_type,
					'member_id'					=> $member_id,
					'withdrawal_total_amount'	=> $totalbalence,
					'withdrawal_request_amount' => $request_amount,
					'withdrawal_admin_charges'	=> $admin_charges,
					'withdrawal_tds_charges'	=> $tds, 
					'withdrawal_net_amount'		=> $net_payout,
					'withdrawal_request_date'	=> date('Y-m-d H:i:s'),						 
					'payment_option'			=> $payment_option,
					'withdrawal_status'			=> $withdrawal_status,
					'usdt_address'				=> $usdt_address,
					'btc_address'				=> $btc_address,
					'eth_address'				=> $eth_address
				);
				//  print_r($req);
		$this->db->insert('roi_withdrawal_request',$req);
		// dd($this->db->last_query());
		unset($_POST);
		$response = array(
			'status' 	=> "1",
			'additional_cashback' => $additional_cashback,
			'msg' 		=> "Withdrawal Request Sent Successfully"
		);
//  		echo "<pre>";print_r($response);die;
		return $response;
	}
	public function get_all_downline($member_id)
	{
		$this->db->select('member_id');
		$this->db->from('isp_members'); 
		$this->db->where_in('member_upline_id',$member_id);
		$q = $this->db->get();
// 		 echo $this->db->last_query();		
		return $q->result();
	}
	function update_pass($member_id,$password,$d) {

    $this->db->trans_start();
   $p= $password['member_password'];
 
    $this->db->where('member_id',$member_id);
    $this->db->set('member_password',$p);
    $this->db->update('isp_members');

    $this->db->where('id',$member_id);
    $this->db->set('password',$d);
    $this->db->update('users');
   
    $this->db->trans_complete();
  if ($this->db->trans_status() === FALSE) {
      $this->db->trans_rollback();
        return false;
    } else {
      
        $this->db->trans_commit();
        return true;
    }
}
function insertDataapi($table,$data)
    {
      
        $this->db->insert($table,$data);
        return $this->db->insert_id();
    }
}  //class close
