<?php
Class Member_epin_mdl extends CI_Model
{
   public  function __construct()
	{
		parent::__construct();
	}  

	public function insert_data($table,$insertData)
	{
		return $this->db->insert($table,$insertData);		
	}

	public function today_date()
	{
		return $today_date = date('Y-m-d H:i:s');
	}

	public function get_epin_member_data($status,$member_id)
	{
		$this->db->select('members.member_id,members.member_name,epin_request.*');
		$this->db->from('epin_request');
		$this->db->join('members','members.member_id=epin_request.request_member_id'); 
		$this->db->where('request_member_id',$member_id);
		$this->db->where('request_status',$status);
		$this->db->order_by('request_id','DESC');
		$q = $this->db->get();
		return $q->result();
	} 
	public function get_myepin_list($member_id)
	{
		$this->db->select('members.member_id,members.member_name,epin_request.*');
		$this->db->from('epin_request');
		$this->db->join('members','members.member_id=epin_request.request_member_id'); 
		$this->db->where('request_member_id',$member_id);		
		$this->db->order_by('request_id','DESC');
		$q = $this->db->get();
		return $q->result();
	} 
	public function get_unused_epin($status,$member_id)
	{
		$this->db->select('*');
		$this->db->from('epin');		
		$this->db->where('epin_member_id',$member_id);		
		$this->db->order_by('epin_id','DESC');
		$this->db->where('epin_status',$status);
		$q = $this->db->get();
		return $q->result();
	} 
	public function get_used_epin($status,$member_id)
	{
		$this->db->select('members.member_id,members.member_login_id,members.member_name,epin.*');
		$this->db->from('epin');
		$this->db->join('members','members.member_id=epin.epin_member_id'); 
	// old    	$this->db->join('members','members.member_epin_id=epin.epin_id'); 
	
		//$this->db->join('members','members.member_epin_id=epin.epin_id'); 
		$this->db->where('epin_member_id',$member_id);
		$this->db->where('epin_status',$status);
		$this->db->order_by('epin_id','DESC');
		$q = $this->db->get();
		//echo $this->db->last_query();die();
		return $q->result();
	} 
	public function get_my_level($member_id)
	{
		
		$this->db->select('*');
		$this->db->from('re_entry');
		$this->db->where('member_id',$member_id);		
		$this->db->order_by('re_entry_id','DESC');
		$this->db->limit(1);
		$q = $this->db->get();		
		return $q->row();
	}
	public function get_downline($member_id)
	{
		$this->db->select('member_id');
		$this->db->from('members'); 
		$this->db->where('member_upline_id',$member_id);
		$this->db->where('member_upline_id !=','0');
		$q = $this->db->get();
		return $q->row();
	}
	public function count_rentry_level($member_id)
	{
		$this->db->select('count(*) as tot');
		$this->db->from('re_entry'); 
		$this->db->where('member_id',$member_id);		
		$q = $this->db->get();
		return $q->row();
	}
	public function check_stage_exist_or_not($member_id,$stage)
	{
		$this->db->select('*');
		$this->db->from('re_entry'); 
		$this->db->where('member_id',$member_id);
		$this->db->where('re_entry_stage',$stage);		
		$q = $this->db->get();
		if($q->num_rows()>0)
		{
			return false;
		}
		else{
			return  true;
		}
	}
	public function find_stage($member_id,$stage)
	{
		$this->db->select('*');
		$this->db->from('re_entry'); 
		$this->db->where('member_id',$member_id);
		$this->db->where('re_entry_stage',$stage);		
		$q = $this->db->get();
		if($q->num_rows()>0)
		{
			return true;
		}
		else{
			return  false;
		}
	}
	function get_available_epin($member_id,$status)
	{
		$this->db->select('*');
		$this->db->from('epin');		
		$this->db->where('epin_member_id',$member_id);		
		$this->db->order_by('epin_id','DESC');
		$this->db->where('epin_status',$status);
		$q = $this->db->get();
		return $q->num_rows();
	}
	function get_my_epin($member_id,$status,$no_of_epin)
	{
		$this->db->select('*');
		$this->db->from('epin');		
		$this->db->where('epin_member_id',$member_id);		
		$this->db->order_by('epin_id','DESC');
		$this->db->where('epin_status',$status);
		$this->db->limit($no_of_epin);
		$q = $this->db->get();
		return $q->result();
	}
	public function get_stage($member_id)
	{
		$this->db->select('count(*) as stage');
		$this->db->from('isp_re_entry');		
		$this->db->where('member_id',$member_id);		
		$this->db->order_by('re_entry_id','DESC');
		$this->db->limit(1);	
		$q = $this->db->get();
		if($q->num_rows()>0)
		{
		return $q->row();
		}
		
	}
	public function get_business_stage($total_downline)
	{
		$this->db->select('*');
		$this->db->from('isp_business_table');	
		$this->db->where('total_downline<=',$total_downline);		
		$this->db->order_by('stage','DESC');	
		$this->db->limit(1);			
		$q = $this->db->get();
		return $q->row();
	}
	public function get_stage_details($stage)
	{
		
		$condition='stage="'.$stage.'"';
		
		$this->db->select('*');
		$this->db->from('isp_business_table');	
		$this->db->where($condition);		
		$this->db->order_by('stage','DESC');	
		$this->db->limit(1);			
		$q = $this->db->get();
		return $q->row();
	}
	public function get_transfer_epins($member_id)
	{
		$this->db->select('COUNT(`epin_id`) as total,epin_member_id as to_member_id,old_epin_member_id as from_member_id,ein_transfer_date');
		$this->db->from('epin'); 
		$this->db->where('old_epin_member_id',$member_id);		
		//$this->db->group_by('epin_member_id');
		$this->db->order_by('ein_transfer_date','desc');
		$this->db->group_by('DATE(ein_transfer_date)');
		$q = $this->db->get();
		
		return $q->result();
	} 
	public function get_trans_history($member_id)
	{
		$this->db->select('COUNT(`history_id`) as total,transfer_to ,transfer_from ,transfer_date');
		$this->db->from('epin_history'); 
		$this->db->where('transfer_from',$member_id);		
		$this->db->order_by('transfer_date','desc');
		$this->db->group_by('DATE(transfer_date)');
		$q = $this->db->get();
		
		return $q->result();
	}
	public function get_payout_rentry_list($first_date,$second_date,$todays_date)
	{
		$end_date=date('Y-m-02');
		$where='re_entry_stage<=6';
		$this->db->select('re_entry_id,count(*) as tot_record,member_id,sum(re_entry_count) as re_entry_count,sum(re_entry_income) as re_entry_income');
		$this->db->from('re_entry'); 
		$this->db->where('is_payout','No');	
		$this->db->where($where);			
		//$this->db->where('re_entry_date >=', $first_date);
		//$this->db->where('re_entry_date <', $end_date);
		
		$this->db->group_by('member_id');			
		$q = $this->db->get();		
	

		return $q->result();
	}
	public function get_scriptvise_area()
	{
		$where='re_entry_stage<=6';
		$this->db->select('*');
		$this->db->from('re_entry'); 
		$this->db->where('is_payout','No');	
		$this->db->where($where);			
		$q = $this->db->get();		
	

		return $q->result();
	}
	public function get_sponsor_income_for_15_days($member_id,$start_date,$end_date)
	{
		$this->db->select('SUM(sponsor_income)as sponsor_income');
		$this->db->from('isp_sponsor_income'); 
		$this->db->where('is_payout','No');	
		$this->db->where('DATE(create_date) >=', $start_date);
		$this->db->where('DATE(create_date) <=', $end_date);		
		$this->db->where('member_id', $member_id);		
		//$this->db->group_by('member_id');
			
		$q = $this->db->get();	
		//echo $this->db->last_query();
		
		return $q->row();
	}
	public function call_sponsor_income($stage,$member_id)
	{
		$status='Pending';
		if($stage>=4 && $stage<=15)
		{
			$sponsor_id=$this->get_sponsor_id($member_id);
			$insert_sponsor_income=$this->insert_sponsor_income($sponsor_id,$member_id,$stage,$status);
		}		
	}
	public function get_sponsor_id($member_id)
	{
			$query = $this->db->get_where('members',array('member_id'=>$member_id));
			$ret = $query->row();
			return $ret->member_sponsored;
	}
	public function get_sponsor_income($stage)
	{
			$query = $this->db->get_where('business_table',array('stage'=>$stage));
			$ret = $query->row();
			return $ret->sponsor_income;
	}
	public function insert_sponsor_income($sponsor_id,$member_id,$stage,$status)
	{
		$array=array(
		'member_id'=>$sponsor_id,
		'downline_id'=>$member_id,
		'sponsor_income'=>$this->get_sponsor_income($stage),
		'sponsor_stage'=>$stage,
		'status'=>$status
		);
		$this->db->insert('sponsor_income',$array);
	}
	
	public function total_sponsor_income($member_id)
	{
			$date=date('Y-m-d');
			$this->db->select('SUM(sponsor_income) AS amount');			
			$this->db->where('DATE(create_date) <=', $date);
			$this->db->where("member_id",$member_id);
			$query = $this->db->get('sponsor_income');
			$result = $query->result();
			return $result[0]->amount;			
	}
	 
	public function get_recieve_epins($member_id)
	{ 
		$this->db->select('count(epin_id) as total,epin_member_id as recieve_member_id,old_epin_member_id as sender_member_id,ein_transfer_date');
		$this->db->from('epin'); 
		$this->db->where('epin_member_id',$member_id);
		$this->db->order_by('ein_transfer_date','desc');
		$this->db->group_by('DATE(ein_transfer_date)');
		$q= $this->db->get();
		return $q->result();
	}  
	public function get_receive_history($member_id)
	{
		$this->db->select('count(history_id) as total,transfer_to ,transfer_from ,transfer_date');
		$this->db->from('epin_history'); 
		$this->db->where('transfer_to',$member_id);
		$this->db->order_by('transfer_date','desc');
		$this->db->group_by('DATE(transfer_date)');
		$q= $this->db->get();
		return $q->result();
	}
	public function get_all_applicable_for_sponsor_income()
	{
		$this->db->select('*');
		$this->db->from('re_entry'); 
		$this->db->where('re_entry_stage>=','4');		
		$q= $this->db->get();
		return $q->result();
	}
	public function check_already_paid_sponsor_income($member_id,$stage)
	{
		$sponsor_id=$this->get_sponsor_id($member_id);
		$this->db->select('*');
		$this->db->from('sponsor_income'); 
		$this->db->where('downline_id',$member_id);
		$this->db->where('member_id',$sponsor_id);
		$this->db->where('sponsor_stage',$stage);
		$q= $this->db->get();
		if($q->num_rows()>0)
		{
			return true;
		}
		else{
			return false;
		}
	}
	public function check_level_payment($start_date,$end_date)
	{
		$this->db->select('*');
		$this->db->from(' isp_level_calculation'); 
		$this->db->where('level_status','Complete');
		$this->db->where('status','Pending');		
		$this->db->where('DATE(added_date) >=', $start_date);
		$this->db->where('DATE(added_date) <=', $end_date);	
		$q = $this->db->get();	
		return $q->result();
	}

}  //class close
